/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.engine;

import io.delta.kernel.defaults.engine.fileio.FileIO;
import io.delta.kernel.defaults.engine.fileio.InputFile;
import io.delta.kernel.defaults.engine.fileio.SeekableInputStream;
import io.delta.kernel.engine.FileReadRequest;
import io.delta.kernel.engine.FileSystemClient;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.FileStatus;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;

public class DefaultFileSystemClient
implements FileSystemClient {
    private final FileIO fileIO;

    public DefaultFileSystemClient(FileIO fileIO) {
        this.fileIO = Objects.requireNonNull(fileIO, "fileIO is null");
    }

    public CloseableIterator<FileStatus> listFrom(String string) throws IOException {
        return this.fileIO.listFrom(string);
    }

    public String resolvePath(String string) throws IOException {
        return this.fileIO.resolvePath(string);
    }

    public CloseableIterator<ByteArrayInputStream> readFiles(CloseableIterator<FileReadRequest> closeableIterator) throws IOException {
        return closeableIterator.map(fileReadRequest -> this.getStream(fileReadRequest.getPath(), fileReadRequest.getStartOffset(), fileReadRequest.getReadLength()));
    }

    public boolean mkdirs(String string) throws IOException {
        return this.fileIO.mkdirs(string);
    }

    public boolean delete(String string) throws IOException {
        return this.fileIO.delete(string);
    }

    private ByteArrayInputStream getStream(String string, int n, int n2) {
        ByteArrayInputStream byteArrayInputStream;
        block8: {
            InputFile inputFile = this.fileIO.newInputFile(string, -1L);
            SeekableInputStream seekableInputStream = inputFile.newStream();
            try {
                seekableInputStream.seek(n);
                byte[] byArray = new byte[n2];
                seekableInputStream.readFully(byArray, 0, n2);
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                if (seekableInputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (seekableInputStream != null) {
                        try {
                            seekableInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new UncheckedIOException(String.format("IOException reading from file %s at offset %s size %s", string, n, n2), iOException);
                }
            }
            seekableInputStream.close();
        }
        return byteArrayInputStream;
    }
}

