/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.engine;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.data.Row;
import io.delta.kernel.defaults.engine.fileio.FileIO;
import io.delta.kernel.defaults.engine.fileio.SeekableInputStream;
import io.delta.kernel.defaults.internal.data.DefaultJsonRow;
import io.delta.kernel.defaults.internal.data.DefaultRowBasedColumnarBatch;
import io.delta.kernel.defaults.internal.json.JsonUtils;
import io.delta.kernel.engine.JsonHandler;
import io.delta.kernel.exceptions.KernelEngineException;
import io.delta.kernel.expressions.Predicate;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.Utils;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.FileStatus;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Optional;

public class DefaultJsonHandler
implements JsonHandler {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final ObjectReader objectReaderReadBigDecimals = new ObjectMapper().reader(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
    private final FileIO fileIO;
    private final int maxBatchSize;

    public DefaultJsonHandler(FileIO fileIO) {
        this.fileIO = fileIO;
        this.maxBatchSize = fileIO.getConf("delta.kernel.default.json.reader.batch-size").map(Integer::valueOf).orElse(1024);
        Preconditions.checkArgument((this.maxBatchSize > 0 ? 1 : 0) != 0, (String)"invalid JSON reader batch size: %d", (Object[])new Object[]{this.maxBatchSize});
    }

    public ColumnarBatch parseJson(ColumnVector columnVector, StructType structType, Optional<ColumnVector> optional) {
        ArrayList<Row> arrayList = new ArrayList<Row>();
        for (int i = 0; i < columnVector.getSize(); ++i) {
            boolean bl;
            boolean bl2 = bl = !optional.isPresent() || !optional.get().isNullAt(i) && optional.get().getBoolean(i);
            if (bl && !columnVector.isNullAt(i)) {
                arrayList.add(this.parseJson(columnVector.getString(i), structType));
                continue;
            }
            arrayList.add(null);
        }
        return new DefaultRowBasedColumnarBatch(structType, arrayList);
    }

    public CloseableIterator<ColumnarBatch> readJsonFiles(final CloseableIterator<FileStatus> closeableIterator, final StructType structType, Optional<Predicate> optional) throws IOException {
        return new CloseableIterator<ColumnarBatch>(){
            private FileStatus currentFile;
            private BufferedReader currentFileReader;
            private String nextLine;

            public void close() throws IOException {
                Utils.closeCloseables((AutoCloseable[])new AutoCloseable[]{this.currentFileReader, closeableIterator});
            }

            public boolean hasNext() {
                if (this.nextLine != null) {
                    return true;
                }
                try {
                    if ((this.currentFileReader == null || (this.nextLine = this.currentFileReader.readLine()) == null) && this.tryOpenNextFile()) {
                        return this.hasNext();
                    }
                    return this.nextLine != null;
                }
                catch (IOException iOException) {
                    throw new KernelEngineException(String.format("Error reading JSON file: %s", this.currentFile.getPath()), (Throwable)iOException);
                }
            }

            public ColumnarBatch next() {
                if (this.nextLine == null) {
                    throw new NoSuchElementException();
                }
                ArrayList<Row> arrayList = new ArrayList<Row>();
                int n = 0;
                do {
                    arrayList.add(DefaultJsonHandler.this.parseJson(this.nextLine, structType));
                    this.nextLine = null;
                } while (++n < DefaultJsonHandler.this.maxBatchSize && this.hasNext());
                return new DefaultRowBasedColumnarBatch(structType, arrayList);
            }

            private boolean tryOpenNextFile() throws IOException {
                Utils.closeCloseables((AutoCloseable[])new AutoCloseable[]{this.currentFileReader});
                this.currentFileReader = null;
                if (closeableIterator.hasNext()) {
                    this.currentFile = (FileStatus)closeableIterator.next();
                    SeekableInputStream seekableInputStream = null;
                    try {
                        seekableInputStream = DefaultJsonHandler.this.fileIO.newInputFile(this.currentFile.getPath(), this.currentFile.getSize()).newStream();
                        this.currentFileReader = new BufferedReader(new InputStreamReader((InputStream)seekableInputStream, StandardCharsets.UTF_8));
                    }
                    catch (Exception exception) {
                        Utils.closeCloseablesSilently((AutoCloseable[])new AutoCloseable[]{seekableInputStream});
                        throw exception;
                    }
                }
                return this.currentFileReader != null;
            }
        };
    }

    public void writeJsonFileAtomically(String string, CloseableIterator<Row> closeableIterator, boolean bl) throws IOException {
        this.fileIO.newOutputFile(string).writeAtomically((CloseableIterator<String>)closeableIterator.map(JsonUtils::rowToJson), bl);
    }

    private Row parseJson(String string, StructType structType) {
        try {
            JsonNode jsonNode = objectReaderReadBigDecimals.readTree(string);
            return new DefaultJsonRow((ObjectNode)jsonNode, structType);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new KernelEngineException(String.format("Could not parse JSON: %s", string), (Throwable)jsonProcessingException);
        }
    }
}

