/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.engine;

import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.data.FilteredColumnarBatch;
import io.delta.kernel.defaults.engine.fileio.FileIO;
import io.delta.kernel.defaults.internal.parquet.ParquetFileReader;
import io.delta.kernel.defaults.internal.parquet.ParquetFileWriter;
import io.delta.kernel.engine.ParquetHandler;
import io.delta.kernel.expressions.Column;
import io.delta.kernel.expressions.Predicate;
import io.delta.kernel.internal.util.Utils;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.DataFileStatus;
import io.delta.kernel.utils.FileStatus;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DefaultParquetHandler
implements ParquetHandler {
    private final FileIO fileIO;

    public DefaultParquetHandler(FileIO fileIO) {
        this.fileIO = Objects.requireNonNull(fileIO, "fileIO is null");
    }

    public CloseableIterator<ColumnarBatch> readParquetFiles(final CloseableIterator<FileStatus> closeableIterator, final StructType structType, final Optional<Predicate> optional) throws IOException {
        return new CloseableIterator<ColumnarBatch>(){
            private final ParquetFileReader batchReader;
            private CloseableIterator<ColumnarBatch> currentFileReader;
            {
                this.batchReader = new ParquetFileReader(DefaultParquetHandler.this.fileIO);
            }

            public void close() throws IOException {
                Utils.closeCloseables((AutoCloseable[])new AutoCloseable[]{this.currentFileReader, closeableIterator});
            }

            public boolean hasNext() {
                if (this.currentFileReader != null && this.currentFileReader.hasNext()) {
                    return true;
                }
                Utils.closeCloseables((AutoCloseable[])new AutoCloseable[]{this.currentFileReader});
                this.currentFileReader = null;
                if (closeableIterator.hasNext()) {
                    this.currentFileReader = this.batchReader.read((FileStatus)closeableIterator.next(), structType, optional);
                    return this.hasNext();
                }
                return false;
            }

            public ColumnarBatch next() {
                return (ColumnarBatch)this.currentFileReader.next();
            }
        };
    }

    public CloseableIterator<DataFileStatus> writeParquetFiles(String string, CloseableIterator<FilteredColumnarBatch> closeableIterator, List<Column> list) throws IOException {
        ParquetFileWriter parquetFileWriter = ParquetFileWriter.multiFileWriter(this.fileIO, string, list);
        return parquetFileWriter.write(closeableIterator);
    }

    public void writeParquetFileAtomically(String string, CloseableIterator<FilteredColumnarBatch> closeableIterator) throws IOException {
        try {
            ParquetFileWriter parquetFileWriter = ParquetFileWriter.singleFileWriter(this.fileIO, string, true, Collections.emptyList());
            parquetFileWriter.write(closeableIterator).next();
        }
        catch (UncheckedIOException uncheckedIOException) {
            try {
                throw uncheckedIOException.getCause();
            }
            catch (Throwable throwable) {
                Utils.closeCloseables((AutoCloseable[])new AutoCloseable[]{closeableIterator});
                throw throwable;
            }
        }
        Utils.closeCloseables((AutoCloseable[])new AutoCloseable[]{closeableIterator});
    }
}

