/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.engine;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.delta.kernel.engine.MetricsReporter;
import io.delta.kernel.internal.metrics.MetricsReportSerializers;
import io.delta.kernel.metrics.MetricsReport;
import io.delta.kernel.metrics.ScanReport;
import io.delta.kernel.metrics.SnapshotReport;
import io.delta.kernel.metrics.TransactionReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingMetricsReporter
implements MetricsReporter {
    private static final Logger logger = LoggerFactory.getLogger(LoggingMetricsReporter.class);

    public void report(MetricsReport metricsReport) {
        try {
            if (metricsReport instanceof SnapshotReport) {
                logger.info("SnapshotReport = {}", (Object)MetricsReportSerializers.serializeSnapshotReport((SnapshotReport)((SnapshotReport)metricsReport)));
            } else if (metricsReport instanceof ScanReport) {
                logger.info("ScanReport = {}", (Object)MetricsReportSerializers.serializeScanReport((ScanReport)((ScanReport)metricsReport)));
            } else if (metricsReport instanceof TransactionReport) {
                logger.info("TransactionReport = {}", (Object)MetricsReportSerializers.serializeTransactionReport((TransactionReport)((TransactionReport)metricsReport)));
            } else {
                logger.info("{} = [{} does not support serializing this type of MetricReport]", metricsReport.getClass(), this.getClass());
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            logger.info("Encountered exception while serializing report {}: {}", (Object)metricsReport, (Object)jsonProcessingException);
        }
    }
}

