/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.engine.hadoopio;

import io.delta.kernel.defaults.engine.fileio.FileIO;
import io.delta.kernel.defaults.engine.fileio.InputFile;
import io.delta.kernel.defaults.engine.fileio.OutputFile;
import io.delta.kernel.defaults.engine.hadoopio.HadoopInputFile;
import io.delta.kernel.defaults.engine.hadoopio.HadoopOutputFile;
import io.delta.kernel.defaults.internal.logstore.LogStoreProvider;
import io.delta.kernel.internal.util.Utils;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.storage.LogStore;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HadoopFileIO
implements FileIO {
    private final Configuration hadoopConf;

    public HadoopFileIO(Configuration configuration) {
        this.hadoopConf = Objects.requireNonNull(configuration, "hadoopConf is null");
    }

    @Override
    public CloseableIterator<io.delta.kernel.utils.FileStatus> listFrom(String string) throws IOException {
        Path path = new Path(string);
        LogStore logStore = LogStoreProvider.getLogStore(this.hadoopConf, path.toUri().getScheme());
        return Utils.toCloseableIterator((Iterator)logStore.listFrom(path, this.hadoopConf)).map(fileStatus -> io.delta.kernel.utils.FileStatus.of((String)fileStatus.getPath().toString(), (long)fileStatus.getLen(), (long)fileStatus.getModificationTime()));
    }

    @Override
    public io.delta.kernel.utils.FileStatus getFileStatus(String string) throws IOException {
        Path path = new Path(string);
        FileSystem fileSystem = path.getFileSystem(this.hadoopConf);
        FileStatus fileStatus = fileSystem.getFileStatus(path);
        return io.delta.kernel.utils.FileStatus.of((String)fileStatus.getPath().toString(), (long)fileStatus.getLen(), (long)fileStatus.getModificationTime());
    }

    @Override
    public String resolvePath(String string) throws IOException {
        Path path = new Path(string);
        FileSystem fileSystem = path.getFileSystem(this.hadoopConf);
        return fileSystem.makeQualified(path).toString();
    }

    @Override
    public boolean mkdirs(String string) throws IOException {
        Path path = new Path(string);
        FileSystem fileSystem = path.getFileSystem(this.hadoopConf);
        return fileSystem.mkdirs(path);
    }

    @Override
    public InputFile newInputFile(String string, long l) {
        return new HadoopInputFile(this.getFs(string), new Path(string), l);
    }

    @Override
    public OutputFile newOutputFile(String string) {
        return new HadoopOutputFile(this.hadoopConf, string);
    }

    @Override
    public boolean delete(String string) throws IOException {
        FileSystem fileSystem = this.getFs(string);
        return fileSystem.delete(new Path(string), false);
    }

    @Override
    public Optional<String> getConf(String string) {
        return Optional.ofNullable(this.hadoopConf.get(string));
    }

    private FileSystem getFs(String string) {
        try {
            Path path = new Path(string);
            return path.getFileSystem(this.hadoopConf);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException("Could not resolve the FileSystem", iOException);
        }
    }
}

