/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.engine.hadoopio;

import io.delta.kernel.defaults.engine.fileio.OutputFile;
import io.delta.kernel.defaults.engine.fileio.PositionOutputStream;
import io.delta.kernel.defaults.engine.hadoopio.HadoopPositionOutputStream;
import io.delta.kernel.defaults.internal.logstore.LogStoreProvider;
import io.delta.kernel.internal.util.Utils;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.storage.LogStore;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.util.Objects;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HadoopOutputFile
implements OutputFile {
    private final Configuration hadoopConf;
    private final String path;

    public HadoopOutputFile(Configuration configuration, String string) {
        this.hadoopConf = Objects.requireNonNull(configuration, "fs is null");
        this.path = Objects.requireNonNull(string, "path is null");
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public PositionOutputStream create(boolean bl) throws IOException {
        Path path;
        final Path path2 = new Path(this.path);
        final FileSystem fileSystem = path2.getFileSystem(this.hadoopConf);
        if (!bl) {
            return new HadoopPositionOutputStream(fileSystem.create(path2));
        }
        LogStore logStore = LogStoreProvider.getLogStore(this.hadoopConf, path2.toUri().getScheme());
        final boolean bl2 = logStore.isPartialWriteVisible(path2, this.hadoopConf);
        if (bl2) {
            String string = String.format(".%s.%s.tmp", path2.getName(), UUID.randomUUID());
            path = new Path(path2.getParent(), string);
        } else {
            path = path2;
        }
        return new HadoopPositionOutputStream(fileSystem.create(path)){

            @Override
            public void close() throws IOException {
                super.close();
                if (bl2) {
                    boolean bl = false;
                    try {
                        bl = fileSystem.rename(path, path2);
                        if (!bl) {
                            if (fileSystem.exists(path2)) {
                                throw new FileAlreadyExistsException("target file already exists: " + path2);
                            }
                            throw new IOException("Failed to rename the file");
                        }
                    }
                    finally {
                        if (!bl) {
                            fileSystem.delete(path, false);
                        }
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeAtomically(CloseableIterator<String> closeableIterator, boolean bl) throws IOException {
        Path path = new Path(this.path);
        try {
            LogStore logStore = LogStoreProvider.getLogStore(this.hadoopConf, path.toUri().getScheme());
            logStore.write(path, closeableIterator, Boolean.valueOf(bl), this.hadoopConf);
        }
        catch (Throwable throwable) {
            Utils.closeCloseables((AutoCloseable[])new AutoCloseable[]{closeableIterator});
            throw throwable;
        }
        Utils.closeCloseables((AutoCloseable[])new AutoCloseable[]{closeableIterator});
    }
}

