/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.data;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.delta.kernel.data.ArrayValue;
import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.MapValue;
import io.delta.kernel.data.Row;
import io.delta.kernel.defaults.internal.DefaultKernelUtils;
import io.delta.kernel.defaults.internal.data.vector.DefaultGenericVector;
import io.delta.kernel.internal.util.InternalUtils;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.ByteType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DateType;
import io.delta.kernel.types.DecimalType;
import io.delta.kernel.types.DoubleType;
import io.delta.kernel.types.FloatType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.ShortType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import io.delta.kernel.types.TimestampNTZType;
import io.delta.kernel.types.TimestampType;
import java.math.BigDecimal;
import java.sql.Date;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DefaultJsonRow
implements Row {
    private final Object[] parsedValues;
    private final StructType readSchema;

    public DefaultJsonRow(ObjectNode objectNode, StructType structType) {
        this.readSchema = structType;
        this.parsedValues = new Object[structType.length()];
        for (int i = 0; i < structType.length(); ++i) {
            Object object;
            StructField structField = structType.at(i);
            this.parsedValues[i] = object = DefaultJsonRow.decodeField(objectNode, structField);
        }
    }

    public StructType getSchema() {
        return this.readSchema;
    }

    public boolean isNullAt(int n) {
        return this.parsedValues[n] == null;
    }

    public boolean getBoolean(int n) {
        return (Boolean)this.parsedValues[n];
    }

    public byte getByte(int n) {
        return (Byte)this.parsedValues[n];
    }

    public short getShort(int n) {
        return (Short)this.parsedValues[n];
    }

    public int getInt(int n) {
        return (Integer)this.parsedValues[n];
    }

    public long getLong(int n) {
        return (Long)this.parsedValues[n];
    }

    public float getFloat(int n) {
        return ((Float)this.parsedValues[n]).floatValue();
    }

    public double getDouble(int n) {
        return (Double)this.parsedValues[n];
    }

    public String getString(int n) {
        return (String)this.parsedValues[n];
    }

    public BigDecimal getDecimal(int n) {
        return (BigDecimal)this.parsedValues[n];
    }

    public byte[] getBinary(int n) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Row getStruct(int n) {
        return (DefaultJsonRow)this.parsedValues[n];
    }

    public ArrayValue getArray(int n) {
        return (ArrayValue)this.parsedValues[n];
    }

    public MapValue getMap(int n) {
        return (MapValue)this.parsedValues[n];
    }

    private static void throwIfTypeMismatch(String string, boolean bl, JsonNode jsonNode) {
        if (!bl) {
            throw new RuntimeException(String.format("Couldn't decode %s, expected a %s", jsonNode, string));
        }
    }

    private static Object decodeElement(final JsonNode jsonNode, DataType dataType) {
        Object object;
        if (jsonNode.isNull()) {
            return null;
        }
        if (dataType instanceof BooleanType) {
            DefaultJsonRow.throwIfTypeMismatch("boolean", jsonNode.isBoolean(), jsonNode);
            return jsonNode.booleanValue();
        }
        if (dataType instanceof ByteType) {
            DefaultJsonRow.throwIfTypeMismatch("byte", jsonNode.canConvertToExactIntegral() && jsonNode.canConvertToInt() && jsonNode.intValue() <= 127 && jsonNode.canConvertToInt() && jsonNode.intValue() >= -128, jsonNode);
            return jsonNode.numberValue().byteValue();
        }
        if (dataType instanceof ShortType) {
            DefaultJsonRow.throwIfTypeMismatch("short", jsonNode.canConvertToExactIntegral() && jsonNode.canConvertToInt() && jsonNode.intValue() <= Short.MAX_VALUE && jsonNode.canConvertToInt() && jsonNode.intValue() >= Short.MIN_VALUE, jsonNode);
            return jsonNode.numberValue().shortValue();
        }
        if (dataType instanceof IntegerType) {
            DefaultJsonRow.throwIfTypeMismatch("integer", jsonNode.isIntegralNumber() && jsonNode.canConvertToInt(), jsonNode);
            return jsonNode.intValue();
        }
        if (dataType instanceof LongType) {
            DefaultJsonRow.throwIfTypeMismatch("long", jsonNode.isIntegralNumber() && jsonNode.canConvertToLong(), jsonNode);
            return jsonNode.numberValue().longValue();
        }
        if (dataType instanceof FloatType) {
            switch (jsonNode.getNodeType()) {
                case NUMBER: {
                    DefaultJsonRow.throwIfTypeMismatch("float", !Float.isInfinite(jsonNode.floatValue()), jsonNode);
                    return Float.valueOf(jsonNode.floatValue());
                }
                case STRING: {
                    switch (jsonNode.asText()) {
                        case "NaN": {
                            return Float.valueOf(Float.NaN);
                        }
                        case "+INF": 
                        case "+Infinity": 
                        case "Infinity": {
                            return Float.valueOf(Float.POSITIVE_INFINITY);
                        }
                        case "-INF": 
                        case "-Infinity": {
                            return Float.valueOf(Float.NEGATIVE_INFINITY);
                        }
                    }
                }
            }
            DefaultJsonRow.throwIfTypeMismatch("float", false, jsonNode);
        }
        if (dataType instanceof DoubleType) {
            switch (jsonNode.getNodeType()) {
                case NUMBER: {
                    DefaultJsonRow.throwIfTypeMismatch("double", !Double.isInfinite(jsonNode.doubleValue()), jsonNode);
                    return jsonNode.doubleValue();
                }
                case STRING: {
                    switch (jsonNode.asText()) {
                        case "NaN": {
                            return Double.NaN;
                        }
                        case "+INF": 
                        case "+Infinity": 
                        case "Infinity": {
                            return Double.POSITIVE_INFINITY;
                        }
                        case "-INF": 
                        case "-Infinity": {
                            return Double.NEGATIVE_INFINITY;
                        }
                    }
                }
            }
            DefaultJsonRow.throwIfTypeMismatch("double", false, jsonNode);
        }
        if (dataType instanceof StringType) {
            DefaultJsonRow.throwIfTypeMismatch("string", jsonNode.isTextual(), jsonNode);
            return jsonNode.asText();
        }
        if (dataType instanceof DecimalType) {
            DefaultJsonRow.throwIfTypeMismatch("decimal", jsonNode.isNumber(), jsonNode);
            return jsonNode.decimalValue();
        }
        if (dataType instanceof DateType) {
            DefaultJsonRow.throwIfTypeMismatch("date", jsonNode.isTextual(), jsonNode);
            return InternalUtils.daysSinceEpoch((Date)Date.valueOf(jsonNode.textValue()));
        }
        if (dataType instanceof TimestampType) {
            DefaultJsonRow.throwIfTypeMismatch("timestamp", jsonNode.isTextual(), jsonNode);
            object = OffsetDateTime.parse(jsonNode.textValue()).toInstant();
            return ChronoUnit.MICROS.between(Instant.EPOCH, (Temporal)object);
        }
        if (dataType instanceof TimestampNTZType) {
            DefaultJsonRow.throwIfTypeMismatch("timestamp_ntz", jsonNode.isTextual(), jsonNode);
            return DefaultKernelUtils.parseTimestampNTZ(jsonNode.textValue());
        }
        if (dataType instanceof StructType) {
            DefaultJsonRow.throwIfTypeMismatch("object", jsonNode.isObject(), jsonNode);
            return new DefaultJsonRow((ObjectNode)jsonNode, (StructType)dataType);
        }
        if (dataType instanceof ArrayType) {
            DefaultJsonRow.throwIfTypeMismatch("array", jsonNode.isArray(), jsonNode);
            object = (ArrayType)dataType;
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            final Object[] objectArray = new Object[arrayNode.size()];
            for (int i = 0; i < arrayNode.size(); ++i) {
                JsonNode jsonNode2 = arrayNode.get(i);
                Object object2 = DefaultJsonRow.decodeElement(jsonNode2, object.getElementType());
                if (object2 == null && !object.containsNull()) {
                    throw new RuntimeException("Array type expects no nulls as elements, but received `null` as array element");
                }
                objectArray[i] = object2;
            }
            return new ArrayValue(){
                final /* synthetic */ ArrayType val$arrayType;
                {
                    this.val$arrayType = arrayType;
                }

                public int getSize() {
                    return objectArray.length;
                }

                public ColumnVector getElements() {
                    return DefaultGenericVector.fromArray(this.val$arrayType.getElementType(), objectArray);
                }
            };
        }
        if (dataType instanceof MapType) {
            DefaultJsonRow.throwIfTypeMismatch("map", jsonNode.isObject(), jsonNode);
            object = (MapType)dataType;
            if (!(object.getKeyType() instanceof StringType)) {
                throw new RuntimeException("MapType with a key type of `String` is supported, received a key type: " + object.getKeyType());
            }
            ArrayList<String> arrayList = new ArrayList<String>(jsonNode.size());
            ArrayList<Object> arrayList2 = new ArrayList<Object>(jsonNode.size());
            Iterator iterator = jsonNode.fields();
            boolean bl = object.getValueType() instanceof StringType;
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                String string = (String)entry.getKey();
                Object object3 = null;
                if (bl) {
                    if (!((JsonNode)entry.getValue()).isNull()) {
                        object3 = ((JsonNode)entry.getValue()).asText();
                    }
                } else {
                    object3 = DefaultJsonRow.decodeElement((JsonNode)entry.getValue(), object.getValueType());
                }
                if (object3 == null && !object.isValueContainsNull()) {
                    throw new RuntimeException("Map type expects no nulls in values, but received `null` as value");
                }
                arrayList.add(string);
                arrayList2.add(object3);
            }
            return new MapValue(){
                final /* synthetic */ MapType val$mapType;
                final /* synthetic */ List val$keys;
                final /* synthetic */ List val$values;
                {
                    this.val$mapType = mapType;
                    this.val$keys = list;
                    this.val$values = list2;
                }

                public int getSize() {
                    return jsonNode.size();
                }

                public ColumnVector getKeys() {
                    return DefaultGenericVector.fromList(this.val$mapType.getKeyType(), this.val$keys);
                }

                public ColumnVector getValues() {
                    return DefaultGenericVector.fromList(this.val$mapType.getValueType(), this.val$values);
                }
            };
        }
        throw new UnsupportedOperationException(String.format("Unsupported DataType %s for RootNode %s", dataType, jsonNode));
    }

    private static Object decodeField(ObjectNode objectNode, StructField structField) {
        if (objectNode.get(structField.getName()) == null || objectNode.get(structField.getName()).isNull()) {
            if (structField.isNullable()) {
                return null;
            }
            throw new RuntimeException(String.format("Root node at key %s is null but field isn't nullable. Root node: %s", structField.getName(), objectNode));
        }
        return DefaultJsonRow.decodeElement(objectNode.get(structField.getName()), structField.getDataType());
    }
}

