/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.expressions;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.defaults.internal.expressions.DefaultExpressionUtils;
import io.delta.kernel.expressions.Expression;
import io.delta.kernel.expressions.Predicate;
import io.delta.kernel.internal.util.Utils;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.DataType;
import java.util.List;

public class StartsWithExpressionEvaluator {
    static Predicate validateAndTransform(Predicate predicate, List<Expression> list, List<DataType> list2) {
        DefaultExpressionUtils.checkArgsCount((Expression)predicate, 2, predicate.getName(), "Example usage: STARTS_WITH(column, 'test')");
        for (DataType dataType : list2) {
            DefaultExpressionUtils.checkIsStringType(dataType, (Expression)predicate, "'STARTS_WITH' expects STRING type inputs");
        }
        DefaultExpressionUtils.checkIsLiteral(list.get(1), (Expression)predicate, "'STARTS_WITH' expects literal as the second input");
        return new Predicate(predicate.getName(), list);
    }

    static ColumnVector eval(final List<ColumnVector> list) {
        return new ColumnVector(){
            final ColumnVector left;
            final ColumnVector right;
            {
                this.left = (ColumnVector)list.get(0);
                this.right = (ColumnVector)list.get(1);
            }

            public DataType getDataType() {
                return BooleanType.BOOLEAN;
            }

            public int getSize() {
                return this.left.getSize();
            }

            public void close() {
                Utils.closeCloseables((AutoCloseable[])new AutoCloseable[]{this.left, this.right});
            }

            public boolean getBoolean(int n) {
                if (this.isNullAt(n)) {
                    return false;
                }
                return this.left.getString(n).startsWith(this.right.getString(n));
            }

            public boolean isNullAt(int n) {
                return this.left.isNullAt(n) || this.right.isNullAt(n);
            }
        };
    }
}

