/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.expressions;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.defaults.internal.DefaultEngineErrors;
import io.delta.kernel.defaults.internal.expressions.DefaultExpressionUtils;
import io.delta.kernel.expressions.Expression;
import io.delta.kernel.expressions.ScalarExpression;
import io.delta.kernel.internal.util.Utils;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.StringType;
import java.util.List;
import java.util.Optional;

public class SubstringEvaluator {
    private SubstringEvaluator() {
    }

    static ScalarExpression validateAndTransform(ScalarExpression scalarExpression, List<Expression> list, List<DataType> list2) {
        int n = scalarExpression.getChildren().size();
        if (n < 2 || n > 3) {
            throw DefaultEngineErrors.unsupportedExpressionException((Expression)scalarExpression, "Invalid number of inputs to SUBSTRING expression. Example usage: SUBSTRING(column, pos), SUBSTRING(column, pos, len)");
        }
        if (!StringType.STRING.equals((Object)list2.get(0))) {
            throw DefaultEngineErrors.unsupportedExpressionException((Expression)scalarExpression, "Invalid type of first input of SUBSTRING: expects STRING");
        }
        Expression expression = list.get(1);
        DefaultExpressionUtils.checkIntegerLiteral(expression, "Invalid `pos` argument type for SUBSTRING", (Expression)scalarExpression);
        if (n == 3) {
            Expression expression2 = list.get(2);
            DefaultExpressionUtils.checkIntegerLiteral(expression2, "Invalid `len` argument type for SUBSTRING", (Expression)scalarExpression);
        }
        return new ScalarExpression(scalarExpression.getName(), list);
    }

    static ColumnVector eval(final List<ColumnVector> list) {
        return new ColumnVector(){
            final ColumnVector input;
            final ColumnVector positionVector;
            final Optional<ColumnVector> lengthVector;
            {
                this.input = (ColumnVector)list.get(0);
                this.positionVector = (ColumnVector)list.get(1);
                this.lengthVector = list.size() > 2 ? Optional.of((ColumnVector)list.get(2)) : Optional.empty();
            }

            public DataType getDataType() {
                return StringType.STRING;
            }

            public int getSize() {
                return this.input.getSize();
            }

            public void close() {
                Utils.closeCloseables((AutoCloseable[])new AutoCloseable[]{this.input, this.positionVector, this.lengthVector.orElse(null)});
            }

            public boolean isNullAt(int n) {
                if (n < 0 || n >= this.getSize()) {
                    throw new IllegalArgumentException(String.format("Unexpected rowId %d, expected between 0 and the size of the column vector", n));
                }
                return this.input.isNullAt(n);
            }

            public String getString(int n) {
                if (this.isNullAt(n)) {
                    return null;
                }
                String string = this.input.getString(n);
                int n2 = this.positionVector.getInt(n);
                Optional<Integer> optional = this.lengthVector.map(columnVector -> columnVector.getInt(n));
                if (n2 > SubstringEvaluator.getStringLength(string) || optional.isPresent() && optional.get() < 1) {
                    return "";
                }
                int n4 = SubstringEvaluator.buildStartPosition(string, n2);
                int n5 = Math.max(n4, 0);
                return optional.map(n3 -> {
                    int n4 = Math.min(SubstringEvaluator.getStringLength(string), Math.max(n4 + n3, 0));
                    return SubstringEvaluator.getSubstring(string, n5, Optional.of(n4));
                }).orElse(SubstringEvaluator.getSubstring(string, n5, Optional.empty()));
            }
        };
    }

    private static int buildStartPosition(String string, int n) {
        if (n < 0) {
            return SubstringEvaluator.getStringLength(string) + n;
        }
        return Math.max(n - 1, 0);
    }

    private static int getStringLength(String string) {
        return string.codePointCount(0, string.length());
    }

    private static String getSubstring(String string, int n, Optional<Integer> optional) {
        int n3 = string.offsetByCodePoints(0, n);
        return optional.map(n2 -> string.substring(n3, string.offsetByCodePoints(0, (int)n2))).orElse(string.substring(n3));
    }
}

