/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.parquet;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.data.FilteredColumnarBatch;
import io.delta.kernel.defaults.engine.fileio.FileIO;
import io.delta.kernel.defaults.internal.parquet.ParquetColumnWriters;
import io.delta.kernel.defaults.internal.parquet.ParquetIOUtils;
import io.delta.kernel.defaults.internal.parquet.ParquetSchemaUtils;
import io.delta.kernel.defaults.internal.parquet.ParquetStatsReader;
import io.delta.kernel.expressions.Column;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.Utils;
import io.delta.kernel.statistics.DataFileStatistics;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.DataFileStatus;
import io.delta.kernel.utils.FileStatus;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.MessageType;

public class ParquetFileWriter {
    public static final String TARGET_FILE_SIZE_CONF = "delta.kernel.default.parquet.writer.targetMaxFileSize";
    public static final long DEFAULT_TARGET_FILE_SIZE = 0x8000000L;
    private final FileIO fileIO;
    private final boolean writeAsSingleFile;
    private final String location;
    private final boolean atomicWrite;
    private final long targetMaxFileSize;
    private final List<Column> statsColumns;
    private long currentFileNumber;

    public static ParquetFileWriter multiFileWriter(FileIO fileIO, String string, List<Column> list) {
        return new ParquetFileWriter(fileIO, string, false, false, list);
    }

    public static ParquetFileWriter singleFileWriter(FileIO fileIO, String string, boolean bl, List<Column> list) {
        return new ParquetFileWriter(fileIO, string, true, bl, list);
    }

    private ParquetFileWriter(FileIO fileIO, String string, boolean bl, boolean bl2, List<Column> list) {
        this.fileIO = Objects.requireNonNull(fileIO, "fileIO is null");
        this.writeAsSingleFile = bl;
        this.location = Objects.requireNonNull(string, "location is null");
        this.atomicWrite = bl2;
        this.statsColumns = Objects.requireNonNull(list, "statsColumns is null");
        this.targetMaxFileSize = fileIO.getConf(TARGET_FILE_SIZE_CONF).map(Long::valueOf).orElse(0x8000000L);
        Preconditions.checkArgument((this.targetMaxFileSize > 0L ? 1 : 0) != 0, (String)"Invalid target Parquet file size: %s", (Object[])new Object[]{this.targetMaxFileSize});
    }

    public CloseableIterator<DataFileStatus> write(final CloseableIterator<FilteredColumnarBatch> closeableIterator) {
        return new CloseableIterator<DataFileStatus>(){
            private Optional<DataFileStatus> lastWrittenFileOutput = Optional.empty();
            private FilteredColumnarBatch currentBatch = null;
            private int currentBatchCursor = 0;
            private BatchWriteSupport batchWriteSupport = null;
            private StructType dataSchema = null;

            public void close() {
                Utils.closeCloseables((AutoCloseable[])new AutoCloseable[]{closeableIterator});
            }

            public boolean hasNext() {
                if (this.lastWrittenFileOutput.isPresent()) {
                    return true;
                }
                this.lastWrittenFileOutput = this.writeNextFile();
                return this.lastWrittenFileOutput.isPresent();
            }

            public DataFileStatus next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                DataFileStatus dataFileStatus = this.lastWrittenFileOutput.get();
                this.lastWrittenFileOutput = Optional.empty();
                return dataFileStatus;
            }

            private Optional<DataFileStatus> writeNextFile() {
                if (!this.hasNextRow()) {
                    return Optional.empty();
                }
                OutputFile outputFile = ParquetIOUtils.createParquetOutputFile(ParquetFileWriter.this.generateNextOutputFile(), ParquetFileWriter.this.atomicWrite);
                assert (this.batchWriteSupport != null) : "batchWriteSupport is not initialized";
                long l = 0L;
                try (ParquetWriter parquetWriter = ParquetFileWriter.this.createWriter(outputFile, (WriteSupport<Integer>)this.batchWriteSupport);){
                    boolean bl;
                    do {
                        if (this.consumeNextRow((ParquetWriter<Integer>)parquetWriter)) {
                            ++l;
                        }
                        boolean bl2 = bl = !ParquetFileWriter.this.writeAsSingleFile && parquetWriter.getDataSize() >= ParquetFileWriter.this.targetMaxFileSize;
                    } while (!bl && this.hasNextRow());
                }
                catch (IOException iOException) {
                    throw new UncheckedIOException("Failed to write the Parquet file: " + outputFile.getPath(), iOException);
                }
                return Optional.of(ParquetFileWriter.this.constructDataFileStatus(outputFile.getPath(), this.dataSchema, l));
            }

            boolean hasNextRow() {
                boolean bl;
                boolean bl2 = bl = this.currentBatch != null && this.currentBatchCursor < this.currentBatch.getData().getSize();
                if (bl) {
                    return true;
                }
                do {
                    if (!closeableIterator.hasNext()) {
                        return false;
                    }
                    this.currentBatch = (FilteredColumnarBatch)closeableIterator.next();
                    this.currentBatchCursor = 0;
                } while (this.currentBatch.getData().getSize() == 0);
                ColumnarBatch columnarBatch = this.currentBatch.getData();
                this.dataSchema = columnarBatch.getSchema();
                BatchWriteSupport batchWriteSupport = this.createOrGetWriteSupport(this.dataSchema);
                ParquetColumnWriters.ColumnWriter[] columnWriterArray = ParquetColumnWriters.createColumnVectorWriters(columnarBatch);
                batchWriteSupport.setColumnVectorWriters(columnWriterArray);
                return true;
            }

            boolean consumeNextRow(ParquetWriter<Integer> parquetWriter) throws IOException {
                boolean bl;
                Optional optional = this.currentBatch.getSelectionVector();
                boolean bl2 = bl = !optional.isPresent() || !((ColumnVector)optional.get()).isNullAt(this.currentBatchCursor) && ((ColumnVector)optional.get()).getBoolean(this.currentBatchCursor);
                if (bl) {
                    parquetWriter.write((Object)this.currentBatchCursor);
                }
                ++this.currentBatchCursor;
                return bl;
            }

            BatchWriteSupport createOrGetWriteSupport(StructType structType) {
                if (this.batchWriteSupport == null) {
                    MessageType messageType = ParquetSchemaUtils.toParquetSchema(structType);
                    this.batchWriteSupport = new BatchWriteSupport(structType, messageType);
                    return this.batchWriteSupport;
                }
                if (!this.batchWriteSupport.inputSchema.equals((Object)structType)) {
                    throw new IllegalArgumentException("Input data has columnar batches with different schemas:\n schema 1: " + this.batchWriteSupport.inputSchema + "\n schema 2: " + structType);
                }
                return this.batchWriteSupport;
            }
        };
    }

    private io.delta.kernel.defaults.engine.fileio.OutputFile generateNextOutputFile() {
        if (this.writeAsSingleFile) {
            Preconditions.checkArgument((this.currentFileNumber++ == 0L ? 1 : 0) != 0, (String)"expected to write just one file");
            return this.fileIO.newOutputFile(this.location);
        }
        String string = String.format("%s-%03d.parquet", UUID.randomUUID(), this.currentFileNumber++);
        String string2 = new Path(this.location, string).toString();
        return this.fileIO.newOutputFile(string2);
    }

    private ParquetWriter<Integer> createWriter(OutputFile outputFile, WriteSupport<Integer> writeSupport) throws IOException {
        ParquetRowDataBuilder parquetRowDataBuilder = new ParquetRowDataBuilder(outputFile, writeSupport);
        this.fileIO.getConf("parquet.compression").ifPresent(string -> parquetRowDataBuilder.withCompressionCodec(CompressionCodecName.fromConf((String)string)));
        this.fileIO.getConf("parquet.block.size").map(Long::parseLong).ifPresent(arg_0 -> ((ParquetRowDataBuilder)parquetRowDataBuilder).withRowGroupSize(arg_0));
        this.fileIO.getConf("parquet.page.size").map(Integer::parseInt).ifPresent(arg_0 -> ((ParquetRowDataBuilder)parquetRowDataBuilder).withPageSize(arg_0));
        this.fileIO.getConf("parquet.dictionary.page.size").map(Integer::parseInt).ifPresent(arg_0 -> ((ParquetRowDataBuilder)parquetRowDataBuilder).withDictionaryPageSize(arg_0));
        this.fileIO.getConf("parquet.writer.max-padding").map(Integer::parseInt).ifPresent(arg_0 -> ((ParquetRowDataBuilder)parquetRowDataBuilder).withMaxPaddingSize(arg_0));
        this.fileIO.getConf("parquet.enable.dictionary").map(Boolean::parseBoolean).ifPresent(arg_0 -> ((ParquetRowDataBuilder)parquetRowDataBuilder).withDictionaryEncoding(arg_0));
        this.fileIO.getConf("parquet.validation").map(Boolean::parseBoolean).ifPresent(arg_0 -> ((ParquetRowDataBuilder)parquetRowDataBuilder).withValidation(arg_0));
        this.fileIO.getConf("parquet.writer.version").map(ParquetProperties.WriterVersion::fromString).ifPresent(arg_0 -> ((ParquetRowDataBuilder)parquetRowDataBuilder).withWriterVersion(arg_0));
        return parquetRowDataBuilder.build();
    }

    private DataFileStatus constructDataFileStatus(String string, StructType structType, long l) {
        try {
            FileStatus fileStatus = this.fileIO.getFileStatus(string);
            String string2 = this.fileIO.resolvePath(string);
            DataFileStatistics dataFileStatistics = this.statsColumns.isEmpty() ? new DataFileStatistics(l, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap()) : ParquetStatsReader.readDataFileStatistics(this.fileIO.newInputFile(string2, fileStatus.getSize()), structType, this.statsColumns);
            return new DataFileStatus(string2, fileStatus.getSize(), fileStatus.getModificationTime(), Optional.ofNullable(dataFileStatistics));
        }
        catch (IOException iOException) {
            throw new UncheckedIOException("Failed to read the stats for: " + string, iOException);
        }
    }

    private static class ParquetRowDataBuilder
    extends ParquetWriter.Builder<Integer, ParquetRowDataBuilder> {
        private final WriteSupport<Integer> writeSupport;

        protected ParquetRowDataBuilder(OutputFile outputFile, WriteSupport<Integer> writeSupport) {
            super(outputFile);
            this.writeSupport = Objects.requireNonNull(writeSupport, "writeSupport is null");
        }

        protected ParquetRowDataBuilder self() {
            return this;
        }

        protected WriteSupport<Integer> getWriteSupport(Configuration configuration) {
            return this.writeSupport;
        }
    }

    private static class BatchWriteSupport
    extends WriteSupport<Integer> {
        final StructType inputSchema;
        final MessageType parquetSchema;
        private ParquetColumnWriters.ColumnWriter[] columnWriters;
        private RecordConsumer recordConsumer;

        BatchWriteSupport(StructType structType, MessageType messageType) {
            this.inputSchema = Objects.requireNonNull(structType, "inputSchema is null");
            this.parquetSchema = Objects.requireNonNull(messageType, "parquetSchema is null");
        }

        void setColumnVectorWriters(ParquetColumnWriters.ColumnWriter[] columnWriterArray) {
            this.columnWriters = Objects.requireNonNull(columnWriterArray, "columnVectorWriters is null");
        }

        public String getName() {
            return "delta-kernel-default-parquet-writer";
        }

        public WriteSupport.WriteContext init(Configuration configuration) {
            Map<String, String> map = Collections.singletonMap("io.delta.kernel.default-parquet-writer", "Kernel-Defaults-4.0.0");
            return new WriteSupport.WriteContext(this.parquetSchema, map);
        }

        public void prepareForWrite(RecordConsumer recordConsumer) {
            this.recordConsumer = recordConsumer;
        }

        public void write(Integer n) {
            assert (this.recordConsumer != null) : "Parquet record consumer is null";
            assert (this.columnWriters != null) : "Column writers are not set";
            this.recordConsumer.startMessage();
            for (int i = 0; i < this.columnWriters.length; ++i) {
                this.columnWriters[i].writeRowValue(this.recordConsumer, n);
            }
            this.recordConsumer.endMessage();
        }
    }
}

