/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.parquet;

import io.delta.kernel.defaults.engine.fileio.InputFile;
import io.delta.kernel.defaults.engine.fileio.PositionOutputStream;
import java.io.IOException;
import org.apache.parquet.io.DelegatingPositionOutputStream;
import org.apache.parquet.io.DelegatingSeekableInputStream;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.io.SeekableInputStream;

public class ParquetIOUtils {
    private ParquetIOUtils() {
    }

    static org.apache.parquet.io.InputFile createParquetInputFile(final InputFile inputFile) {
        return new org.apache.parquet.io.InputFile(){

            public long getLength() throws IOException {
                return inputFile.length();
            }

            public SeekableInputStream newStream() throws IOException {
                final io.delta.kernel.defaults.engine.fileio.SeekableInputStream seekableInputStream = inputFile.newStream();
                return new DelegatingSeekableInputStream(seekableInputStream){

                    public void seek(long l) throws IOException {
                        seekableInputStream.seek(l);
                    }

                    public long getPos() throws IOException {
                        return seekableInputStream.getPos();
                    }
                };
            }
        };
    }

    static OutputFile createParquetOutputFile(final io.delta.kernel.defaults.engine.fileio.OutputFile outputFile, final boolean bl) {
        return new OutputFile(){

            public org.apache.parquet.io.PositionOutputStream create(long l) throws IOException {
                final PositionOutputStream positionOutputStream = outputFile.create(bl);
                return new DelegatingPositionOutputStream(positionOutputStream){

                    public long getPos() throws IOException {
                        return positionOutputStream.getPos();
                    }
                };
            }

            public org.apache.parquet.io.PositionOutputStream createOrOverwrite(long l) throws IOException {
                throw new UnsupportedOperationException("createOrOverwrite is not supported in Kernel");
            }

            public boolean supportsBlockSize() {
                return false;
            }

            public long defaultBlockSize() {
                return 0x8000000L;
            }

            public String getPath() {
                return outputFile.path();
            }
        };
    }
}

