/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.parquet;

import io.delta.kernel.defaults.engine.fileio.InputFile;
import io.delta.kernel.defaults.internal.DefaultKernelUtils;
import io.delta.kernel.defaults.internal.parquet.ParquetIOUtils;
import io.delta.kernel.expressions.Column;
import io.delta.kernel.expressions.Literal;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.statistics.DataFileStatistics;
import io.delta.kernel.types.BinaryType;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.ByteType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DateType;
import io.delta.kernel.types.DecimalType;
import io.delta.kernel.types.DoubleType;
import io.delta.kernel.types.FloatType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.ShortType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructType;
import io.delta.kernel.types.TimestampNTZType;
import io.delta.kernel.types.TimestampType;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.apache.hadoop.shaded.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.shaded.com.google.common.collect.ImmutableMultimap;
import org.apache.hadoop.shaded.com.google.common.collect.Multimap;
import org.apache.parquet.column.statistics.BinaryStatistics;
import org.apache.parquet.column.statistics.IntStatistics;
import org.apache.parquet.column.statistics.LongStatistics;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.LogicalTypeAnnotation;

public class ParquetStatsReader {
    public static DataFileStatistics readDataFileStatistics(InputFile inputFile, StructType structType, List<Column> list) throws IOException {
        org.apache.parquet.io.InputFile inputFile2 = ParquetIOUtils.createParquetInputFile(inputFile);
        ParquetMetadata parquetMetadata = ParquetFileReader.readFooter((org.apache.parquet.io.InputFile)inputFile2, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        long l = 0L;
        for (BlockMetaData blockMetaData : parquetMetadata.getBlocks()) {
            l += blockMetaData.getRowCount();
            for (ColumnChunkMetaData columnChunkMetaData : blockMetaData.getColumns()) {
                Column column = new Column(columnChunkMetaData.getPath().toArray());
                builder.put((Object)column, (Object)columnChunkMetaData);
            }
        }
        return ParquetStatsReader.constructFileStats((Multimap<Column, ColumnChunkMetaData>)builder.build(), structType, list, l);
    }

    private static DataFileStatistics constructFileStats(Multimap<Column, ColumnChunkMetaData> multimap, StructType structType, List<Column> list, long l) {
        Map map = (Map)multimap.keySet().stream().collect(ImmutableMap.toImmutableMap(UnaryOperator.identity(), column -> ParquetStatsReader.mergeMetadataList(multimap.get(column))));
        HashMap<Column, Literal> hashMap = new HashMap<Column, Literal>();
        HashMap<Column, Literal> hashMap2 = new HashMap<Column, Literal>();
        HashMap<Column, Long> hashMap3 = new HashMap<Column, Long>();
        for (Column column2 : list) {
            Optional optional = (Optional)map.get(column2);
            DataType dataType = DefaultKernelUtils.getDataType(structType, column2);
            if (optional == null || !optional.isPresent() || !ParquetStatsReader.isStatsSupportedDataType(dataType)) continue;
            Statistics statistics = (Statistics)optional.get();
            Long l2 = statistics.isNumNullsSet() ? Long.valueOf(statistics.getNumNulls()) : null;
            hashMap3.put(column2, l2);
            if (l2 != null && l == l2) {
                hashMap.put(column2, Literal.ofNull((DataType)dataType));
                hashMap2.put(column2, Literal.ofNull((DataType)dataType));
                continue;
            }
            Literal literal = ParquetStatsReader.decodeMinMaxStat(dataType, statistics, true);
            hashMap.put(column2, literal);
            Literal literal2 = ParquetStatsReader.decodeMinMaxStat(dataType, statistics, false);
            hashMap2.put(column2, literal2);
        }
        return new DataFileStatistics(l, hashMap, hashMap2, hashMap3);
    }

    private static Literal decodeMinMaxStat(DataType dataType, Statistics<?> statistics, boolean bl) {
        Comparable comparable;
        Comparable comparable2 = comparable = bl ? statistics.genericGetMin() : statistics.genericGetMax();
        if (comparable == null) {
            return null;
        }
        if (dataType instanceof BooleanType) {
            return Literal.ofBoolean((boolean)((Boolean)comparable));
        }
        if (dataType instanceof ByteType) {
            return Literal.ofByte((byte)((Number)((Object)comparable)).byteValue());
        }
        if (dataType instanceof ShortType) {
            return Literal.ofShort((short)((Number)((Object)comparable)).shortValue());
        }
        if (dataType instanceof IntegerType) {
            return Literal.ofInt((int)((Number)((Object)comparable)).intValue());
        }
        if (dataType instanceof LongType) {
            return Literal.ofLong((long)((Number)((Object)comparable)).longValue());
        }
        if (dataType instanceof FloatType) {
            return Literal.ofFloat((float)((Number)((Object)comparable)).floatValue());
        }
        if (dataType instanceof DoubleType) {
            return Literal.ofDouble((double)((Number)((Object)comparable)).doubleValue());
        }
        if (dataType instanceof DecimalType) {
            BigDecimal bigDecimal;
            LogicalTypeAnnotation logicalTypeAnnotation = statistics.type().getLogicalTypeAnnotation();
            Preconditions.checkArgument((boolean)(logicalTypeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation), (String)"Physical decimal column has invalid Parquet Logical Type: %s", (Object[])new Object[]{logicalTypeAnnotation});
            int n = ((LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)logicalTypeAnnotation).getScale();
            DecimalType decimalType = (DecimalType)dataType;
            Preconditions.checkArgument((n == decimalType.getScale() ? 1 : 0) != 0, (String)"Physical decimal type has different scale than the logical type: %s", (Object[])new Object[]{n});
            if (statistics instanceof IntStatistics) {
                bigDecimal = BigDecimal.valueOf(((Integer)comparable).intValue()).movePointLeft(n);
            } else if (statistics instanceof LongStatistics) {
                bigDecimal = BigDecimal.valueOf((Long)comparable).movePointLeft(n);
            } else if (statistics instanceof BinaryStatistics) {
                BigInteger bigInteger = new BigInteger(ParquetStatsReader.getBinaryStat(statistics, bl));
                bigDecimal = new BigDecimal(bigInteger, n);
            } else {
                throw new UnsupportedOperationException("Unsupported stats type for Decimal: " + statistics.getClass());
            }
            return Literal.ofDecimal((BigDecimal)bigDecimal, (int)decimalType.getPrecision(), (int)decimalType.getScale());
        }
        if (dataType instanceof DateType) {
            Preconditions.checkArgument((boolean)(statistics instanceof IntStatistics), (String)"Column with DATE type contained invalid statistics: %s", (Object[])new Object[]{statistics});
            return Literal.ofDate((int)((Integer)comparable));
        }
        if (dataType instanceof TimestampType) {
            Preconditions.checkArgument((boolean)(statistics instanceof LongStatistics), (String)"Column with TIMESTAMP type contained invalid statistics: %s", (Object[])new Object[]{statistics});
            return Literal.ofTimestamp((long)((Long)comparable));
        }
        if (dataType instanceof TimestampNTZType) {
            Preconditions.checkArgument((boolean)(statistics instanceof LongStatistics), (String)"Column with TIMESTAMP_NTZ type contained invalid statistics: %s", (Object[])new Object[]{statistics});
            return Literal.ofTimestampNtz((long)((Long)comparable));
        }
        if (dataType instanceof StringType) {
            byte[] byArray = ParquetStatsReader.getBinaryStat(statistics, bl);
            return Literal.ofString((String)new String(byArray, StandardCharsets.UTF_8));
        }
        if (dataType instanceof BinaryType) {
            return Literal.ofBinary((byte[])ParquetStatsReader.getBinaryStat(statistics, bl));
        }
        throw new IllegalArgumentException("Unsupported stats data type: " + comparable);
    }

    private static Optional<Statistics<?>> mergeMetadataList(Collection<ColumnChunkMetaData> collection) {
        if (ParquetStatsReader.hasInvalidStatistics(collection)) {
            return Optional.empty();
        }
        return collection.stream().map(ColumnChunkMetaData::getStatistics).reduce((statistics, statistics2) -> {
            statistics.mergeStatistics(statistics2);
            return statistics;
        });
    }

    private static boolean hasInvalidStatistics(Collection<ColumnChunkMetaData> collection) {
        return collection.stream().anyMatch(columnChunkMetaData -> {
            Statistics statistics = columnChunkMetaData.getStatistics();
            if (statistics == null || statistics.isEmpty() || !statistics.isNumNullsSet()) {
                return true;
            }
            return !statistics.hasNonNullValue() && statistics.getNumNulls() != columnChunkMetaData.getValueCount();
        });
    }

    private static boolean isStatsSupportedDataType(DataType dataType) {
        return dataType instanceof BooleanType || dataType instanceof ByteType || dataType instanceof ShortType || dataType instanceof IntegerType || dataType instanceof LongType || dataType instanceof FloatType || dataType instanceof DoubleType || dataType instanceof DecimalType || dataType instanceof DateType || dataType instanceof TimestampType || dataType instanceof TimestampNTZType || dataType instanceof StringType || dataType instanceof BinaryType;
    }

    private static byte[] getBinaryStat(Statistics<?> statistics, boolean bl) {
        return bl ? statistics.getMinBytes() : statistics.getMaxBytes();
    }
}

