/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.engine;

import io.delta.kernel.defaults.internal.logstore.LogStoreProvider;
import io.delta.kernel.engine.FileReadRequest;
import io.delta.kernel.engine.FileSystemClient;
import io.delta.kernel.internal.util.Utils;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.FileStatus;
import io.delta.storage.LogStore;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class DefaultFileSystemClient
implements FileSystemClient {
    private final Configuration hadoopConf;

    public DefaultFileSystemClient(Configuration configuration) {
        this.hadoopConf = configuration;
    }

    public CloseableIterator<FileStatus> listFrom(String string) throws IOException {
        Path path = new Path(string);
        LogStore logStore = LogStoreProvider.getLogStore(this.hadoopConf, path.toUri().getScheme());
        return Utils.toCloseableIterator((Iterator)logStore.listFrom(path, this.hadoopConf)).map(fileStatus -> FileStatus.of((String)fileStatus.getPath().toString(), (long)fileStatus.getLen(), (long)fileStatus.getModificationTime()));
    }

    public String resolvePath(String string) throws IOException {
        Path path = new Path(string);
        FileSystem fileSystem = path.getFileSystem(this.hadoopConf);
        return fileSystem.makeQualified(path).toString();
    }

    public CloseableIterator<ByteArrayInputStream> readFiles(CloseableIterator<FileReadRequest> closeableIterator) {
        return closeableIterator.map(fileReadRequest -> this.getStream(fileReadRequest.getPath(), fileReadRequest.getStartOffset(), fileReadRequest.getReadLength()));
    }

    public boolean mkdirs(String string) throws IOException {
        Path path = new Path(string);
        FileSystem fileSystem = path.getFileSystem(this.hadoopConf);
        return fileSystem.mkdirs(path);
    }

    private ByteArrayInputStream getStream(String string, int n, int n2) {
        ByteArrayInputStream byteArrayInputStream;
        block11: {
            Path path = new Path(string);
            FileSystem fileSystem = path.getFileSystem(this.hadoopConf);
            FSDataInputStream fSDataInputStream = fileSystem.open(path);
            try {
                fSDataInputStream.skipBytes(n);
                byte[] byArray = new byte[n2];
                fSDataInputStream.readFully(byArray);
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                if (fSDataInputStream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (fSDataInputStream != null) {
                            try {
                                fSDataInputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(String.format("IOException reading from file %s at offset %s size %s", string, n, n2), iOException);
                    }
                }
                catch (IOException iOException) {
                    throw new RuntimeException(String.format("Could not resolve the FileSystem for path %s", string), iOException);
                }
            }
            fSDataInputStream.close();
        }
        return byteArrayInputStream;
    }
}

