/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.expressions;

import io.delta.kernel.data.ArrayValue;
import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.MapValue;
import io.delta.kernel.expressions.Expression;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.Utils;
import io.delta.kernel.types.BinaryType;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.ByteType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DateType;
import io.delta.kernel.types.DecimalType;
import io.delta.kernel.types.DoubleType;
import io.delta.kernel.types.FloatType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.ShortType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.TimestampNTZType;
import io.delta.kernel.types.TimestampType;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;

class DefaultExpressionUtils {
    static final Comparator<BigDecimal> BIGDECIMAL_COMPARATOR = Comparator.naturalOrder();
    static final Comparator<String> STRING_COMPARATOR = Comparator.naturalOrder();
    static final Comparator<byte[]> BINARY_COMPARTOR = (byArray, byArray2) -> {
        for (int i = 0; i < ((byte[])byArray).length && i < ((byte[])byArray2).length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return Byte.compare(byArray[i], byArray2[i]);
        }
        return Integer.compare(((byte[])byArray).length, ((byte[])byArray2).length);
    };

    private DefaultExpressionUtils() {
    }

    static boolean[] evalNullability(ColumnVector columnVector, ColumnVector columnVector2) {
        int n = columnVector.getSize();
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray[i] = columnVector.isNullAt(i) || columnVector2.isNullAt(i);
        }
        return blArray;
    }

    static ColumnVector booleanWrapperVector(final ColumnVector columnVector, final Function<Integer, Boolean> function, final Function<Integer, Boolean> function2) {
        return new ColumnVector(){

            public DataType getDataType() {
                return BooleanType.BOOLEAN;
            }

            public int getSize() {
                return columnVector.getSize();
            }

            public void close() {
                columnVector.close();
            }

            public boolean isNullAt(int n) {
                return (Boolean)function2.apply(n);
            }

            public boolean getBoolean(int n) {
                return (Boolean)function.apply(n);
            }
        };
    }

    static ColumnVector comparatorVector(final ColumnVector columnVector, final ColumnVector columnVector2, IntPredicate intPredicate) {
        IntPredicate intPredicate2;
        Preconditions.checkArgument((columnVector.getSize() == columnVector2.getSize() ? 1 : 0) != 0, (String)"Left and right operand have different vector sizes.");
        DataType dataType = columnVector.getDataType();
        if (dataType instanceof BooleanType) {
            intPredicate2 = n -> intPredicate.test(Boolean.compare(columnVector.getBoolean(n), columnVector2.getBoolean(n)));
        } else if (dataType instanceof ByteType) {
            intPredicate2 = n -> intPredicate.test(Byte.compare(columnVector.getByte(n), columnVector2.getByte(n)));
        } else if (dataType instanceof ShortType) {
            intPredicate2 = n -> intPredicate.test(Short.compare(columnVector.getShort(n), columnVector2.getShort(n)));
        } else if (dataType instanceof IntegerType || dataType instanceof DateType) {
            intPredicate2 = n -> intPredicate.test(Integer.compare(columnVector.getInt(n), columnVector2.getInt(n)));
        } else if (dataType instanceof LongType || dataType instanceof TimestampType || dataType instanceof TimestampNTZType) {
            intPredicate2 = n -> intPredicate.test(Long.compare(columnVector.getLong(n), columnVector2.getLong(n)));
        } else if (dataType instanceof FloatType) {
            intPredicate2 = n -> intPredicate.test(Float.compare(columnVector.getFloat(n), columnVector2.getFloat(n)));
        } else if (dataType instanceof DoubleType) {
            intPredicate2 = n -> intPredicate.test(Double.compare(columnVector.getDouble(n), columnVector2.getDouble(n)));
        } else if (dataType instanceof DecimalType) {
            intPredicate2 = n -> intPredicate.test(BIGDECIMAL_COMPARATOR.compare(columnVector.getDecimal(n), columnVector2.getDecimal(n)));
        } else if (dataType instanceof StringType) {
            intPredicate2 = n -> intPredicate.test(STRING_COMPARATOR.compare(columnVector.getString(n), columnVector2.getString(n)));
        } else if (dataType instanceof BinaryType) {
            intPredicate2 = n -> intPredicate.test(BINARY_COMPARTOR.compare(columnVector.getBinary(n), columnVector2.getBinary(n)));
        } else {
            throw new UnsupportedOperationException(dataType + " can not be compared.");
        }
        return new ColumnVector(){

            public DataType getDataType() {
                return BooleanType.BOOLEAN;
            }

            public void close() {
                Utils.closeCloseables((AutoCloseable[])new AutoCloseable[]{columnVector, columnVector2});
            }

            public int getSize() {
                return columnVector.getSize();
            }

            public boolean isNullAt(int n) {
                return columnVector.isNullAt(n) || columnVector2.isNullAt(n);
            }

            public boolean getBoolean(int n) {
                if (this.isNullAt(n)) {
                    return false;
                }
                return intPredicate2.test(n);
            }
        };
    }

    static Expression childAt(Expression expression, int n) {
        return (Expression)expression.getChildren().get(n);
    }

    static ColumnVector combinationVector(final List<ColumnVector> list, final Function<Integer, Integer> function) {
        return new ColumnVector(){
            private int lastLookupRowId = -1;
            private ColumnVector lastLookupVector = null;

            public DataType getDataType() {
                return ((ColumnVector)list.get(0)).getDataType();
            }

            public int getSize() {
                return ((ColumnVector)list.get(0)).getSize();
            }

            public void close() {
                Utils.closeCloseables((AutoCloseable[])((AutoCloseable[])list.toArray(new ColumnVector[0])));
            }

            public boolean isNullAt(int n) {
                return this.getVector(n).isNullAt(n);
            }

            public boolean getBoolean(int n) {
                return this.getVector(n).getBoolean(n);
            }

            public byte getByte(int n) {
                return this.getVector(n).getByte(n);
            }

            public short getShort(int n) {
                return this.getVector(n).getShort(n);
            }

            public int getInt(int n) {
                return this.getVector(n).getInt(n);
            }

            public long getLong(int n) {
                return this.getVector(n).getLong(n);
            }

            public float getFloat(int n) {
                return this.getVector(n).getFloat(n);
            }

            public double getDouble(int n) {
                return this.getVector(n).getDouble(n);
            }

            public byte[] getBinary(int n) {
                return this.getVector(n).getBinary(n);
            }

            public String getString(int n) {
                return this.getVector(n).getString(n);
            }

            public BigDecimal getDecimal(int n) {
                return this.getVector(n).getDecimal(n);
            }

            public MapValue getMap(int n) {
                return this.getVector(n).getMap(n);
            }

            public ArrayValue getArray(int n) {
                return this.getVector(n).getArray(n);
            }

            public ColumnVector getChild(int n) {
                return DefaultExpressionUtils.combinationVector(list.stream().map(columnVector -> columnVector.getChild(n)).collect(Collectors.toList()), function);
            }

            private ColumnVector getVector(int n) {
                if (n == this.lastLookupRowId) {
                    return this.lastLookupVector;
                }
                this.lastLookupRowId = n;
                this.lastLookupVector = (ColumnVector)list.get((Integer)function.apply(n));
                return this.lastLookupVector;
            }
        };
    }
}

