/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.expressions;

import io.delta.kernel.defaults.internal.expressions.ImplicitCastExpression;
import io.delta.kernel.expressions.AlwaysFalse;
import io.delta.kernel.expressions.AlwaysTrue;
import io.delta.kernel.expressions.And;
import io.delta.kernel.expressions.Column;
import io.delta.kernel.expressions.Expression;
import io.delta.kernel.expressions.Literal;
import io.delta.kernel.expressions.Or;
import io.delta.kernel.expressions.PartitionValueExpression;
import io.delta.kernel.expressions.Predicate;
import io.delta.kernel.expressions.ScalarExpression;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

abstract class ExpressionVisitor<R> {
    ExpressionVisitor() {
    }

    abstract R visitAnd(And var1);

    abstract R visitOr(Or var1);

    abstract R visitAlwaysTrue(AlwaysTrue var1);

    abstract R visitAlwaysFalse(AlwaysFalse var1);

    abstract R visitComparator(Predicate var1);

    abstract R visitLiteral(Literal var1);

    abstract R visitColumn(Column var1);

    abstract R visitCast(ImplicitCastExpression var1);

    abstract R visitPartitionValue(PartitionValueExpression var1);

    abstract R visitElementAt(ScalarExpression var1);

    abstract R visitNot(Predicate var1);

    abstract R visitIsNotNull(Predicate var1);

    abstract R visitIsNull(Predicate var1);

    abstract R visitCoalesce(ScalarExpression var1);

    abstract R visitLike(Predicate var1);

    final R visit(Expression expression) {
        if (expression instanceof PartitionValueExpression) {
            return this.visitPartitionValue((PartitionValueExpression)expression);
        }
        if (expression instanceof ScalarExpression) {
            return this.visitScalarExpression((ScalarExpression)expression);
        }
        if (expression instanceof Literal) {
            return this.visitLiteral((Literal)expression);
        }
        if (expression instanceof Column) {
            return this.visitColumn((Column)expression);
        }
        if (expression instanceof ImplicitCastExpression) {
            return this.visitCast((ImplicitCastExpression)expression);
        }
        throw new UnsupportedOperationException(String.format("Expression %s is not supported.", expression));
    }

    private R visitScalarExpression(ScalarExpression scalarExpression) {
        String string;
        List list = scalarExpression.getChildren();
        switch (string = scalarExpression.getName().toUpperCase(Locale.ENGLISH)) {
            case "ALWAYS_TRUE": {
                return this.visitAlwaysTrue(AlwaysTrue.ALWAYS_TRUE);
            }
            case "ALWAYS_FALSE": {
                return this.visitAlwaysFalse(AlwaysFalse.ALWAYS_FALSE);
            }
            case "AND": {
                return this.visitAnd(new And(ExpressionVisitor.elemAsPredicate(list, 0), ExpressionVisitor.elemAsPredicate(list, 1)));
            }
            case "OR": {
                return this.visitOr(new Or(ExpressionVisitor.elemAsPredicate(list, 0), ExpressionVisitor.elemAsPredicate(list, 1)));
            }
            case "=": 
            case "<": 
            case "<=": 
            case ">": 
            case ">=": {
                return this.visitComparator(new Predicate(string, list));
            }
            case "ELEMENT_AT": {
                return this.visitElementAt(scalarExpression);
            }
            case "NOT": {
                return this.visitNot(new Predicate(string, list));
            }
            case "IS_NOT_NULL": {
                return this.visitIsNotNull(new Predicate(string, list));
            }
            case "IS_NULL": {
                return this.visitIsNull(new Predicate(string, list));
            }
            case "COALESCE": {
                return this.visitCoalesce(scalarExpression);
            }
            case "LIKE": {
                return this.visitLike(new Predicate(string, list));
            }
        }
        throw new UnsupportedOperationException(String.format("Scalar expression `%s` is not supported.", string));
    }

    private static Predicate elemAsPredicate(List<Expression> list, int n) {
        if (list.size() <= n) {
            throw new RuntimeException(String.format("Trying to access invalid entry (%d) in list %s", n, list.stream().map(Object::toString).collect(Collectors.joining(","))));
        }
        Expression expression = list.get(n);
        if (!(expression instanceof Predicate)) {
            throw new RuntimeException("Expected a predicate, but got " + expression);
        }
        return (Predicate)list.get(n);
    }
}

