/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.expressions;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.defaults.internal.DefaultEngineErrors;
import io.delta.kernel.expressions.Expression;
import io.delta.kernel.expressions.Literal;
import io.delta.kernel.expressions.Predicate;
import io.delta.kernel.internal.util.Utils;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.StringType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

public class LikeExpressionEvaluator {
    private LikeExpressionEvaluator() {
    }

    static Predicate validateAndTransform(Predicate predicate, List<Expression> list, List<DataType> list2) {
        DataType dataType;
        int n = list.size();
        if (n < 2 || n > 3) {
            throw DefaultEngineErrors.unsupportedExpressionException((Expression)predicate, "Invalid number of inputs to LIKE expression. Example usage: LIKE(column, 'test%'), LIKE(column, 'test\\[%', '\\')");
        }
        Expression expression = list.get(0);
        DataType dataType2 = list2.get(0);
        Expression expression2 = list.get(1);
        DataType dataType3 = list2.get(1);
        Expression expression3 = n == 3 ? list.get(2) : null;
        DataType dataType4 = dataType = n == 3 ? list2.get(2) : null;
        if (!StringType.STRING.equivalent(dataType2) || !StringType.STRING.equivalent(dataType3)) {
            throw DefaultEngineErrors.unsupportedExpressionException((Expression)predicate, "LIKE is only supported for string type expressions");
        }
        if (!(expression3 == null || expression3 instanceof Literal && StringType.STRING.equivalent(dataType))) {
            throw DefaultEngineErrors.unsupportedExpressionException((Expression)predicate, "LIKE expects escape token expression to be a literal of String type");
        }
        Literal literal = (Literal)expression3;
        if (literal != null && literal.getValue().toString().length() != 1) {
            throw DefaultEngineErrors.unsupportedExpressionException((Expression)predicate, "LIKE expects escape token to be a single character");
        }
        ArrayList<Expression> arrayList = new ArrayList<Expression>(Arrays.asList(expression, expression2));
        if (Objects.nonNull(expression3)) {
            arrayList.add(expression3);
        }
        return new Predicate(predicate.getName(), arrayList);
    }

    static ColumnVector eval(final List<ColumnVector> list) {
        return new ColumnVector(){
            final ColumnVector escapeCharVector;
            final ColumnVector left;
            final ColumnVector right;
            Character escapeChar;
            {
                this.escapeCharVector = list.size() == 3 ? (ColumnVector)list.get(2) : null;
                this.left = (ColumnVector)list.get(0);
                this.right = (ColumnVector)list.get(1);
                this.escapeChar = null;
            }

            public void initEscapeCharIfRequired() {
                if (this.escapeChar == null) {
                    this.escapeChar = Character.valueOf(this.escapeCharVector != null && !this.escapeCharVector.getString(0).isEmpty() ? this.escapeCharVector.getString(0).charAt(0) : (char)'\\');
                }
            }

            public DataType getDataType() {
                return BooleanType.BOOLEAN;
            }

            public int getSize() {
                return this.left.getSize();
            }

            public void close() {
                Utils.closeCloseables((AutoCloseable[])new AutoCloseable[]{this.left, this.right});
            }

            public boolean getBoolean(int n) {
                this.initEscapeCharIfRequired();
                return this.isLike(this.left.getString(n), this.right.getString(n), this.escapeChar.charValue());
            }

            public boolean isNullAt(int n) {
                return this.left.isNullAt(n) || this.right.isNullAt(n);
            }

            public boolean isLike(String string, String string2, char c) {
                if (!Objects.isNull(string) && !Objects.isNull(string2)) {
                    String string3 = LikeExpressionEvaluator.escapeLikeRegex(string2, c);
                    return string.matches(string3);
                }
                return false;
            }
        };
    }

    private static String escapeLikeRegex(String string, char c) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n + n);
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) {
                if (i == string.length() - 1) {
                    throw DefaultEngineErrors.invalidEscapeSequence(string, i);
                }
                char c3 = string.charAt(i + 1);
                if (c3 == '_' || c3 == '%' || c3 == c) {
                    stringBuilder.append(Pattern.quote(Character.toString(c3)));
                    ++i;
                    continue;
                }
                throw DefaultEngineErrors.invalidEscapeSequence(string, i);
            }
            if (c2 == '_') {
                stringBuilder.append('.');
                continue;
            }
            if (c2 == '%') {
                stringBuilder.append(".*");
                continue;
            }
            stringBuilder.append(Pattern.quote(Character.toString(c2)));
        }
        return "(?s)" + stringBuilder;
    }
}

