/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.logstore;

import io.delta.kernel.defaults.internal.DefaultEngineErrors;
import io.delta.storage.AzureLogStore;
import io.delta.storage.GCSLogStore;
import io.delta.storage.HDFSLogStore;
import io.delta.storage.LogStore;
import io.delta.storage.S3SingleDriverLogStore;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;

public class LogStoreProvider {
    private static final Set<String> S3_SCHEMES = LogStoreProvider.unmodifiableSet("s3", "s3a", "s3n");
    private static final Set<String> AZURE_SCHEMES = LogStoreProvider.unmodifiableSet("abfs", "abfss", "adl", "wasb", "wasbs");
    private static final Set<String> GCS_SCHEMES = LogStoreProvider.unmodifiableSet("gs");

    public static LogStore getLogStore(Configuration configuration, String string) {
        String string2 = Optional.ofNullable(string).map(String::toLowerCase).orElse(null);
        String string3 = configuration.get(LogStoreProvider.getLogStoreSchemeConfKey(string2));
        if (string3 != null) {
            try {
                return LogStoreProvider.getLogStoreClass(string3).getConstructor(Configuration.class).newInstance(configuration);
            }
            catch (Exception exception) {
                throw DefaultEngineErrors.canNotInstantiateLogStore(string3);
            }
        }
        String string4 = HDFSLogStore.class.getName();
        if (S3_SCHEMES.contains(string2)) {
            string4 = S3SingleDriverLogStore.class.getName();
        } else if (AZURE_SCHEMES.contains(string2)) {
            string4 = AzureLogStore.class.getName();
        } else if (GCS_SCHEMES.contains(string2)) {
            string4 = GCSLogStore.class.getName();
        }
        try {
            return LogStoreProvider.getLogStoreClass(string4).getConstructor(Configuration.class).newInstance(configuration);
        }
        catch (Exception exception) {
            throw DefaultEngineErrors.canNotInstantiateLogStore(string4);
        }
    }

    static String getLogStoreSchemeConfKey(String string) {
        return "io.delta.kernel.logStore." + string + ".impl";
    }

    private static Class<? extends LogStore> getLogStoreClass(String string) throws ClassNotFoundException {
        return Class.forName(string, true, Thread.currentThread().getContextClassLoader()).asSubclass(LogStore.class);
    }

    private static Set<String> unmodifiableSet(String ... stringArray) {
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(stringArray)));
    }
}

