/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.parquet;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.defaults.internal.data.vector.DefaultBinaryVector;
import io.delta.kernel.defaults.internal.data.vector.DefaultBooleanVector;
import io.delta.kernel.defaults.internal.data.vector.DefaultByteVector;
import io.delta.kernel.defaults.internal.data.vector.DefaultConstantVector;
import io.delta.kernel.defaults.internal.data.vector.DefaultDoubleVector;
import io.delta.kernel.defaults.internal.data.vector.DefaultFloatVector;
import io.delta.kernel.defaults.internal.data.vector.DefaultIntVector;
import io.delta.kernel.defaults.internal.data.vector.DefaultLongVector;
import io.delta.kernel.defaults.internal.data.vector.DefaultShortVector;
import io.delta.kernel.defaults.internal.parquet.ArrayColumnReader;
import io.delta.kernel.defaults.internal.parquet.DecimalColumnReader;
import io.delta.kernel.defaults.internal.parquet.MapColumnReader;
import io.delta.kernel.defaults.internal.parquet.RowColumnReader;
import io.delta.kernel.defaults.internal.parquet.TimestampConverters;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.BinaryType;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.ByteType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DateType;
import io.delta.kernel.types.DecimalType;
import io.delta.kernel.types.DoubleType;
import io.delta.kernel.types.FloatType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.ShortType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructType;
import io.delta.kernel.types.TimestampNTZType;
import io.delta.kernel.types.TimestampType;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.Type;

class ParquetColumnReaders {
    ParquetColumnReaders() {
    }

    public static Converter createConverter(int n, DataType dataType, Type type) {
        if (dataType instanceof StructType) {
            return new RowColumnReader(n, (StructType)dataType, (GroupType)type);
        }
        if (dataType instanceof ArrayType) {
            return new ArrayColumnReader(n, (ArrayType)dataType, (GroupType)type);
        }
        if (dataType instanceof MapType) {
            return new MapColumnReader(n, (MapType)dataType, (GroupType)type);
        }
        if (dataType instanceof StringType || dataType instanceof BinaryType) {
            return new BinaryColumnReader(dataType, n);
        }
        if (dataType instanceof BooleanType) {
            return new BooleanColumnReader(n);
        }
        if (dataType instanceof IntegerType || dataType instanceof DateType) {
            return new IntColumnReader(dataType, n);
        }
        if (dataType instanceof ByteType) {
            return new ByteColumnReader(n);
        }
        if (dataType instanceof ShortType) {
            return new ShortColumnReader(n);
        }
        if (dataType instanceof LongType) {
            return new LongColumnReader(dataType, n);
        }
        if (dataType instanceof FloatType) {
            return new FloatColumnReader(n);
        }
        if (dataType instanceof DoubleType) {
            return new DoubleColumnReader(n);
        }
        if (dataType instanceof DecimalType) {
            return DecimalColumnReader.createDecimalConverter(n, (DecimalType)dataType, type);
        }
        if (dataType instanceof TimestampType) {
            return TimestampConverters.createTimestampConverter(n, type);
        }
        if (dataType instanceof TimestampNTZType) {
            return TimestampConverters.createTimestampNtzConverter(n, type);
        }
        throw new UnsupportedOperationException(dataType + " is not supported");
    }

    static boolean[] initNullabilityVector(int n) {
        boolean[] blArray = new boolean[n];
        Arrays.fill(blArray, true);
        return blArray;
    }

    static void setNullabilityToTrue(boolean[] blArray, int n, int n2) {
        Arrays.fill(blArray, n, n2, true);
    }

    public static class BinaryColumnReader
    extends BasePrimitiveColumnReader {
        private final DataType dataType;
        private byte[][] values;

        BinaryColumnReader(DataType dataType, int n) {
            super(n);
            this.dataType = dataType;
            this.values = new byte[n][];
        }

        public void addBinary(Binary binary) {
            this.resizeIfNeeded();
            this.nullability[this.currentRowIndex] = false;
            this.values[this.currentRowIndex] = binary.getBytes();
        }

        @Override
        public ColumnVector getDataColumnVector(int n) {
            DefaultBinaryVector defaultBinaryVector = new DefaultBinaryVector(this.dataType, n, this.values);
            this.nullability = ParquetColumnReaders.initNullabilityVector(this.nullability.length);
            this.values = new byte[this.values.length][];
            this.currentRowIndex = 0;
            return defaultBinaryVector;
        }

        @Override
        public void resizeIfNeeded() {
            if (this.values.length == this.currentRowIndex) {
                int n = this.values.length * 2;
                this.values = (byte[][])Arrays.copyOf(this.values, n);
                this.nullability = Arrays.copyOf(this.nullability, n);
                ParquetColumnReaders.setNullabilityToTrue(this.nullability, n / 2, n);
            }
        }
    }

    public static class BooleanColumnReader
    extends BasePrimitiveColumnReader {
        private boolean[] values;

        BooleanColumnReader(int n) {
            super(n);
            this.values = new boolean[n];
        }

        public void addBoolean(boolean bl) {
            this.resizeIfNeeded();
            this.nullability[this.currentRowIndex] = false;
            this.values[this.currentRowIndex] = bl;
        }

        @Override
        public ColumnVector getDataColumnVector(int n) {
            DefaultBooleanVector defaultBooleanVector = new DefaultBooleanVector(n, Optional.of(this.nullability), this.values);
            this.nullability = ParquetColumnReaders.initNullabilityVector(this.nullability.length);
            this.values = new boolean[this.values.length];
            this.currentRowIndex = 0;
            return defaultBooleanVector;
        }

        @Override
        public void resizeIfNeeded() {
            if (this.values.length == this.currentRowIndex) {
                int n = this.values.length * 2;
                this.values = Arrays.copyOf(this.values, n);
                this.nullability = Arrays.copyOf(this.nullability, n);
                ParquetColumnReaders.setNullabilityToTrue(this.nullability, n / 2, n);
            }
        }
    }

    public static class IntColumnReader
    extends BasePrimitiveColumnReader {
        private final DataType dataType;
        private int[] values;

        IntColumnReader(DataType dataType, int n) {
            super(n);
            Preconditions.checkArgument((dataType instanceof IntegerType || dataType instanceof DataType ? 1 : 0) != 0);
            this.dataType = dataType;
            this.values = new int[n];
        }

        public void addInt(int n) {
            this.resizeIfNeeded();
            this.nullability[this.currentRowIndex] = false;
            this.values[this.currentRowIndex] = n;
        }

        @Override
        public ColumnVector getDataColumnVector(int n) {
            DefaultIntVector defaultIntVector = new DefaultIntVector(this.dataType, n, Optional.of(this.nullability), this.values);
            this.nullability = ParquetColumnReaders.initNullabilityVector(this.nullability.length);
            this.values = new int[this.values.length];
            this.currentRowIndex = 0;
            return defaultIntVector;
        }

        @Override
        public void resizeIfNeeded() {
            if (this.values.length == this.currentRowIndex) {
                int n = this.values.length * 2;
                this.values = Arrays.copyOf(this.values, n);
                this.nullability = Arrays.copyOf(this.nullability, n);
                ParquetColumnReaders.setNullabilityToTrue(this.nullability, n / 2, n);
            }
        }
    }

    public static class ByteColumnReader
    extends BasePrimitiveColumnReader {
        private byte[] values;

        ByteColumnReader(int n) {
            super(n);
            this.values = new byte[n];
        }

        public void addInt(int n) {
            this.resizeIfNeeded();
            this.nullability[this.currentRowIndex] = false;
            this.values[this.currentRowIndex] = (byte)n;
        }

        @Override
        public ColumnVector getDataColumnVector(int n) {
            DefaultByteVector defaultByteVector = new DefaultByteVector(n, Optional.of(this.nullability), this.values);
            this.nullability = ParquetColumnReaders.initNullabilityVector(this.nullability.length);
            this.values = new byte[this.values.length];
            this.currentRowIndex = 0;
            return defaultByteVector;
        }

        @Override
        public void resizeIfNeeded() {
            if (this.values.length == this.currentRowIndex) {
                int n = this.values.length * 2;
                this.values = Arrays.copyOf(this.values, n);
                this.nullability = Arrays.copyOf(this.nullability, n);
                ParquetColumnReaders.setNullabilityToTrue(this.nullability, n / 2, n);
            }
        }
    }

    public static class ShortColumnReader
    extends BasePrimitiveColumnReader {
        private short[] values;

        ShortColumnReader(int n) {
            super(n);
            this.values = new short[n];
        }

        public void addInt(int n) {
            this.resizeIfNeeded();
            this.nullability[this.currentRowIndex] = false;
            this.values[this.currentRowIndex] = (short)n;
        }

        @Override
        public ColumnVector getDataColumnVector(int n) {
            DefaultShortVector defaultShortVector = new DefaultShortVector(n, Optional.of(this.nullability), this.values);
            this.nullability = ParquetColumnReaders.initNullabilityVector(this.nullability.length);
            this.values = new short[this.values.length];
            this.currentRowIndex = 0;
            return defaultShortVector;
        }

        @Override
        public void resizeIfNeeded() {
            if (this.values.length == this.currentRowIndex) {
                int n = this.values.length * 2;
                this.values = Arrays.copyOf(this.values, n);
                this.nullability = Arrays.copyOf(this.nullability, n);
                ParquetColumnReaders.setNullabilityToTrue(this.nullability, n / 2, n);
            }
        }
    }

    public static class LongColumnReader
    extends BasePrimitiveColumnReader {
        private final DataType dataType;
        private long[] values;

        LongColumnReader(DataType dataType, int n) {
            super(n);
            Preconditions.checkArgument((dataType instanceof LongType || dataType instanceof TimestampType || dataType instanceof TimestampNTZType ? 1 : 0) != 0);
            this.dataType = dataType;
            this.values = new long[n];
        }

        public void addLong(long l) {
            this.resizeIfNeeded();
            this.nullability[this.currentRowIndex] = false;
            this.values[this.currentRowIndex] = l;
        }

        @Override
        public ColumnVector getDataColumnVector(int n) {
            DefaultLongVector defaultLongVector = new DefaultLongVector(this.dataType, n, Optional.of(this.nullability), this.values);
            this.nullability = ParquetColumnReaders.initNullabilityVector(this.nullability.length);
            this.values = new long[this.values.length];
            this.currentRowIndex = 0;
            return defaultLongVector;
        }

        @Override
        public void resizeIfNeeded() {
            if (this.values.length == this.currentRowIndex) {
                int n = this.values.length * 2;
                this.values = Arrays.copyOf(this.values, n);
                this.nullability = Arrays.copyOf(this.nullability, n);
                ParquetColumnReaders.setNullabilityToTrue(this.nullability, n / 2, n);
            }
        }
    }

    public static class FloatColumnReader
    extends BasePrimitiveColumnReader {
        private float[] values;

        FloatColumnReader(int n) {
            super(n);
            this.values = new float[n];
        }

        public void addFloat(float f) {
            this.resizeIfNeeded();
            this.nullability[this.currentRowIndex] = false;
            this.values[this.currentRowIndex] = f;
        }

        @Override
        public ColumnVector getDataColumnVector(int n) {
            DefaultFloatVector defaultFloatVector = new DefaultFloatVector(n, Optional.of(this.nullability), this.values);
            this.nullability = ParquetColumnReaders.initNullabilityVector(this.nullability.length);
            this.values = new float[this.values.length];
            this.currentRowIndex = 0;
            return defaultFloatVector;
        }

        @Override
        public void resizeIfNeeded() {
            if (this.values.length == this.currentRowIndex) {
                int n = this.values.length * 2;
                this.values = Arrays.copyOf(this.values, n);
                this.nullability = Arrays.copyOf(this.nullability, n);
                ParquetColumnReaders.setNullabilityToTrue(this.nullability, n / 2, n);
            }
        }
    }

    public static class DoubleColumnReader
    extends BasePrimitiveColumnReader {
        private double[] values;

        DoubleColumnReader(int n) {
            super(n);
            this.values = new double[n];
        }

        public void addDouble(double d) {
            this.resizeIfNeeded();
            this.nullability[this.currentRowIndex] = false;
            this.values[this.currentRowIndex] = d;
        }

        @Override
        public ColumnVector getDataColumnVector(int n) {
            DefaultDoubleVector defaultDoubleVector = new DefaultDoubleVector(n, Optional.of(this.nullability), this.values);
            this.nullability = ParquetColumnReaders.initNullabilityVector(this.nullability.length);
            this.values = new double[this.values.length];
            this.currentRowIndex = 0;
            return defaultDoubleVector;
        }

        @Override
        public void resizeIfNeeded() {
            if (this.values.length == this.currentRowIndex) {
                int n = this.values.length * 2;
                this.values = Arrays.copyOf(this.values, n);
                this.nullability = Arrays.copyOf(this.nullability, n);
                ParquetColumnReaders.setNullabilityToTrue(this.nullability, n / 2, n);
            }
        }
    }

    public static class FileRowIndexColumnReader
    extends LongColumnReader {
        FileRowIndexColumnReader(int n) {
            super((DataType)LongType.LONG, n);
        }

        @Override
        public void addLong(long l) {
            throw new UnsupportedOperationException("cannot add long to metadata column");
        }

        @Override
        public void finalizeCurrentRow(long l) {
            super.addLong(l);
            super.finalizeCurrentRow(l);
        }
    }

    public static abstract class BasePrimitiveColumnReader
    extends PrimitiveConverter
    implements BaseColumnReader {
        protected int currentRowIndex;
        protected boolean[] nullability;

        BasePrimitiveColumnReader(int n) {
            Preconditions.checkArgument((n > 0 ? 1 : 0) != 0, (String)"invalid initialBatchSize: %s", (Object[])new Object[]{n});
            this.nullability = ParquetColumnReaders.initNullabilityVector(n);
        }

        @Override
        public void finalizeCurrentRow(long l) {
            this.resizeIfNeeded();
            ++this.currentRowIndex;
        }
    }

    public static class NonExistentColumnReader
    extends PrimitiveConverter
    implements BaseColumnReader {
        private final DataType dataType;

        NonExistentColumnReader(DataType dataType) {
            this.dataType = Objects.requireNonNull(dataType, "dataType is null");
        }

        @Override
        public ColumnVector getDataColumnVector(int n) {
            return new DefaultConstantVector(this.dataType, n, null);
        }

        @Override
        public void finalizeCurrentRow(long l) {
        }
    }

    public static interface BaseColumnReader {
        public ColumnVector getDataColumnVector(int var1);

        public void finalizeCurrentRow(long var1);

        default public void resizeIfNeeded() {
        }

        default public void resetWorkingState() {
        }
    }
}

