/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.parquet;

import io.delta.kernel.data.ArrayValue;
import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.data.MapValue;
import io.delta.kernel.defaults.internal.parquet.ParquetSchemaUtils;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.BinaryType;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.ByteType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DateType;
import io.delta.kernel.types.DecimalType;
import io.delta.kernel.types.DoubleType;
import io.delta.kernel.types.FloatType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.ShortType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructType;
import io.delta.kernel.types.TimestampNTZType;
import io.delta.kernel.types.TimestampType;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;

class ParquetColumnWriters {
    private ParquetColumnWriters() {
    }

    static ColumnWriter[] createColumnVectorWriters(ColumnarBatch columnarBatch) {
        Objects.requireNonNull(columnarBatch, "batch is null");
        StructType structType = columnarBatch.getSchema();
        ColumnVector[] columnVectorArray = new ColumnVector[structType.length()];
        for (int i = 0; i < structType.length(); ++i) {
            columnVectorArray[i] = columnarBatch.getColumnVector(i);
        }
        return ParquetColumnWriters.createColumnVectorWritersHelper(structType, columnVectorArray);
    }

    static ColumnWriter[] createColumnVectorWriters(ColumnVector columnVector) {
        Objects.requireNonNull(columnVector, "batch is null");
        Preconditions.checkArgument((boolean)(columnVector.getDataType() instanceof StructType), (String)"ColumnVector is not a struct type");
        StructType structType = (StructType)columnVector.getDataType();
        ColumnVector[] columnVectorArray = new ColumnVector[structType.length()];
        for (int i = 0; i < structType.length(); ++i) {
            columnVectorArray[i] = columnVector.getChild(i);
        }
        return ParquetColumnWriters.createColumnVectorWritersHelper(structType, columnVectorArray);
    }

    private static ColumnWriter[] createColumnVectorWritersHelper(StructType structType, ColumnVector[] columnVectorArray) {
        int n = structType.length();
        Preconditions.checkArgument((n == columnVectorArray.length ? 1 : 0) != 0, (String)"Number of columns in schema does not match number of column vectors");
        ColumnWriter[] columnWriterArray = new ColumnWriter[n];
        for (int i = 0; i < n; ++i) {
            String string = structType.at(i).getName();
            ColumnVector columnVector = columnVectorArray[i];
            columnWriterArray[i] = ParquetColumnWriters.createColumnWriter(string, i, columnVector);
        }
        return columnWriterArray;
    }

    private static ColumnWriter createColumnWriter(String string, int n, ColumnVector columnVector) {
        DataType dataType = columnVector.getDataType();
        if (dataType instanceof BooleanType) {
            return new BooleanWriter(string, n, columnVector);
        }
        if (dataType instanceof ByteType) {
            return new ByteWriter(string, n, columnVector);
        }
        if (dataType instanceof ShortType) {
            return new ShortWriter(string, n, columnVector);
        }
        if (dataType instanceof IntegerType) {
            return new IntWriter(string, n, columnVector);
        }
        if (dataType instanceof LongType) {
            return new LongWriter(string, n, columnVector);
        }
        if (dataType instanceof FloatType) {
            return new FloatWriter(string, n, columnVector);
        }
        if (dataType instanceof DoubleType) {
            return new DoubleWriter(string, n, columnVector);
        }
        if (dataType instanceof StringType) {
            return new StringWriter(string, n, columnVector);
        }
        if (dataType instanceof BinaryType) {
            return new BinaryWriter(string, n, columnVector);
        }
        if (dataType instanceof DecimalType) {
            int n2 = ((DecimalType)dataType).getPrecision();
            if (n2 <= 9) {
                return new DecimalIntWriter(string, n, columnVector);
            }
            if (n2 <= 18) {
                return new DecimalLongWriter(string, n, columnVector);
            }
            return new DecimalFixedBinaryWriter(string, n, columnVector);
        }
        if (dataType instanceof DateType) {
            return new DateWriter(string, n, columnVector);
        }
        if (dataType instanceof TimestampType || dataType instanceof TimestampNTZType) {
            return new TimestampWriter(string, n, columnVector);
        }
        if (dataType instanceof ArrayType) {
            return new ArrayWriter(string, n, columnVector);
        }
        if (dataType instanceof MapType) {
            return new MapWriter(string, n, columnVector);
        }
        if (dataType instanceof StructType) {
            return new StructWriter(string, n, columnVector);
        }
        throw new IllegalArgumentException("Unsupported column vector type: " + dataType);
    }

    static abstract class ColumnWriter {
        protected final String colName;
        protected final int fieldIndex;
        protected final ColumnVector columnVector;

        ColumnWriter(String string, int n, ColumnVector columnVector) {
            this.colName = string;
            this.fieldIndex = n;
            this.columnVector = columnVector;
        }

        void writeRowValue(RecordConsumer recordConsumer, int n) {
            if (!this.columnVector.isNullAt(n)) {
                recordConsumer.startField(this.colName, this.fieldIndex);
                this.writeNonNullRowValue(recordConsumer, n);
                recordConsumer.endField(this.colName, this.fieldIndex);
            }
        }

        abstract void writeNonNullRowValue(RecordConsumer var1, int var2);
    }

    static class BooleanWriter
    extends ColumnWriter {
        BooleanWriter(String string, int n, ColumnVector columnVector) {
            super(string, n, columnVector);
        }

        @Override
        void writeNonNullRowValue(RecordConsumer recordConsumer, int n) {
            recordConsumer.addBoolean(this.columnVector.getBoolean(n));
        }
    }

    static class ByteWriter
    extends ColumnWriter {
        ByteWriter(String string, int n, ColumnVector columnVector) {
            super(string, n, columnVector);
        }

        @Override
        void writeNonNullRowValue(RecordConsumer recordConsumer, int n) {
            recordConsumer.addInteger((int)this.columnVector.getByte(n));
        }
    }

    static class ShortWriter
    extends ColumnWriter {
        ShortWriter(String string, int n, ColumnVector columnVector) {
            super(string, n, columnVector);
        }

        @Override
        void writeNonNullRowValue(RecordConsumer recordConsumer, int n) {
            recordConsumer.addInteger((int)this.columnVector.getShort(n));
        }
    }

    static class IntWriter
    extends ColumnWriter {
        IntWriter(String string, int n, ColumnVector columnVector) {
            super(string, n, columnVector);
        }

        @Override
        void writeNonNullRowValue(RecordConsumer recordConsumer, int n) {
            recordConsumer.addInteger(this.columnVector.getInt(n));
        }
    }

    static class LongWriter
    extends ColumnWriter {
        LongWriter(String string, int n, ColumnVector columnVector) {
            super(string, n, columnVector);
        }

        @Override
        void writeNonNullRowValue(RecordConsumer recordConsumer, int n) {
            recordConsumer.addLong(this.columnVector.getLong(n));
        }
    }

    static class FloatWriter
    extends ColumnWriter {
        FloatWriter(String string, int n, ColumnVector columnVector) {
            super(string, n, columnVector);
        }

        @Override
        void writeNonNullRowValue(RecordConsumer recordConsumer, int n) {
            recordConsumer.addFloat(this.columnVector.getFloat(n));
        }
    }

    static class DoubleWriter
    extends ColumnWriter {
        DoubleWriter(String string, int n, ColumnVector columnVector) {
            super(string, n, columnVector);
        }

        @Override
        void writeNonNullRowValue(RecordConsumer recordConsumer, int n) {
            recordConsumer.addDouble(this.columnVector.getDouble(n));
        }
    }

    static class StringWriter
    extends ColumnWriter {
        StringWriter(String string, int n, ColumnVector columnVector) {
            super(string, n, columnVector);
        }

        @Override
        void writeNonNullRowValue(RecordConsumer recordConsumer, int n) {
            Binary binary = Binary.fromConstantByteArray((byte[])this.columnVector.getString(n).getBytes(StandardCharsets.UTF_8));
            recordConsumer.addBinary(binary);
        }
    }

    static class BinaryWriter
    extends ColumnWriter {
        BinaryWriter(String string, int n, ColumnVector columnVector) {
            super(string, n, columnVector);
        }

        @Override
        void writeNonNullRowValue(RecordConsumer recordConsumer, int n) {
            Binary binary = Binary.fromConstantByteArray((byte[])this.columnVector.getBinary(n));
            recordConsumer.addBinary(binary);
        }
    }

    static class DecimalIntWriter
    extends ColumnWriter {
        private final int scale;

        DecimalIntWriter(String string, int n, ColumnVector columnVector) {
            super(string, n, columnVector);
            this.scale = ((DecimalType)columnVector.getDataType()).getScale();
        }

        @Override
        void writeNonNullRowValue(RecordConsumer recordConsumer, int n) {
            BigDecimal bigDecimal = this.columnVector.getDecimal(n).movePointRight(this.scale);
            recordConsumer.addInteger(bigDecimal.intValue());
        }
    }

    static class DecimalLongWriter
    extends ColumnWriter {
        private final int scale;

        DecimalLongWriter(String string, int n, ColumnVector columnVector) {
            super(string, n, columnVector);
            this.scale = ((DecimalType)columnVector.getDataType()).getScale();
        }

        @Override
        void writeNonNullRowValue(RecordConsumer recordConsumer, int n) {
            BigDecimal bigDecimal = this.columnVector.getDecimal(n).movePointRight(this.scale);
            recordConsumer.addLong(bigDecimal.longValue());
        }
    }

    static class DecimalFixedBinaryWriter
    extends ColumnWriter {
        private final int precision;
        private final int scale;
        private final int numBytes;
        private final byte[] reusedBuffer;

        DecimalFixedBinaryWriter(String string, int n, ColumnVector columnVector) {
            super(string, n, columnVector);
            DecimalType decimalType = (DecimalType)columnVector.getDataType();
            this.precision = decimalType.getPrecision();
            this.scale = decimalType.getScale();
            this.numBytes = ParquetSchemaUtils.MAX_BYTES_PER_PRECISION.get(this.precision);
            this.reusedBuffer = new byte[this.numBytes];
        }

        @Override
        void writeNonNullRowValue(RecordConsumer recordConsumer, int n) {
            Binary binary;
            byte[] byArray = this.columnVector.getDecimal(n).unscaledValue().toByteArray();
            if (byArray.length == this.numBytes) {
                binary = Binary.fromReusedByteArray((byte[])byArray);
            } else {
                byte by = byArray[0] < 0 ? (byte)-1 : 0;
                Arrays.fill(this.reusedBuffer, 0, this.numBytes - byArray.length, by);
                System.arraycopy(byArray, 0, this.reusedBuffer, this.numBytes - byArray.length, byArray.length);
                binary = Binary.fromReusedByteArray((byte[])this.reusedBuffer);
            }
            recordConsumer.addBinary(binary);
        }
    }

    static class DateWriter
    extends ColumnWriter {
        DateWriter(String string, int n, ColumnVector columnVector) {
            super(string, n, columnVector);
        }

        @Override
        void writeNonNullRowValue(RecordConsumer recordConsumer, int n) {
            recordConsumer.addInteger(this.columnVector.getInt(n));
        }
    }

    static class TimestampWriter
    extends ColumnWriter {
        TimestampWriter(String string, int n, ColumnVector columnVector) {
            super(string, n, columnVector);
        }

        @Override
        void writeNonNullRowValue(RecordConsumer recordConsumer, int n) {
            long l = this.columnVector.getLong(n);
            recordConsumer.addLong(l);
        }
    }

    static class ArrayWriter
    extends ColumnWriter {
        ArrayWriter(String string, int n, ColumnVector columnVector) {
            super(string, n, columnVector);
        }

        @Override
        void writeNonNullRowValue(RecordConsumer recordConsumer, int n) {
            recordConsumer.startGroup();
            ArrayValue arrayValue = this.columnVector.getArray(n);
            if (arrayValue.getSize() > 0) {
                recordConsumer.startField("list", 0);
                ColumnVector columnVector = arrayValue.getElements();
                ColumnWriter columnWriter = ParquetColumnWriters.createColumnWriter("element", 0, columnVector);
                for (int i = 0; i < arrayValue.getSize(); ++i) {
                    recordConsumer.startGroup();
                    if (!columnVector.isNullAt(i)) {
                        columnWriter.writeRowValue(recordConsumer, i);
                    }
                    recordConsumer.endGroup();
                }
                recordConsumer.endField("list", 0);
            }
            recordConsumer.endGroup();
        }
    }

    static class MapWriter
    extends ColumnWriter {
        MapWriter(String string, int n, ColumnVector columnVector) {
            super(string, n, columnVector);
        }

        @Override
        void writeNonNullRowValue(RecordConsumer recordConsumer, int n) {
            recordConsumer.startGroup();
            MapValue mapValue = this.columnVector.getMap(n);
            if (mapValue.getSize() > 0) {
                recordConsumer.startField("key_value", 0);
                ColumnVector columnVector = mapValue.getKeys();
                ColumnWriter columnWriter = ParquetColumnWriters.createColumnWriter("key", 0, columnVector);
                ColumnVector columnVector2 = mapValue.getValues();
                ColumnWriter columnWriter2 = ParquetColumnWriters.createColumnWriter("value", 1, columnVector2);
                for (int i = 0; i < mapValue.getSize(); ++i) {
                    recordConsumer.startGroup();
                    columnWriter.writeRowValue(recordConsumer, i);
                    if (!columnVector2.isNullAt(i)) {
                        columnWriter2.writeRowValue(recordConsumer, i);
                    }
                    recordConsumer.endGroup();
                }
                recordConsumer.endField("key_value", 0);
            }
            recordConsumer.endGroup();
        }
    }

    static class StructWriter
    extends ColumnWriter {
        private final ColumnWriter[] fieldWriters;

        StructWriter(String string, int n, ColumnVector columnVector) {
            super(string, n, columnVector);
            this.fieldWriters = ParquetColumnWriters.createColumnVectorWriters(columnVector);
        }

        @Override
        void writeNonNullRowValue(RecordConsumer recordConsumer, int n) {
            recordConsumer.startGroup();
            for (ColumnWriter columnWriter : this.fieldWriters) {
                columnWriter.writeRowValue(recordConsumer, n);
            }
            recordConsumer.endGroup();
        }
    }
}

