/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.parquet;

import io.delta.kernel.defaults.internal.DefaultKernelUtils;
import io.delta.kernel.defaults.internal.parquet.ParquetColumnReaders;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.TimestampNTZType;
import io.delta.kernel.types.TimestampType;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class TimestampConverters {
    public static Converter createTimestampConverter(int n, Type type) {
        PrimitiveType primitiveType = type.asPrimitiveType();
        if (primitiveType.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT96) {
            return new TimestampBinaryConverter((DataType)TimestampType.TIMESTAMP, n);
        }
        if (primitiveType.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT64) {
            LogicalTypeAnnotation logicalTypeAnnotation = primitiveType.getLogicalTypeAnnotation();
            if (!(logicalTypeAnnotation instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)) {
                throw new RuntimeException(String.format("Unsupported timestamp column with Parquet type %s.", type));
            }
            LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampLogicalTypeAnnotation = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)logicalTypeAnnotation;
            Preconditions.checkArgument((boolean)timestampLogicalTypeAnnotation.isAdjustedToUTC(), (String)"TimestampType must have Parquet TimestampType(isAdjustedToUTC=true)");
            switch (timestampLogicalTypeAnnotation.getUnit()) {
                case MICROS: {
                    return new ParquetColumnReaders.LongColumnReader((DataType)TimestampType.TIMESTAMP, n);
                }
                case MILLIS: {
                    return new TimestampMillisConverter((DataType)TimestampType.TIMESTAMP, n);
                }
            }
            throw new UnsupportedOperationException(String.format("Unsupported Parquet TimeType unit=%s", timestampLogicalTypeAnnotation.getUnit()));
        }
        throw new RuntimeException(String.format("Unsupported timestamp column with Parquet type %s.", type));
    }

    public static Converter createTimestampNtzConverter(int n, Type type) {
        PrimitiveType primitiveType = type.asPrimitiveType();
        LogicalTypeAnnotation logicalTypeAnnotation = primitiveType.getLogicalTypeAnnotation();
        Preconditions.checkArgument((boolean)(logicalTypeAnnotation instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation), (String)("Invalid logical type annotation for timestamp_ntz type columns: " + logicalTypeAnnotation));
        Preconditions.checkArgument((primitiveType.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT64 ? 1 : 0) != 0, (String)("Invalid storage type for timestamp_ntz columns: " + primitiveType.getPrimitiveTypeName()));
        LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampLogicalTypeAnnotation = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)logicalTypeAnnotation;
        Preconditions.checkArgument((!timestampLogicalTypeAnnotation.isAdjustedToUTC() ? 1 : 0) != 0, (String)(TimestampNTZType.TIMESTAMP_NTZ + " must have Parquet TimestampType(isAdjustedToUTC=false)"));
        switch (timestampLogicalTypeAnnotation.getUnit()) {
            case MICROS: {
                return new ParquetColumnReaders.LongColumnReader((DataType)TimestampNTZType.TIMESTAMP_NTZ, n);
            }
            case MILLIS: {
                return new TimestampMillisConverter((DataType)TimestampNTZType.TIMESTAMP_NTZ, n);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported Parquet TimeType unit=%s", timestampLogicalTypeAnnotation.getUnit()));
    }

    private static DataType validTimestampType(DataType dataType) {
        Preconditions.checkArgument((dataType instanceof TimestampType || dataType instanceof TimestampNTZType ? 1 : 0) != 0);
        return dataType;
    }

    public static class TimestampBinaryConverter
    extends ParquetColumnReaders.LongColumnReader {
        TimestampBinaryConverter(DataType dataType, int n) {
            super(TimestampConverters.validTimestampType(dataType), n);
        }

        private long binaryToSQLTimestamp(Binary binary) {
            Preconditions.checkArgument((binary.length() == 12 ? 1 : 0) != 0, (String)String.format("Timestamps (with nanoseconds) are expected to be stored in 12-byte long binaries. Found a %s-byte binary instead.", binary.length()));
            ByteBuffer byteBuffer = binary.toByteBuffer().order(ByteOrder.LITTLE_ENDIAN);
            long l = byteBuffer.getLong();
            int n = byteBuffer.getInt();
            return DefaultKernelUtils.fromJulianDay(n, l);
        }

        public void addBinary(Binary binary) {
            long l;
            long l2 = l = this.binaryToSQLTimestamp(binary);
            super.addLong(l2);
        }

        @Override
        public void addLong(long l) {
            throw new UnsupportedOperationException(this.getClass().getName());
        }
    }

    public static class TimestampMillisConverter
    extends ParquetColumnReaders.LongColumnReader {
        TimestampMillisConverter(DataType dataType, int n) {
            super(TimestampConverters.validTimestampType(dataType), n);
        }

        @Override
        public void addLong(long l) {
            super.addLong(DefaultKernelUtils.millisToMicros(l));
        }
    }
}

