/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.types;

import com.fasterxml.jackson.databind.JsonNode;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.BasePrimitiveType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DecimalType;
import io.delta.kernel.types.FieldMetadata;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataTypeParser {
    private static String FIXED_DECIMAL_REGEX = "decimal\\(\\s*(\\d+)\\s*,\\s*(\\-?\\d+)\\s*\\)";
    private static Pattern FIXED_DECIMAL_PATTERN = Pattern.compile(FIXED_DECIMAL_REGEX);

    private DataTypeParser() {
    }

    public static StructType parseSchema(JsonNode jsonNode) {
        DataType dataType = DataTypeParser.parseDataType(jsonNode);
        if (dataType instanceof StructType) {
            return (StructType)dataType;
        }
        throw new IllegalArgumentException(String.format("Could not parse the following JSON as a valid StructType:\n%s", jsonNode));
    }

    static DataType parseDataType(JsonNode jsonNode) {
        switch (jsonNode.getNodeType()) {
            case STRING: {
                return DataTypeParser.nameToType(jsonNode.textValue());
            }
            case OBJECT: {
                String string;
                switch (string = DataTypeParser.getStringField(jsonNode, "type")) {
                    case "struct": {
                        return DataTypeParser.parseStructType(jsonNode);
                    }
                    case "array": {
                        return DataTypeParser.parseArrayType(jsonNode);
                    }
                    case "map": {
                        return DataTypeParser.parseMapType(jsonNode);
                    }
                }
            }
        }
        throw new IllegalArgumentException(String.format("Could not parse the following JSON as a valid Delta data type:\n%s", jsonNode));
    }

    private static ArrayType parseArrayType(JsonNode jsonNode) {
        Preconditions.checkArgument((jsonNode.isObject() && jsonNode.size() == 3 ? 1 : 0) != 0, (String)String.format("Expected JSON object with 3 fields for array data type but got:\n%s", jsonNode));
        boolean bl = DataTypeParser.getBooleanField(jsonNode, "containsNull");
        DataType dataType = DataTypeParser.parseDataType(DataTypeParser.getNonNullField(jsonNode, "elementType"));
        return new ArrayType(dataType, bl);
    }

    private static MapType parseMapType(JsonNode jsonNode) {
        Preconditions.checkArgument((jsonNode.isObject() && jsonNode.size() == 4 ? 1 : 0) != 0, (String)String.format("Expected JSON object with 4 fields for map data type but got:\n%s", jsonNode));
        boolean bl = DataTypeParser.getBooleanField(jsonNode, "valueContainsNull");
        DataType dataType = DataTypeParser.parseDataType(DataTypeParser.getNonNullField(jsonNode, "keyType"));
        DataType dataType2 = DataTypeParser.parseDataType(DataTypeParser.getNonNullField(jsonNode, "valueType"));
        return new MapType(dataType, dataType2, bl);
    }

    private static StructType parseStructType(JsonNode jsonNode) {
        Preconditions.checkArgument((jsonNode.isObject() && jsonNode.size() == 2 ? 1 : 0) != 0, (String)String.format("Expected JSON object with 2 fields for struct data type but got:\n%s", jsonNode));
        JsonNode jsonNode2 = DataTypeParser.getNonNullField(jsonNode, "fields");
        Preconditions.checkArgument((boolean)jsonNode2.isArray(), (String)String.format("Expected array for fieldName=%s in:\n%s", "fields", jsonNode));
        Iterator iterator = jsonNode2.elements();
        ArrayList<StructField> arrayList = new ArrayList<StructField>();
        while (iterator.hasNext()) {
            arrayList.add(DataTypeParser.parseStructField((JsonNode)iterator.next()));
        }
        return new StructType(arrayList);
    }

    private static StructField parseStructField(JsonNode jsonNode) {
        Preconditions.checkArgument((boolean)jsonNode.isObject(), (String)"Expected JSON object for struct field");
        String string = DataTypeParser.getStringField(jsonNode, "name");
        DataType dataType = DataTypeParser.parseDataType(DataTypeParser.getNonNullField(jsonNode, "type"));
        boolean bl = DataTypeParser.getBooleanField(jsonNode, "nullable");
        FieldMetadata fieldMetadata = DataTypeParser.parseFieldMetadata(jsonNode.get("metadata"));
        return new StructField(string, dataType, bl, fieldMetadata);
    }

    private static FieldMetadata parseFieldMetadata(JsonNode jsonNode2) {
        if (jsonNode2 == null || jsonNode2.isNull()) {
            return FieldMetadata.empty();
        }
        Preconditions.checkArgument((boolean)jsonNode2.isObject(), (String)"Expected JSON object for struct field metadata");
        Iterator iterator = jsonNode2.fields();
        FieldMetadata.Builder builder = FieldMetadata.builder();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            JsonNode jsonNode3 = (JsonNode)entry.getValue();
            String string = (String)entry.getKey();
            if (jsonNode3.isNull()) {
                builder.putNull(string);
                continue;
            }
            if (jsonNode3.isInt()) {
                builder.putLong(string, (long)jsonNode3.intValue());
                continue;
            }
            if (jsonNode3.isDouble()) {
                builder.putDouble(string, jsonNode3.doubleValue());
                continue;
            }
            if (jsonNode3.isBoolean()) {
                builder.putBoolean(string, jsonNode3.booleanValue());
                continue;
            }
            if (jsonNode3.isTextual()) {
                builder.putString(string, jsonNode3.textValue());
                continue;
            }
            if (jsonNode3.isObject()) {
                builder.putFieldMetadata(string, DataTypeParser.parseFieldMetadata(jsonNode3));
                continue;
            }
            if (jsonNode3.isArray()) {
                Iterator iterator2 = jsonNode3.elements();
                if (!iterator2.hasNext()) {
                    builder.putLongArray(string, new Long[0]);
                    continue;
                }
                JsonNode jsonNode4 = (JsonNode)iterator2.next();
                if (jsonNode4.isInt()) {
                    builder.putLongArray(string, DataTypeParser.buildList(jsonNode3, jsonNode -> jsonNode.intValue()).toArray(new Long[0]));
                    continue;
                }
                if (jsonNode4.isDouble()) {
                    builder.putDoubleArray(string, DataTypeParser.buildList(jsonNode3, JsonNode::doubleValue).toArray(new Double[0]));
                    continue;
                }
                if (jsonNode4.isBoolean()) {
                    builder.putBooleanArray(string, DataTypeParser.buildList(jsonNode3, JsonNode::booleanValue).toArray(new Boolean[0]));
                    continue;
                }
                if (jsonNode4.isTextual()) {
                    builder.putStringArray(string, DataTypeParser.buildList(jsonNode3, JsonNode::textValue).toArray(new String[0]));
                    continue;
                }
                if (jsonNode4.isObject()) {
                    builder.putFieldMetadataArray(string, DataTypeParser.buildList(jsonNode3, DataTypeParser::parseFieldMetadata).toArray(new FieldMetadata[0]));
                    continue;
                }
                throw new IllegalArgumentException(String.format("Unsupported type for Array as field metadata value: %s", jsonNode3));
            }
            throw new IllegalArgumentException(String.format("Unsupported type for field metadata value: %s", jsonNode3));
        }
        return builder.build();
    }

    private static <T> List<T> buildList(JsonNode jsonNode, Function<JsonNode, T> function) {
        ArrayList<T> arrayList = new ArrayList<T>();
        Iterator iterator = jsonNode.elements();
        while (iterator.hasNext()) {
            arrayList.add(function.apply((JsonNode)iterator.next()));
        }
        return arrayList;
    }

    private static DataType nameToType(String string) {
        if (BasePrimitiveType.isPrimitiveType((String)string)) {
            return BasePrimitiveType.createPrimitive((String)string);
        }
        if (string.equals("decimal")) {
            return DecimalType.USER_DEFAULT;
        }
        Matcher matcher = FIXED_DECIMAL_PATTERN.matcher(string);
        if (matcher.matches()) {
            int n = Integer.parseInt(matcher.group(1));
            int n2 = Integer.parseInt(matcher.group(2));
            return new DecimalType(n, n2);
        }
        throw new IllegalArgumentException(String.format("%s is not a supported delta data type", string));
    }

    private static JsonNode getNonNullField(JsonNode jsonNode, String string) {
        JsonNode jsonNode2 = jsonNode.get(string);
        if (jsonNode2 == null || jsonNode2.isNull()) {
            throw new IllegalArgumentException(String.format("Expected non-null for fieldName=%s in:\n%s", string, jsonNode));
        }
        return jsonNode2;
    }

    private static String getStringField(JsonNode jsonNode, String string) {
        JsonNode jsonNode2 = DataTypeParser.getNonNullField(jsonNode, string);
        Preconditions.checkArgument((boolean)jsonNode2.isTextual(), (String)String.format("Expected string for fieldName=%s in:\n%s", string, jsonNode));
        return jsonNode2.textValue();
    }

    private static boolean getBooleanField(JsonNode jsonNode, String string) {
        JsonNode jsonNode2 = DataTypeParser.getNonNullField(jsonNode, string);
        Preconditions.checkArgument((boolean)jsonNode2.isBoolean(), (String)String.format("Expected boolean for fieldName=%s in:\n%s", string, jsonNode));
        return jsonNode2.booleanValue();
    }
}

