/*
 * Decompiled with CFR 0.152.
 */
package io.delta.sharing.client;

import io.delta.sharing.client.DeltaSharingClient;
import io.delta.sharing.client.DeltaSharingProfileProvider;
import io.delta.sharing.client.ParsedDeltaSharingTablePath;
import io.delta.sharing.client.util.ConfUtils$;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.VersionInfo;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.package$;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.internal.SQLConf;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.util.Properties$;

public final class DeltaSharingRestClient$
implements Logging {
    public static final DeltaSharingRestClient$ MODULE$ = new DeltaSharingRestClient$();
    private static String USER_AGENT;
    private static final String SPARK_STRUCTURED_STREAMING;
    private static final String DELTA_SHARING_CAPABILITIES_HEADER;
    private static final String RESPONSE_TABLE_VERSION_HEADER_KEY;
    private static final String RESPONSE_FORMAT;
    private static final String READER_FEATURES;
    private static final String DELTA_SHARING_CAPABILITIES_ASYNC_READ;
    private static final String DELTA_SHARING_INCLUDE_END_STREAM_ACTION;
    private static final String RESPONSE_FORMAT_DELTA;
    private static final String RESPONSE_FORMAT_PARQUET;
    private static final String DELTA_SHARING_CAPABILITIES_DELIMITER;
    private static transient Logger org$apache$spark$internal$Logging$$log_;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$((Logging)MODULE$);
        SPARK_STRUCTURED_STREAMING = "Delta-Sharing-SparkStructuredStreaming";
        DELTA_SHARING_CAPABILITIES_HEADER = "delta-sharing-capabilities";
        RESPONSE_TABLE_VERSION_HEADER_KEY = "Delta-Table-Version";
        RESPONSE_FORMAT = "responseformat";
        READER_FEATURES = "readerfeatures";
        DELTA_SHARING_CAPABILITIES_ASYNC_READ = "asyncquery";
        DELTA_SHARING_INCLUDE_END_STREAM_ACTION = "includeendstreamaction";
        RESPONSE_FORMAT_DELTA = "delta";
        RESPONSE_FORMAT_PARQUET = "parquet";
        DELTA_SHARING_CAPABILITIES_DELIMITER = ";";
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int $lessinit$greater$default$2() {
        return 120;
    }

    public int $lessinit$greater$default$3() {
        return 3;
    }

    public long $lessinit$greater$default$4() {
        return Long.MAX_VALUE;
    }

    public long $lessinit$greater$default$5() {
        return 1000L;
    }

    public boolean $lessinit$greater$default$6() {
        return false;
    }

    public boolean $lessinit$greater$default$7() {
        return false;
    }

    public String $lessinit$greater$default$8() {
        return this.RESPONSE_FORMAT_PARQUET();
    }

    public String $lessinit$greater$default$9() {
        return "";
    }

    public boolean $lessinit$greater$default$10() {
        return false;
    }

    public int $lessinit$greater$default$11() {
        return 100000;
    }

    public boolean $lessinit$greater$default$12() {
        return false;
    }

    public boolean $lessinit$greater$default$13() {
        return false;
    }

    public long $lessinit$greater$default$14() {
        return 10000L;
    }

    public long $lessinit$greater$default$15() {
        return 600000L;
    }

    public int $lessinit$greater$default$16() {
        return 5;
    }

    public int $lessinit$greater$default$17() {
        return 60;
    }

    public int $lessinit$greater$default$18() {
        return 600;
    }

    public String SPARK_STRUCTURED_STREAMING() {
        return SPARK_STRUCTURED_STREAMING;
    }

    public String DELTA_SHARING_CAPABILITIES_HEADER() {
        return DELTA_SHARING_CAPABILITIES_HEADER;
    }

    public String RESPONSE_TABLE_VERSION_HEADER_KEY() {
        return RESPONSE_TABLE_VERSION_HEADER_KEY;
    }

    public String RESPONSE_FORMAT() {
        return RESPONSE_FORMAT;
    }

    public String READER_FEATURES() {
        return READER_FEATURES;
    }

    public String DELTA_SHARING_CAPABILITIES_ASYNC_READ() {
        return DELTA_SHARING_CAPABILITIES_ASYNC_READ;
    }

    public String DELTA_SHARING_INCLUDE_END_STREAM_ACTION() {
        return DELTA_SHARING_INCLUDE_END_STREAM_ACTION;
    }

    public String RESPONSE_FORMAT_DELTA() {
        return RESPONSE_FORMAT_DELTA;
    }

    public String RESPONSE_FORMAT_PARQUET() {
        return RESPONSE_FORMAT_PARQUET;
    }

    public String DELTA_SHARING_CAPABILITIES_DELIMITER() {
        return DELTA_SHARING_CAPABILITIES_DELIMITER;
    }

    private String USER_AGENT$lzycompute() {
        DeltaSharingRestClient$ deltaSharingRestClient$ = this;
        synchronized (deltaSharingRestClient$) {
            if (!bitmap$0) {
                USER_AGENT = this.liftedTree1$1();
                bitmap$0 = true;
            }
        }
        return USER_AGENT;
    }

    public String USER_AGENT() {
        if (!bitmap$0) {
            return this.USER_AGENT$lzycompute();
        }
        return USER_AGENT;
    }

    public String sparkVersionString() {
        return (String)Option$.MODULE$.apply((Object)SparkEnv$.MODULE$.get()).flatMap((Function1 & Serializable)env -> env.conf().getOption("spark.databricks.clusterUsageTags.sparkVersion")).map((Function1 & Serializable)dbrVersion -> new StringBuilder(19).append("Databricks-Runtime/").append((String)dbrVersion).toString()).getOrElse((Function0 & Serializable)() -> new StringBuilder(6).append("Spark/").append(package$.MODULE$.SPARK_VERSION()).toString());
    }

    public String spaceFreeProperty(String key) {
        String value = System.getProperty(key);
        if (value == null) {
            return "<unknown>";
        }
        return value.replace(' ', '_');
    }

    public ParsedDeltaSharingTablePath parsePath(String path) {
        int shapeIndex = path.lastIndexOf(35);
        if (shapeIndex < 0) {
            throw new IllegalArgumentException(new StringBuilder(18).append("path ").append(path).append(" is not valid").toString());
        }
        String profileFile = path.substring(0, shapeIndex);
        String[] tableSplits = path.substring(shapeIndex + 1).split("\\.", -1);
        if (tableSplits.length != 3) {
            throw new IllegalArgumentException(new StringBuilder(18).append("path ").append(path).append(" is not valid").toString());
        }
        if (profileFile.isEmpty() || tableSplits[0].isEmpty() || tableSplits[1].isEmpty() || tableSplits[2].isEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(18).append("path ").append(path).append(" is not valid").toString());
        }
        return new ParsedDeltaSharingTablePath(profileFile, tableSplits[0], tableSplits[1], tableSplits[2]);
    }

    public DeltaSharingClient apply(String profileFile, boolean forStreaming, String responseFormat, String readerFeatures) {
        SQLConf sqlConf = SparkSession$.MODULE$.active().sessionState().conf();
        String profileProviderClass = ConfUtils$.MODULE$.profileProviderClass(sqlConf);
        DeltaSharingProfileProvider profileProvider = (DeltaSharingProfileProvider)Class.forName(profileProviderClass).getConstructor(Configuration.class, String.class).newInstance(SparkSession$.MODULE$.active().sessionState().newHadoopConf(), profileFile);
        boolean sslTrustAll = ConfUtils$.MODULE$.sslTrustAll(sqlConf);
        int numRetries = ConfUtils$.MODULE$.numRetries(sqlConf);
        long maxRetryDurationMillis = ConfUtils$.MODULE$.maxRetryDurationMillis(sqlConf);
        long retrySleepIntervalMillis = ConfUtils$.MODULE$.retrySleepIntervalMillis(sqlConf);
        int timeoutInSeconds = ConfUtils$.MODULE$.timeoutInSeconds(sqlConf);
        boolean queryTablePaginationEnabled = ConfUtils$.MODULE$.queryTablePaginationEnabled(sqlConf);
        int maxFilesPerReq = ConfUtils$.MODULE$.maxFilesPerQueryRequest(sqlConf);
        boolean useAsyncQuery = ConfUtils$.MODULE$.useAsyncQuery(sqlConf);
        boolean endStreamActionEnabled = ConfUtils$.MODULE$.includeEndStreamAction(sqlConf);
        long asyncQueryMaxDurationMillis = ConfUtils$.MODULE$.asyncQueryTimeout(sqlConf);
        long asyncQueryPollDurationMillis = ConfUtils$.MODULE$.asyncQueryPollIntervalMillis(sqlConf);
        int tokenExchangeMaxRetries = ConfUtils$.MODULE$.tokenExchangeMaxRetries(sqlConf);
        int tokenExchangeMaxRetryDurationInSeconds = ConfUtils$.MODULE$.tokenExchangeMaxRetryDurationInSeconds(sqlConf);
        int tokenRenewalThresholdInSeconds = ConfUtils$.MODULE$.tokenRenewalThresholdInSeconds(sqlConf);
        String clientClass = ConfUtils$.MODULE$.clientClass(sqlConf);
        return (DeltaSharingClient)Class.forName(clientClass).getConstructor(DeltaSharingProfileProvider.class, Integer.TYPE, Integer.TYPE, Long.TYPE, Long.TYPE, Boolean.TYPE, Boolean.TYPE, String.class, String.class, Boolean.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(profileProvider, timeoutInSeconds, numRetries, maxRetryDurationMillis, retrySleepIntervalMillis, sslTrustAll, forStreaming, responseFormat, readerFeatures, queryTablePaginationEnabled, maxFilesPerReq, endStreamActionEnabled, useAsyncQuery, asyncQueryPollDurationMillis, asyncQueryMaxDurationMillis, tokenExchangeMaxRetries, tokenExchangeMaxRetryDurationInSeconds, tokenRenewalThresholdInSeconds);
    }

    public boolean apply$default$2() {
        return false;
    }

    public String apply$default$3() {
        return this.RESPONSE_FORMAT_PARQUET();
    }

    public String apply$default$4() {
        return "";
    }

    private final /* synthetic */ String liftedTree1$1() {
        String string;
        try {
            string = new StringBuilder(38).append(" Hadoop/").append(VersionInfo.getVersion()).append(" ").append(this.spaceFreeProperty("os.name")).append("/").append(this.spaceFreeProperty("os.version")).append(" ").append(this.spaceFreeProperty("java.vm.name")).append("/").append(this.spaceFreeProperty("java.vm.version")).append(" java/").append(this.spaceFreeProperty("java.version")).append(" scala/").append(Properties$.MODULE$.versionNumberString()).append(" java_vendor/").append(this.spaceFreeProperty("java.vendor")).toString();
        }
        catch (Throwable e) {
            this.log().warn("Unable to load version information for Delta Sharing", e);
            string = "Delta-Sharing-Spark/<unknown>";
        }
        return string;
    }

    private DeltaSharingRestClient$() {
    }
}

