/*
 * Decompiled with CFR 0.152.
 */
package io.delta.sharing.spark;

import io.delta.sharing.client.model.AddCDCFile;
import io.delta.sharing.client.model.AddFileForCDF;
import io.delta.sharing.client.model.RemoveFile;
import io.delta.sharing.spark.RemoteDeltaCDCFileIndex;
import io.delta.sharing.spark.RemoteDeltaCDFAddFileIndex;
import io.delta.sharing.spark.RemoteDeltaCDFFileIndexBase;
import io.delta.sharing.spark.RemoteDeltaCDFRemoveFileIndex;
import io.delta.sharing.spark.RemoteDeltaFileIndexParams;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import org.apache.spark.delta.sharing.CachedTableManager$;
import org.apache.spark.delta.sharing.TableRefreshResult;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.DeltaSharingScanUtils$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.StructType;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class DeltaSharingCDFReader$ {
    public static final DeltaSharingCDFReader$ MODULE$ = new DeltaSharingCDFReader$();

    public Dataset<Row> changesToDF(RemoteDeltaFileIndexParams params, String[] requiredColumns, Seq<AddFileForCDF> addFiles, Seq<AddCDCFile> cdfFiles, Seq<RemoveFile> removeFiles, StructType schema, boolean isStreaming, Function1<Option<String>, TableRefreshResult> refresher, long lastQueryTableTimestamp, Option<Object> expirationTimestamp) {
        ListBuffer dfs = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ListBuffer refs = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RemoteDeltaCDFAddFileIndex fileIndex1 = new RemoteDeltaCDFAddFileIndex(params, addFiles);
        refs.append(new WeakReference<RemoteDeltaCDFAddFileIndex>(fileIndex1));
        dfs.append(this.scanIndex(fileIndex1, schema, isStreaming));
        RemoteDeltaCDCFileIndex fileIndex2 = new RemoteDeltaCDCFileIndex(params, cdfFiles);
        refs.append(new WeakReference<RemoteDeltaCDCFileIndex>(fileIndex2));
        dfs.append(this.scanIndex(fileIndex2, schema, isStreaming));
        RemoteDeltaCDFRemoveFileIndex fileIndex3 = new RemoteDeltaCDFRemoveFileIndex(params, removeFiles);
        refs.append(new WeakReference<RemoteDeltaCDFRemoveFileIndex>(fileIndex3));
        dfs.append(this.scanIndex(fileIndex3, schema, isStreaming));
        CachedTableManager$.MODULE$.INSTANCE().register(params.path().toString(), this.getIdToUrl(addFiles, cdfFiles, removeFiles), (Seq<WeakReference<Object>>)refs.toSeq(), params.profileProvider(), refresher, expirationTimestamp.isDefined() ? BoxesRunTime.unboxToLong((Object)expirationTimestamp.get()) : lastQueryTableTimestamp + CachedTableManager$.MODULE$.INSTANCE().preSignedUrlExpirationMs(), (Option<String>)None$.MODULE$);
        return ((Dataset)dfs.reduce((Function2 & Serializable)(df1, df2) -> df1.unionAll(df2))).select((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])requiredColumns), (Function1 & Serializable)c -> functions$.MODULE$.col(MODULE$.quoteIdentifier((String)c)), ClassTag$.MODULE$.apply(Column.class))));
    }

    public Map<String, String> getIdToUrl(Seq<AddFileForCDF> addFiles, Seq<AddCDCFile> cdfFiles, Seq<RemoveFile> removeFiles) {
        return (Map)((MapOps)((IterableOnceOps)addFiles.map((Function1 & Serializable)a -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)a.id()), (Object)a.url()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$plus$plus((IterableOnce)((IterableOnceOps)cdfFiles.map((Function1 & Serializable)c -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)c.id()), (Object)c.url()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))).$plus$plus((IterableOnce)((IterableOnceOps)removeFiles.map((Function1 & Serializable)r -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)r.id()), (Object)r.url()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public Option<Object> getMinUrlExpiration(Seq<AddFileForCDF> addFiles, Seq<AddCDCFile> cdfFiles, Seq<RemoveFile> removeFiles) {
        ObjectRef minUrlExpiration;
        block0: {
            minUrlExpiration = ObjectRef.create((Object)None$.MODULE$);
            addFiles.foreach((Function1 & Serializable)a -> {
                DeltaSharingCDFReader$.$anonfun$getMinUrlExpiration$1(minUrlExpiration, a);
                return BoxedUnit.UNIT;
            });
            cdfFiles.foreach((Function1 & Serializable)c -> {
                DeltaSharingCDFReader$.$anonfun$getMinUrlExpiration$2(minUrlExpiration, c);
                return BoxedUnit.UNIT;
            });
            removeFiles.foreach((Function1 & Serializable)r -> {
                DeltaSharingCDFReader$.$anonfun$getMinUrlExpiration$3(minUrlExpiration, r);
                return BoxedUnit.UNIT;
            });
            if (CachedTableManager$.MODULE$.INSTANCE().isValidUrlExpirationTime((Option<Object>)((Option)minUrlExpiration.elem))) break block0;
            minUrlExpiration.elem = None$.MODULE$;
        }
        return (Option)minUrlExpiration.elem;
    }

    private String quoteIdentifier(String part) {
        return new StringBuilder(2).append("`").append(part.replace("`", "``")).append("`").toString();
    }

    private Dataset<Row> scanIndex(RemoteDeltaCDFFileIndexBase fileIndex, StructType schema, boolean isStreaming) {
        HadoopFsRelation relation = new HadoopFsRelation((FileIndex)fileIndex, fileIndex.partitionSchema(), schema, (Option)None$.MODULE$, fileIndex.params().snapshotAtAnalysis().fileFormat(), Predef$.MODULE$.Map().empty(), fileIndex.params().spark());
        LogicalRelation plan = LogicalRelation$.MODULE$.apply((BaseRelation)relation, isStreaming);
        return DeltaSharingScanUtils$.MODULE$.ofRows(fileIndex.params().spark(), plan);
    }

    public static final /* synthetic */ void $anonfun$getMinUrlExpiration$1(ObjectRef minUrlExpiration$1, AddFileForCDF a) {
        if (a.expirationTimestamp() != null) {
            minUrlExpiration$1.elem = ((Option)minUrlExpiration$1.elem).isDefined() && BoxesRunTime.unboxToLong((Object)((Option)minUrlExpiration$1.elem).get()) < Predef$.MODULE$.Long2long(a.expirationTimestamp()) ? (Option)minUrlExpiration$1.elem : new Some((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(a.expirationTimestamp())));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$getMinUrlExpiration$2(ObjectRef minUrlExpiration$1, AddCDCFile c) {
        if (c.expirationTimestamp() != null) {
            minUrlExpiration$1.elem = ((Option)minUrlExpiration$1.elem).isDefined() && BoxesRunTime.unboxToLong((Object)((Option)minUrlExpiration$1.elem).get()) < Predef$.MODULE$.Long2long(c.expirationTimestamp()) ? (Option)minUrlExpiration$1.elem : new Some((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(c.expirationTimestamp())));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$getMinUrlExpiration$3(ObjectRef minUrlExpiration$1, RemoveFile r) {
        if (r.expirationTimestamp() != null) {
            minUrlExpiration$1.elem = ((Option)minUrlExpiration$1.elem).isDefined() && BoxesRunTime.unboxToLong((Object)((Option)minUrlExpiration$1.elem).get()) < Predef$.MODULE$.Long2long(r.expirationTimestamp()) ? (Option)minUrlExpiration$1.elem : new Some((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(r.expirationTimestamp())));
            return;
        }
    }

    private DeltaSharingCDFReader$() {
    }
}

