/*
 * Decompiled with CFR 0.152.
 */
package io.delta.sharing.spark;

import io.delta.sharing.client.util.JsonUtils$;
import io.delta.sharing.spark.DeltaSharingErrors$;
import io.delta.sharing.spark.DeltaSharingSourceOffset;
import java.io.Serializable;
import org.apache.spark.sql.connector.read.streaming.Offset;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple5;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class DeltaSharingSourceOffset$
implements Serializable {
    public static final DeltaSharingSourceOffset$ MODULE$ = new DeltaSharingSourceOffset$();
    private static final int VERSION_1 = 1;

    public int VERSION_1() {
        return VERSION_1;
    }

    public DeltaSharingSourceOffset apply(long sourceVersion, String tableId, long tableVersion, long index, boolean isStartingVersion) {
        return new DeltaSharingSourceOffset(sourceVersion, tableId, tableVersion, index, isStartingVersion);
    }

    public DeltaSharingSourceOffset apply(String tableId, Offset offset) {
        Offset offset2 = offset;
        if (offset2 instanceof DeltaSharingSourceOffset) {
            DeltaSharingSourceOffset deltaSharingSourceOffset = (DeltaSharingSourceOffset)offset2;
            return deltaSharingSourceOffset;
        }
        this.validateSourceVersion(offset2.json());
        DeltaSharingSourceOffset o = (DeltaSharingSourceOffset)JsonUtils$.MODULE$.fromJson(offset2.json(), ManifestFactory$.MODULE$.classType(DeltaSharingSourceOffset.class));
        String string = o.tableId();
        String string2 = tableId;
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw DeltaSharingErrors$.MODULE$.nonExistentDeltaSharingTable(o.tableId());
        }
        return o;
    }

    private void validateSourceVersion(String json) {
        JsonAST.JValue parsedJson = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(json), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
        Option versionOpt = this.jsonOption(package$.MODULE$.jvalue2monadic(parsedJson).$bslash("sourceVersion")).map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToLong((long)DeltaSharingSourceOffset$.$anonfun$validateSourceVersion$1(x0$1)));
        if (versionOpt.isEmpty()) {
            throw DeltaSharingErrors$.MODULE$.cannotFindSourceVersionException(json);
        }
        int maxVersion = this.VERSION_1();
        if (BoxesRunTime.unboxToLong((Object)versionOpt.get()) > (long)maxVersion) {
            throw DeltaSharingErrors$.MODULE$.unsupportedTableReaderVersion(maxVersion, BoxesRunTime.unboxToLong((Object)versionOpt.get()));
        }
    }

    private Option<JsonAST.JValue> jsonOption(JsonAST.JValue json) {
        JsonAST.JValue jValue = json;
        JsonAST.JNothing$ jNothing$ = package$.MODULE$.JNothing();
        JsonAST.JValue jValue2 = jValue;
        if (!(jNothing$ != null ? !jNothing$.equals(jValue2) : jValue2 != null)) {
            return None$.MODULE$;
        }
        if (jValue != null) {
            JsonAST.JValue jValue3 = jValue;
            return new Some((Object)jValue3);
        }
        throw new MatchError((Object)jValue);
    }

    public void validateOffsets(DeltaSharingSourceOffset previousOffset, DeltaSharingSourceOffset currentOffset) {
        if (!previousOffset.isStartingVersion() && currentOffset.isStartingVersion()) {
            throw new IllegalStateException(new StringBuilder(84).append("Found invalid offsets: 'isStartingVersion' fliped incorrectly. ").append("Previous: ").append(previousOffset).append(", Current: ").append(currentOffset).toString());
        }
        if (previousOffset.compare(currentOffset) > 0) {
            throw new IllegalStateException(new StringBuilder(44).append("Found invalid offsets. Previous: ").append(previousOffset).append(", Current: ").append(currentOffset).toString());
        }
    }

    public Option<Tuple5<Object, String, Object, Object, Object>> unapply(DeltaSharingSourceOffset x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple5((Object)BoxesRunTime.boxToLong((long)x$0.sourceVersion()), (Object)x$0.tableId(), (Object)BoxesRunTime.boxToLong((long)x$0.tableVersion()), (Object)BoxesRunTime.boxToLong((long)x$0.index()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.isStartingVersion())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DeltaSharingSourceOffset$.class);
    }

    public static final /* synthetic */ long $anonfun$validateSourceVersion$1(JsonAST.JValue x0$1) {
        JsonAST.JValue jValue = x0$1;
        if (jValue instanceof JsonAST.JInt) {
            JsonAST.JInt jInt = (JsonAST.JInt)jValue;
            return jInt.num().longValue();
        }
        throw DeltaSharingErrors$.MODULE$.invalidSourceVersion(jValue.toString());
    }

    private DeltaSharingSourceOffset$() {
    }
}

