/*
 * Decompiled with CFR 0.152.
 */
package io.delta.sharing.spark;

import io.delta.sharing.client.DeltaSharingClient;
import io.delta.sharing.client.model.AddFile;
import io.delta.sharing.client.model.DeltaTableFiles;
import io.delta.sharing.client.model.DeltaTableMetadata;
import io.delta.sharing.client.model.Metadata;
import io.delta.sharing.client.model.Protocol;
import io.delta.sharing.client.model.Table;
import io.delta.sharing.client.util.ConfUtils$;
import io.delta.sharing.spark.DeltaTableUtils$;
import io.delta.sharing.spark.RemoteDeltaLog$;
import io.delta.sharing.spark.RemoteDeltaSnapshotFileIndex;
import io.delta.sharing.spark.RemoteSnapshot$;
import io.delta.sharing.spark.util.SchemaUtils$;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.delta.sharing.CachedTableManager$;
import org.apache.spark.delta.sharing.TableRefreshResult;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.DeltaSharingScanUtils$;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\u0005%g\u0001\u0002\u000f\u001e\u0001\u0019B\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\"Aq\t\u0001B\u0001B\u0003%\u0001\n\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003P\u0011!)\u0006A!A!\u0002\u00131\u0006\u0002\u00032\u0001\u0005\u0003\u0005\u000b\u0011B2\t\u000b\u001d\u0004A\u0011\u00015\t\u000by\u0001A\u0011C9\t\u0011a\u0004\u0001R1A\u0005\neD!B\u001f\u0001\u0011\u0002#\u001d\r\u0015\"\u0003|\u0011)\tY\u0001\u0001EC\u0002\u0013\u0005\u0011Q\u0002\u0005\u000b\u0003\u001f\u0001\u0001R1A\u0005\u0002\u0005E\u0001BCA\n\u0001!\u0015\r\u0011\"\u0001\u0002\u0016!Q\u0011q\u0003\u0001\t\u0006\u0004%\t!!\u0007\t\u0015\u0005\u001d\u0002\u0001#b\u0001\n\u0003\tI\u0002C\u0004\u0002*\u0001!\t!a\u000b\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@!Q\u0011\u0011\t\u0001\t\u0006\u0004%\t!!\u0006\t\u000f\u0005\r\u0003\u0001\"\u0003\u0002F!9\u0011\u0011\u000b\u0001\u0005\n\u0005M\u0003bBA-\u0001\u0011\u0005\u00111L\u0004\n\u0003;k\u0012\u0011!E\u0001\u0003?3\u0001\u0002H\u000f\u0002\u0002#\u0005\u0011\u0011\u0015\u0005\u0007O^!\t!a)\t\u0013\u0005\u0015v#%A\u0005\u0002\u0005\u001d\u0006\"CA_/E\u0005I\u0011AA`\u0011%\t\u0019mFI\u0001\n\u0003\t)M\u0001\bSK6|G/Z*oCB\u001c\bn\u001c;\u000b\u0005yy\u0012!B:qCJ\\'B\u0001\u0011\"\u0003\u001d\u0019\b.\u0019:j]\u001eT!AI\u0012\u0002\u000b\u0011,G\u000e^1\u000b\u0003\u0011\n!![8\u0004\u0001M\u0019\u0001aJ\u0017\u0011\u0005!ZS\"A\u0015\u000b\u0003)\nQa]2bY\u0006L!\u0001L\u0015\u0003\r\u0005s\u0017PU3g!\tqc'D\u00010\u0015\t\u0001\u0014'\u0001\u0005j]R,'O\\1m\u0015\tq\"G\u0003\u00024i\u00051\u0011\r]1dQ\u0016T\u0011!N\u0001\u0004_J<\u0017BA\u001c0\u0005\u001daunZ4j]\u001e\f\u0011\u0002^1cY\u0016\u0004\u0016\r\u001e5\u0011\u0005izT\"A\u001e\u000b\u0005qj\u0014A\u00014t\u0015\tq$'\u0001\u0004iC\u0012|w\u000e]\u0005\u0003\u0001n\u0012A\u0001U1uQ\u000611\r\\5f]R\u0004\"aQ#\u000e\u0003\u0011S!!Q\u0010\n\u0005\u0019#%A\u0005#fYR\f7\u000b[1sS:<7\t\\5f]R\fQ\u0001^1cY\u0016\u0004\"!\u0013'\u000e\u0003)S!a\u0013#\u0002\u000b5|G-\u001a7\n\u00055S%!\u0002+bE2,\u0017a\u0003<feNLwN\\!t\u001f\u001a\u00042\u0001\u000b)S\u0013\t\t\u0016F\u0001\u0004PaRLwN\u001c\t\u0003QMK!\u0001V\u0015\u0003\t1{gnZ\u0001\u000ei&lWm\u001d;b[B\f5o\u00144\u0011\u0007!\u0002v\u000b\u0005\u0002Y?:\u0011\u0011,\u0018\t\u00035&j\u0011a\u0017\u0006\u00039\u0016\na\u0001\u0010:p_Rt\u0014B\u00010*\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001-\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005yK\u0013AF5oSR$U\r\u001c;b)\u0006\u0014G.Z'fi\u0006$\u0017\r^1\u0011\u0007!\u0002F\r\u0005\u0002JK&\u0011aM\u0013\u0002\u0013\t\u0016dG/\u0019+bE2,W*\u001a;bI\u0006$\u0018-\u0001\u0004=S:LGO\u0010\u000b\bS.dWN\\8q!\tQ\u0007!D\u0001\u001e\u0011\u0015At\u00011\u0001:\u0011\u0015\tu\u00011\u0001C\u0011\u00159u\u00011\u0001I\u0011\u001dqu\u0001%AA\u0002=Cq!V\u0004\u0011\u0002\u0003\u0007a\u000bC\u0004c\u000fA\u0005\t\u0019A2\u0016\u0003I\u0004\"a\u001d<\u000e\u0003QT!!^\u0019\u0002\u0007M\fH.\u0003\u0002xi\na1\u000b]1sWN+7o]5p]\u0006iA/\u00192mK6+G/\u00193bi\u0006,\u0012\u0001Z\u0001\u0004q\u0012\u001aT#\u0001?\u0011\r!jx0!\u0002S\u0013\tq\u0018F\u0001\u0004UkBdWm\r\t\u0004\u0013\u0006\u0005\u0011bAA\u0002\u0015\nAQ*\u001a;bI\u0006$\u0018\rE\u0002J\u0003\u000fI1!!\u0003K\u0005!\u0001&o\u001c;pG>d\u0017\u0001C7fi\u0006$\u0017\r^1\u0016\u0003}\f\u0001\u0002\u001d:pi>\u001cw\u000e\\\u000b\u0003\u0003\u000b\tqA^3sg&|g.F\u0001S\u0003\u0019\u00198\r[3nCV\u0011\u00111\u0004\t\u0005\u0003;\t\u0019#\u0004\u0002\u0002 )\u0019\u0011\u0011\u0005;\u0002\u000bQL\b/Z:\n\t\u0005\u0015\u0012q\u0004\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017a\u00049beRLG/[8o'\u000eDW-\\1\u0002\u0015\u0019LG.\u001a$pe6\fG/\u0006\u0002\u0002.A!\u0011qFA\u001d\u001b\t\t\tD\u0003\u0003\u00024\u0005U\u0012a\u00033bi\u0006\u001cx.\u001e:dKNT1!a\u000eu\u0003%)\u00070Z2vi&|g.\u0003\u0003\u0002<\u0005E\"A\u0003$jY\u00164uN]7bi\u0006aq-\u001a;UC\ndW\rU1uQV\t\u0011(A\u0006tSj,\u0017J\u001c\"zi\u0016\u001c\u0018AF2iK\u000e\\\u0007K]8u_\u000e|GNT8u\u0007\"\fgnZ3\u0015\t\u0005\u001d\u0013Q\n\t\u0004Q\u0005%\u0013bAA&S\t!QK\\5u\u0011\u001d\tye\u0005a\u0001\u0003\u000b\t1B\\3x!J|Go\\2pY\u0006!2\r[3dWN\u001b\u0007.Z7b\u001d>$8\t[1oO\u0016$B!a\u0012\u0002V!1\u0011q\u000b\u000bA\u0002}\f1B\\3x\u001b\u0016$\u0018\rZ1uC\u0006aa-\u001b7fg\u001a{'oU2b]RQ\u0011QLA;\u0003\u0017\u000by)a%\u0011\r\u0005}\u0013\u0011NA8\u001d\u0011\t\t'!\u001a\u000f\u0007i\u000b\u0019'C\u0001+\u0013\r\t9'K\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY'!\u001c\u0003\u0007M+\u0017OC\u0002\u0002h%\u00022!SA9\u0013\r\t\u0019H\u0013\u0002\b\u0003\u0012$g)\u001b7f\u0011\u001d\t9(\u0006a\u0001\u0003s\nqAZ5mi\u0016\u00148\u000f\u0005\u0004\u0002`\u0005%\u00141\u0010\t\u0005\u0003{\n9)\u0004\u0002\u0002\u0000)!\u0011\u0011QAB\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0007\u0005\u0015E/\u0001\u0005dCR\fG._:u\u0013\u0011\tI)a \u0003\u0015\u0015C\bO]3tg&|g\u000e\u0003\u0004\u0002\u000eV\u0001\raT\u0001\nY&l\u0017\u000e\u001e%j]RDa!!%\u0016\u0001\u00041\u0016A\u00056t_:\u0004&/\u001a3jG\u0006$X\rS5oiNDq!!&\u0016\u0001\u0004\t9*A\u0005gS2,\u0017J\u001c3fqB\u0019!.!'\n\u0007\u0005mUD\u0001\u000fSK6|G/\u001a#fYR\f7K\\1qg\"|GOR5mK&sG-\u001a=\u0002\u001dI+Wn\u001c;f':\f\u0007o\u001d5piB\u0011!nF\n\u0003/\u001d\"\"!a(\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\tIKK\u0002P\u0003W[#!!,\u0011\t\u0005=\u0016\u0011X\u0007\u0003\u0003cSA!a-\u00026\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003oK\u0013AC1o]>$\u0018\r^5p]&!\u00111XAY\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005\u0005'f\u0001,\u0002,\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIY*\"!a2+\u0007\r\fY\u000b")
public class RemoteSnapshot
implements Logging {
    private DeltaTableMetadata tableMetadata;
    private Tuple3<Metadata, Protocol, Object> x$3;
    private Metadata metadata;
    private Protocol protocol;
    private long version;
    private StructType schema;
    private StructType partitionSchema;
    private long sizeInBytes;
    private final Path tablePath;
    private final DeltaSharingClient client;
    private final Table table;
    private final Option<Object> versionAsOf;
    private final Option<String> timestampAsOf;
    private Option<DeltaTableMetadata> initDeltaTableMetadata;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static Option<DeltaTableMetadata> $lessinit$greater$default$6() {
        return RemoteSnapshot$.MODULE$.$lessinit$greater$default$6();
    }

    public static Option<String> $lessinit$greater$default$5() {
        return RemoteSnapshot$.MODULE$.$lessinit$greater$default$5();
    }

    public static Option<Object> $lessinit$greater$default$4() {
        return RemoteSnapshot$.MODULE$.$lessinit$greater$default$4();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SparkSession spark() {
        return SparkSession$.MODULE$.active();
    }

    private DeltaTableMetadata tableMetadata$lzycompute() {
        RemoteSnapshot remoteSnapshot = this;
        synchronized (remoteSnapshot) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.tableMetadata = (DeltaTableMetadata)this.initDeltaTableMetadata.getOrElse((Function0 & Serializable)() -> $this.client.getMetadata($this.table, $this.versionAsOf, $this.timestampAsOf));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        this.initDeltaTableMetadata = null;
        return this.tableMetadata;
    }

    private DeltaTableMetadata tableMetadata() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.tableMetadata$lzycompute();
        }
        return this.tableMetadata;
    }

    private Tuple3<Metadata, Protocol, Object> x$3$lzycompute() {
        RemoteSnapshot remoteSnapshot = this;
        synchronized (remoteSnapshot) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Tuple3 tuple3 = new Tuple3((Object)this.tableMetadata().metadata(), (Object)this.tableMetadata().protocol(), (Object)BoxesRunTime.boxToLong((long)this.tableMetadata().version()));
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                Metadata metadata = (Metadata)tuple3._1();
                Protocol protocol = (Protocol)tuple3._2();
                long version = BoxesRunTime.unboxToLong((Object)tuple3._3());
                this.x$3 = new Tuple3((Object)metadata, (Object)protocol, (Object)BoxesRunTime.boxToLong((long)version));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.x$3;
    }

    private /* synthetic */ Tuple3 x$3() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.x$3$lzycompute();
        }
        return this.x$3;
    }

    private Metadata metadata$lzycompute() {
        RemoteSnapshot remoteSnapshot = this;
        synchronized (remoteSnapshot) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.metadata = (Metadata)this.x$3()._1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.metadata;
    }

    public Metadata metadata() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.metadata$lzycompute();
        }
        return this.metadata;
    }

    private Protocol protocol$lzycompute() {
        RemoteSnapshot remoteSnapshot = this;
        synchronized (remoteSnapshot) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.protocol = (Protocol)this.x$3()._2();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.protocol;
    }

    public Protocol protocol() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.protocol$lzycompute();
        }
        return this.protocol;
    }

    private long version$lzycompute() {
        RemoteSnapshot remoteSnapshot = this;
        synchronized (remoteSnapshot) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.version = BoxesRunTime.unboxToLong((Object)this.x$3()._3());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.version;
    }

    public long version() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.version$lzycompute();
        }
        return this.version;
    }

    private StructType schema$lzycompute() {
        RemoteSnapshot remoteSnapshot = this;
        synchronized (remoteSnapshot) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.schema = DeltaTableUtils$.MODULE$.toSchema(this.metadata().schemaString());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.schema;
    }

    public StructType schema() {
        if ((byte)(this.bitmap$0 & 0x20) == 0) {
            return this.schema$lzycompute();
        }
        return this.schema;
    }

    private StructType partitionSchema$lzycompute() {
        RemoteSnapshot remoteSnapshot = this;
        synchronized (remoteSnapshot) {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                this.partitionSchema = new StructType((StructField[])((IterableOnceOps)this.metadata().partitionColumns().map((Function1 & Serializable)c -> this.schema().apply(c))).toArray(ClassTag$.MODULE$.apply(StructField.class)));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
            }
        }
        return this.partitionSchema;
    }

    public StructType partitionSchema() {
        if ((byte)(this.bitmap$0 & 0x40) == 0) {
            return this.partitionSchema$lzycompute();
        }
        return this.partitionSchema;
    }

    public FileFormat fileFormat() {
        return new ParquetFileFormat();
    }

    public Path getTablePath() {
        return this.tablePath;
    }

    private long sizeInBytes$lzycompute() {
        RemoteSnapshot remoteSnapshot = this;
        synchronized (remoteSnapshot) {
            if ((byte)(this.bitmap$0 & 0x80) == 0) {
                long l;
                SparkSession.implicits$ implicits = this.spark().implicits();
                if (this.metadata().size() != null) {
                    l = Predef$.MODULE$.Long2long(this.metadata().size());
                } else {
                    this.log().warn(new StringBuilder(52).append("Getting table size from a full file scan for table: ").append(this.table).toString());
                    DeltaTableFiles tableFiles = this.client.getFiles(this.table, (Seq<String>)Nil$.MODULE$, (Option<Object>)None$.MODULE$, this.versionAsOf, this.timestampAsOf, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
                    this.checkProtocolNotChange(tableFiles.protocol());
                    this.checkSchemaNotChange(tableFiles.metadata());
                    l = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)tableFiles.files().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.size()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                }
                this.sizeInBytes = l;
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x80);
            }
        }
        return this.sizeInBytes;
    }

    public long sizeInBytes() {
        if ((byte)(this.bitmap$0 & 0x80) == 0) {
            return this.sizeInBytes$lzycompute();
        }
        return this.sizeInBytes;
    }

    private void checkProtocolNotChange(Protocol newProtocol) {
        Protocol protocol = newProtocol;
        Protocol protocol2 = this.protocol();
        if (protocol == null ? protocol2 != null : !((Object)protocol).equals(protocol2)) {
            throw new SparkException("The table protocol has changed since your DataFrame was created. Please redefine your DataFrame");
        }
    }

    private void checkSchemaNotChange(Metadata newMetadata) {
        block6: {
            SparkException schemaChangedException;
            block5: {
                schemaChangedException = new SparkException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("The schema or partition columns of your Delta table has changed since your\n         |DataFrame was created. Please redefine your DataFrame")));
                if (ConfUtils$.MODULE$.structuralSchemaMatchingEnabled(this.spark().sessionState().conf())) {
                    StructType newSchema = (StructType)DataType$.MODULE$.fromJson(newMetadata.schemaString());
                    StructType currentSchema = (StructType)DataType$.MODULE$.fromJson(this.metadata().schemaString());
                    Seq<String> seq = this.metadata().partitionColumns();
                    Seq<String> seq2 = newMetadata.partitionColumns();
                    if ((seq != null ? !seq.equals(seq2) : seq2 != null) || !SchemaUtils$.MODULE$.isReadCompatible(currentSchema, newSchema)) {
                        throw schemaChangedException;
                    }
                    return;
                }
                String string = newMetadata.schemaString();
                String string2 = this.metadata().schemaString();
                if (string != null ? !string.equals(string2) : string2 != null) break block5;
                Seq<String> seq = newMetadata.partitionColumns();
                Seq<String> seq3 = this.metadata().partitionColumns();
                if (!(seq == null ? seq3 != null : !seq.equals(seq3))) break block6;
            }
            throw schemaChangedException;
        }
    }

    public Seq<AddFile> filesForScan(Seq<Expression> filters, Option<Object> limitHint, Option<String> jsonPredicateHints, RemoteDeltaSnapshotFileIndex fileIndex) {
        Encoder<AddFile> enc = RemoteDeltaLog$.MODULE$.addFileEncoder();
        Seq partitionFilters = (Seq)filters.flatMap((Function1 & Serializable)filter -> (Seq)DeltaTableUtils$.MODULE$.splitMetadataAndDataPredicates((Expression)filter, this.metadata().partitionColumns(), this.spark())._1());
        Seq<Expression> rewrittenFilters = DeltaTableUtils$.MODULE$.rewritePartitionFilters(this.partitionSchema(), (Function2<String, String, Object>)this.spark().sessionState().conf().resolver(), (Seq<Expression>)partitionFilters, this.spark().sessionState().conf().sessionLocalTimeZone());
        Seq predicates = (Seq)rewrittenFilters.map((Function1 & Serializable)x$5 -> x$5.sql());
        if (predicates.nonEmpty()) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Sending predicates ").append(predicates).append(" to the server").toString());
        }
        SparkSession.implicits$ implicits = this.spark().implicits();
        DeltaTableFiles tableFiles = this.client.getFiles(this.table, (Seq<String>)predicates, limitHint, this.versionAsOf, this.timestampAsOf, jsonPredicateHints, (Option<String>)None$.MODULE$);
        ObjectRef minUrlExpirationTimestamp = ObjectRef.create((Object)None$.MODULE$);
        Map idToUrl = ((IterableOnceOps)tableFiles.files().map((Function1 & Serializable)file -> {
            block0: {
                if (file.expirationTimestamp() == null) break block0;
                minUrlExpirationTimestamp$1.elem = ((Option)minUrlExpirationTimestamp$1.elem).isDefined() && BoxesRunTime.unboxToLong((Object)((Option)minUrlExpirationTimestamp$1.elem).get()) < Predef$.MODULE$.Long2long(file.expirationTimestamp()) ? (Option)minUrlExpirationTimestamp$1.elem : new Some((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(file.expirationTimestamp())));
            }
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)file.id()), (Object)file.url());
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        CachedTableManager$.MODULE$.INSTANCE().register(fileIndex.params().path().toString(), (Map<String, String>)idToUrl, (Seq<WeakReference<Object>>)new .colon.colon(new WeakReference<RemoteDeltaSnapshotFileIndex>(fileIndex), (List)Nil$.MODULE$), fileIndex.params().profileProvider(), (Function1<Option<String>, TableRefreshResult>)(Function1 & Serializable)refreshToken -> {
            DeltaTableFiles tableFiles = $this.client.getFiles($this.table, (Seq<String>)Nil$.MODULE$, (Option<Object>)None$.MODULE$, $this.versionAsOf, $this.timestampAsOf, jsonPredicateHints, (Option<String>)refreshToken);
            ObjectRef minUrlExpiration = ObjectRef.create((Object)None$.MODULE$);
            Map idToUrl = ((IterableOnceOps)tableFiles.files().map((Function1 & Serializable)add -> {
                block0: {
                    if (add.expirationTimestamp() == null) break block0;
                    minUrlExpiration$1.elem = ((Option)minUrlExpiration$1.elem).isDefined() && BoxesRunTime.unboxToLong((Object)((Option)minUrlExpiration$1.elem).get()) < Predef$.MODULE$.Long2long(add.expirationTimestamp()) ? (Option)minUrlExpiration$1.elem : new Some((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(add.expirationTimestamp())));
                }
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)add.id()), (Object)add.url());
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            return new TableRefreshResult((Map<String, String>)idToUrl, (Option<Object>)((Option)minUrlExpiration.elem), tableFiles.refreshToken());
        }, CachedTableManager$.MODULE$.INSTANCE().isValidUrlExpirationTime((Option<Object>)((Option)minUrlExpirationTimestamp.elem)) ? BoxesRunTime.unboxToLong((Object)((Option)minUrlExpirationTimestamp.elem).get()) : System.currentTimeMillis() + CachedTableManager$.MODULE$.INSTANCE().preSignedUrlExpirationMs(), tableFiles.refreshToken());
        this.checkProtocolNotChange(tableFiles.protocol());
        this.checkSchemaNotChange(tableFiles.metadata());
        Dataset remoteFiles = implicits.localSeqToDatasetHolder(tableFiles.files(), enc).toDS();
        Column columnFilter = DeltaSharingScanUtils$.MODULE$.toColumn((Expression)rewrittenFilters.reduceLeftOption((Function2)And$.MODULE$).getOrElse((Function0 & Serializable)() -> Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true))));
        return Predef$.MODULE$.copyArrayToImmutableIndexedSeq(remoteFiles.filter(columnFilter).as(enc).collect());
    }

    public RemoteSnapshot(Path tablePath, DeltaSharingClient client, Table table, Option<Object> versionAsOf, Option<String> timestampAsOf, Option<DeltaTableMetadata> initDeltaTableMetadata) {
        this.tablePath = tablePath;
        this.client = client;
        this.table = table;
        this.versionAsOf = versionAsOf;
        this.timestampAsOf = timestampAsOf;
        this.initDeltaTableMetadata = initDeltaTableMetadata;
        Logging.$init$((Logging)this);
    }
}

