/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.delta.sharing;

import io.delta.sharing.client.DeltaSharingProfileProvider;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.spark.delta.sharing.CachedTable;
import org.apache.spark.delta.sharing.CachedTableManager$;
import org.apache.spark.delta.sharing.TableRefreshResult;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005}e\u0001B\u000e\u001d\u0001\u001dB\u0001\u0002\u000e\u0001\u0003\u0006\u0004%\t!\u000e\u0005\ts\u0001\u0011\t\u0011)A\u0005m!A!\b\u0001B\u0001B\u0003%a\u0007\u0003\u0005<\u0001\t\u0015\r\u0011\"\u00016\u0011!a\u0004A!A!\u0002\u00131\u0004\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001c\t\u000by\u0002A\u0011A \t\u000f\u0019\u0003!\u0019!C\u0005\u000f\"1\u0001\r\u0001Q\u0001\n!Cq!\u0019\u0001C\u0002\u0013%!\r\u0003\u0004g\u0001\u0001\u0006Ia\u0019\u0005\u0006O\u0002!\t\u0001\u001b\u0005\u0006c\u0002!\tA\u001d\u0005\u0006m\u0002!\ta\u001e\u0005\b\u0003\u001f\u0001A\u0011AA\t\u0011%\t9\bAI\u0001\n\u0003\tI\b\u0003\u0004\u0002\u0010\u0002!\tA\u001d\u0005\u0007\u0003#\u0003A\u0011\u0001:\b\u000f\u0005ME\u0004#\u0001\u0002\u0016\u001a11\u0004\bE\u0001\u0003/CaA\u0010\u000b\u0005\u0002\u0005e\u0005\u0002\u0003\u001b\u0015\u0011\u000b\u0007I\u0011B\u001b\t\u0011i\"\u0002R1A\u0005\nUB\u0001b\u000f\u000b\t\u0006\u0004%I!\u000e\u0005\t{QA)\u0019!C\u0005k!Q\u00111\u0014\u000b\t\u0006\u0004%\t!!(\u0003%\r\u000b7\r[3e)\u0006\u0014G.Z'b]\u0006<WM\u001d\u0006\u0003;y\tqa\u001d5be&twM\u0003\u0002 A\u0005)A-\u001a7uC*\u0011\u0011EI\u0001\u0006gB\f'o\u001b\u0006\u0003G\u0011\na!\u00199bG\",'\"A\u0013\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Ac\u0006\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#F\u0001\u0004B]f\u0014VM\u001a\t\u0003_Ij\u0011\u0001\r\u0006\u0003c\u0001\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003gA\u0012q\u0001T8hO&tw-\u0001\rqe\u0016\u001c\u0016n\u001a8fIV\u0013H.\u0012=qSJ\fG/[8o\u001bN,\u0012A\u000e\t\u0003S]J!\u0001\u000f\u0016\u0003\t1{gnZ\u0001\u001aaJ,7+[4oK\u0012,&\u000f\\#ya&\u0014\u0018\r^5p]6\u001b\b%\u0001\fsK\u001a\u0014Xm\u001d5DQ\u0016\u001c7.\u00138uKJ4\u0018\r\\'t\u0003I\u0011XM\u001a:fg\"$\u0006N]3tQ>dG-T:\u0002'I,gM]3tQRC'/Z:i_2$Wj\u001d\u0011\u0002'\u0015D\b/\u001b:f\u0003\u001a$XM]!dG\u0016\u001c8/T:\u0002\rqJg.\u001b;?)\u0015\u0001%i\u0011#F!\t\t\u0005!D\u0001\u001d\u0011\u0015!t\u00011\u00017\u0011\u0015Qt\u00011\u00017\u0011\u0015Yt\u00011\u00017\u0011\u0015it\u00011\u00017\u0003\u0015\u0019\u0017m\u00195f+\u0005A\u0005\u0003B%Q%vk\u0011A\u0013\u0006\u0003\u00172\u000b!bY8oGV\u0014(/\u001a8u\u0015\tie*\u0001\u0003vi&d'\"A(\u0002\t)\fg/Y\u0005\u0003#*\u0013\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\t\u0019&L\u0004\u0002U1B\u0011QKK\u0007\u0002-*\u0011qKJ\u0001\u0007yI|w\u000e\u001e \n\u0005eS\u0013A\u0002)sK\u0012,g-\u0003\u0002\\9\n11\u000b\u001e:j]\u001eT!!\u0017\u0016\u0011\u0005\u0005s\u0016BA0\u001d\u0005-\u0019\u0015m\u00195fIR\u000b'\r\\3\u0002\r\r\f7\r[3!\u00035\u0011XM\u001a:fg\"$\u0006N]3bIV\t1\r\u0005\u0002JI&\u0011QM\u0013\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017A\u0004:fMJ,7\u000f\u001b+ie\u0016\fG\rI\u0001\u0019SN4\u0016\r\\5e+JdW\t\u001f9je\u0006$\u0018n\u001c8US6,GCA5m!\tI#.\u0003\u0002lU\t9!i\\8mK\u0006t\u0007\"B7\r\u0001\u0004q\u0017AC3ya&\u0014\u0018\r^5p]B\u0019\u0011f\u001c\u001c\n\u0005AT#AB(qi&|g.A\u0004sK\u001a\u0014Xm\u001d5\u0015\u0003M\u0004\"!\u000b;\n\u0005UT#\u0001B+oSR\fqbZ3u!J,7+[4oK\u0012,&\u000f\u001c\u000b\u0006q\u0006\u001d\u00111\u0002\t\u0004s\u0006\u0005aB\u0001>~\u001d\t\t50\u0003\u0002}9\u0005\t\u0002K]3TS\u001etW\rZ+sY\u000e\u000b7\r[3\n\u0005y|\u0018a\u0001*qG*\u0011A\u0010H\u0005\u0005\u0003\u0007\t)AA\fHKR\u0004&/Z*jO:,G-\u0016:m%\u0016\u001c\bo\u001c8tK*\u0011ap \u0005\u0007\u0003\u0013q\u0001\u0019\u0001*\u0002\u0013Q\f'\r\\3QCRD\u0007BBA\u0007\u001d\u0001\u0007!+\u0001\u0004gS2,\u0017\nZ\u0001\te\u0016<\u0017n\u001d;feRy1/a\u0005\u0002\u0016\u0005}\u0011QIA/\u0003_\n\u0019\b\u0003\u0004\u0002\n=\u0001\rA\u0015\u0005\b\u0003/y\u0001\u0019AA\r\u0003\u001dIG\rV8Ve2\u0004RaUA\u000e%JK1!!\b]\u0005\ri\u0015\r\u001d\u0005\b\u0003Cy\u0001\u0019AA\u0012\u0003\u0011\u0011XMZ:\u0011\r\u0005\u0015\u0012qFA\u001b\u001d\u0011\t9#a\u000b\u000f\u0007U\u000bI#C\u0001,\u0013\r\tiCK\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t$a\r\u0003\u0007M+\u0017OC\u0002\u0002.)\u0002R!a\u000e\u0002B!j!!!\u000f\u000b\t\u0005m\u0012QH\u0001\u0004e\u00164'bAA \u001d\u0006!A.\u00198h\u0013\u0011\t\u0019%!\u000f\u0003\u001b]+\u0017m\u001b*fM\u0016\u0014XM\\2f\u0011\u001d\t9e\u0004a\u0001\u0003\u0013\nq\u0002\u001d:pM&dW\r\u0015:pm&$WM\u001d\t\u0005\u0003\u0017\nI&\u0004\u0002\u0002N)!\u0011qJA)\u0003\u0019\u0019G.[3oi*\u0019Q$a\u0015\u000b\u0007}\t)F\u0003\u0002\u0002X\u0005\u0011\u0011n\\\u0005\u0005\u00037\niEA\u000eEK2$\u0018m\u00155be&tw\r\u0015:pM&dW\r\u0015:pm&$WM\u001d\u0005\b\u0003?z\u0001\u0019AA1\u0003%\u0011XM\u001a:fg\",'\u000fE\u0004*\u0003G\n9'!\u001b\n\u0007\u0005\u0015$FA\u0005Gk:\u001cG/[8ocA\u0019\u0011f\u001c*\u0011\u0007\u0005\u000bY'C\u0002\u0002nq\u0011!\u0003V1cY\u0016\u0014VM\u001a:fg\"\u0014Vm];mi\"A\u0011\u0011O\b\u0011\u0002\u0003\u0007a'A\nfqBL'/\u0019;j_:$\u0016.\\3ti\u0006l\u0007\u000fC\u0004\u0002v=\u0001\r!a\u001a\u0002\u0019I,gM]3tQR{7.\u001a8\u0002%I,w-[:uKJ$C-\u001a4bk2$HEN\u000b\u0003\u0003wR3ANA?W\t\ty\b\u0005\u0003\u0002\u0002\u0006-UBAAB\u0015\u0011\t))a\"\u0002\u0013Ut7\r[3dW\u0016$'bAAEU\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u00055\u00151\u0011\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001B:u_B\fQa\u00197fCJ\f!cQ1dQ\u0016$G+\u00192mK6\u000bg.Y4feB\u0011\u0011\tF\n\u0003)!\"\"!!&\u0002\u0011%s5\u000bV!O\u0007\u0016+\u0012\u0001\u0011")
public class CachedTableManager
implements Logging {
    private final long preSignedUrlExpirationMs;
    private final long refreshThresholdMs;
    private final long expireAfterAccessMs;
    private final ConcurrentHashMap<String, CachedTable> cache;
    private final ScheduledExecutorService refreshThread;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static CachedTableManager INSTANCE() {
        return CachedTableManager$.MODULE$.INSTANCE();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public long preSignedUrlExpirationMs() {
        return this.preSignedUrlExpirationMs;
    }

    public long refreshThresholdMs() {
        return this.refreshThresholdMs;
    }

    private ConcurrentHashMap<String, CachedTable> cache() {
        return this.cache;
    }

    private ScheduledExecutorService refreshThread() {
        return this.refreshThread;
    }

    public boolean isValidUrlExpirationTime(Option<Object> expiration) {
        boolean isValid;
        block0: {
            boolean bl = isValid = expiration.isDefined() && BoxesRunTime.unboxToLong((Object)expiration.get()) > System.currentTimeMillis() + this.refreshThresholdMs();
            if (isValid || !expiration.isDefined()) break block0;
            long currentTs = System.currentTimeMillis();
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(81).append("Invalid url expiration timestamp(").append(expiration).append(", ").append(new Date(BoxesRunTime.unboxToLong((Object)expiration.get()))).append("), refreshThresholdMs:").append(this.refreshThresholdMs()).append(", ").append("current timestamp(").append(currentTs).append(", ").append(new Date(currentTs)).append(").").toString());
        }
        return isValid;
    }

    public void refresh() {
        Map.Entry[] snapshot = (Map.Entry[])((IterableOnceOps)JavaConverters$.MODULE$.asScalaSetConverter(this.cache().entrySet()).asScala()).toArray(ClassTag$.MODULE$.apply(Map.Entry.class));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])snapshot), (Function1 & Serializable)entry -> {
            String tablePath = (String)entry.getKey();
            CachedTable cachedTable = (CachedTable)entry.getValue();
            if (cachedTable.refs().forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CachedTableManager.$anonfun$refresh$2(x$1)))) {
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(86).append("Removing table ").append(tablePath).append(" from the pre signed url cache as there are").append(" no references pointed to it").toString());
                return BoxesRunTime.boxToBoolean((boolean)this.cache().remove(tablePath, cachedTable));
            }
            if (cachedTable.lastAccess() + $this.expireAfterAccessMs < System.currentTimeMillis()) {
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(78).append("Removing table ").append(tablePath).append(" from the pre signed url cache as it was not accessed ").append("after ").append($this.expireAfterAccessMs).append(" ms").toString());
                return BoxesRunTime.boxToBoolean((boolean)this.cache().remove(tablePath, cachedTable));
            }
            if (cachedTable.expiration() - System.currentTimeMillis() < this.refreshThresholdMs()) {
                Object object;
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Updating pre signed urls for ").append(tablePath).append(" (expiration time: ").append(new Date(cachedTable.expiration())).append("), token:").append(cachedTable.refreshToken()).toString());
                try {
                    TableRefreshResult refreshRes = (TableRefreshResult)cachedTable.refresher().apply(cachedTable.refreshToken());
                    CachedTable newTable = new CachedTable(this.isValidUrlExpirationTime(refreshRes.expirationTimestamp()) ? BoxesRunTime.unboxToLong((Object)refreshRes.expirationTimestamp().get()) : this.preSignedUrlExpirationMs() + System.currentTimeMillis(), refreshRes.idToUrl(), cachedTable.refs(), cachedTable.lastAccess(), cachedTable.refresher(), refreshRes.refreshToken());
                    this.cache().replace(tablePath, cachedTable, newTable);
                    this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(39).append("Updated pre signed urls for ").append(tablePath).append(" with size ").append(refreshRes.idToUrl().size()).toString());
                    object = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Failed to refresh pre signed urls for table ").append(tablePath).toString(), e);
                        if (cachedTable.expiration() < System.currentTimeMillis()) {
                            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(61).append("Removing table ").append(tablePath).append(" form cache as the pre signed url have expired").toString());
                            object = BoxesRunTime.boxToBoolean((boolean)this.cache().remove(tablePath, cachedTable));
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                    }
                    throw throwable;
                }
                return object;
            }
            return BoxedUnit.UNIT;
        });
    }

    public Tuple2<String, Object> getPreSignedUrl(String tablePath, String fileId) {
        CachedTable cachedTable = this.cache().get(tablePath);
        if (cachedTable == null) {
            throw new IllegalStateException(new StringBuilder(18).append("table ").append(tablePath).append(" was removed").toString());
        }
        cachedTable.lastAccess_$eq(System.currentTimeMillis());
        String url = (String)cachedTable.idToUrl().getOrElse((Object)fileId, (Function0 & Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(33).append("cannot find url for id ").append(fileId).append(" in table ").append(tablePath).toString());
        });
        return new Tuple2((Object)url, (Object)BoxesRunTime.boxToLong((long)cachedTable.expiration()));
    }

    /*
     * Unable to fully structure code
     */
    public void register(String tablePath, Map<String, String> idToUrl, Seq<WeakReference<Object>> refs, DeltaSharingProfileProvider profileProvider, Function1<Option<String>, TableRefreshResult> refresher, long expirationTimestamp, Option<String> refreshToken) {
        customTablePath = profileProvider.getCustomTablePath(tablePath);
        customRefresher = profileProvider.getCustomRefresher(refresher);
        v0 = expirationTimestamp - System.currentTimeMillis() < this.refreshThresholdMs() ? (this.isValidUrlExpirationTime((refreshRes = (TableRefreshResult)customRefresher.apply(refreshToken)).expirationTimestamp()) ? new Tuple3(refreshRes.idToUrl(), refreshRes.expirationTimestamp().get(), refreshRes.refreshToken()) : new Tuple3(refreshRes.idToUrl(), (Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() + this.preSignedUrlExpirationMs())), refreshRes.refreshToken())) : (var13_11 = new Tuple3(idToUrl, (Object)BoxesRunTime.boxToLong((long)expirationTimestamp), refreshToken));
        if (var13_11 == null) {
            throw new MatchError((Object)var13_11);
        }
        resolvedIdToUrl = (Map)var13_11._1();
        resolvedExpiration = BoxesRunTime.unboxToLong((Object)var13_11._2());
        resolvedRefreshToken = (Option)var13_11._3();
        var12_15 = new Tuple3((Object)resolvedIdToUrl, (Object)BoxesRunTime.boxToLong((long)resolvedExpiration), (Object)resolvedRefreshToken);
        resolvedIdToUrl = (Map)var12_15._1();
        resolvedExpiration = BoxesRunTime.unboxToLong((Object)var12_15._2());
        resolvedRefreshToken = (Option)var12_15._3();
        cachedTable = new CachedTable(resolvedExpiration, (Map<String, String>)resolvedIdToUrl, refs, System.currentTimeMillis(), customRefresher, (Option<String>)resolvedRefreshToken);
        oldTable = ObjectRef.create((Object)this.cache().putIfAbsent(customTablePath, cachedTable));
        if ((CachedTable)oldTable.elem == null) {
            this.logInfo((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$register$1(java.lang.String ), ()Ljava/lang/String;)((String)customTablePath));
            return;
        }
        do lbl-1000:
        // 3 sources

        {
            mergedTable = new CachedTable(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(cachedTable.expiration()), ((CachedTable)oldTable.elem).expiration()), (Map<String, String>)((Map)((CachedTable)oldTable.elem).idToUrl().$plus$plus(cachedTable.idToUrl())), (Seq<WeakReference<Object>>)((Seq)((IterableOps)refs.filterNot((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$register$2$adapted(scala.runtime.ObjectRef java.lang.ref.WeakReference ), (Ljava/lang/ref/WeakReference;)Ljava/lang/Object;)((ObjectRef)oldTable))).$plus$plus(((CachedTable)oldTable.elem).refs())), System.currentTimeMillis(), customRefresher, cachedTable.refreshToken());
            if (this.cache().replace(customTablePath, (CachedTable)oldTable.elem, mergedTable)) {
                this.logInfo((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$register$4(java.lang.String ), ()Ljava/lang/String;)((String)customTablePath));
                return;
            }
            oldTable.elem = this.cache().get(customTablePath);
            if ((CachedTable)oldTable.elem != null) ** GOTO lbl-1000
            oldTable.elem = this.cache().putIfAbsent(customTablePath, cachedTable);
        } while ((CachedTable)oldTable.elem != null);
        this.logInfo((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$register$5(java.lang.String ), ()Ljava/lang/String;)((String)customTablePath));
    }

    public long register$default$6() {
        return System.currentTimeMillis() + this.preSignedUrlExpirationMs();
    }

    public void stop() {
        this.refreshThread().shutdownNow();
    }

    public void clear() {
        this.cache().clear();
    }

    public static final /* synthetic */ boolean $anonfun$refresh$2(WeakReference x$1) {
        return x$1.get() == null;
    }

    public static final /* synthetic */ String $anonfun$register$1(String customTablePath$1) {
        return new StringBuilder(43).append("Registered a new entry in cache for table ").append(customTablePath$1).append(".").toString();
    }

    public static final /* synthetic */ boolean $anonfun$register$3(WeakReference ref$1, WeakReference x$3) {
        return x$3.get() == ref$1.get();
    }

    public static final /* synthetic */ boolean $anonfun$register$2(ObjectRef oldTable$1, WeakReference ref) {
        return ((CachedTable)oldTable$1.elem).refs().exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CachedTableManager.$anonfun$register$3(ref, x$3)));
    }

    public static final /* synthetic */ String $anonfun$register$4(String customTablePath$1) {
        return new StringBuilder(52).append("Registered to an existing entry in cache for table ").append(customTablePath$1).append(".").toString();
    }

    public static final /* synthetic */ String $anonfun$register$5(String customTablePath$1) {
        return new StringBuilder(54).append("Registered a new entry in cache for table ").append(customTablePath$1).append(" on 2nd try.").toString();
    }

    public CachedTableManager(long preSignedUrlExpirationMs, long refreshCheckIntervalMs, long refreshThresholdMs, long expireAfterAccessMs) {
        this.preSignedUrlExpirationMs = preSignedUrlExpirationMs;
        this.refreshThresholdMs = refreshThresholdMs;
        this.expireAfterAccessMs = expireAfterAccessMs;
        Logging.$init$((Logging)this);
        this.cache = new ConcurrentHashMap();
        ScheduledExecutorService thread = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("delta-sharing-pre-signed-url-refresh-thread");
        thread.scheduleWithFixedDelay(() -> this.refresh(), refreshCheckIntervalMs, refreshCheckIntervalMs, TimeUnit.MILLISECONDS);
        this.refreshThread = thread;
    }

    public static final /* synthetic */ Object $anonfun$register$2$adapted(ObjectRef oldTable$1, WeakReference ref) {
        return BoxesRunTime.boxToBoolean((boolean)CachedTableManager.$anonfun$register$2(oldTable$1, ref));
    }
}

