/*
 * Decompiled with CFR 0.152.
 */
package io.delta.sharing.client;

import io.delta.sharing.client.DeltaSharingFileSystem$;
import io.delta.sharing.client.InMemoryHttpInputStream;
import io.delta.sharing.client.RandomAccessHttpInputStream;
import io.delta.sharing.client.model.FileAction;
import io.delta.sharing.client.util.ConfUtils;
import io.delta.sharing.client.util.ConfUtils$;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.RequestWrapper;
import org.apache.http.impl.conn.DefaultRoutePlanner;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.spark.SparkEnv$;
import org.apache.spark.delta.sharing.PreSignedUrlCache$;
import org.apache.spark.delta.sharing.PreSignedUrlFetcher;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.rpc.RpcEndpointRef;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.StringContext;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r\u001da!B\u001e=\u0001y\"\u0005\"B-\u0001\t\u0003Y\u0006\u0002\u00030\u0001\u0011\u000b\u0007I\u0011B0\t\u0011\u0019\u0004\u0001R1A\u0005\n\u001dD\u0001b\u001b\u0001\t\u0006\u0004%Ia\u0018\u0005\tY\u0002A)\u0019!C\u0005[\"1q\u000f\u0001C\u0001}aD\u0001\"\u001f\u0001\t\u0006\u0004%Ia\u001a\u0005\tu\u0002A)\u0019!C\u0005w\"9\u0011Q\u0001\u0001\u0005B\u0005\u001d\u0001bBA\u0010\u0001\u0011\u0005\u0013\u0011\u0005\u0005\b\u0003g\u0001A\u0011IA\u001b\u0011\u001d\tY\u0005\u0001C!\u0003\u001bBq!a$\u0001\t\u0003\n\t\nC\u0004\u0002\u001a\u0002!\t%a'\t\u000f\u0005\u0015\u0006\u0001\"\u0011\u0002(\"9\u0011q\u0016\u0001\u0005B\u0005E\u0006bBAa\u0001\u0011\u0005\u00131\u0019\u0005\b\u0003\u001f\u0004A\u0011IAi\u0011\u001d\t\u0019\u000e\u0001C!\u0003+Dq!a7\u0001\t\u0003\ni\u000eC\u0004\u0002b\u0002!\t%a9\t\u000f\u0005\u0015\b\u0001\"\u0011\u0002d\u001eA\u0011q\u001d\u001f\t\u0002y\nIOB\u0004<y!\u0005a(a;\t\reCB\u0011AAz\u0011%\t)\u0010\u0007b\u0001\n\u0003\t9\u0010\u0003\u0005\u0003\u0004a\u0001\u000b\u0011BA}\r\u0019\u0011)\u0001\u0007!\u0003\b!Q!\u0011\u0005\u000f\u0003\u0016\u0004%\tAa\t\t\u0015\t\u0015BD!E!\u0002\u0013\tI\u0001\u0003\u0006\u0003(q\u0011)\u001a!C\u0001\u0005GA!B!\u000b\u001d\u0005#\u0005\u000b\u0011BA\u0005\u0011%\u0011Y\u0003\bBK\u0002\u0013\u0005q\rC\u0005\u0003.q\u0011\t\u0012)A\u0005Q\"1\u0011\f\bC\u0001\u0005_AqAa\u000f\u001d\t\u0003\u0011i\u0004C\u0005\u0003@q\t\t\u0011\"\u0001\u0003B!I!\u0011\n\u000f\u0012\u0002\u0013\u0005!1\n\u0005\n\u0005Cb\u0012\u0013!C\u0001\u0005\u0017B\u0011Ba\u0019\u001d#\u0003%\tA!\u001a\t\u0013\t%D$!A\u0005B\u0005]\b\u0002\u0003B69\u0005\u0005I\u0011A0\t\u0013\t5D$!A\u0005\u0002\t=\u0004\"\u0003B>9\u0005\u0005I\u0011\tB?\u0011%\u0011Y\tHA\u0001\n\u0003\u0011i\tC\u0005\u0003\u0012r\t\t\u0011\"\u0011\u0003\u0014\"I!q\u0013\u000f\u0002\u0002\u0013\u0005#\u0011\u0014\u0005\n\u00057c\u0012\u0011!C!\u0005;C\u0011Ba(\u001d\u0003\u0003%\tE!)\b\u0013\t\u0015\u0006$!A\t\u0002\t\u001df!\u0003B\u00031\u0005\u0005\t\u0012\u0001BU\u0011\u0019I6\u0007\"\u0001\u0003@\"I!1T\u001a\u0002\u0002\u0013\u0015#Q\u0014\u0005\n\u0005\u0003\u001c\u0014\u0011!CA\u0005\u0007D\u0011Ba34\u0003\u0003%\tI!4\t\u0013\t}7'!A\u0005\n\t\u0005\bb\u0002Bu1\u0011\u0005!1\u001e\u0005\b\u0005\u007fDB\u0011AB\u0001\u0005Y!U\r\u001c;b'\"\f'/\u001b8h\r&dWmU=ti\u0016l'BA\u001f?\u0003\u0019\u0019G.[3oi*\u0011q\bQ\u0001\bg\"\f'/\u001b8h\u0015\t\t%)A\u0003eK2$\u0018MC\u0001D\u0003\tIwnE\u0002\u0001\u000bF\u0003\"AR(\u000e\u0003\u001dS!\u0001S%\u0002\u0005\u0019\u001c(B\u0001&L\u0003\u0019A\u0017\rZ8pa*\u0011A*T\u0001\u0007CB\f7\r[3\u000b\u00039\u000b1a\u001c:h\u0013\t\u0001vI\u0001\u0006GS2,7+_:uK6\u0004\"AU,\u000e\u0003MS!\u0001V+\u0002\u0011%tG/\u001a:oC2T!AV&\u0002\u000bM\u0004\u0018M]6\n\u0005a\u001b&a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\tA\f\u0005\u0002^\u00015\tA(\u0001\u0006ok6\u0014V\r\u001e:jKN,\u0012\u0001\u0019\t\u0003C\u0012l\u0011A\u0019\u0006\u0002G\u0006)1oY1mC&\u0011QM\u0019\u0002\u0004\u0013:$\u0018AF7bqJ+GO]=EkJ\fG/[8o\u001b&dG.[:\u0016\u0003!\u0004\"!Y5\n\u0005)\u0014'\u0001\u0002'p]\u001e\f\u0001\u0003^5nK>,H/\u00138TK\u000e|g\u000eZ:\u0002\u0015!$H\u000f]\"mS\u0016tG/F\u0001o!\tyW/D\u0001q\u0015\ti\u0014O\u0003\u0002sg\u0006!\u0011.\u001c9m\u0015\t!8*\u0001\u0003iiR\u0004\u0018B\u0001<q\u0005M\u0019En\\:fC\ndW\r\u0013;ua\u000ec\u0017.\u001a8u\u0003A\u0019'/Z1uK\"#H\u000f]\"mS\u0016tG\u000fF\u0001o\u0003I\u0011XM\u001a:fg\"$\u0006N]3tQ>dG-T:\u0002)A\u0014XmU5h]\u0016$WK\u001d7DC\u000eDWMU3g+\u0005a\bcA?\u0002\u00025\taP\u0003\u0002\u0000+\u0006\u0019!\u000f]2\n\u0007\u0005\raP\u0001\bSa\u000e,e\u000e\u001a9pS:$(+\u001a4\u0002\u0013\u001d,GoU2iK6,GCAA\u0005!\u0011\tY!!\u0007\u000f\t\u00055\u0011Q\u0003\t\u0004\u0003\u001f\u0011WBAA\t\u0015\r\t\u0019BW\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005]!-\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00037\tiB\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003/\u0011\u0017AB4fiV\u0013\u0018\u000e\u0006\u0002\u0002$A!\u0011QEA\u0018\u001b\t\t9C\u0003\u0003\u0002*\u0005-\u0012a\u00018fi*\u0011\u0011QF\u0001\u0005U\u00064\u0018-\u0003\u0003\u00022\u0005\u001d\"aA+S\u0013\u0006!q\u000e]3o)\u0019\t9$!\u0010\u0002HA\u0019a)!\u000f\n\u0007\u0005mrIA\tG'\u0012\u000bG/Y%oaV$8\u000b\u001e:fC6Dq!a\u0010\f\u0001\u0004\t\t%A\u0001g!\r1\u00151I\u0005\u0004\u0003\u000b:%\u0001\u0002)bi\"Da!!\u0013\f\u0001\u0004\u0001\u0017A\u00032vM\u001a,'oU5{K\u000611M]3bi\u0016$\u0002#a\u0014\u0002V\u0005]\u0013QMA8\u0003c\nY(a \u0011\u0007\u0019\u000b\t&C\u0002\u0002T\u001d\u0013!CR*ECR\fw*\u001e;qkR\u001cFO]3b[\"9\u0011q\b\u0007A\u0002\u0005\u0005\u0003bBA-\u0019\u0001\u0007\u00111L\u0001\u000ba\u0016\u0014X.[:tS>t\u0007\u0003BA/\u0003Cj!!a\u0018\u000b\u0007\u0005es)\u0003\u0003\u0002d\u0005}#\u0001\u0004$t!\u0016\u0014X.[:tS>t\u0007bBA4\u0019\u0001\u0007\u0011\u0011N\u0001\n_Z,'o\u001e:ji\u0016\u00042!YA6\u0013\r\tiG\u0019\u0002\b\u0005>|G.Z1o\u0011\u0019\tI\u0005\u0004a\u0001A\"9\u00111\u000f\u0007A\u0002\u0005U\u0014a\u0003:fa2L7-\u0019;j_:\u00042!YA<\u0013\r\tIH\u0019\u0002\u0006'\"|'\u000f\u001e\u0005\u0007\u0003{b\u0001\u0019\u00015\u0002\u0013\tdwnY6TSj,\u0007bBAA\u0019\u0001\u0007\u00111Q\u0001\taJ|wM]3tgB!\u0011QQAF\u001b\t\t9IC\u0002\u0002\n&\u000bA!\u001e;jY&!\u0011QRAD\u00051\u0001&o\\4sKN\u001c\u0018M\u00197f\u0003\u0019\t\u0007\u000f]3oIRA\u0011qJAJ\u0003+\u000b9\nC\u0004\u0002@5\u0001\r!!\u0011\t\r\u0005%S\u00021\u0001a\u0011\u001d\t\t)\u0004a\u0001\u0003\u0007\u000baA]3oC6,GCBA5\u0003;\u000b\t\u000bC\u0004\u0002 :\u0001\r!!\u0011\u0002\u0007M\u00148\rC\u0004\u0002$:\u0001\r!!\u0011\u0002\u0007\u0011\u001cH/\u0001\u0004eK2,G/\u001a\u000b\u0007\u0003S\nI+a+\t\u000f\u0005}r\u00021\u0001\u0002B!9\u0011QV\bA\u0002\u0005%\u0014!\u0003:fGV\u00148/\u001b<f\u0003)a\u0017n\u001d;Ti\u0006$Xo\u001d\u000b\u0005\u0003g\u000by\fE\u0003b\u0003k\u000bI,C\u0002\u00028\n\u0014Q!\u0011:sCf\u00042ARA^\u0013\r\til\u0012\u0002\u000b\r&dWm\u0015;biV\u001c\bbBA !\u0001\u0007\u0011\u0011I\u0001\u0014g\u0016$xk\u001c:lS:<G)\u001b:fGR|'/\u001f\u000b\u0005\u0003\u000b\fY\rE\u0002b\u0003\u000fL1!!3c\u0005\u0011)f.\u001b;\t\u000f\u00055\u0017\u00031\u0001\u0002B\u00059a.Z<`I&\u0014\u0018aE4fi^{'o[5oO\u0012K'/Z2u_JLHCAA!\u0003\u0019i7\u000eZ5sgR1\u0011\u0011NAl\u00033Dq!a\u0010\u0014\u0001\u0004\t\t\u0005C\u0004\u0002ZM\u0001\r!a\u0017\u0002\u001b\u001d,GOR5mKN#\u0018\r^;t)\u0011\tI,a8\t\u000f\u0005}B\u00031\u0001\u0002B\u0005Aa-\u001b8bY&TX\r\u0006\u0002\u0002F\u0006)1\r\\8tK\u00061B)\u001a7uCNC\u0017M]5oO\u001aKG.Z*zgR,W\u000e\u0005\u0002^1M\u0019\u0001$!<\u0011\u0007\u0005\fy/C\u0002\u0002r\n\u0014a!\u00118z%\u00164GCAAu\u0003\u0019\u00196\tS#N\u000bV\u0011\u0011\u0011 \t\u0005\u0003w\u0014\t!\u0004\u0002\u0002~*!\u0011q`A\u0016\u0003\u0011a\u0017M\\4\n\t\u0005m\u0011Q`\u0001\b'\u000eCU)T#!\u0005A!U\r\u001c;b'\"\f'/\u001b8h!\u0006$\bnE\u0004\u001d\u0003[\u0014IAa\u0004\u0011\u0007\u0005\u0014Y!C\u0002\u0003\u000e\t\u0014q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0003\u0012\tma\u0002\u0002B\n\u0005/qA!a\u0004\u0003\u0016%\t1-C\u0002\u0003\u001a\t\fq\u0001]1dW\u0006<W-\u0003\u0003\u0003\u001e\t}!\u0001D*fe&\fG.\u001b>bE2,'b\u0001B\rE\u0006IA/\u00192mKB\u000bG\u000f[\u000b\u0003\u0003\u0013\t!\u0002^1cY\u0016\u0004\u0016\r\u001e5!\u0003\u00191\u0017\u000e\\3JI\u00069a-\u001b7f\u0013\u0012\u0004\u0013\u0001\u00034jY\u0016\u001c\u0016N_3\u0002\u0013\u0019LG.Z*ju\u0016\u0004C\u0003\u0003B\u0019\u0005k\u00119D!\u000f\u0011\u0007\tMB$D\u0001\u0019\u0011\u001d\u0011\tc\ta\u0001\u0003\u0013AqAa\n$\u0001\u0004\tI\u0001\u0003\u0004\u0003,\r\u0002\r\u0001[\u0001\u0007i>\u0004\u0016\r\u001e5\u0016\u0005\u0005\u0005\u0013\u0001B2paf$\u0002B!\r\u0003D\t\u0015#q\t\u0005\n\u0005C)\u0003\u0013!a\u0001\u0003\u0013A\u0011Ba\n&!\u0003\u0005\r!!\u0003\t\u0011\t-R\u0005%AA\u0002!\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003N)\"\u0011\u0011\u0002B(W\t\u0011\t\u0006\u0005\u0003\u0003T\tuSB\u0001B+\u0015\u0011\u00119F!\u0017\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B.E\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t}#Q\u000b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\u00119GK\u0002i\u0005\u001f\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&D\u0018\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005c\u00129\bE\u0002b\u0005gJ1A!\u001ec\u0005\r\te.\u001f\u0005\t\u0005sZ\u0013\u0011!a\u0001A\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa \u0011\r\t\u0005%q\u0011B9\u001b\t\u0011\u0019IC\u0002\u0003\u0006\n\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011IIa!\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003S\u0012y\tC\u0005\u0003z5\n\t\u00111\u0001\u0003r\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\tIP!&\t\u0011\ted&!AA\u0002\u0001\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002A\u0006AAo\\*ue&tw\r\u0006\u0002\u0002z\u00061Q-];bYN$B!!\u001b\u0003$\"I!\u0011P\u0019\u0002\u0002\u0003\u0007!\u0011O\u0001\u0011\t\u0016dG/Y*iCJLgn\u001a)bi\"\u00042Aa\r4'\u0015\u0019$1\u0016B\\!-\u0011iKa-\u0002\n\u0005%\u0001N!\r\u000e\u0005\t=&b\u0001BYE\u00069!/\u001e8uS6,\u0017\u0002\u0002B[\u0005_\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84!\u0011\u0011IL!0\u000e\u0005\tm&bA\"\u0002,%!!Q\u0004B^)\t\u00119+A\u0003baBd\u0017\u0010\u0006\u0005\u00032\t\u0015'q\u0019Be\u0011\u001d\u0011\tC\u000ea\u0001\u0003\u0013AqAa\n7\u0001\u0004\tI\u0001\u0003\u0004\u0003,Y\u0002\r\u0001[\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011yMa7\u0011\u000b\u0005\u0014\tN!6\n\u0007\tM'M\u0001\u0004PaRLwN\u001c\t\tC\n]\u0017\u0011BA\u0005Q&\u0019!\u0011\u001c2\u0003\rQ+\b\u000f\\34\u0011%\u0011inNA\u0001\u0002\u0004\u0011\t$A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"Aa9\u0011\t\u0005m(Q]\u0005\u0005\u0005O\fiP\u0001\u0004PE*,7\r^\u0001\u0007K:\u001cw\u000eZ3\u0015\r\u0005\u0005#Q\u001eBx\u0011\u001d\u0011\t#\u000fa\u0001\u0003\u0013AqA!=:\u0001\u0004\u0011\u00190\u0001\u0004bGRLwN\u001c\t\u0005\u0005k\u0014Y0\u0004\u0002\u0003x*\u0019!\u0011 \u001f\u0002\u000b5|G-\u001a7\n\t\tu(q\u001f\u0002\u000b\r&dW-Q2uS>t\u0017A\u00023fG>$W\r\u0006\u0003\u00032\r\r\u0001bBB\u0003u\u0001\u0007\u0011\u0011I\u0001\u0005a\u0006$\b\u000e")
public class DeltaSharingFileSystem
extends FileSystem
implements Logging {
    private int numRetries;
    private long maxRetryDurationMillis;
    private int timeoutInSeconds;
    private CloseableHttpClient httpClient;
    private long refreshThresholdMs;
    private RpcEndpointRef preSignedUrlCacheRef;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static DeltaSharingPath decode(Path path) {
        return DeltaSharingFileSystem$.MODULE$.decode(path);
    }

    public static Path encode(String tablePath, FileAction action) {
        return DeltaSharingFileSystem$.MODULE$.encode(tablePath, action);
    }

    public static String SCHEME() {
        return DeltaSharingFileSystem$.MODULE$.SCHEME();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int numRetries$lzycompute() {
        DeltaSharingFileSystem deltaSharingFileSystem = this;
        synchronized (deltaSharingFileSystem) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.numRetries = ConfUtils$.MODULE$.numRetries(this.getConf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.numRetries;
    }

    private int numRetries() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.numRetries$lzycompute();
        }
        return this.numRetries;
    }

    private long maxRetryDurationMillis$lzycompute() {
        DeltaSharingFileSystem deltaSharingFileSystem = this;
        synchronized (deltaSharingFileSystem) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.maxRetryDurationMillis = ConfUtils$.MODULE$.maxRetryDurationMillis(this.getConf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.maxRetryDurationMillis;
    }

    private long maxRetryDurationMillis() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.maxRetryDurationMillis$lzycompute();
        }
        return this.maxRetryDurationMillis;
    }

    private int timeoutInSeconds$lzycompute() {
        DeltaSharingFileSystem deltaSharingFileSystem = this;
        synchronized (deltaSharingFileSystem) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.timeoutInSeconds = ConfUtils$.MODULE$.timeoutInSeconds(this.getConf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.timeoutInSeconds;
    }

    private int timeoutInSeconds() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.timeoutInSeconds$lzycompute();
        }
        return this.timeoutInSeconds;
    }

    private CloseableHttpClient httpClient$lzycompute() {
        DeltaSharingFileSystem deltaSharingFileSystem = this;
        synchronized (deltaSharingFileSystem) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.httpClient = this.createHttpClient();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.httpClient;
    }

    private CloseableHttpClient httpClient() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.httpClient$lzycompute();
        }
        return this.httpClient;
    }

    public CloseableHttpClient createHttpClient() {
        Option<ConfUtils.ProxyConfig> proxyConfigOpt = ConfUtils$.MODULE$.getProxyConfig(this.getConf());
        int maxConnections = ConfUtils$.MODULE$.maxConnections(this.getConf());
        RequestConfig config = RequestConfig.custom().setConnectTimeout(this.timeoutInSeconds() * 1000).setConnectionRequestTimeout(this.timeoutInSeconds() * 1000).setSocketTimeout(this.timeoutInSeconds() * 1000).build();
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(58).append("Creating delta sharing httpClient with timeoutInSeconds: ").append(this.timeoutInSeconds()).append(".").toString());
        HttpClientBuilder clientBuilder = HttpClientBuilder.create().setMaxConnTotal(maxConnections).setMaxConnPerRoute(maxConnections).setDefaultRequestConfig(config).disableAutomaticRetries();
        proxyConfigOpt.foreach((Function1 & Serializable)proxyConfig -> {
            BoxedUnit boxedUnit;
            HttpHost proxy = new HttpHost(proxyConfig.host(), proxyConfig.port());
            clientBuilder.setProxy(proxy);
            boolean neverUseHttps = ConfUtils$.MODULE$.getNeverUseHttps(this.getConf());
            if (neverUseHttps) {
                HttpRequestExecutor httpRequestDowngradeExecutor = new HttpRequestExecutor(this){
                    private final /* synthetic */ DeltaSharingFileSystem $outer;

                    public HttpResponse execute(HttpRequest request, HttpClientConnection connection, HttpContext context) {
                        try {
                            URI modifiedUri = new URIBuilder(request.getRequestLine().getUri()).setScheme("http").build();
                            RequestWrapper wrappedRequest = new RequestWrapper(request);
                            wrappedRequest.setURI(modifiedUri);
                            return super.execute((HttpRequest)wrappedRequest, connection, context);
                        }
                        catch (Exception e) {
                            this.$outer.logInfo((Function0<String>)(Function0 & Serializable)() -> "Failed to downgrade the request to http", (Throwable)e);
                            return super.execute(request, connection, context);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$execute$1()}, serializedLambda);
                    }
                };
                boxedUnit = clientBuilder.setRequestExecutor(httpRequestDowngradeExecutor);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if (proxyConfig.noProxyHosts().nonEmpty() || neverUseHttps) {
                DefaultRoutePlanner routePlanner = new DefaultRoutePlanner(null, (ConfUtils.ProxyConfig)proxyConfig, proxy){
                    private final ConfUtils.ProxyConfig proxyConfig$1;
                    private final HttpHost proxy$1;

                    public HttpRoute determineRoute(HttpHost target, HttpRequest request, HttpContext context) {
                        if (this.proxyConfig$1.noProxyHosts().contains((Object)target.getHostName())) {
                            return new HttpRoute(target);
                        }
                        return new HttpRoute(target, this.proxy$1);
                    }
                    {
                        this.proxyConfig$1 = proxyConfig$1;
                        this.proxy$1 = proxy$1;
                        super((SchemePortResolver)DefaultSchemePortResolver.INSTANCE);
                    }
                };
                return clientBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
            }
            return BoxedUnit.UNIT;
        });
        return clientBuilder.build();
    }

    private long refreshThresholdMs$lzycompute() {
        DeltaSharingFileSystem deltaSharingFileSystem = this;
        synchronized (deltaSharingFileSystem) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.refreshThresholdMs = this.getConf().getLong("spark.delta.sharing.executor.refreshThresholdMs", TimeUnit.MINUTES.toMillis(10L));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.refreshThresholdMs;
    }

    private long refreshThresholdMs() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.refreshThresholdMs$lzycompute();
        }
        return this.refreshThresholdMs;
    }

    private RpcEndpointRef preSignedUrlCacheRef$lzycompute() {
        DeltaSharingFileSystem deltaSharingFileSystem = this;
        synchronized (deltaSharingFileSystem) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.preSignedUrlCacheRef = PreSignedUrlCache$.MODULE$.getEndpointRefInExecutor(SparkEnv$.MODULE$.get());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.preSignedUrlCacheRef;
    }

    private RpcEndpointRef preSignedUrlCacheRef() {
        if ((byte)(this.bitmap$0 & 0x20) == 0) {
            return this.preSignedUrlCacheRef$lzycompute();
        }
        return this.preSignedUrlCacheRef;
    }

    public String getScheme() {
        return DeltaSharingFileSystem$.MODULE$.SCHEME();
    }

    public URI getUri() {
        return URI.create(new StringBuilder(4).append(DeltaSharingFileSystem$.MODULE$.SCHEME()).append(":///").toString());
    }

    public FSDataInputStream open(Path f, int bufferSize) {
        DeltaSharingPath path = DeltaSharingFileSystem$.MODULE$.decode(f);
        PreSignedUrlFetcher fetcher = new PreSignedUrlFetcher(this.preSignedUrlCacheRef(), path.tablePath(), path.fileId(), this.refreshThresholdMs());
        if (this.getConf().getBoolean("spark.delta.sharing.loadDataFilesInMemory", false)) {
            long start = System.currentTimeMillis();
            FSDataInputStream stream = new FSDataInputStream((InputStream)new InMemoryHttpInputStream(new URI(fetcher.getUrl())));
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(64).append("Took ").append((System.currentTimeMillis() - start) / 1000L).append("s to build ").append("InMemoryHttpInputStream for delta sharing path ").append(path).append(".").toString());
            return stream;
        }
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(83).append("opening delta sharing path [").append(path).append("] with RandomAccessHttpInputStream, ").append("with bufferSize:[").append(bufferSize).append("].").toString());
        return new FSDataInputStream((InputStream)((Object)new RandomAccessHttpInputStream((HttpClient)this.httpClient(), fetcher, path.fileSize(), this.statistics, this.numRetries(), this.maxRetryDurationMillis())));
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) {
        throw new UnsupportedOperationException("create");
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) {
        throw new UnsupportedOperationException("append");
    }

    public boolean rename(Path src, Path dst) {
        throw new UnsupportedOperationException("rename");
    }

    public boolean delete(Path f, boolean recursive) {
        throw new UnsupportedOperationException("delete");
    }

    public FileStatus[] listStatus(Path f) {
        throw new UnsupportedOperationException("listStatus");
    }

    public void setWorkingDirectory(Path new_dir) {
        throw new UnsupportedOperationException("setWorkingDirectory");
    }

    public Path getWorkingDirectory() {
        return new Path(this.getUri());
    }

    public boolean mkdirs(Path f, FsPermission permission) {
        throw new UnsupportedOperationException("mkdirs");
    }

    public FileStatus getFileStatus(Path f) {
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append("Checking delta sharing file status for path: ").append(f).append(".").toString());
        Path resolved = this.makeQualified(f);
        return new FileStatus(DeltaSharingFileSystem$.MODULE$.decode(resolved).fileSize(), false, 0, 1L, 0L, f);
    }

    public void finalize() {
        try {
            super.finalize();
        }
        finally {
            this.close();
        }
    }

    public void close() {
        try {
            super.close();
        }
        finally {
            this.httpClient().close();
        }
    }

    public DeltaSharingFileSystem() {
        Logging.$init$((Logging)this);
    }

    public static class DeltaSharingPath
    implements Product,
    Serializable {
        private final String tablePath;
        private final String fileId;
        private final long fileSize;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String tablePath() {
            return this.tablePath;
        }

        public String fileId() {
            return this.fileId;
        }

        public long fileSize() {
            return this.fileSize;
        }

        public Path toPath() {
            String encodedTablePath = URLEncoder.encode(this.tablePath(), "UTF-8");
            String encodedFileId = URLEncoder.encode(this.fileId(), "UTF-8");
            return new Path(new StringBuilder(6).append(DeltaSharingFileSystem$.MODULE$.SCHEME()).append(":///").append(encodedTablePath).append("/").append(encodedFileId).append("/").append(this.fileSize()).toString());
        }

        public DeltaSharingPath copy(String tablePath, String fileId, long fileSize) {
            return new DeltaSharingPath(tablePath, fileId, fileSize);
        }

        public String copy$default$1() {
            return this.tablePath();
        }

        public String copy$default$2() {
            return this.fileId();
        }

        public long copy$default$3() {
            return this.fileSize();
        }

        public String productPrefix() {
            return "DeltaSharingPath";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.tablePath();
                }
                case 1: {
                    return this.fileId();
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this.fileSize());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof DeltaSharingPath;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "tablePath";
                }
                case 1: {
                    return "fileId";
                }
                case 2: {
                    return "fileSize";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.tablePath()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.fileId()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.fileSize()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof DeltaSharingPath)) return false;
            boolean bl = true;
            if (!bl) return false;
            DeltaSharingPath deltaSharingPath = (DeltaSharingPath)x$1;
            if (this.fileSize() != deltaSharingPath.fileSize()) return false;
            String string = this.tablePath();
            String string2 = deltaSharingPath.tablePath();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.fileId();
            String string4 = deltaSharingPath.fileId();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (!deltaSharingPath.canEqual(this)) return false;
            return true;
        }

        public DeltaSharingPath(String tablePath, String fileId, long fileSize) {
            this.tablePath = tablePath;
            this.fileId = fileId;
            this.fileSize = fileSize;
            Product.$init$((Product)this);
        }
    }
}

