/*
 * Decompiled with CFR 0.152.
 */
package io.delta.sharing.client;

import io.delta.sharing.client.DeltaSharingFileSystem$;
import io.delta.sharing.client.DeltaSharingFileSystemHttpClient;
import io.delta.sharing.client.DeltaSharingFileSystemHttpClientBuilder;
import io.delta.sharing.client.DeltaSharingFileSystemHttpClientBuilder$;
import io.delta.sharing.client.InMemoryHttpInputStream;
import io.delta.sharing.client.RandomAccessHttpInputStream;
import io.delta.sharing.client.model.FileAction;
import io.delta.sharing.client.util.ConfUtils;
import io.delta.sharing.client.util.ConfUtils$;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.spark.SparkEnv$;
import org.apache.spark.delta.sharing.PreSignedUrlCache$;
import org.apache.spark.delta.sharing.PreSignedUrlFetcher;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.rpc.RpcEndpointRef;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.StringContext;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\tmh!B\u001e=\u0001y\"\u0005\"B-\u0001\t\u0003Y\u0006\u0002\u00030\u0001\u0011\u000b\u0007I\u0011B0\t\u0011\u0019\u0004\u0001R1A\u0005\n\u001dD\u0001b\u001b\u0001\t\u0006\u0004%Ia\u0018\u0005\tY\u0002A)\u0019!C\u0005[\"1\u0011\u000f\u0001C\u0001}ID\u0001b\u001d\u0001\t\u0006\u0004%Ia\u001a\u0005\ti\u0002A)\u0019!C\u0005k\")A\u0010\u0001C!{\"9\u00111\u0003\u0001\u0005B\u0005U\u0001bBA\u0014\u0001\u0011\u0005\u0013\u0011\u0006\u0005\b\u0003\u007f\u0001A\u0011IA!\u0011\u001d\t\u0019\t\u0001C!\u0003\u000bCq!!$\u0001\t\u0003\ny\tC\u0004\u0002\u001a\u0002!\t%a'\t\u000f\u0005\r\u0006\u0001\"\u0011\u0002&\"9\u0011Q\u0017\u0001\u0005B\u0005]\u0006bBAb\u0001\u0011\u0005\u0013Q\u0019\u0005\b\u0003\u000f\u0004A\u0011IAe\u0011\u001d\ty\r\u0001C!\u0003#Dq!!6\u0001\t\u0003\n9\u000eC\u0004\u0002Z\u0002!\t%a6\b\u0011\u0005mG\b#\u0001?\u0003;4qa\u000f\u001f\t\u0002y\ny\u000e\u0003\u0004Z1\u0011\u0005\u0011q\u001d\u0005\n\u0003SD\"\u0019!C\u0001\u0003WD\u0001\"a>\u0019A\u0003%\u0011Q\u001e\u0004\u0007\u0003sD\u0002)a?\t\u0015\tUAD!f\u0001\n\u0003\u00119\u0002C\u0005\u0003\u001aq\u0011\t\u0012)A\u0005}\"Q!1\u0004\u000f\u0003\u0016\u0004%\tAa\u0006\t\u0013\tuAD!E!\u0002\u0013q\b\"\u0003B\u00109\tU\r\u0011\"\u0001h\u0011%\u0011\t\u0003\bB\tB\u0003%\u0001\u000e\u0003\u0004Z9\u0011\u0005!1\u0005\u0005\b\u0005_aB\u0011\u0001B\u0019\u0011%\u0011\u0019\u0004HA\u0001\n\u0003\u0011)\u0004C\u0005\u0003>q\t\n\u0011\"\u0001\u0003@!I!Q\u000b\u000f\u0012\u0002\u0013\u0005!q\b\u0005\n\u0005/b\u0012\u0013!C\u0001\u00053B\u0011B!\u0018\u001d\u0003\u0003%\t%a;\t\u0011\t}C$!A\u0005\u0002}C\u0011B!\u0019\u001d\u0003\u0003%\tAa\u0019\t\u0013\t=D$!A\u0005B\tE\u0004\"\u0003B@9\u0005\u0005I\u0011\u0001BA\u0011%\u0011)\tHA\u0001\n\u0003\u00129\tC\u0005\u0003\fr\t\t\u0011\"\u0011\u0003\u000e\"I!q\u0012\u000f\u0002\u0002\u0013\u0005#\u0011\u0013\u0005\n\u0005'c\u0012\u0011!C!\u0005+;\u0011B!'\u0019\u0003\u0003E\tAa'\u0007\u0013\u0005e\b$!A\t\u0002\tu\u0005BB-4\t\u0003\u0011\u0019\fC\u0005\u0003\u0010N\n\t\u0011\"\u0012\u0003\u0012\"I!QW\u001a\u0002\u0002\u0013\u0005%q\u0017\u0005\n\u0005\u007f\u001b\u0014\u0011!CA\u0005\u0003D\u0011Ba54\u0003\u0003%IA!6\t\u000f\tu\u0007\u0004\"\u0001\u0003`\"9!1\u001f\r\u0005\u0002\tU(A\u0006#fYR\f7\u000b[1sS:<g)\u001b7f'f\u001cH/Z7\u000b\u0005ur\u0014AB2mS\u0016tGO\u0003\u0002@\u0001\u000691\u000f[1sS:<'BA!C\u0003\u0015!W\r\u001c;b\u0015\u0005\u0019\u0015AA5p'\r\u0001Q)\u0015\t\u0003\r>k\u0011a\u0012\u0006\u0003\u0011&\u000b!AZ:\u000b\u0005)[\u0015A\u00025bI>|\u0007O\u0003\u0002M\u001b\u00061\u0011\r]1dQ\u0016T\u0011AT\u0001\u0004_J<\u0017B\u0001)H\u0005)1\u0015\u000e\\3TsN$X-\u001c\t\u0003%^k\u0011a\u0015\u0006\u0003)V\u000b\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003-.\u000bQa\u001d9be.L!\u0001W*\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001]!\ti\u0006!D\u0001=\u0003)qW/\u001c*fiJLWm]\u000b\u0002AB\u0011\u0011\rZ\u0007\u0002E*\t1-A\u0003tG\u0006d\u0017-\u0003\u0002fE\n\u0019\u0011J\u001c;\u0002-5\f\u0007PU3uef$UO]1uS>tW*\u001b7mSN,\u0012\u0001\u001b\t\u0003C&L!A\u001b2\u0003\t1{gnZ\u0001\u0011i&lWm\\;u\u0013:\u001cVmY8oIN\f!\u0002\u001b;ua\u000ec\u0017.\u001a8u+\u0005q\u0007CA/p\u0013\t\u0001HH\u0001\u0011EK2$\u0018m\u00155be&twMR5mKNK8\u000f^3n\u0011R$\bo\u00117jK:$\u0018\u0001E2sK\u0006$X\r\u0013;ua\u000ec\u0017.\u001a8u)\u0005q\u0017A\u0005:fMJ,7\u000f\u001b+ie\u0016\u001c\bn\u001c7e\u001bN\fA\u0003\u001d:f'&<g.\u001a3Ve2\u001c\u0015m\u00195f%\u00164W#\u0001<\u0011\u0005]TX\"\u0001=\u000b\u0005e,\u0016a\u0001:qG&\u00111\u0010\u001f\u0002\u000f%B\u001cWI\u001c3q_&tGOU3g\u0003%9W\r^*dQ\u0016lW\rF\u0001\u007f!\ry\u0018Q\u0002\b\u0005\u0003\u0003\tI\u0001E\u0002\u0002\u0004\tl!!!\u0002\u000b\u0007\u0005\u001d!,\u0001\u0004=e>|GOP\u0005\u0004\u0003\u0017\u0011\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0010\u0005E!AB*ue&twMC\u0002\u0002\f\t\faaZ3u+JLGCAA\f!\u0011\tI\"a\t\u000e\u0005\u0005m!\u0002BA\u000f\u0003?\t1A\\3u\u0015\t\t\t#\u0001\u0003kCZ\f\u0017\u0002BA\u0013\u00037\u00111!\u0016*J\u0003\u0011y\u0007/\u001a8\u0015\r\u0005-\u0012\u0011GA\u001e!\r1\u0015QF\u0005\u0004\u0003_9%!\u0005$T\t\u0006$\u0018-\u00138qkR\u001cFO]3b[\"9\u00111G\u0006A\u0002\u0005U\u0012!\u00014\u0011\u0007\u0019\u000b9$C\u0002\u0002:\u001d\u0013A\u0001U1uQ\"1\u0011QH\u0006A\u0002\u0001\f!BY;gM\u0016\u00148+\u001b>f\u0003\u0019\u0019'/Z1uKR\u0001\u00121IA%\u0003\u0017\nI&a\u0019\u0002f\u0005=\u00141\u000f\t\u0004\r\u0006\u0015\u0013bAA$\u000f\n\u0011bi\u0015#bi\u0006|U\u000f\u001e9viN#(/Z1n\u0011\u001d\t\u0019\u0004\u0004a\u0001\u0003kAq!!\u0014\r\u0001\u0004\ty%\u0001\u0006qKJl\u0017n]:j_:\u0004B!!\u0015\u0002V5\u0011\u00111\u000b\u0006\u0004\u0003\u001b:\u0015\u0002BA,\u0003'\u0012ABR:QKJl\u0017n]:j_:Dq!a\u0017\r\u0001\u0004\ti&A\u0005pm\u0016\u0014xO]5uKB\u0019\u0011-a\u0018\n\u0007\u0005\u0005$MA\u0004C_>dW-\u00198\t\r\u0005uB\u00021\u0001a\u0011\u001d\t9\u0007\u0004a\u0001\u0003S\n1B]3qY&\u001c\u0017\r^5p]B\u0019\u0011-a\u001b\n\u0007\u00055$MA\u0003TQ>\u0014H\u000f\u0003\u0004\u0002r1\u0001\r\u0001[\u0001\nE2|7m[*ju\u0016Dq!!\u001e\r\u0001\u0004\t9(\u0001\u0005qe><'/Z:t!\u0011\tI(a \u000e\u0005\u0005m$bAA?\u0013\u0006!Q\u000f^5m\u0013\u0011\t\t)a\u001f\u0003\u0019A\u0013xn\u001a:fgN\f'\r\\3\u0002\r\u0005\u0004\b/\u001a8e)!\t\u0019%a\"\u0002\n\u0006-\u0005bBA\u001a\u001b\u0001\u0007\u0011Q\u0007\u0005\u0007\u0003{i\u0001\u0019\u00011\t\u000f\u0005UT\u00021\u0001\u0002x\u00051!/\u001a8b[\u0016$b!!\u0018\u0002\u0012\u0006U\u0005bBAJ\u001d\u0001\u0007\u0011QG\u0001\u0004gJ\u001c\u0007bBAL\u001d\u0001\u0007\u0011QG\u0001\u0004IN$\u0018A\u00023fY\u0016$X\r\u0006\u0004\u0002^\u0005u\u0015q\u0014\u0005\b\u0003gy\u0001\u0019AA\u001b\u0011\u001d\t\tk\u0004a\u0001\u0003;\n\u0011B]3dkJ\u001c\u0018N^3\u0002\u00151L7\u000f^*uCR,8\u000f\u0006\u0003\u0002(\u0006M\u0006#B1\u0002*\u00065\u0016bAAVE\n)\u0011I\u001d:bsB\u0019a)a,\n\u0007\u0005EvI\u0001\u0006GS2,7\u000b^1ukNDq!a\r\u0011\u0001\u0004\t)$A\ntKR<vN]6j]\u001e$\u0015N]3di>\u0014\u0018\u0010\u0006\u0003\u0002:\u0006}\u0006cA1\u0002<&\u0019\u0011Q\u00182\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u0003\f\u0002\u0019AA\u001b\u0003\u001dqWm^0eSJ\f1cZ3u/>\u00148.\u001b8h\t&\u0014Xm\u0019;pef$\"!!\u000e\u0002\r5\\G-\u001b:t)\u0019\ti&a3\u0002N\"9\u00111G\nA\u0002\u0005U\u0002bBA''\u0001\u0007\u0011qJ\u0001\u000eO\u0016$h)\u001b7f'R\fG/^:\u0015\t\u00055\u00161\u001b\u0005\b\u0003g!\u0002\u0019AA\u001b\u0003!1\u0017N\\1mSj,GCAA]\u0003\u0015\u0019Gn\\:f\u0003Y!U\r\u001c;b'\"\f'/\u001b8h\r&dWmU=ti\u0016l\u0007CA/\u0019'\rA\u0012\u0011\u001d\t\u0004C\u0006\r\u0018bAAsE\n1\u0011I\\=SK\u001a$\"!!8\u0002\rM\u001b\u0005*R'F+\t\ti\u000f\u0005\u0003\u0002p\u0006UXBAAy\u0015\u0011\t\u00190a\b\u0002\t1\fgnZ\u0005\u0005\u0003\u001f\t\t0A\u0004T\u0007\"+U*\u0012\u0011\u0003!\u0011+G\u000e^1TQ\u0006\u0014\u0018N\\4QCRD7c\u0002\u000f\u0002b\u0006u(1\u0001\t\u0004C\u0006}\u0018b\u0001B\u0001E\n9\u0001K]8ek\u000e$\b\u0003\u0002B\u0003\u0005\u001fqAAa\u0002\u0003\f9!\u00111\u0001B\u0005\u0013\u0005\u0019\u0017b\u0001B\u0007E\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002B\t\u0005'\u0011AbU3sS\u0006d\u0017N_1cY\u0016T1A!\u0004c\u0003%!\u0018M\u00197f!\u0006$\b.F\u0001\u007f\u0003)!\u0018M\u00197f!\u0006$\b\u000eI\u0001\u0007M&dW-\u00133\u0002\u000f\u0019LG.Z%eA\u0005Aa-\u001b7f'&TX-A\u0005gS2,7+\u001b>fAQA!Q\u0005B\u0015\u0005W\u0011i\u0003E\u0002\u0003(qi\u0011\u0001\u0007\u0005\u0007\u0005+\u0019\u0003\u0019\u0001@\t\r\tm1\u00051\u0001\u007f\u0011\u0019\u0011yb\ta\u0001Q\u00061Ao\u001c)bi\",\"!!\u000e\u0002\t\r|\u0007/\u001f\u000b\t\u0005K\u00119D!\u000f\u0003<!A!QC\u0013\u0011\u0002\u0003\u0007a\u0010\u0003\u0005\u0003\u001c\u0015\u0002\n\u00111\u0001\u007f\u0011!\u0011y\"\nI\u0001\u0002\u0004A\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005\u0003R3A B\"W\t\u0011)\u0005\u0005\u0003\u0003H\tESB\u0001B%\u0015\u0011\u0011YE!\u0014\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B(E\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tM#\u0011\n\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011YFK\u0002i\u0005\u0007\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&D\u0018\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005K\u0012Y\u0007E\u0002b\u0005OJ1A!\u001bc\u0005\r\te.\u001f\u0005\t\u0005[Z\u0013\u0011!a\u0001A\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\u001d\u0011\r\tU$1\u0010B3\u001b\t\u00119HC\u0002\u0003z\t\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011iHa\u001e\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003;\u0012\u0019\tC\u0005\u0003n5\n\t\u00111\u0001\u0003f\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\tiO!#\t\u0011\t5d&!AA\u0002\u0001\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002A\u0006AAo\\*ue&tw\r\u0006\u0002\u0002n\u00061Q-];bYN$B!!\u0018\u0003\u0018\"I!QN\u0019\u0002\u0002\u0003\u0007!QM\u0001\u0011\t\u0016dG/Y*iCJLgn\u001a)bi\"\u00042Aa\n4'\u0015\u0019$q\u0014BV!%\u0011\tKa*\u007f}\"\u0014)#\u0004\u0002\u0003$*\u0019!Q\u00152\u0002\u000fI,h\u000e^5nK&!!\u0011\u0016BR\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\t\u0005\u0005[\u0013\t,\u0004\u0002\u00030*\u00191)a\b\n\t\tE!q\u0016\u000b\u0003\u00057\u000bQ!\u00199qYf$\u0002B!\n\u0003:\nm&Q\u0018\u0005\u0007\u0005+1\u0004\u0019\u0001@\t\r\tma\u00071\u0001\u007f\u0011\u0019\u0011yB\u000ea\u0001Q\u00069QO\\1qa2LH\u0003\u0002Bb\u0005\u001f\u0004R!\u0019Bc\u0005\u0013L1Aa2c\u0005\u0019y\u0005\u000f^5p]B1\u0011Ma3\u007f}\"L1A!4c\u0005\u0019!V\u000f\u001d7fg!I!\u0011[\u001c\u0002\u0002\u0003\u0007!QE\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001Bl!\u0011\tyO!7\n\t\tm\u0017\u0011\u001f\u0002\u0007\u001f\nTWm\u0019;\u0002\r\u0015t7m\u001c3f)\u0019\t)D!9\u0003d\"1!QC\u001dA\u0002yDqA!::\u0001\u0004\u00119/\u0001\u0004bGRLwN\u001c\t\u0005\u0005S\u0014y/\u0004\u0002\u0003l*\u0019!Q\u001e\u001f\u0002\u000b5|G-\u001a7\n\t\tE(1\u001e\u0002\u000b\r&dW-Q2uS>t\u0017A\u00023fG>$W\r\u0006\u0003\u0003&\t]\bb\u0002B}u\u0001\u0007\u0011QG\u0001\u0005a\u0006$\b\u000e")
public class DeltaSharingFileSystem
extends FileSystem
implements Logging {
    private int numRetries;
    private long maxRetryDurationMillis;
    private int timeoutInSeconds;
    private DeltaSharingFileSystemHttpClient httpClient;
    private long refreshThresholdMs;
    private RpcEndpointRef preSignedUrlCacheRef;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static DeltaSharingPath decode(Path path) {
        return DeltaSharingFileSystem$.MODULE$.decode(path);
    }

    public static Path encode(String tablePath, FileAction action) {
        return DeltaSharingFileSystem$.MODULE$.encode(tablePath, action);
    }

    public static String SCHEME() {
        return DeltaSharingFileSystem$.MODULE$.SCHEME();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int numRetries$lzycompute() {
        DeltaSharingFileSystem deltaSharingFileSystem = this;
        synchronized (deltaSharingFileSystem) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.numRetries = ConfUtils$.MODULE$.numRetries(this.getConf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.numRetries;
    }

    private int numRetries() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.numRetries$lzycompute();
        }
        return this.numRetries;
    }

    private long maxRetryDurationMillis$lzycompute() {
        DeltaSharingFileSystem deltaSharingFileSystem = this;
        synchronized (deltaSharingFileSystem) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.maxRetryDurationMillis = ConfUtils$.MODULE$.maxRetryDurationMillis(this.getConf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.maxRetryDurationMillis;
    }

    private long maxRetryDurationMillis() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.maxRetryDurationMillis$lzycompute();
        }
        return this.maxRetryDurationMillis;
    }

    private int timeoutInSeconds$lzycompute() {
        DeltaSharingFileSystem deltaSharingFileSystem = this;
        synchronized (deltaSharingFileSystem) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.timeoutInSeconds = ConfUtils$.MODULE$.timeoutInSeconds(this.getConf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.timeoutInSeconds;
    }

    private int timeoutInSeconds() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.timeoutInSeconds$lzycompute();
        }
        return this.timeoutInSeconds;
    }

    private DeltaSharingFileSystemHttpClient httpClient$lzycompute() {
        DeltaSharingFileSystem deltaSharingFileSystem = this;
        synchronized (deltaSharingFileSystem) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.httpClient = this.createHttpClient();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.httpClient;
    }

    private DeltaSharingFileSystemHttpClient httpClient() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.httpClient$lzycompute();
        }
        return this.httpClient;
    }

    public DeltaSharingFileSystemHttpClient createHttpClient() {
        Option<ConfUtils.ProxyConfig> proxyConfigOpt = ConfUtils$.MODULE$.getProxyConfig(this.getConf());
        int maxConnections = ConfUtils$.MODULE$.maxConnections(this.getConf());
        boolean neverUseHttps = ConfUtils$.MODULE$.getNeverUseHttps(this.getConf());
        RequestConfig config = RequestConfig.custom().setConnectTimeout(this.timeoutInSeconds() * 1000).setConnectionRequestTimeout(this.timeoutInSeconds() * 1000).setSocketTimeout(this.timeoutInSeconds() * 1000).build();
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(58).append("Creating delta sharing httpClient with timeoutInSeconds: ").append(this.timeoutInSeconds()).append(".").toString());
        DeltaSharingFileSystemHttpClientBuilder clientBuilder = DeltaSharingFileSystemHttpClientBuilder$.MODULE$.create().setMaxConnTotal(maxConnections).setMaxConnPerRoute(maxConnections).setDefaultRequestConfig(config).disableAutomaticRetries();
        Object object = neverUseHttps ? clientBuilder.setDisableHttps() : BoxedUnit.UNIT;
        proxyConfigOpt.foreach((Function1 & Serializable)proxyConfig -> {
            HttpHost proxy = new HttpHost(proxyConfig.host(), proxyConfig.port());
            clientBuilder.setProxy(proxy);
            return clientBuilder.setNoProxyHosts(proxyConfig.noProxyHosts());
        });
        return clientBuilder.build();
    }

    private long refreshThresholdMs$lzycompute() {
        DeltaSharingFileSystem deltaSharingFileSystem = this;
        synchronized (deltaSharingFileSystem) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.refreshThresholdMs = this.getConf().getLong("spark.delta.sharing.executor.refreshThresholdMs", TimeUnit.MINUTES.toMillis(10L));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.refreshThresholdMs;
    }

    private long refreshThresholdMs() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.refreshThresholdMs$lzycompute();
        }
        return this.refreshThresholdMs;
    }

    private RpcEndpointRef preSignedUrlCacheRef$lzycompute() {
        DeltaSharingFileSystem deltaSharingFileSystem = this;
        synchronized (deltaSharingFileSystem) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.preSignedUrlCacheRef = PreSignedUrlCache$.MODULE$.getEndpointRefInExecutor(SparkEnv$.MODULE$.get());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.preSignedUrlCacheRef;
    }

    private RpcEndpointRef preSignedUrlCacheRef() {
        if ((byte)(this.bitmap$0 & 0x20) == 0) {
            return this.preSignedUrlCacheRef$lzycompute();
        }
        return this.preSignedUrlCacheRef;
    }

    public String getScheme() {
        return DeltaSharingFileSystem$.MODULE$.SCHEME();
    }

    public URI getUri() {
        return URI.create(new StringBuilder(4).append(DeltaSharingFileSystem$.MODULE$.SCHEME()).append(":///").toString());
    }

    public FSDataInputStream open(Path f, int bufferSize) {
        DeltaSharingPath path = DeltaSharingFileSystem$.MODULE$.decode(f);
        PreSignedUrlFetcher fetcher = new PreSignedUrlFetcher(this.preSignedUrlCacheRef(), path.tablePath(), path.fileId(), this.refreshThresholdMs());
        if (this.getConf().getBoolean("spark.delta.sharing.loadDataFilesInMemory", false)) {
            long start = System.currentTimeMillis();
            FSDataInputStream stream = new FSDataInputStream((InputStream)new InMemoryHttpInputStream(new URI(fetcher.getUrl())));
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(64).append("Took ").append((System.currentTimeMillis() - start) / 1000L).append("s to build ").append("InMemoryHttpInputStream for delta sharing path ").append(path).append(".").toString());
            return stream;
        }
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(83).append("opening delta sharing path [").append(path).append("] with RandomAccessHttpInputStream, ").append("with bufferSize:[").append(bufferSize).append("].").toString());
        return new FSDataInputStream((InputStream)((Object)new RandomAccessHttpInputStream((HttpClient)this.httpClient(), fetcher, path.fileSize(), this.statistics, this.numRetries(), this.maxRetryDurationMillis())));
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) {
        throw new UnsupportedOperationException("create");
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) {
        throw new UnsupportedOperationException("append");
    }

    public boolean rename(Path src, Path dst) {
        throw new UnsupportedOperationException("rename");
    }

    public boolean delete(Path f, boolean recursive) {
        throw new UnsupportedOperationException("delete");
    }

    public FileStatus[] listStatus(Path f) {
        throw new UnsupportedOperationException("listStatus");
    }

    public void setWorkingDirectory(Path new_dir) {
        throw new UnsupportedOperationException("setWorkingDirectory");
    }

    public Path getWorkingDirectory() {
        return new Path(this.getUri());
    }

    public boolean mkdirs(Path f, FsPermission permission) {
        throw new UnsupportedOperationException("mkdirs");
    }

    public FileStatus getFileStatus(Path f) {
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append("Checking delta sharing file status for path: ").append(f).append(".").toString());
        Path resolved = this.makeQualified(f);
        return new FileStatus(DeltaSharingFileSystem$.MODULE$.decode(resolved).fileSize(), false, 0, 1L, 0L, f);
    }

    public void finalize() {
        try {
            super.finalize();
        }
        finally {
            this.close();
        }
    }

    public void close() {
        try {
            super.close();
        }
        finally {
            this.httpClient().close();
        }
    }

    public DeltaSharingFileSystem() {
        Logging.$init$((Logging)this);
    }

    public static class DeltaSharingPath
    implements Product,
    Serializable {
        private final String tablePath;
        private final String fileId;
        private final long fileSize;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String tablePath() {
            return this.tablePath;
        }

        public String fileId() {
            return this.fileId;
        }

        public long fileSize() {
            return this.fileSize;
        }

        public Path toPath() {
            String encodedTablePath = URLEncoder.encode(this.tablePath(), "UTF-8");
            String encodedFileId = URLEncoder.encode(this.fileId(), "UTF-8");
            return new Path(new StringBuilder(6).append(DeltaSharingFileSystem$.MODULE$.SCHEME()).append(":///").append(encodedTablePath).append("/").append(encodedFileId).append("/").append(this.fileSize()).toString());
        }

        public DeltaSharingPath copy(String tablePath, String fileId, long fileSize) {
            return new DeltaSharingPath(tablePath, fileId, fileSize);
        }

        public String copy$default$1() {
            return this.tablePath();
        }

        public String copy$default$2() {
            return this.fileId();
        }

        public long copy$default$3() {
            return this.fileSize();
        }

        public String productPrefix() {
            return "DeltaSharingPath";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.tablePath();
                }
                case 1: {
                    return this.fileId();
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this.fileSize());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof DeltaSharingPath;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "tablePath";
                }
                case 1: {
                    return "fileId";
                }
                case 2: {
                    return "fileSize";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.tablePath()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.fileId()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.fileSize()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof DeltaSharingPath)) return false;
            boolean bl = true;
            if (!bl) return false;
            DeltaSharingPath deltaSharingPath = (DeltaSharingPath)x$1;
            if (this.fileSize() != deltaSharingPath.fileSize()) return false;
            String string = this.tablePath();
            String string2 = deltaSharingPath.tablePath();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.fileId();
            String string4 = deltaSharingPath.fileId();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (!deltaSharingPath.canEqual(this)) return false;
            return true;
        }

        public DeltaSharingPath(String tablePath, String fileId, long fileSize) {
            this.tablePath = tablePath;
            this.fileId = fileId;
            this.fileSize = fileSize;
            Product.$init$((Product)this);
        }
    }
}

