/*
 * Decompiled with CFR 0.152.
 */
package io.delta.sharing.client;

import io.delta.sharing.client.RandomAccessHttpInputStream$;
import io.delta.sharing.client.util.RetryUtils$;
import io.delta.sharing.client.util.UnexpectedHttpStatus;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.EofSensorInputStream;
import org.apache.spark.delta.sharing.PreSignedUrlFetcher;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.StringContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005ef!B\u0012%\u0001\u0019b\u0003\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\t\u0011%\u0003!\u0011!Q\u0001\n)C\u0001\u0002\u0015\u0001\u0003\u0002\u0003\u0006I!\u0015\u0005\t/\u0002\u0011\t\u0011)A\u00051\"Aq\f\u0001B\u0001B\u0003%\u0001\r\u0003\u0005d\u0001\t\u0005\t\u0015!\u0003R\u0011\u0015!\u0007\u0001\"\u0001f\u0011\u001dq\u0007\u00011A\u0005\n=Dqa\u001d\u0001A\u0002\u0013%A\u000f\u0003\u0004{\u0001\u0001\u0006K\u0001\u001d\u0005\bw\u0002\u0001\r\u0011\"\u0003}\u0011\u001di\b\u00011A\u0005\nyDq!!\u0001\u0001A\u0003&\u0011\u000bC\u0005\u0002\u0004\u0001\u0001\r\u0011\"\u0003\u0002\u0006!I\u0011Q\u0003\u0001A\u0002\u0013%\u0011q\u0003\u0005\t\u00037\u0001\u0001\u0015)\u0003\u0002\b!I\u0011Q\u0004\u0001A\u0002\u0013%\u0011q\u0004\u0005\n\u0003o\u0001\u0001\u0019!C\u0005\u0003sA\u0001\"!\u0010\u0001A\u0003&\u0011\u0011\u0005\u0005\b\u0003\u007f\u0001A\u0011BA!\u0011\u001d\t\u0019\u0005\u0001C!\u0003\u000bBq!!\u0013\u0001\t\u0003\nY\u0005C\u0004\u0002N\u0001!\t%a\u0014\t\u000f\u0005U\u0003\u0001\"\u0011\u0002X!9\u0011\u0011\f\u0001\u0005\n\u0005m\u0003bBA+\u0001\u0011\u0005\u0013Q\u000e\u0005\b\u0003\u000f\u0003A\u0011BAE\u0011\u001d\ti\t\u0001C!\u0003/Bq!a$\u0001\t\u0013\t\t\u0005C\u0004\u0002\u0012\u0002!\t%!\u0011\b\u0015\u0005ME%!A\t\u0002\u0019\n)JB\u0005$I\u0005\u0005\t\u0012\u0001\u0014\u0002\u0018\"1A\r\tC\u0001\u0003?C\u0011\"!)!#\u0003%\t!a)\u00037I\u000bg\u000eZ8n\u0003\u000e\u001cWm]:IiR\u0004\u0018J\u001c9viN#(/Z1n\u0015\t)c%\u0001\u0004dY&,g\u000e\u001e\u0006\u0003O!\nqa\u001d5be&twM\u0003\u0002*U\u0005)A-\u001a7uC*\t1&\u0001\u0002j_N\u0019\u0001!L\u001d\u0011\u00059:T\"A\u0018\u000b\u0005A\n\u0014A\u00014t\u0015\t\u00114'\u0001\u0004iC\u0012|w\u000e\u001d\u0006\u0003iU\na!\u00199bG\",'\"\u0001\u001c\u0002\u0007=\u0014x-\u0003\u00029_\tiaiU%oaV$8\u000b\u001e:fC6\u0004\"AO \u000e\u0003mR!\u0001P\u001f\u0002\u0011%tG/\u001a:oC2T!AP\u001a\u0002\u000bM\u0004\u0018M]6\n\u0005\u0001[$a\u0002'pO\u001eLgnZ\u0002\u0001!\t\u0019u)D\u0001E\u0015\t)SI\u0003\u0002Gg\u0005!\u0001\u000e\u001e;q\u0013\tAEI\u0001\u0006IiR\u00048\t\\5f]R\fqAZ3uG\",'\u000f\u0005\u0002L\u001d6\tAJ\u0003\u0002(\u001b*\u0011\u0011&P\u0005\u0003\u001f2\u00131\u0003\u0015:f'&<g.\u001a3Ve24U\r^2iKJ\fQbY8oi\u0016tG\u000fT3oORD\u0007C\u0001*V\u001b\u0005\u0019&\"\u0001+\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001b&\u0001\u0002'p]\u001e\fQa\u001d;biN\u0004\"!\u0017/\u000f\u00059R\u0016BA.0\u0003)1\u0015\u000e\\3TsN$X-\\\u0005\u0003;z\u0013!b\u0015;bi&\u001cH/[2t\u0015\tYv&\u0001\u0006ok6\u0014V\r\u001e:jKN\u0004\"AU1\n\u0005\t\u001c&aA%oi\u0006\u0001R.\u0019=SKR\u0014\u0018\u0010R;sCRLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f\u0019D\u0017N[6m[B\u0011q\rA\u0007\u0002I!)Qe\u0002a\u0001\u0005\")\u0011j\u0002a\u0001\u0015\")\u0001k\u0002a\u0001#\")qk\u0002a\u00011\")ql\u0002a\u0001A\"91m\u0002I\u0001\u0002\u0004\t\u0016AB2m_N,G-F\u0001q!\t\u0011\u0016/\u0003\u0002s'\n9!i\\8mK\u0006t\u0017AC2m_N,Gm\u0018\u0013fcR\u0011Q\u000f\u001f\t\u0003%ZL!a^*\u0003\tUs\u0017\u000e\u001e\u0005\bs&\t\t\u00111\u0001q\u0003\rAH%M\u0001\bG2|7/\u001a3!\u0003\r\u0001xn]\u000b\u0002#\u00069\u0001o\\:`I\u0015\fHCA;\u0000\u0011\u001dIH\"!AA\u0002E\u000bA\u0001]8tA\u0005i1-\u001e:sK:$8\u000b\u001e:fC6,\"!a\u0002\u0011\t\u0005%\u0011\u0011C\u0007\u0003\u0003\u0017Q1aKA\u0007\u0015\t\ty!\u0001\u0003kCZ\f\u0017\u0002BA\n\u0003\u0017\u00111\"\u00138qkR\u001cFO]3b[\u0006\t2-\u001e:sK:$8\u000b\u001e:fC6|F%Z9\u0015\u0007U\fI\u0002\u0003\u0005z\u001f\u0005\u0005\t\u0019AA\u0004\u00039\u0019WO\u001d:f]R\u001cFO]3b[\u0002\n1!\u001e:j+\t\t\t\u0003\u0005\u0003\u0002$\u0005Eb\u0002BA\u0013\u0003[\u00012!a\nT\u001b\t\tICC\u0002\u0002,\u0005\u000ba\u0001\u0010:p_Rt\u0014bAA\u0018'\u00061\u0001K]3eK\u001aLA!a\r\u00026\t11\u000b\u001e:j]\u001eT1!a\fT\u0003\u001d)(/[0%KF$2!^A\u001e\u0011!I(#!AA\u0002\u0005\u0005\u0012\u0001B;sS\u0002\nq\"Y:tKJ$hj\u001c;DY>\u001cX\r\u001a\u000b\u0002k\u0006!1/Z3l)\r)\u0018q\t\u0005\u0006wV\u0001\r!U\u0001\u0007O\u0016$\bk\\:\u0015\u0003E\u000bqb]3fWR{g*Z<T_V\u00148-\u001a\u000b\u0004a\u0006E\u0003BBA*/\u0001\u0007\u0011+A\u0005uCJ<W\r\u001e)pg\u0006!!/Z1e)\u0005\u0001\u0017!E2sK\u0006$X\r\u0013;uaJ+\u0017/^3tiR!\u0011QLA5!\u0011\ty&!\u001a\u000e\u0005\u0005\u0005$bAA2\t\u00069Q.\u001a;i_\u0012\u001c\u0018\u0002BA4\u0003C\u0012q\u0002\u0013;uaJ+\u0017/^3ti\n\u000b7/\u001a\u0005\u0007\u0003WJ\u0002\u0019A)\u0002\u000bM$\u0018M\u001d;\u0015\u000f\u0001\fy'a \u0002\u0004\"9\u0011\u0011\u000f\u000eA\u0002\u0005M\u0014a\u00012vMB)!+!\u001e\u0002z%\u0019\u0011qO*\u0003\u000b\u0005\u0013(/Y=\u0011\u0007I\u000bY(C\u0002\u0002~M\u0013AAQ=uK\"1\u0011\u0011\u0011\u000eA\u0002\u0001\f1a\u001c4g\u0011\u0019\t)I\u0007a\u0001A\u0006\u0019A.\u001a8\u0002\rI,w\u000e]3o)\r)\u00181\u0012\u0005\u0006wn\u0001\r!U\u0001\nCZ\f\u0017\u000e\\1cY\u0016\f!#\u00192peR\u001cUO\u001d:f]R\u001cFO]3b[\u0006)1\r\\8tK\u0006Y\"+\u00198e_6\f5mY3tg\"#H\u000f]%oaV$8\u000b\u001e:fC6\u0004\"a\u001a\u0011\u0014\u0007\u0001\nI\nE\u0002S\u00037K1!!(T\u0005\u0019\te.\u001f*fMR\u0011\u0011QS\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\u0005\u0015&fA)\u0002(.\u0012\u0011\u0011\u0016\t\u0005\u0003W\u000b),\u0004\u0002\u0002.*!\u0011qVAY\u0003%)hn\u00195fG.,GMC\u0002\u00024N\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t9,!,\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class RandomAccessHttpInputStream
extends FSInputStream
implements Logging {
    private final HttpClient client;
    private final PreSignedUrlFetcher fetcher;
    private final long contentLength;
    private final FileSystem.Statistics stats;
    private final int numRetries;
    private final long maxRetryDuration;
    private boolean closed;
    private long pos;
    private InputStream currentStream;
    private String uri;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static long $lessinit$greater$default$6() {
        return RandomAccessHttpInputStream$.MODULE$.$lessinit$greater$default$6();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private boolean closed() {
        return this.closed;
    }

    private void closed_$eq(boolean x$1) {
        this.closed = x$1;
    }

    private long pos() {
        return this.pos;
    }

    private void pos_$eq(long x$1) {
        this.pos = x$1;
    }

    private InputStream currentStream() {
        return this.currentStream;
    }

    private void currentStream_$eq(InputStream x$1) {
        this.currentStream = x$1;
    }

    private String uri() {
        return this.uri;
    }

    private void uri_$eq(String x$1) {
        this.uri = x$1;
    }

    private void assertNotClosed() {
        if (this.closed()) {
            throw new IOException("Stream is closed!");
        }
        String newUrl = this.fetcher.getUrl();
        String string = this.uri();
        String string2 = newUrl;
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.uri_$eq(newUrl);
            this.abortCurrentStream();
            return;
        }
    }

    public synchronized void seek(long pos) {
        if (this.pos() != pos) {
            this.assertNotClosed();
            this.reopen(pos);
            return;
        }
    }

    public synchronized long getPos() {
        return this.pos();
    }

    public boolean seekToNewSource(long targetPos) {
        return false;
    }

    public synchronized int read() {
        int n;
        block2: {
            this.assertNotClosed();
            if (this.currentStream() == null) {
                this.reopen(this.pos());
            }
            if ((n = this.currentStream().read()) >= 0) {
                this.pos_$eq(this.pos() + 1L);
            }
            if (this.stats == null || n < 0) break block2;
            this.stats.incrementBytesRead(1L);
        }
        return n;
    }

    private HttpRequestBase createHttpRequest(long start) {
        HttpGet request = new HttpGet(this.uri());
        String rangeValue = new StringBuilder(7).append("bytes=").append(start).append("-").append(this.contentLength - 1L).toString();
        request.addHeader("Range", rangeValue);
        return request;
    }

    public synchronized int read(byte[] buf, int off, int len) {
        int byteRead;
        block2: {
            this.assertNotClosed();
            if (this.currentStream() == null) {
                this.reopen(this.pos());
            }
            if ((byteRead = this.currentStream().read(buf, off, len)) > 0) {
                this.pos_$eq(this.pos() + (long)byteRead);
            }
            if (this.stats == null || byteRead <= 0) break block2;
            this.stats.incrementBytesRead((long)byteRead);
        }
        return byteRead;
    }

    private void reopen(long pos) {
        if (this.currentStream() != null) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(35).append("Aborting old stream to open at pos ").append(pos).toString());
            this.abortCurrentStream();
        }
        if (pos < 0L) {
            throw new EOFException(new StringBuilder(33).append("Cannot seek to a negative offset ").append(pos).toString());
        }
        if (this.contentLength > 0L && pos > this.contentLength - 1L) {
            throw new EOFException(new StringBuilder(51).append("Attempted to seek or read past the end of the file ").append(pos).toString());
        }
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(21).append("Opening file ").append(this.uri()).append(" at pos ").append(pos).toString());
        HttpEntity entity = (HttpEntity)RetryUtils$.MODULE$.runWithExponentialBackoff(this.numRetries, this.maxRetryDuration, RetryUtils$.MODULE$.runWithExponentialBackoff$default$3(), (Function0 & Serializable)() -> {
            HttpRequestBase httpRequest = this.createHttpRequest(pos);
            HttpResponse response = $this.client.execute((HttpUriRequest)httpRequest);
            StatusLine status = response.getStatusLine();
            HttpEntity entity = response.getEntity();
            int statusCode = status.getStatusCode();
            if (statusCode != 206) {
                String string;
                if (entity == null) {
                    string = "";
                } else {
                    try (InputStream input = entity.getContent();){
                        string = IOUtils.toString((InputStream)input, (Charset)StandardCharsets.UTF_8);
                    }
                }
                String errorBody = string;
                throw new UnexpectedHttpStatus(new StringBuilder(76).append("HTTP request failed with status: ").append(status).append(" ").append(errorBody).append(",").append(" while accessing URI of shared table file").toString(), statusCode);
            }
            return entity;
        });
        this.currentStream_$eq(entity.getContent());
        this.pos_$eq(pos);
    }

    public synchronized int available() {
        this.assertNotClosed();
        return this.currentStream().available();
    }

    private void abortCurrentStream() {
        if (this.currentStream() != null) {
            InputStream inputStream = this.currentStream();
            if (inputStream instanceof EofSensorInputStream) {
                EofSensorInputStream eofSensorInputStream = (EofSensorInputStream)inputStream;
                eofSensorInputStream.abortConnection();
            } else {
                this.currentStream().close();
            }
            this.currentStream_$eq(null);
            return;
        }
    }

    public synchronized void close() {
        if (!this.closed()) {
            super.close();
            this.closed_$eq(true);
            if (this.currentStream() != null) {
                if (this.contentLength - this.pos() <= 4096L) {
                    this.currentStream().close();
                    this.currentStream_$eq(null);
                    return;
                }
                this.abortCurrentStream();
                return;
            }
            return;
        }
    }

    public RandomAccessHttpInputStream(HttpClient client, PreSignedUrlFetcher fetcher, long contentLength, FileSystem.Statistics stats, int numRetries, long maxRetryDuration) {
        this.client = client;
        this.fetcher = fetcher;
        this.contentLength = contentLength;
        this.stats = stats;
        this.numRetries = numRetries;
        this.maxRetryDuration = maxRetryDuration;
        Logging.$init$((Logging)this);
        this.closed = false;
        this.pos = 0L;
        this.currentStream = null;
        this.uri = null;
    }
}

