/*
 * Decompiled with CFR 0.152.
 */
package io.delta.sharing.spark;

import io.delta.sharing.spark.DeltaSharingErrors$;
import io.delta.sharing.spark.DeltaSharingOptionParser;
import io.delta.sharing.spark.DeltaSharingOptions$;
import io.delta.sharing.spark.DeltaStartingVersion;
import io.delta.sharing.spark.StartingVersion$;
import io.delta.sharing.spark.StartingVersionLatest$;
import java.io.Serializable;
import org.apache.spark.network.util.ByteUnit;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005-4q\u0001F\u000b\u0011\u0002\u0007\u0005a\u0004C\u0003*\u0001\u0011\u0005!\u0006C\u0004/\u0001\t\u0007I\u0011A\u0018\t\u000fY\u0002!\u0019!C\u0001o!9A\b\u0001b\u0001\n\u0003y\u0003bB\u001f\u0001\u0005\u0004%\tA\u0010\u0005\b\u0005\u0002\u0011\r\u0011\"\u0001?\u0011\u001d\u0019\u0005A1A\u0005\u0002yBq\u0001\u0012\u0001C\u0002\u0013\u0005a\bC\u0004F\u0001\t\u0007I\u0011\u0001$\t\u000f-\u0003!\u0019!C\u0001\u0019\"9\u0011\f\u0001b\u0001\n\u0003Q\u0006b\u00020\u0001\u0005\u0004%\ta\u000e\u0005\b?\u0002\u0011\r\u0011\"\u0001M\u0011\u001d\u0001\u0007A1A\u0005\u0002\u0005DQA\u0019\u0001\u0005\u0002yBQa\u0019\u0001\u0005\n\u0011DQa\u001a\u0001\u0005\n!DQ!\u001b\u0001\u0005\n)BQA\u001b\u0001\u0005\n)\u0012q\u0003R3mi\u0006\u001c\u0006.\u0019:j]\u001e\u0014V-\u00193PaRLwN\\:\u000b\u0005Y9\u0012!B:qCJ\\'B\u0001\r\u001a\u0003\u001d\u0019\b.\u0019:j]\u001eT!AG\u000e\u0002\u000b\u0011,G\u000e^1\u000b\u0003q\t!![8\u0004\u0001M\u0019\u0001aH\u0013\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\r\u0005s\u0017PU3g!\t1s%D\u0001\u0016\u0013\tASC\u0001\rEK2$\u0018m\u00155be&twm\u00149uS>t\u0007+\u0019:tKJ\fa\u0001J5oSR$C#A\u0016\u0011\u0005\u0001b\u0013BA\u0017\"\u0005\u0011)f.\u001b;\u0002%5\f\u0007PR5mKN\u0004VM\u001d+sS\u001e<WM]\u000b\u0002aA\u0019\u0001%M\u001a\n\u0005I\n#AB(qi&|g\u000e\u0005\u0002!i%\u0011Q'\t\u0002\u0004\u0013:$\u0018AE7bq\nKH/Z:QKJ$&/[4hKJ,\u0012\u0001\u000f\t\u0004AEJ\u0004C\u0001\u0011;\u0013\tY\u0014E\u0001\u0003M_:<\u0017!E7bqZ+'o]5p]N\u0004VM\u001d*qG\u0006i\u0011n\u001a8pe\u0016\u001c\u0005.\u00198hKN,\u0012a\u0010\t\u0003A\u0001K!!Q\u0011\u0003\u000f\t{w\u000e\\3b]\u0006i\u0011n\u001a8pe\u0016$U\r\\3uKN\f\u0011c]6ja\u000eC\u0017M\\4f\u0007>lW.\u001b;t\u00039\u0011X-\u00193DQ\u0006tw-\u001a$fK\u0012\fqb\u001d;beRLgn\u001a,feNLwN\\\u000b\u0002\u000fB\u0019\u0001%\r%\u0011\u0005\u0019J\u0015B\u0001&\u0016\u0005Q!U\r\u001c;b'R\f'\u000f^5oOZ+'o]5p]\u0006\t2\u000f^1si&tw\rV5nKN$\u0018-\u001c9\u0016\u00035\u00032\u0001I\u0019O!\tyeK\u0004\u0002Q)B\u0011\u0011+I\u0007\u0002%*\u00111+H\u0001\u0007yI|w\u000e\u001e \n\u0005U\u000b\u0013A\u0002)sK\u0012,g-\u0003\u0002X1\n11\u000b\u001e:j]\u001eT!!V\u0011\u0002\u0015\r$gm\u00149uS>t7/F\u0001\\!\u0011yEL\u0014(\n\u0005uC&aA'ba\u0006Ya/\u001a:tS>t\u0017i](g\u00035!\u0018.\\3ti\u0006l\u0007/Q:PM\u0006q!/Z:q_:\u001cXMR8s[\u0006$X#\u0001(\u0002\u0019%\u001cH+[7f)J\fg/\u001a7\u0002+\u001d,GOR8s[\u0006$H/\u001a3US6,7\u000f^1naR\u0011a*\u001a\u0005\u0006MB\u0001\rAT\u0001\u0004gR\u0014\u0018!\u00059sKB\f'/Z\"eM>\u0003H/[8ogR\t1,A\rwC2LG-\u0019;f\u001f:,7\u000b^1si&twm\u00149uS>t\u0017a\u0007<bY&$\u0017\r^3P]\u0016$\u0016.\\3Ue\u00064X\r\\(qi&|g\u000e")
public interface DeltaSharingReadOptions
extends DeltaSharingOptionParser {
    public void io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$maxFilesPerTrigger_$eq(Option<Object> var1);

    public void io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$maxBytesPerTrigger_$eq(Option<Object> var1);

    public void io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$maxVersionsPerRpc_$eq(Option<Object> var1);

    public void io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$ignoreChanges_$eq(boolean var1);

    public void io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$ignoreDeletes_$eq(boolean var1);

    public void io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$skipChangeCommits_$eq(boolean var1);

    public void io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$readChangeFeed_$eq(boolean var1);

    public void io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$startingVersion_$eq(Option<DeltaStartingVersion> var1);

    public void io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$startingTimestamp_$eq(Option<String> var1);

    public void io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$cdfOptions_$eq(Map<String, String> var1);

    public void io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$versionAsOf_$eq(Option<Object> var1);

    public void io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$timestampAsOf_$eq(Option<String> var1);

    public void io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$responseFormat_$eq(String var1);

    public Option<Object> maxFilesPerTrigger();

    public Option<Object> maxBytesPerTrigger();

    public Option<Object> maxVersionsPerRpc();

    public boolean ignoreChanges();

    public boolean ignoreDeletes();

    public boolean skipChangeCommits();

    public boolean readChangeFeed();

    public Option<DeltaStartingVersion> startingVersion();

    public Option<String> startingTimestamp();

    public Map<String, String> cdfOptions();

    public Option<Object> versionAsOf();

    public Option<String> timestampAsOf();

    public String responseFormat();

    public static /* synthetic */ boolean isTimeTravel$(DeltaSharingReadOptions $this) {
        return $this.isTimeTravel();
    }

    default public boolean isTimeTravel() {
        return this.versionAsOf().isDefined() || this.timestampAsOf().isDefined();
    }

    private String getFormattedTimestamp(String str) {
        Object castResult = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Cast qual$1 = new Cast((Expression)Literal$.MODULE$.apply((Object)str), (DataType)TimestampType$.MODULE$, Option$.MODULE$.apply((Object)SQLConf$.MODULE$.get().sessionLocalTimeZone()));
            InternalRow x$1 = qual$1.eval$default$1();
            return qual$1.eval(x$1);
        }).toOption().getOrElse((Function0 & Serializable)() -> {
            throw DeltaSharingErrors$.MODULE$.timestampInvalid(str);
        });
        return DateTimeUtils$.MODULE$.toJavaTimestamp(Predef$.MODULE$.Long2long((Long)castResult)).toInstant().toString();
    }

    private Map<String, String> prepareCdfOptions() {
        if (this.readChangeFeed()) {
            return (Map)((MapOps)DeltaSharingOptions$.MODULE$.validCdfOptions().filter((Function1 & Serializable)option -> BoxesRunTime.boxToBoolean((boolean)DeltaSharingReadOptions.$anonfun$prepareCdfOptions$1(this, option)))).map((Function1 & Serializable)option -> {
                block3: {
                    block2: {
                        Object object = option._1();
                        String string = DeltaSharingOptions$.MODULE$.CDF_START_TIMESTAMP();
                        if (!(object == null ? string != null : !object.equals(string))) break block2;
                        Object object2 = option._1();
                        String string2 = DeltaSharingOptions$.MODULE$.CDF_END_TIMESTAMP();
                        if (object2 != null ? !object2.equals(string2) : string2 != null) break block3;
                    }
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(option._1()), (Object)this.getFormattedTimestamp((String)this.options().get((String)option._1()).get()));
                }
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(option._1()), this.options().get((String)option._1()).get());
            });
        }
        return Predef$.MODULE$.Map().empty();
    }

    private void validateOneStartingOption() {
        if (this.startingTimestamp().isDefined() && this.startingVersion().isDefined()) {
            throw DeltaSharingErrors$.MODULE$.versionAndTimestampBothSetException(DeltaSharingOptions$.MODULE$.STARTING_VERSION_OPTION(), DeltaSharingOptions$.MODULE$.STARTING_TIMESTAMP_OPTION());
        }
    }

    private void validateOneTimeTravelOption() {
        if (this.versionAsOf().isDefined() && this.timestampAsOf().isDefined()) {
            throw DeltaSharingErrors$.MODULE$.versionAndTimestampBothSetException(DeltaSharingOptions$.MODULE$.TIME_TRAVEL_VERSION(), DeltaSharingOptions$.MODULE$.TIME_TRAVEL_TIMESTAMP());
        }
    }

    public static /* synthetic */ int $anonfun$maxFilesPerTrigger$1(String str) {
        return BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(str))).toOption().filter((Function1)(JFunction1.mcZI.sp & Serializable)x$1 -> x$1 > 0).getOrElse((Function0 & Serializable)() -> {
            throw DeltaSharingErrors$.MODULE$.illegalDeltaSharingOptionException(DeltaSharingOptions$.MODULE$.MAX_FILES_PER_TRIGGER_OPTION(), str, "must be a positive integer");
        }));
    }

    public static /* synthetic */ long $anonfun$maxBytesPerTrigger$1(String str) {
        return BoxesRunTime.unboxToLong((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable)() -> JavaUtils.byteStringAs((String)str, (ByteUnit)ByteUnit.BYTE)).toOption().filter((Function1)(JFunction1.mcZJ.sp & Serializable)x$2 -> x$2 > 0L).getOrElse((Function0 & Serializable)() -> {
            throw DeltaSharingErrors$.MODULE$.illegalDeltaSharingOptionException(DeltaSharingOptions$.MODULE$.MAX_BYTES_PER_TRIGGER_OPTION(), str, "must be a size configuration such as '10g'");
        }));
    }

    public static /* synthetic */ int $anonfun$maxVersionsPerRpc$1(String str) {
        return BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(str))).toOption().filter((Function1)(JFunction1.mcZI.sp & Serializable)x$3 -> x$3 > 0).getOrElse((Function0 & Serializable)() -> {
            throw DeltaSharingErrors$.MODULE$.illegalDeltaSharingOptionException(DeltaSharingOptions$.MODULE$.MAX_VERSIONS_PER_RPC(), str, "must be a positive integer");
        }));
    }

    public static /* synthetic */ long $anonfun$versionAsOf$1(String str) {
        return BoxesRunTime.unboxToLong((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable)() -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(str))).toOption().filter((Function1)(JFunction1.mcZJ.sp & Serializable)x$11 -> x$11 >= 0L).getOrElse((Function0 & Serializable)() -> {
            throw DeltaSharingErrors$.MODULE$.illegalDeltaSharingOptionException(DeltaSharingOptions$.MODULE$.TIME_TRAVEL_VERSION(), str, "must be an integer greater than or equal to zero");
        }));
    }

    public static /* synthetic */ boolean $anonfun$prepareCdfOptions$1(DeltaSharingReadOptions $this, Tuple2 option) {
        return $this.options().contains((String)option._1());
    }

    public static void $init$(DeltaSharingReadOptions $this) {
        $this.io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$maxFilesPerTrigger_$eq((Option<Object>)$this.options().get(DeltaSharingOptions$.MODULE$.MAX_FILES_PER_TRIGGER_OPTION()).map((Function1 & Serializable)str -> BoxesRunTime.boxToInteger((int)DeltaSharingReadOptions.$anonfun$maxFilesPerTrigger$1(str))));
        $this.io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$maxBytesPerTrigger_$eq((Option<Object>)$this.options().get(DeltaSharingOptions$.MODULE$.MAX_BYTES_PER_TRIGGER_OPTION()).map((Function1 & Serializable)str -> BoxesRunTime.boxToLong((long)DeltaSharingReadOptions.$anonfun$maxBytesPerTrigger$1(str))));
        $this.io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$maxVersionsPerRpc_$eq((Option<Object>)$this.options().get(DeltaSharingOptions$.MODULE$.MAX_VERSIONS_PER_RPC()).map((Function1 & Serializable)str -> BoxesRunTime.boxToInteger((int)DeltaSharingReadOptions.$anonfun$maxVersionsPerRpc$1(str))));
        $this.io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$ignoreChanges_$eq($this.options().get(DeltaSharingOptions$.MODULE$.IGNORE_CHANGES_OPTION()).exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)$this.toBoolean(x$4, DeltaSharingOptions$.MODULE$.IGNORE_CHANGES_OPTION()))));
        $this.io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$ignoreDeletes_$eq($this.options().get(DeltaSharingOptions$.MODULE$.IGNORE_DELETES_OPTION()).exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)$this.toBoolean(x$5, DeltaSharingOptions$.MODULE$.IGNORE_DELETES_OPTION()))));
        $this.io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$skipChangeCommits_$eq($this.options().get(DeltaSharingOptions$.MODULE$.SKIP_CHANGE_COMMITS_OPTION()).exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)$this.toBoolean(x$6, DeltaSharingOptions$.MODULE$.SKIP_CHANGE_COMMITS_OPTION()))));
        $this.io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$readChangeFeed_$eq($this.options().get(DeltaSharingOptions$.MODULE$.CDF_READ_OPTION()).exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)$this.toBoolean(x$7, DeltaSharingOptions$.MODULE$.CDF_READ_OPTION()))) || $this.options().get(DeltaSharingOptions$.MODULE$.CDF_READ_OPTION_LEGACY()).exists((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)$this.toBoolean(x$8, DeltaSharingOptions$.MODULE$.CDF_READ_OPTION_LEGACY()))));
        $this.io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$startingVersion_$eq((Option<DeltaStartingVersion>)$this.options().get(DeltaSharingOptions$.MODULE$.STARTING_VERSION_OPTION()).map((Function1 & Serializable)x0$1 -> {
            String string = x0$1;
            switch (string == null ? 0 : string.hashCode()) {
                case -1109880953: {
                    if (!"latest".equals(string)) break;
                    return StartingVersionLatest$.MODULE$;
                }
            }
            return (DeltaStartingVersion)Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable)() -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(string))).toOption().filter((Function1)(JFunction1.mcZJ.sp & Serializable)x$9 -> x$9 >= 0L).map((Function1)StartingVersion$.MODULE$).getOrElse((Function0 & Serializable)() -> {
                throw DeltaSharingErrors$.MODULE$.illegalDeltaSharingOptionException(DeltaSharingOptions$.MODULE$.STARTING_VERSION_OPTION(), string, "must be greater than or equal to zero");
            });
        }));
        $this.io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$startingTimestamp_$eq((Option<String>)$this.options().get(DeltaSharingOptions$.MODULE$.STARTING_TIMESTAMP_OPTION()).map((Function1 & Serializable)x$10 -> $this.getFormattedTimestamp((String)x$10)));
        $this.io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$cdfOptions_$eq($this.prepareCdfOptions());
        $this.io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$versionAsOf_$eq((Option<Object>)$this.options().get(DeltaSharingOptions$.MODULE$.TIME_TRAVEL_VERSION()).map((Function1 & Serializable)str -> BoxesRunTime.boxToLong((long)DeltaSharingReadOptions.$anonfun$versionAsOf$1(str))));
        $this.io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$timestampAsOf_$eq((Option<String>)$this.options().get(DeltaSharingOptions$.MODULE$.TIME_TRAVEL_TIMESTAMP()).map((Function1 & Serializable)x$12 -> $this.getFormattedTimestamp((String)x$12)));
        $this.io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$responseFormat_$eq((String)$this.options().get(DeltaSharingOptions$.MODULE$.RESPONSE_FORMAT()).map((Function1 & Serializable)str -> {
            String string = str;
            String string2 = DeltaSharingOptions$.MODULE$.RESPONSE_FORMAT_PARQUET();
            if (string == null ? string2 != null : !string.equals(string2)) {
                String string3 = str;
                String string4 = DeltaSharingOptions$.MODULE$.RESPONSE_FORMAT_DELTA();
                if (string3 == null ? string4 != null : !string3.equals(string4)) {
                    throw DeltaSharingErrors$.MODULE$.illegalDeltaSharingOptionException(DeltaSharingOptions$.MODULE$.RESPONSE_FORMAT(), (String)str, new StringBuilder(35).append("The user input must be one of:{").append(DeltaSharingOptions$.MODULE$.RESPONSE_FORMAT_PARQUET()).append(", ").append(DeltaSharingOptions$.MODULE$.RESPONSE_FORMAT_DELTA()).append("}.").toString());
                }
            }
            return str;
        }).getOrElse((Function0 & Serializable)() -> DeltaSharingOptions$.MODULE$.RESPONSE_FORMAT_PARQUET()));
        $this.validateOneStartingOption();
        $this.validateOneTimeTravelOption();
    }
}

