/*
 * Decompiled with CFR 0.152.
 */
package io.delta.sharing.spark;

import io.delta.sharing.client.util.JsonUtils$;
import io.delta.sharing.spark.DeltaSharingErrors$;
import io.delta.sharing.spark.DeltaSharingSourceOffset;
import java.io.Serializable;
import org.apache.spark.sql.connector.read.streaming.Offset;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple5;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class DeltaSharingSourceOffset$
implements Serializable {
    public static final DeltaSharingSourceOffset$ MODULE$ = new DeltaSharingSourceOffset$();
    private static final int VERSION_1 = 1;

    public int VERSION_1() {
        return VERSION_1;
    }

    public DeltaSharingSourceOffset apply(long sourceVersion, String tableId, long tableVersion, long index, boolean isStartingVersion) {
        return new DeltaSharingSourceOffset(sourceVersion, tableId, tableVersion, index, isStartingVersion);
    }

    public DeltaSharingSourceOffset apply(String tableId, Offset offset) {
        Offset offset2 = offset;
        if (offset2 instanceof DeltaSharingSourceOffset) {
            DeltaSharingSourceOffset deltaSharingSourceOffset = (DeltaSharingSourceOffset)offset2;
            return deltaSharingSourceOffset;
        }
        DeltaSharingSourceOffset o = (DeltaSharingSourceOffset)JsonUtils$.MODULE$.fromJson(offset2.json(), ManifestFactory$.MODULE$.classType(DeltaSharingSourceOffset.class));
        this.validateSourceVersion(o);
        String string = o.tableId();
        String string2 = tableId;
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw DeltaSharingErrors$.MODULE$.nonExistentDeltaSharingTable(o.tableId());
        }
        return o;
    }

    private void validateSourceVersion(DeltaSharingSourceOffset offset) {
        if (offset.sourceVersion() != (long)this.VERSION_1()) {
            throw DeltaSharingErrors$.MODULE$.unsupportedTableReaderVersion(this.VERSION_1(), offset.sourceVersion());
        }
    }

    public void validateOffsets(DeltaSharingSourceOffset previousOffset, DeltaSharingSourceOffset currentOffset) {
        if (!previousOffset.isStartingVersion() && currentOffset.isStartingVersion()) {
            throw new IllegalStateException(new StringBuilder(84).append("Found invalid offsets: 'isStartingVersion' fliped incorrectly. ").append("Previous: ").append(previousOffset).append(", Current: ").append(currentOffset).toString());
        }
        if (previousOffset.compare(currentOffset) > 0) {
            throw new IllegalStateException(new StringBuilder(44).append("Found invalid offsets. Previous: ").append(previousOffset).append(", Current: ").append(currentOffset).toString());
        }
    }

    public Option<Tuple5<Object, String, Object, Object, Object>> unapply(DeltaSharingSourceOffset x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple5((Object)BoxesRunTime.boxToLong((long)x$0.sourceVersion()), (Object)x$0.tableId(), (Object)BoxesRunTime.boxToLong((long)x$0.tableVersion()), (Object)BoxesRunTime.boxToLong((long)x$0.index()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.isStartingVersion())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DeltaSharingSourceOffset$.class);
    }

    private DeltaSharingSourceOffset$() {
    }
}

