/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.delta.sharing;

import io.delta.sharing.client.DeltaSharingProfileProvider;
import io.delta.sharing.client.util.ConfUtils$;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.spark.delta.sharing.BaseCachedTable;
import org.apache.spark.delta.sharing.CachedTable;
import org.apache.spark.delta.sharing.CachedTableManager$;
import org.apache.spark.delta.sharing.QuerySpecificCachedTable;
import org.apache.spark.delta.sharing.TableRefreshResult;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005=h\u0001B\u0011#\u00015B\u0001B\u000f\u0001\u0003\u0006\u0004%\ta\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005y!A\u0001\t\u0001B\u0001B\u0003%A\b\u0003\u0005B\u0001\t\u0015\r\u0011\"\u0001<\u0011!\u0011\u0005A!A!\u0002\u0013a\u0004\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001f\t\u000b\u0011\u0003A\u0011A#\t\u000f1\u0003!\u0019!C\u0005\u001b\"1a\r\u0001Q\u0001\n9Cqa\u001a\u0001C\u0002\u0013%\u0001\u000e\u0003\u0004m\u0001\u0001\u0006I!\u001b\u0005\u0006[\u0002!\tA\u001c\u0005\u0006e\u0002!\ta\u001d\u0005\u0006m\u0002!\ta\u001e\u0005\b\u0003\u0003\u0001A\u0011AA\u0002\u0011\u001d\tY\u0001\u0001C\u0005\u0003\u001bAq!!\b\u0001\t\u0013\ty\u0002C\u0004\u0002.\u0001!I!a\f\t\u000f\u0005M\u0002\u0001\"\u0001\u00026!9\u00111\u000b\u0001\u0005\n\u0005U\u0003bBA[\u0001\u0011\u0005\u0011q\u0017\u0005\n\u0003\u000f\u0004\u0011\u0013!C\u0001\u0003\u0013Dq!a8\u0001\t\u0003\t\u0019\u0001C\u0004\u0002b\u0002!\t!a\u0001\b\u000f\u0005\r(\u0005#\u0001\u0002f\u001a1\u0011E\tE\u0001\u0003ODa\u0001\u0012\u000e\u0005\u0002\u0005%\b\u0002\u0003\u001e\u001b\u0011\u000b\u0007I\u0011B\u001e\t\u0011\u0001S\u0002R1A\u0005\nmB\u0001\"\u0011\u000e\t\u0006\u0004%Ia\u000f\u0005\t\u0007jA)\u0019!C\u0005w!Q\u00111\u001e\u000e\t\u0006\u0004%\t!!<\u0003%\r\u000b7\r[3e)\u0006\u0014G.Z'b]\u0006<WM\u001d\u0006\u0003G\u0011\nqa\u001d5be&twM\u0003\u0002&M\u0005)A-\u001a7uC*\u0011q\u0005K\u0001\u0006gB\f'o\u001b\u0006\u0003S)\na!\u00199bG\",'\"A\u0016\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001qC\u0007\u0005\u00020e5\t\u0001GC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004G\u0001\u0004B]f\u0014VM\u001a\t\u0003kaj\u0011A\u000e\u0006\u0003o\u0019\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003sY\u0012q\u0001T8hO&tw-\u0001\rqe\u0016\u001c\u0016n\u001a8fIV\u0013H.\u0012=qSJ\fG/[8o\u001bN,\u0012\u0001\u0010\t\u0003_uJ!A\u0010\u0019\u0003\t1{gnZ\u0001\u001aaJ,7+[4oK\u0012,&\u000f\\#ya&\u0014\u0018\r^5p]6\u001b\b%\u0001\fsK\u001a\u0014Xm\u001d5DQ\u0016\u001c7.\u00138uKJ4\u0018\r\\'t\u0003I\u0011XM\u001a:fg\"$\u0006N]3tQ>dG-T:\u0002'I,gM]3tQRC'/Z:i_2$Wj\u001d\u0011\u0002'\u0015D\b/\u001b:f\u0003\u001a$XM]!dG\u0016\u001c8/T:\u0002\rqJg.\u001b;?)\u00151\u0005*\u0013&L!\t9\u0005!D\u0001#\u0011\u0015Qt\u00011\u0001=\u0011\u0015\u0001u\u00011\u0001=\u0011\u0015\tu\u00011\u0001=\u0011\u0015\u0019u\u00011\u0001=\u0003\u0015\u0019\u0017m\u00195f+\u0005q\u0005\u0003B(W1\u000el\u0011\u0001\u0015\u0006\u0003#J\u000b!bY8oGV\u0014(/\u001a8u\u0015\t\u0019F+\u0001\u0003vi&d'\"A+\u0002\t)\fg/Y\u0005\u0003/B\u0013\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\tI\u0006M\u0004\u0002[=B\u00111\fM\u0007\u00029*\u0011Q\fL\u0001\u0007yI|w\u000e\u001e \n\u0005}\u0003\u0014A\u0002)sK\u0012,g-\u0003\u0002bE\n11\u000b\u001e:j]\u001eT!a\u0018\u0019\u0011\u0005\u001d#\u0017BA3#\u0005=\u0011\u0015m]3DC\u000eDW\r\u001a+bE2,\u0017AB2bG\",\u0007%A\u0007sK\u001a\u0014Xm\u001d5UQJ,\u0017\rZ\u000b\u0002SB\u0011qJ[\u0005\u0003WB\u0013\u0001dU2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u00039\u0011XM\u001a:fg\"$\u0006N]3bI\u0002\nAa]5{KR\tq\u000e\u0005\u00020a&\u0011\u0011\u000f\r\u0002\u0004\u0013:$\u0018!E4fiF+XM]=Ti\u0006$XmU5{KR\u0011q\u000e\u001e\u0005\u0006k6\u0001\r\u0001W\u0001\ni\u0006\u0014G.\u001a)bi\"\f\u0001$[:WC2LG-\u0016:m\u000bb\u0004\u0018N]1uS>tG+[7f)\tA8\u0010\u0005\u00020s&\u0011!\u0010\r\u0002\b\u0005>|G.Z1o\u0011\u0015ah\u00021\u0001~\u0003))\u0007\u0010]5sCRLwN\u001c\t\u0004_yd\u0014BA@1\u0005\u0019y\u0005\u000f^5p]\u00069!/\u001a4sKNDGCAA\u0003!\ry\u0013qA\u0005\u0004\u0003\u0013\u0001$\u0001B+oSR\f\u0011\u0004\\8h\t&4g-\u001a:f]\u000e,7OQ3uo\u0016,g.\u0016:mgR1\u0011QAA\b\u00033Aq!!\u0005\u0011\u0001\u0004\t\u0019\"A\u0007sK\u001a\u0014Xm\u001d5fIV\u0013Hn\u001d\t\u00063\u0006U\u0001\fW\u0005\u0004\u0003/\u0011'aA'ba\"9\u00111\u0004\tA\u0002\u0005M\u0011AC2bG\",G-\u0016:mg\u0006A\u0002.\u00198eY\u0016\u001c\u0015m\u00195fIR\u000b'\r\\3SK\u001a\u0014Xm\u001d5\u0015\r\u0005\u0015\u0011\u0011EA\u0012\u0011\u0015)\u0018\u00031\u0001Y\u0011\u001d\t)#\u0005a\u0001\u0003O\t1bY1dQ\u0016$G+\u00192mKB\u0019q)!\u000b\n\u0007\u0005-\"EA\u0006DC\u000eDW\r\u001a+bE2,\u0017!\n5b]\u0012dW-U;fef\u001c\u0006/Z2jM&\u001c7)Y2iK\u0012$\u0016M\u00197f%\u00164'/Z:i)\u0011\t)!!\r\t\u000bU\u0014\u0002\u0019\u0001-\u0002\u001f\u001d,G\u000f\u0015:f'&<g.\u001a3Ve2$b!a\u000e\u0002N\u0005=\u0003\u0003BA\u001d\u0003\u000frA!a\u000f\u0002B9\u0019q)!\u0010\n\u0007\u0005}\"%A\tQe\u0016\u001c\u0016n\u001a8fIV\u0013HnQ1dQ\u0016LA!a\u0011\u0002F\u0005\u0019!\u000b]2\u000b\u0007\u0005}\"%\u0003\u0003\u0002J\u0005-#aF$fiB\u0013XmU5h]\u0016$WK\u001d7SKN\u0004xN\\:f\u0015\u0011\t\u0019%!\u0012\t\u000bU\u001c\u0002\u0019\u0001-\t\r\u0005E3\u00031\u0001Y\u0003\u00191\u0017\u000e\\3JI\u0006\u0001#/Z4jgR,'/U;fef\u001c\u0006/Z2jM&\u001c7)Y2iK\u0012$\u0016M\u00197f)A\t)!a\u0016\u0002Z\u0005u\u00131QAK\u00033\u000bi\nC\u0003v)\u0001\u0007\u0001\fC\u0004\u0002\\Q\u0001\r!a\u0005\u0002\u000f%$Gk\\+sY\"9\u0011q\f\u000bA\u0002\u0005\u0005\u0014\u0001\u0002:fMN\u0004b!a\u0019\u0002n\u0005Md\u0002BA3\u0003Sr1aWA4\u0013\u0005\t\u0014bAA6a\u00059\u0001/Y2lC\u001e,\u0017\u0002BA8\u0003c\u00121aU3r\u0015\r\tY\u0007\r\t\u0006\u0003k\nyHL\u0007\u0003\u0003oRA!!\u001f\u0002|\u0005\u0019!/\u001a4\u000b\u0007\u0005uD+\u0001\u0003mC:<\u0017\u0002BAA\u0003o\u0012QbV3bWJ+g-\u001a:f]\u000e,\u0007bBAC)\u0001\u0007\u0011qQ\u0001\ne\u00164'/Z:iKJ\u0004raLAE\u0003\u001b\u000by)C\u0002\u0002\fB\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0007=r\b\fE\u0002H\u0003#K1!a%#\u0005I!\u0016M\u00197f%\u00164'/Z:i%\u0016\u001cX\u000f\u001c;\t\r\u0005]E\u00031\u0001=\u0003M)\u0007\u0010]5sCRLwN\u001c+j[\u0016\u001cH/Y7q\u0011\u001d\tY\n\u0006a\u0001\u0003\u001b\u000bAB]3ge\u0016\u001c\b\u000eV8lK:Dq!a(\u0015\u0001\u0004\t\t+A\bqe>4\u0017\u000e\\3Qe>4\u0018\u000eZ3s!\u0011\t\u0019+!-\u000e\u0005\u0005\u0015&\u0002BAT\u0003S\u000baa\u00197jK:$(bA\u0012\u0002,*\u0019Q%!,\u000b\u0005\u0005=\u0016AA5p\u0013\u0011\t\u0019,!*\u00037\u0011+G\u000e^1TQ\u0006\u0014\u0018N\\4Qe>4\u0017\u000e\\3Qe>4\u0018\u000eZ3s\u0003!\u0011XmZ5ti\u0016\u0014H\u0003EA\u0003\u0003s\u000bY,!0\u0002@\u0006\u0005\u00171YAc\u0011\u0015)X\u00031\u0001Y\u0011\u001d\tY&\u0006a\u0001\u0003'Aq!a\u0018\u0016\u0001\u0004\t\t\u0007C\u0004\u0002 V\u0001\r!!)\t\u000f\u0005\u0015U\u00031\u0001\u0002\b\"A\u0011qS\u000b\u0011\u0002\u0003\u0007A\bC\u0004\u0002\u001cV\u0001\r!!$\u0002%I,w-[:uKJ$C-\u001a4bk2$HEN\u000b\u0003\u0003\u0017T3\u0001PAgW\t\ty\r\u0005\u0003\u0002R\u0006mWBAAj\u0015\u0011\t).a6\u0002\u0013Ut7\r[3dW\u0016$'bAAma\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005u\u00171\u001b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001B:u_B\fQa\u00197fCJ\f!cQ1dQ\u0016$G+\u00192mK6\u000bg.Y4feB\u0011qIG\n\u000359\"\"!!:\u0002\u0011%s5\u000bV!O\u0007\u0016+\u0012A\u0012")
public class CachedTableManager
implements Logging {
    private final long preSignedUrlExpirationMs;
    private final long refreshThresholdMs;
    private final long expireAfterAccessMs;
    private final ConcurrentHashMap<String, BaseCachedTable> cache;
    private final ScheduledExecutorService refreshThread;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static CachedTableManager INSTANCE() {
        return CachedTableManager$.MODULE$.INSTANCE();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public long preSignedUrlExpirationMs() {
        return this.preSignedUrlExpirationMs;
    }

    public long refreshThresholdMs() {
        return this.refreshThresholdMs;
    }

    private ConcurrentHashMap<String, BaseCachedTable> cache() {
        return this.cache;
    }

    private ScheduledExecutorService refreshThread() {
        return this.refreshThread;
    }

    public int size() {
        return this.cache().size();
    }

    public int getQueryStateSize(String tablePath) {
        BaseCachedTable cachedTable = this.cache().get(tablePath);
        if (cachedTable == null) {
            throw new IllegalStateException(new StringBuilder(18).append("table ").append(tablePath).append(" was removed").toString());
        }
        BaseCachedTable baseCachedTable = cachedTable;
        if (baseCachedTable instanceof QuerySpecificCachedTable) {
            QuerySpecificCachedTable querySpecificCachedTable = (QuerySpecificCachedTable)baseCachedTable;
            return querySpecificCachedTable.queryStates().size();
        }
        return 0;
    }

    public boolean isValidUrlExpirationTime(Option<Object> expiration) {
        boolean isValid;
        block0: {
            boolean bl = isValid = expiration.isDefined() && BoxesRunTime.unboxToLong((Object)expiration.get()) > System.currentTimeMillis() + this.refreshThresholdMs();
            if (isValid || !expiration.isDefined()) break block0;
            long currentTs = System.currentTimeMillis();
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(81).append("Invalid url expiration timestamp(").append(expiration).append(", ").append(new Date(BoxesRunTime.unboxToLong((Object)expiration.get()))).append("), refreshThresholdMs:").append(this.refreshThresholdMs()).append(", ").append("current timestamp(").append(currentTs).append(", ").append(new Date(currentTs)).append(").").toString());
        }
        return isValid;
    }

    public void refresh() {
        Map.Entry[] snapshot = (Map.Entry[])((IterableOnceOps)JavaConverters$.MODULE$.asScalaSetConverter(this.cache().entrySet()).asScala()).toArray(ClassTag$.MODULE$.apply(Map.Entry.class));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])snapshot), (Function1 & Serializable)entry -> {
            String tablePath = (String)entry.getKey();
            BaseCachedTable cachedTable = (BaseCachedTable)entry.getValue();
            if (cachedTable.lastAccess() + $this.expireAfterAccessMs < System.currentTimeMillis()) {
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(78).append("Removing table ").append(tablePath).append(" from the pre signed url cache as it was not accessed ").append("after ").append($this.expireAfterAccessMs).append(" ms").toString());
                return BoxesRunTime.boxToBoolean((boolean)this.cache().remove(tablePath, cachedTable));
            }
            BaseCachedTable baseCachedTable = cachedTable;
            if (baseCachedTable instanceof CachedTable) {
                CachedTable cachedTable2 = (CachedTable)baseCachedTable;
                this.handleCachedTableRefresh(tablePath, cachedTable2);
            } else if (baseCachedTable instanceof QuerySpecificCachedTable) {
                this.handleQuerySpecificCachedTableRefresh(tablePath);
            } else {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Unknown table type for ").append(tablePath).append(", type ").append(cachedTable.getClass()).append(".").toString());
            }
            return BoxedUnit.UNIT;
        });
    }

    private void logDifferencesBetweenUrls(scala.collection.immutable.Map<String, String> refreshedUrls, scala.collection.immutable.Map<String, String> cachedUrls) {
        if (refreshedUrls.size() != cachedUrls.size()) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("freshen urls size ").append(refreshedUrls.size()).append(" is not equal to ").append("cached urls size ").append(cachedUrls.size()).toString());
        }
        scala.collection.immutable.Set onlyInRefresh = (scala.collection.immutable.Set)refreshedUrls.keySet().diff((Set)cachedUrls.keySet());
        scala.collection.immutable.Set onlyInCached = (scala.collection.immutable.Set)cachedUrls.keySet().diff((Set)refreshedUrls.keySet());
        if (onlyInRefresh.nonEmpty() || onlyInCached.nonEmpty()) {
            if (onlyInRefresh.nonEmpty()) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Keys only in refreshRes.idToUrl: ").append(onlyInRefresh.mkString(", ")).toString());
            }
            if (onlyInCached.nonEmpty()) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("Keys only in cachedTable.idToUrl: ").append(onlyInCached.mkString(", ")).toString());
                return;
            }
            return;
        }
    }

    private void handleCachedTableRefresh(String tablePath, CachedTable cachedTable) {
        if (cachedTable.refs().forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CachedTableManager.$anonfun$handleCachedTableRefresh$1(x$1)))) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(86).append("Removing table ").append(tablePath).append(" from the pre signed url cache as there are").append(" no references pointed to it").toString());
            this.cache().remove(tablePath, cachedTable);
            return;
        }
        if (cachedTable.expiration() - System.currentTimeMillis() < this.refreshThresholdMs()) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Updating pre signed urls for ").append(tablePath).append(" (expiration time: ").append(new Date(cachedTable.expiration())).append("), token:").append(cachedTable.refreshToken()).toString());
            try {
                TableRefreshResult refreshRes = (TableRefreshResult)cachedTable.refresher().apply(cachedTable.refreshToken());
                this.logDifferencesBetweenUrls(refreshRes.idToUrl(), cachedTable.idToUrl());
                long x$12 = this.isValidUrlExpirationTime(refreshRes.expirationTimestamp()) ? BoxesRunTime.unboxToLong((Object)refreshRes.expirationTimestamp().get()) : this.preSignedUrlExpirationMs() + System.currentTimeMillis();
                scala.collection.immutable.Map<String, String> x$2 = refreshRes.idToUrl();
                Seq<WeakReference<Object>> x$3 = cachedTable.refs();
                long x$4 = cachedTable.lastAccess();
                Function1<Option<String>, TableRefreshResult> x$5 = cachedTable.refresher();
                Option<String> x$6 = refreshRes.refreshToken();
                CachedTable newTable = new CachedTable(x$12, x$2, x$4, x$6, x$5, x$3);
                this.cache().replace(tablePath, cachedTable, newTable);
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(39).append("Updated pre signed urls for ").append(tablePath).append(" with size ").append(refreshRes.idToUrl().size()).toString());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (NonFatal$.MODULE$.apply(throwable2)) {
                    this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Failed to refresh pre signed urls for table ").append(tablePath).toString(), throwable2);
                    if (cachedTable.expiration() < System.currentTimeMillis()) {
                        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(61).append("Removing table ").append(tablePath).append(" form cache as the pre signed url have expired").toString());
                        this.cache().remove(tablePath, cachedTable);
                    }
                }
                throw throwable;
            }
            return;
        }
    }

    private void handleQuerySpecificCachedTableRefresh(String tablePath) {
        this.cache().computeIfPresent(tablePath, (x$2, cachedTable) -> {
            BaseCachedTable baseCachedTable = cachedTable;
            if (baseCachedTable instanceof QuerySpecificCachedTable) {
                QuerySpecificCachedTable querySpecificCachedTable = (QuerySpecificCachedTable)baseCachedTable;
                scala.collection.immutable.Map validStates = (scala.collection.immutable.Map)querySpecificCachedTable.queryStates().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CachedTableManager.$anonfun$handleQuerySpecificCachedTableRefresh$2(x0$1)));
                if (validStates.isEmpty()) {
                    this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Removing table ").append(tablePath).append(" as no valid query mappings remain.").toString());
                    return null;
                }
                if (querySpecificCachedTable.expiration() - System.currentTimeMillis() < this.refreshThresholdMs()) {
                    QuerySpecificCachedTable querySpecificCachedTable2;
                    try {
                        Tuple2 tuple2;
                        Tuple2 tuple22 = (Tuple2)validStates.head();
                        if (tuple22 == null || (tuple2 = (Tuple2)tuple22._2()) == null) {
                            throw new MatchError((Object)tuple22);
                        }
                        Function2 refresherWrapper = (Function2)tuple2._2();
                        Function2 refresherWrapper2 = refresherWrapper;
                        TableRefreshResult refreshRes = (TableRefreshResult)refresherWrapper2.apply(querySpecificCachedTable.refreshToken(), querySpecificCachedTable.refresher());
                        this.logDifferencesBetweenUrls(refreshRes.idToUrl(), querySpecificCachedTable.idToUrl());
                        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append("Updated pre-signed URLs for ").append(tablePath).append(" with size ").append(refreshRes.idToUrl().size()).append(", ").append("validStates: ").append(validStates.size()).append(".").toString());
                        querySpecificCachedTable2 = new QuerySpecificCachedTable(this.isValidUrlExpirationTime(refreshRes.expirationTimestamp()) ? BoxesRunTime.unboxToLong((Object)refreshRes.expirationTimestamp().get()) : this.preSignedUrlExpirationMs() + System.currentTimeMillis(), refreshRes.idToUrl(), querySpecificCachedTable.lastAccess(), refreshRes.refreshToken(), querySpecificCachedTable.refresher(), (scala.collection.immutable.Map<String, Tuple2<Seq<WeakReference<Object>>, Function2<Option<String>, Function1<Option<String>, TableRefreshResult>, TableRefreshResult>>>)validStates);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (NonFatal$.MODULE$.apply(throwable2)) {
                            this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Failed to refresh pre-signed URLs for table ").append(tablePath).toString(), throwable2);
                            if (querySpecificCachedTable.expiration() < System.currentTimeMillis()) {
                                this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Removing table ").append(tablePath).append(" as the pre-signed URL has expired.").toString());
                                querySpecificCachedTable2 = null;
                            } else {
                                querySpecificCachedTable2 = new QuerySpecificCachedTable(querySpecificCachedTable.expiration(), querySpecificCachedTable.idToUrl(), querySpecificCachedTable.lastAccess(), querySpecificCachedTable.refreshToken(), querySpecificCachedTable.refresher(), (scala.collection.immutable.Map<String, Tuple2<Seq<WeakReference<Object>>, Function2<Option<String>, Function1<Option<String>, TableRefreshResult>, TableRefreshResult>>>)validStates);
                            }
                        }
                        throw throwable;
                    }
                    return querySpecificCachedTable2;
                }
                return new QuerySpecificCachedTable(querySpecificCachedTable.expiration(), querySpecificCachedTable.idToUrl(), querySpecificCachedTable.lastAccess(), querySpecificCachedTable.refreshToken(), querySpecificCachedTable.refresher(), (scala.collection.immutable.Map<String, Tuple2<Seq<WeakReference<Object>>, Function2<Option<String>, Function1<Option<String>, TableRefreshResult>, TableRefreshResult>>>)validStates);
            }
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Unexpected table type for ").append(tablePath).append(". Expected QuerySpecificCachedTable.").toString());
            return cachedTable;
        });
    }

    public Tuple2<String, Object> getPreSignedUrl(String tablePath, String fileId) {
        BaseCachedTable cachedTable = this.cache().get(tablePath);
        if (cachedTable == null) {
            throw new IllegalStateException(new StringBuilder(18).append("table ").append(tablePath).append(" was removed").toString());
        }
        cachedTable.lastAccess_$eq(System.currentTimeMillis());
        String url = (String)cachedTable.idToUrl().getOrElse((Object)fileId, (Function0 & Serializable)() -> {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append(cachedTable.idToUrl().size()).append(" urls in cache ").append("with expiration ").append(new Date(cachedTable.expiration())).toString());
            throw new IllegalStateException(new StringBuilder(33).append("cannot find url for id ").append(fileId).append(" in table ").append(tablePath).toString());
        });
        return new Tuple2((Object)url, (Object)BoxesRunTime.boxToLong((long)cachedTable.expiration()));
    }

    private void registerQuerySpecificCachedTable(String tablePath, scala.collection.immutable.Map<String, String> idToUrl, Seq<WeakReference<Object>> refs, Function1<Option<String>, TableRefreshResult> refresher, long expirationTimestamp, Option<String> refreshToken, DeltaSharingProfileProvider profileProvider) {
        Tuple3 tuple3;
        TableRefreshResult refreshRes;
        String queryId = (String)profileProvider.getCustomQueryId().getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException("Query ID is not defined.");
        });
        Function2 refresherWrapper = (Function2)profileProvider.getCustomRefresherWrapper().getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException("refresherWrapper is not defined.");
        });
        if (refs.size() != 1) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(63).append("Multiple references sharing the same QuerySpecificCachedTable: ").append(refs.size()).toString());
        }
        Tuple3 tuple32 = expirationTimestamp - System.currentTimeMillis() < this.refreshThresholdMs() ? (this.isValidUrlExpirationTime((refreshRes = (TableRefreshResult)refresherWrapper.apply(refreshToken, refresher)).expirationTimestamp()) ? new Tuple3(refreshRes.idToUrl(), refreshRes.expirationTimestamp().get(), refreshRes.refreshToken()) : new Tuple3(refreshRes.idToUrl(), (Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() + this.preSignedUrlExpirationMs())), refreshRes.refreshToken())) : (tuple3 = new Tuple3(idToUrl, (Object)BoxesRunTime.boxToLong((long)expirationTimestamp), refreshToken));
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        scala.collection.immutable.Map resolvedIdToUrl = (scala.collection.immutable.Map)tuple3._1();
        long resolvedExpiration = BoxesRunTime.unboxToLong((Object)tuple3._2());
        Option resolvedRefreshToken = (Option)tuple3._3();
        Tuple3 tuple33 = new Tuple3((Object)resolvedIdToUrl, (Object)BoxesRunTime.boxToLong((long)resolvedExpiration), (Object)resolvedRefreshToken);
        scala.collection.immutable.Map resolvedIdToUrl2 = (scala.collection.immutable.Map)tuple33._1();
        long resolvedExpiration2 = BoxesRunTime.unboxToLong((Object)tuple33._2());
        Option resolvedRefreshToken2 = (Option)tuple33._3();
        this.cache().compute(tablePath, (x$5, existingTable) -> {
            if (existingTable == null) {
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(72).append("Registered a new QuerySpecificCachedTable in cache for table ").append(tablePath).append(", ").append("queryId ").append(queryId).append(".").toString());
                return new QuerySpecificCachedTable(resolvedExpiration2, (scala.collection.immutable.Map<String, String>)resolvedIdToUrl2, System.currentTimeMillis(), (Option<String>)resolvedRefreshToken2, refresher, (scala.collection.immutable.Map<String, Tuple2<Seq<WeakReference<Object>>, Function2<Option<String>, Function1<Option<String>, TableRefreshResult>, TableRefreshResult>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)queryId), (Object)new Tuple2((Object)refs, (Object)refresherWrapper))}))));
            }
            BaseCachedTable baseCachedTable = existingTable;
            if (!(baseCachedTable instanceof QuerySpecificCachedTable)) {
                throw new IllegalStateException(new StringBuilder(88).append("Cache entry type mismatch: existing type is ").append(existingTable.getClass()).append(", ").append("expected type is QuerySpecificCachedTable.").toString());
            }
            QuerySpecificCachedTable querySpecificCachedTable = (QuerySpecificCachedTable)baseCachedTable;
            QuerySpecificCachedTable querySpecificCachedTable2 = querySpecificCachedTable;
            scala.collection.immutable.Map newQueryStates = (scala.collection.immutable.Map)querySpecificCachedTable2.queryStates().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)queryId), (Object)new Tuple2((Object)refs, (Object)refresherWrapper)));
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(104).append("Registered to an existing QuerySpecificCachedTable in cache for table ").append(tablePath).append(", ").append("queryId ").append(queryId).append(", newQueryStates size: ").append(newQueryStates.size()).append(".").toString());
            return new QuerySpecificCachedTable(resolvedExpiration2, (scala.collection.immutable.Map<String, String>)resolvedIdToUrl2, System.currentTimeMillis(), (Option<String>)resolvedRefreshToken2, refresher, (scala.collection.immutable.Map<String, Tuple2<Seq<WeakReference<Object>>, Function2<Option<String>, Function1<Option<String>, TableRefreshResult>, TableRefreshResult>>>)newQueryStates);
        });
    }

    public void register(String tablePath, scala.collection.immutable.Map<String, String> idToUrl, Seq<WeakReference<Object>> refs, DeltaSharingProfileProvider profileProvider, Function1<Option<String>, TableRefreshResult> refresher, long expirationTimestamp, Option<String> refreshToken) {
        Tuple3 tuple3;
        Tuple3 tuple32;
        boolean parquetIOCacheEnabled;
        boolean bl;
        String customTablePath = profileProvider.getCustomTablePath(tablePath);
        try {
            bl = ConfUtils$.MODULE$.sparkParquetIOCacheEnabled(SparkSession$.MODULE$.active().sessionState().conf());
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Failed to get sparkParquetIOCacheEnabled, using default value.");
            bl = parquetIOCacheEnabled = false;
        }
        if (parquetIOCacheEnabled && profileProvider.getCustomQueryId().isDefined()) {
            this.registerQuerySpecificCachedTable(customTablePath, idToUrl, refs, refresher, expirationTimestamp, refreshToken, profileProvider);
            return;
        }
        Function1<Option<String>, TableRefreshResult> customRefresher = profileProvider.getCustomRefresher(refresher);
        if (expirationTimestamp - System.currentTimeMillis() < this.refreshThresholdMs()) {
            TableRefreshResult refreshRes = (TableRefreshResult)customRefresher.apply(refreshToken);
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(82).append("Refreshed urls during cache register with old expiration ").append(new Date(expirationTimestamp)).append(", new expiration ").append(refreshRes.expirationTimestamp().map((Function1 & Serializable)x$6 -> CachedTableManager.$anonfun$register$3(BoxesRunTime.unboxToLong((Object)x$6))).getOrElse((Function0 & Serializable)() -> "None")).append(", ").append("lines ").append(refreshRes.idToUrl().size()).toString());
            tuple32 = this.isValidUrlExpirationTime(refreshRes.expirationTimestamp()) ? new Tuple3(refreshRes.idToUrl(), refreshRes.expirationTimestamp().get(), refreshRes.refreshToken()) : new Tuple3(refreshRes.idToUrl(), (Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() + this.preSignedUrlExpirationMs())), refreshRes.refreshToken());
        } else {
            tuple32 = tuple3 = new Tuple3(idToUrl, (Object)BoxesRunTime.boxToLong((long)expirationTimestamp), refreshToken);
        }
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        scala.collection.immutable.Map resolvedIdToUrl = (scala.collection.immutable.Map)tuple3._1();
        long resolvedExpiration = BoxesRunTime.unboxToLong((Object)tuple3._2());
        Option resolvedRefreshToken = (Option)tuple3._3();
        Tuple3 tuple33 = new Tuple3((Object)resolvedIdToUrl, (Object)BoxesRunTime.boxToLong((long)resolvedExpiration), (Object)resolvedRefreshToken);
        scala.collection.immutable.Map resolvedIdToUrl2 = (scala.collection.immutable.Map)tuple33._1();
        long resolvedExpiration2 = BoxesRunTime.unboxToLong((Object)tuple33._2());
        Option resolvedRefreshToken2 = (Option)tuple33._3();
        long x$1 = resolvedExpiration2;
        scala.collection.immutable.Map x$2 = resolvedIdToUrl2;
        Seq<WeakReference<Object>> x$3 = refs;
        long x$4 = System.currentTimeMillis();
        Function1<Option<String>, TableRefreshResult> x$5 = customRefresher;
        Option x$6 = resolvedRefreshToken2;
        CachedTable cachedTable = new CachedTable(x$1, (scala.collection.immutable.Map<String, String>)x$2, x$4, (Option<String>)x$6, x$5, x$3);
        BaseCachedTable oldTable = this.cache().putIfAbsent(customTablePath, cachedTable);
        if (oldTable == null) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(43).append("Registered a new entry in cache for table ").append(customTablePath).append(".").toString());
            return;
        }
        BaseCachedTable baseCachedTable = oldTable;
        if (!(baseCachedTable instanceof CachedTable)) {
            throw new IllegalStateException(new StringBuilder(75).append("Cache entry type mismatch: existing type is ").append(oldTable.getClass()).append(", ").append("expected type is CachedTable.").toString());
        }
        CachedTable cachedTable2 = (CachedTable)baseCachedTable;
        CachedTable oldCachedTable = cachedTable2;
        do {
            long x$7 = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(cachedTable.expiration()), oldTable.expiration());
            scala.collection.immutable.Map x$8 = (scala.collection.immutable.Map)oldTable.idToUrl().$plus$plus(cachedTable.idToUrl());
            Seq x$9 = (Seq)((IterableOps)refs.filterNot((Function1 & Serializable)ref -> BoxesRunTime.boxToBoolean((boolean)CachedTableManager.$anonfun$register$6(oldCachedTable, ref)))).$plus$plus(oldCachedTable.refs());
            long x$10 = System.currentTimeMillis();
            Function1<Option<String>, TableRefreshResult> x$11 = customRefresher;
            Option<String> x$12 = cachedTable.refreshToken();
            CachedTable mergedTable = new CachedTable(x$7, (scala.collection.immutable.Map<String, String>)x$8, x$10, x$12, x$11, (Seq<WeakReference<Object>>)x$9);
            if (!this.cache().replace(customTablePath, oldTable, mergedTable)) continue;
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Registered to an existing entry in cache for table ").append(customTablePath).append(".").toString());
            return;
        } while ((oldTable = this.cache().get(customTablePath)) != null || (oldTable = this.cache().putIfAbsent(customTablePath, cachedTable)) != null);
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(54).append("Registered a new entry in cache for table ").append(customTablePath).append(" on 2nd try.").toString());
    }

    public long register$default$6() {
        return System.currentTimeMillis() + this.preSignedUrlExpirationMs();
    }

    public void stop() {
        this.refreshThread().shutdownNow();
    }

    public void clear() {
        this.cache().clear();
    }

    public static final /* synthetic */ boolean $anonfun$handleCachedTableRefresh$1(WeakReference x$1) {
        return x$1.get() == null;
    }

    public static final /* synthetic */ boolean $anonfun$handleQuerySpecificCachedTableRefresh$3(WeakReference x$3) {
        return x$3.get() != null;
    }

    public static final /* synthetic */ boolean $anonfun$handleQuerySpecificCachedTableRefresh$2(Tuple2 x0$1) {
        Tuple2 tuple2;
        Tuple2 tuple22 = x0$1;
        if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
            Seq refs = (Seq)tuple2._1();
            return refs.exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CachedTableManager.$anonfun$handleQuerySpecificCachedTableRefresh$3(x$3)));
        }
        throw new MatchError((Object)tuple22);
    }

    public static final /* synthetic */ Date $anonfun$register$3(long x$6) {
        return new Date(x$6);
    }

    public static final /* synthetic */ boolean $anonfun$register$7(WeakReference ref$1, WeakReference x$8) {
        return x$8.get() == ref$1.get();
    }

    public static final /* synthetic */ boolean $anonfun$register$6(CachedTable oldCachedTable$1, WeakReference ref) {
        return oldCachedTable$1.refs().exists((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)CachedTableManager.$anonfun$register$7(ref, x$8)));
    }

    public CachedTableManager(long preSignedUrlExpirationMs, long refreshCheckIntervalMs, long refreshThresholdMs, long expireAfterAccessMs) {
        this.preSignedUrlExpirationMs = preSignedUrlExpirationMs;
        this.refreshThresholdMs = refreshThresholdMs;
        this.expireAfterAccessMs = expireAfterAccessMs;
        Logging.$init$((Logging)this);
        this.cache = new ConcurrentHashMap();
        ScheduledExecutorService thread = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("delta-sharing-pre-signed-url-refresh-thread");
        thread.scheduleWithFixedDelay(() -> this.refresh(), refreshCheckIntervalMs, refreshCheckIntervalMs, TimeUnit.MILLISECONDS);
        this.refreshThread = thread;
    }
}

