/*
 * Decompiled with CFR 0.152.
 */
package io.delta.sharing.client.util;

import io.delta.sharing.client.util.ConfUtils;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.sql.internal.SQLConf;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;

public final class ConfUtils$ {
    public static final ConfUtils$ MODULE$ = new ConfUtils$();
    private static final String NUM_RETRIES_CONF = "spark.delta.sharing.network.numRetries";
    private static final int NUM_RETRIES_DEFAULT = 3;
    private static final String MAX_RETRY_DURATION_CONF = "spark.delta.sharing.network.maxRetryDuration";
    private static final long MAX_RETRY_DURATION_DEFAULT_MILLIS = 600000L;
    private static final String RETRY_SLEEP_INTERVAL_CONF = "spark.delta.sharing.network.retrySleepInterval";
    private static final long RETRY_SLEEP_INTERVAL_DEFAULT_MILLIS = 1000L;
    private static final String ASYNC_QUERY_POLL_INTERVAL_CONF = "spark.delta.sharing.network.asyncQueryRetryInterval";
    private static final long ASYNC_QUERY_POLL_INTERVAL_DEFAULT_MILLIS = 10000L;
    private static final String ASYNC_QUERY_TIMEOUT_CONF = "spark.delta.sharing.network.asyncQueryTimeout";
    private static final long ASYNC_QUERY_TIMEOUT_DEFAULT_MILLIS = 600000L;
    private static final String USE_ASYNC_QUERY_CONF = "spark.delta.sharing.network.useAsyncQuery";
    private static final String USE_ASYNC_QUERY_DEFAULT = "false";
    private static final String INCLUDE_END_STREAM_ACTION_CONF = "spark.delta.sharing.query.includeEndStreamAction";
    private static final String INCLUDE_END_STREAM_ACTION_DEFAULT = "false";
    private static final String TIMEOUT_CONF = "spark.delta.sharing.network.timeout";
    private static final String TIMEOUT_DEFAULT = "320s";
    private static final String MAX_CONNECTION_CONF = "spark.delta.sharing.network.maxConnections";
    private static final int MAX_CONNECTION_DEFAULT = 64;
    private static final String SSL_TRUST_ALL_CONF = "spark.delta.sharing.network.sslTrustAll";
    private static final String SSL_TRUST_ALL_DEFAULT = "false";
    private static final String PROFILE_PROVIDER_CLASS_CONF = "spark.delta.sharing.profile.provider.class";
    private static final String PROFILE_PROVIDER_CLASS_DEFAULT = "io.delta.sharing.client.DeltaSharingFileProfileProvider";
    private static final String CLIENT_CLASS_CONF = "spark.delta.sharing.client.class";
    private static final String CLIENT_CLASS_DEFAULT = "io.delta.sharing.client.DeltaSharingRestClient";
    private static final String JSON_PREDICATE_CONF = "spark.delta.sharing.jsonPredicateHints.enabled";
    private static final String JSON_PREDICATE_DEFAULT = "true";
    private static final String JSON_PREDICATE_V2_CONF = "spark.delta.sharing.jsonPredicateV2Hints.enabled";
    private static final String JSON_PREDICATE_V2_DEFAULT = "true";
    private static final String QUERY_PAGINATION_ENABLED_CONF = "spark.delta.sharing.queryPagination.enabled";
    private static final String QUERY_PAGINATION_ENABLED_DEFAULT = "false";
    private static final String MAX_FILES_CONF = "spark.delta.sharing.maxFilesPerQueryRequest";
    private static final int MAX_FILES_DEFAULT = 100000;
    private static final String QUERY_TABLE_VERSION_INTERVAL_SECONDS = "spark.delta.sharing.streaming.queryTableVersionIntervalSeconds";
    private static final String QUERY_TABLE_VERSION_INTERVAL_SECONDS_DEFAULT = "30s";
    private static final int MINIMUM_TABLE_VERSION_INTERVAL_SECONDS = 10;
    private static final String LIMIT_PUSHDOWN_ENABLED_CONF = "spark.delta.sharing.limitPushdown.enabled";
    private static final String LIMIT_PUSHDOWN_ENABLED_DEFAULT = "true";
    private static final String PROXY_HOST = "spark.delta.sharing.network.proxyHost";
    private static final String PROXY_PORT = "spark.delta.sharing.network.proxyPort";
    private static final String NO_PROXY_HOSTS = "spark.delta.sharing.network.noProxyHosts";
    private static final String OAUTH_RETRIES_CONF = "spark.delta.sharing.oauth.tokenExchangeMaxRetries";
    private static final int OAUTH_RETRIES_DEFAULT = 5;
    private static final String OAUTH_MAX_RETRY_DURATION_CONF = "spark.delta.sharing.oauth.tokenExchangeMaxRetryDurationInSeconds";
    private static final int OAUTH_MAX_RETRY_DURATION_SECONDS_DEFAULT = 60;
    private static final String OAUTH_EXPIRATION_THRESHOLD_CONF = "spark.delta.sharing.oauth.tokenRenewalThresholdInSeconds";
    private static final int OAUTH_EXPIRATION_THRESHOLD_SECONDS_DEFAULT = 600;
    private static final String NEVER_USE_HTTPS = "spark.delta.sharing.network.never.use.https";
    private static final String NEVER_USE_HTTPS_DEFAULT = "false";
    private static final String STRUCTURAL_SCHEMA_MATCH_CONF = "spark.delta.sharing.client.useStructuralSchemaMatch";
    private static final String STRUCTURAL_SCHEMA_MATCH_DEFAULT = "false";
    private static final String SPARK_PARQUET_IO_CACHE_CONF = "spark.delta.sharing.client.sparkParquetIOCache.enabled";
    private static final String SPARK_PARQUET_IO_CACHE_DEFAULT = "false";
    private static final String LOG_PRESIGNED_URL_ACCESS_CONF = "spark.delta.sharing.client.logPreSignedUrlAccess.enabled";
    private static final boolean LOG_PRESIGNED_URL_ACCESS_DEFAULT = false;

    public String NUM_RETRIES_CONF() {
        return NUM_RETRIES_CONF;
    }

    public int NUM_RETRIES_DEFAULT() {
        return NUM_RETRIES_DEFAULT;
    }

    public String MAX_RETRY_DURATION_CONF() {
        return MAX_RETRY_DURATION_CONF;
    }

    public long MAX_RETRY_DURATION_DEFAULT_MILLIS() {
        return MAX_RETRY_DURATION_DEFAULT_MILLIS;
    }

    public String RETRY_SLEEP_INTERVAL_CONF() {
        return RETRY_SLEEP_INTERVAL_CONF;
    }

    public long RETRY_SLEEP_INTERVAL_DEFAULT_MILLIS() {
        return RETRY_SLEEP_INTERVAL_DEFAULT_MILLIS;
    }

    public String ASYNC_QUERY_POLL_INTERVAL_CONF() {
        return ASYNC_QUERY_POLL_INTERVAL_CONF;
    }

    public long ASYNC_QUERY_POLL_INTERVAL_DEFAULT_MILLIS() {
        return ASYNC_QUERY_POLL_INTERVAL_DEFAULT_MILLIS;
    }

    public String ASYNC_QUERY_TIMEOUT_CONF() {
        return ASYNC_QUERY_TIMEOUT_CONF;
    }

    public long ASYNC_QUERY_TIMEOUT_DEFAULT_MILLIS() {
        return ASYNC_QUERY_TIMEOUT_DEFAULT_MILLIS;
    }

    public String USE_ASYNC_QUERY_CONF() {
        return USE_ASYNC_QUERY_CONF;
    }

    public String USE_ASYNC_QUERY_DEFAULT() {
        return USE_ASYNC_QUERY_DEFAULT;
    }

    public String INCLUDE_END_STREAM_ACTION_CONF() {
        return INCLUDE_END_STREAM_ACTION_CONF;
    }

    public String INCLUDE_END_STREAM_ACTION_DEFAULT() {
        return INCLUDE_END_STREAM_ACTION_DEFAULT;
    }

    public String TIMEOUT_CONF() {
        return TIMEOUT_CONF;
    }

    public String TIMEOUT_DEFAULT() {
        return TIMEOUT_DEFAULT;
    }

    public String MAX_CONNECTION_CONF() {
        return MAX_CONNECTION_CONF;
    }

    public int MAX_CONNECTION_DEFAULT() {
        return MAX_CONNECTION_DEFAULT;
    }

    public String SSL_TRUST_ALL_CONF() {
        return SSL_TRUST_ALL_CONF;
    }

    public String SSL_TRUST_ALL_DEFAULT() {
        return SSL_TRUST_ALL_DEFAULT;
    }

    public String PROFILE_PROVIDER_CLASS_CONF() {
        return PROFILE_PROVIDER_CLASS_CONF;
    }

    public String PROFILE_PROVIDER_CLASS_DEFAULT() {
        return PROFILE_PROVIDER_CLASS_DEFAULT;
    }

    public String CLIENT_CLASS_CONF() {
        return CLIENT_CLASS_CONF;
    }

    public String CLIENT_CLASS_DEFAULT() {
        return CLIENT_CLASS_DEFAULT;
    }

    public String JSON_PREDICATE_CONF() {
        return JSON_PREDICATE_CONF;
    }

    public String JSON_PREDICATE_DEFAULT() {
        return JSON_PREDICATE_DEFAULT;
    }

    public String JSON_PREDICATE_V2_CONF() {
        return JSON_PREDICATE_V2_CONF;
    }

    public String JSON_PREDICATE_V2_DEFAULT() {
        return JSON_PREDICATE_V2_DEFAULT;
    }

    public String QUERY_PAGINATION_ENABLED_CONF() {
        return QUERY_PAGINATION_ENABLED_CONF;
    }

    public String QUERY_PAGINATION_ENABLED_DEFAULT() {
        return QUERY_PAGINATION_ENABLED_DEFAULT;
    }

    public String MAX_FILES_CONF() {
        return MAX_FILES_CONF;
    }

    public int MAX_FILES_DEFAULT() {
        return MAX_FILES_DEFAULT;
    }

    public String QUERY_TABLE_VERSION_INTERVAL_SECONDS() {
        return QUERY_TABLE_VERSION_INTERVAL_SECONDS;
    }

    public String QUERY_TABLE_VERSION_INTERVAL_SECONDS_DEFAULT() {
        return QUERY_TABLE_VERSION_INTERVAL_SECONDS_DEFAULT;
    }

    public int MINIMUM_TABLE_VERSION_INTERVAL_SECONDS() {
        return MINIMUM_TABLE_VERSION_INTERVAL_SECONDS;
    }

    public String LIMIT_PUSHDOWN_ENABLED_CONF() {
        return LIMIT_PUSHDOWN_ENABLED_CONF;
    }

    public String LIMIT_PUSHDOWN_ENABLED_DEFAULT() {
        return LIMIT_PUSHDOWN_ENABLED_DEFAULT;
    }

    public String PROXY_HOST() {
        return PROXY_HOST;
    }

    public String PROXY_PORT() {
        return PROXY_PORT;
    }

    public String NO_PROXY_HOSTS() {
        return NO_PROXY_HOSTS;
    }

    public String OAUTH_RETRIES_CONF() {
        return OAUTH_RETRIES_CONF;
    }

    public int OAUTH_RETRIES_DEFAULT() {
        return OAUTH_RETRIES_DEFAULT;
    }

    public String OAUTH_MAX_RETRY_DURATION_CONF() {
        return OAUTH_MAX_RETRY_DURATION_CONF;
    }

    public int OAUTH_MAX_RETRY_DURATION_SECONDS_DEFAULT() {
        return OAUTH_MAX_RETRY_DURATION_SECONDS_DEFAULT;
    }

    public String OAUTH_EXPIRATION_THRESHOLD_CONF() {
        return OAUTH_EXPIRATION_THRESHOLD_CONF;
    }

    public int OAUTH_EXPIRATION_THRESHOLD_SECONDS_DEFAULT() {
        return OAUTH_EXPIRATION_THRESHOLD_SECONDS_DEFAULT;
    }

    public String NEVER_USE_HTTPS() {
        return NEVER_USE_HTTPS;
    }

    public String NEVER_USE_HTTPS_DEFAULT() {
        return NEVER_USE_HTTPS_DEFAULT;
    }

    public String STRUCTURAL_SCHEMA_MATCH_CONF() {
        return STRUCTURAL_SCHEMA_MATCH_CONF;
    }

    public String STRUCTURAL_SCHEMA_MATCH_DEFAULT() {
        return STRUCTURAL_SCHEMA_MATCH_DEFAULT;
    }

    public String SPARK_PARQUET_IO_CACHE_CONF() {
        return SPARK_PARQUET_IO_CACHE_CONF;
    }

    public String SPARK_PARQUET_IO_CACHE_DEFAULT() {
        return SPARK_PARQUET_IO_CACHE_DEFAULT;
    }

    public String LOG_PRESIGNED_URL_ACCESS_CONF() {
        return LOG_PRESIGNED_URL_ACCESS_CONF;
    }

    public boolean LOG_PRESIGNED_URL_ACCESS_DEFAULT() {
        return LOG_PRESIGNED_URL_ACCESS_DEFAULT;
    }

    public Option<ConfUtils.ProxyConfig> getProxyConfig(Configuration conf) {
        String proxyHost = conf.get(this.PROXY_HOST(), null);
        String proxyPortAsString = conf.get(this.PROXY_PORT(), null);
        if (proxyHost == null && proxyPortAsString == null) {
            return None$.MODULE$;
        }
        this.validateNonEmpty(proxyHost, this.PROXY_HOST());
        this.validateNonEmpty(proxyPortAsString, this.PROXY_PORT());
        int proxyPort = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(proxyPortAsString));
        this.validatePortNumber(proxyPort, this.PROXY_PORT());
        Seq noProxyList = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])conf.getTrimmedStrings(this.NO_PROXY_HOSTS())));
        return new Some((Object)new ConfUtils.ProxyConfig(proxyHost, proxyPort, (Seq<String>)noProxyList));
    }

    public boolean getNeverUseHttps(Configuration conf) {
        return conf.getBoolean(this.NEVER_USE_HTTPS(), StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(this.NEVER_USE_HTTPS_DEFAULT())));
    }

    public int numRetries(Configuration conf) {
        int numRetries = conf.getInt(this.NUM_RETRIES_CONF(), this.NUM_RETRIES_DEFAULT());
        this.validateNonNeg(numRetries, this.NUM_RETRIES_CONF());
        return numRetries;
    }

    public int numRetries(SQLConf conf) {
        int numRetries = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(conf.getConfString(this.NUM_RETRIES_CONF(), Integer.toString(this.NUM_RETRIES_DEFAULT()))));
        this.validateNonNeg(numRetries, this.NUM_RETRIES_CONF());
        return numRetries;
    }

    public long maxRetryDurationMillis(Configuration conf) {
        long maxDur = conf.getLong(this.MAX_RETRY_DURATION_CONF(), this.MAX_RETRY_DURATION_DEFAULT_MILLIS());
        this.validateNonNeg(maxDur, this.MAX_RETRY_DURATION_CONF());
        return maxDur;
    }

    public long maxRetryDurationMillis(SQLConf conf) {
        long maxDur = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(conf.getConfString(this.MAX_RETRY_DURATION_CONF(), Long.toString(this.MAX_RETRY_DURATION_DEFAULT_MILLIS()))));
        this.validateNonNeg(maxDur, this.MAX_RETRY_DURATION_CONF());
        return maxDur;
    }

    public long retrySleepIntervalMillis(Configuration conf) {
        long interval = conf.getLong(this.RETRY_SLEEP_INTERVAL_CONF(), this.RETRY_SLEEP_INTERVAL_DEFAULT_MILLIS());
        this.validateNonNeg(interval, this.RETRY_SLEEP_INTERVAL_CONF());
        return interval;
    }

    public long retrySleepIntervalMillis(SQLConf conf) {
        long interval = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(conf.getConfString(this.RETRY_SLEEP_INTERVAL_CONF(), Long.toString(this.RETRY_SLEEP_INTERVAL_DEFAULT_MILLIS()))));
        this.validateNonNeg(interval, this.RETRY_SLEEP_INTERVAL_CONF());
        return interval;
    }

    public long asyncQueryPollIntervalMillis(Configuration conf) {
        long interval = conf.getLong(this.ASYNC_QUERY_POLL_INTERVAL_CONF(), this.ASYNC_QUERY_POLL_INTERVAL_DEFAULT_MILLIS());
        this.validateNonNeg(interval, this.ASYNC_QUERY_POLL_INTERVAL_CONF());
        return interval;
    }

    public long asyncQueryPollIntervalMillis(SQLConf conf) {
        long interval = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(conf.getConfString(this.ASYNC_QUERY_POLL_INTERVAL_CONF(), Long.toString(this.ASYNC_QUERY_POLL_INTERVAL_DEFAULT_MILLIS()))));
        this.validateNonNeg(interval, this.ASYNC_QUERY_POLL_INTERVAL_CONF());
        return interval;
    }

    public long asyncQueryTimeout(Configuration conf) {
        long timeout = conf.getLong(this.ASYNC_QUERY_TIMEOUT_CONF(), this.ASYNC_QUERY_TIMEOUT_DEFAULT_MILLIS());
        this.validateNonNeg(timeout, this.ASYNC_QUERY_TIMEOUT_CONF());
        return timeout;
    }

    public long asyncQueryTimeout(SQLConf conf) {
        long timeout = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(conf.getConfString(this.ASYNC_QUERY_TIMEOUT_CONF(), Long.toString(this.ASYNC_QUERY_TIMEOUT_DEFAULT_MILLIS()))));
        this.validateNonNeg(timeout, this.ASYNC_QUERY_TIMEOUT_CONF());
        return timeout;
    }

    public boolean useAsyncQuery(Configuration conf) {
        return conf.getBoolean(this.USE_ASYNC_QUERY_CONF(), StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(this.USE_ASYNC_QUERY_DEFAULT())));
    }

    public boolean useAsyncQuery(SQLConf conf) {
        return StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(conf.getConfString(this.USE_ASYNC_QUERY_CONF(), this.USE_ASYNC_QUERY_DEFAULT())));
    }

    public boolean includeEndStreamAction(Configuration conf) {
        return conf.getBoolean(this.INCLUDE_END_STREAM_ACTION_CONF(), StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(this.INCLUDE_END_STREAM_ACTION_DEFAULT())));
    }

    public boolean includeEndStreamAction(SQLConf conf) {
        return StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(conf.getConfString(this.INCLUDE_END_STREAM_ACTION_CONF(), this.INCLUDE_END_STREAM_ACTION_DEFAULT())));
    }

    public int timeoutInSeconds(Configuration conf) {
        String timeoutStr = conf.get(this.TIMEOUT_CONF(), this.TIMEOUT_DEFAULT());
        return this.toTimeInSeconds(timeoutStr, this.TIMEOUT_CONF());
    }

    public int timeoutInSeconds(SQLConf conf) {
        String timeoutStr = conf.getConfString(this.TIMEOUT_CONF(), this.TIMEOUT_DEFAULT());
        return this.toTimeInSeconds(timeoutStr, this.TIMEOUT_CONF());
    }

    public int maxConnections(Configuration conf) {
        int maxConn = conf.getInt(this.MAX_CONNECTION_CONF(), this.MAX_CONNECTION_DEFAULT());
        this.validateNonNeg(maxConn, this.MAX_CONNECTION_CONF());
        return maxConn;
    }

    public boolean sslTrustAll(SQLConf conf) {
        return StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(conf.getConfString(this.SSL_TRUST_ALL_CONF(), this.SSL_TRUST_ALL_DEFAULT())));
    }

    public String profileProviderClass(SQLConf conf) {
        return conf.getConfString(this.PROFILE_PROVIDER_CLASS_CONF(), this.PROFILE_PROVIDER_CLASS_DEFAULT());
    }

    public String clientClass(SQLConf conf) {
        return conf.getConfString(this.CLIENT_CLASS_CONF(), this.CLIENT_CLASS_DEFAULT());
    }

    public boolean jsonPredicatesEnabled(SQLConf conf) {
        return StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(conf.getConfString(this.JSON_PREDICATE_CONF(), this.JSON_PREDICATE_DEFAULT())));
    }

    public boolean jsonPredicatesV2Enabled(SQLConf conf) {
        return StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(conf.getConfString(this.JSON_PREDICATE_V2_CONF(), this.JSON_PREDICATE_V2_DEFAULT())));
    }

    public boolean queryTablePaginationEnabled(SQLConf conf) {
        return StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(conf.getConfString(this.QUERY_PAGINATION_ENABLED_CONF(), this.QUERY_PAGINATION_ENABLED_DEFAULT())));
    }

    public int maxFilesPerQueryRequest(SQLConf conf) {
        int maxFiles = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(conf.getConfString(this.MAX_FILES_CONF(), Integer.toString(this.MAX_FILES_DEFAULT()))));
        this.validatePositive(maxFiles, this.MAX_FILES_CONF());
        return maxFiles;
    }

    public int streamingQueryTableVersionIntervalSeconds(SQLConf conf) {
        String intervalStr = conf.getConfString(this.QUERY_TABLE_VERSION_INTERVAL_SECONDS(), this.QUERY_TABLE_VERSION_INTERVAL_SECONDS_DEFAULT());
        return this.toTimeInSeconds(intervalStr, this.QUERY_TABLE_VERSION_INTERVAL_SECONDS());
    }

    public boolean limitPushdownEnabled(SQLConf conf) {
        return StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(conf.getConfString(this.LIMIT_PUSHDOWN_ENABLED_CONF(), this.LIMIT_PUSHDOWN_ENABLED_DEFAULT())));
    }

    public int tokenExchangeMaxRetries(Configuration conf) {
        int numRetries = conf.getInt(this.OAUTH_RETRIES_CONF(), this.OAUTH_RETRIES_DEFAULT());
        this.validateNonNeg(numRetries, this.OAUTH_RETRIES_CONF());
        return numRetries;
    }

    public int tokenExchangeMaxRetries(SQLConf conf) {
        int numRetries = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(conf.getConfString(this.OAUTH_RETRIES_CONF(), Integer.toString(this.OAUTH_RETRIES_DEFAULT()))));
        this.validateNonNeg(numRetries, this.NUM_RETRIES_CONF());
        return numRetries;
    }

    public int tokenExchangeMaxRetryDurationInSeconds(Configuration conf) {
        int maxDur = conf.getInt(this.OAUTH_MAX_RETRY_DURATION_CONF(), this.OAUTH_MAX_RETRY_DURATION_SECONDS_DEFAULT());
        this.validatePositive(maxDur, this.OAUTH_MAX_RETRY_DURATION_CONF());
        return maxDur;
    }

    public int tokenExchangeMaxRetryDurationInSeconds(SQLConf conf) {
        int maxDur = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(conf.getConfString(this.OAUTH_MAX_RETRY_DURATION_CONF(), Integer.toString(this.OAUTH_MAX_RETRY_DURATION_SECONDS_DEFAULT()))));
        this.validatePositive(maxDur, this.OAUTH_MAX_RETRY_DURATION_CONF());
        return maxDur;
    }

    public int tokenRenewalThresholdInSeconds(Configuration conf) {
        int maxDur = conf.getInt(this.OAUTH_EXPIRATION_THRESHOLD_CONF(), this.OAUTH_EXPIRATION_THRESHOLD_SECONDS_DEFAULT());
        this.validatePositive(maxDur, this.OAUTH_EXPIRATION_THRESHOLD_CONF());
        return maxDur;
    }

    public int tokenRenewalThresholdInSeconds(SQLConf conf) {
        int maxDur = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(conf.getConfString(this.OAUTH_EXPIRATION_THRESHOLD_CONF(), Integer.toString(this.OAUTH_EXPIRATION_THRESHOLD_SECONDS_DEFAULT()))));
        this.validatePositive(maxDur, this.OAUTH_EXPIRATION_THRESHOLD_CONF());
        return maxDur;
    }

    public boolean structuralSchemaMatchingEnabled(SQLConf conf) {
        return StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(conf.getConfString(this.STRUCTURAL_SCHEMA_MATCH_CONF(), this.STRUCTURAL_SCHEMA_MATCH_DEFAULT())));
    }

    public boolean sparkParquetIOCacheEnabled(Configuration conf) {
        return conf.getBoolean(this.SPARK_PARQUET_IO_CACHE_CONF(), StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(this.SPARK_PARQUET_IO_CACHE_DEFAULT())));
    }

    public boolean sparkParquetIOCacheEnabled(SQLConf conf) {
        return StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(conf.getConfString(this.SPARK_PARQUET_IO_CACHE_CONF(), this.SPARK_PARQUET_IO_CACHE_DEFAULT())));
    }

    public boolean logPreSignedUrlAccessEnabled(Configuration conf) {
        return conf.getBoolean(this.LOG_PRESIGNED_URL_ACCESS_CONF(), this.LOG_PRESIGNED_URL_ACCESS_DEFAULT());
    }

    public boolean logPreSignedUrlAccessEnabled(SQLConf conf) {
        return StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(conf.getConfString(this.LOG_PRESIGNED_URL_ACCESS_CONF(), Boolean.toString(this.LOG_PRESIGNED_URL_ACCESS_DEFAULT()))));
    }

    private int toTimeInSeconds(String timeStr, String conf) {
        long timeInSeconds = JavaUtils.timeStringAs((String)timeStr, (TimeUnit)TimeUnit.SECONDS);
        this.validateNonNeg(timeInSeconds, conf);
        String string = conf;
        String string2 = this.QUERY_TABLE_VERSION_INTERVAL_SECONDS();
        if (!(string != null ? !string.equals(string2) : string2 != null) && timeInSeconds < (long)this.MINIMUM_TABLE_VERSION_INTERVAL_SECONDS()) {
            throw new IllegalArgumentException(new StringBuilder(32).append(conf).append(" must not be less than ").append(this.MINIMUM_TABLE_VERSION_INTERVAL_SECONDS()).append(" seconds.").toString());
        }
        if (timeInSeconds > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(new StringBuilder(13).append(conf).append(" is too big: ").append(timeStr).toString());
        }
        return (int)timeInSeconds;
    }

    private void validateNonNeg(long value, String conf) {
        if (value < 0L) {
            throw new IllegalArgumentException(new StringBuilder(21).append(conf).append(" must not be negative").toString());
        }
    }

    private void validatePositive(int value, String conf) {
        if (value <= 0) {
            throw new IllegalArgumentException(new StringBuilder(17).append(conf).append(" must be positive").toString());
        }
    }

    private void validateNonEmpty(String value, String conf) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(16).append(conf).append(" must be defined").toString());
        }
    }

    private void validatePortNumber(int value, String conf) {
        if (value <= 0 || value > 65535) {
            throw new IllegalArgumentException(new StringBuilder(28).append(conf).append(" must be a valid port number").toString());
        }
    }

    private ConfUtils$() {
    }
}

