/*
 * Decompiled with CFR 0.152.
 */
package io.delta.sharing.filters;

import io.delta.sharing.filters.AndOp;
import io.delta.sharing.filters.BaseOp;
import io.delta.sharing.filters.ColumnOp;
import io.delta.sharing.filters.EqualOp;
import io.delta.sharing.filters.GreaterThanOp;
import io.delta.sharing.filters.GreaterThanOrEqualOp;
import io.delta.sharing.filters.IsNullOp;
import io.delta.sharing.filters.LeafOp;
import io.delta.sharing.filters.LessThanOp;
import io.delta.sharing.filters.LessThanOrEqualOp;
import io.delta.sharing.filters.LiteralOp;
import io.delta.sharing.filters.NotOp;
import io.delta.sharing.filters.OpDataTypes$;
import io.delta.sharing.filters.OrOp;
import java.io.Serializable;
import java.time.Instant;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class OpConverter$ {
    public static final OpConverter$ MODULE$ = new OpConverter$();
    private static final int kMaxSqlInOpSizeLimit = 20;

    public int kMaxSqlInOpSizeLimit() {
        return kMaxSqlInOpSizeLimit;
    }

    public Option<BaseOp> convert(Seq<Expression> expressions) throws IllegalArgumentException {
        SeqOps seqOps;
        SeqOps seqOps2;
        Seq seq = (Seq)expressions.map((Function1 & Serializable)x$1 -> MODULE$.convertOne((Expression)x$1));
        if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0) == 0) {
            return None$.MODULE$;
        }
        if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
            BaseOp child = (BaseOp)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            return new Some((Object)child);
        }
        return new Some((Object)new AndOp((Seq<BaseOp>)seq.toList()));
    }

    private BaseOp convertOne(Expression expr) {
        return (BaseOp)this.maybeConvertAsLeaf(expr, this.maybeConvertAsLeaf$default$2()).getOrElse((Function0 & Serializable)() -> {
            Expression expression = expr;
            if (expression instanceof And) {
                And and = (And)expression;
                Expression left = and.left();
                Expression right = and.right();
                return new AndOp((Seq<BaseOp>)new .colon.colon((Object)MODULE$.convertOne(left), (List)new .colon.colon((Object)MODULE$.convertOne(right), (List)Nil$.MODULE$)));
            }
            if (expression instanceof Or) {
                Or or = (Or)expression;
                Expression left = or.left();
                Expression right = or.right();
                return new OrOp((Seq<BaseOp>)new .colon.colon((Object)MODULE$.convertOne(left), (List)new .colon.colon((Object)MODULE$.convertOne(right), (List)Nil$.MODULE$)));
            }
            if (expression instanceof Not) {
                Not not = (Not)expression;
                Expression child = not.child();
                return new NotOp((Seq<BaseOp>)new .colon.colon((Object)MODULE$.convertOne(child), (List)Nil$.MODULE$));
            }
            if (expression instanceof EqualTo) {
                EqualTo equalTo = (EqualTo)expression;
                Expression left = equalTo.left();
                Expression right = equalTo.right();
                return new EqualOp((Seq<LeafOp>)new .colon.colon((Object)MODULE$.convertAsLeaf(left, MODULE$.convertAsLeaf$default$2()), (List)new .colon.colon((Object)MODULE$.convertAsLeaf(right, MODULE$.convertAsLeaf$default$2()), (List)Nil$.MODULE$)));
            }
            if (expression instanceof LessThan) {
                LessThan lessThan = (LessThan)expression;
                Expression left = lessThan.left();
                Expression right = lessThan.right();
                return new LessThanOp((Seq<LeafOp>)new .colon.colon((Object)MODULE$.convertAsLeaf(left, MODULE$.convertAsLeaf$default$2()), (List)new .colon.colon((Object)MODULE$.convertAsLeaf(right, MODULE$.convertAsLeaf$default$2()), (List)Nil$.MODULE$)));
            }
            if (expression instanceof LessThanOrEqual) {
                LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)expression;
                Expression left = lessThanOrEqual.left();
                Expression right = lessThanOrEqual.right();
                return new LessThanOrEqualOp((Seq<LeafOp>)new .colon.colon((Object)MODULE$.convertAsLeaf(left, MODULE$.convertAsLeaf$default$2()), (List)new .colon.colon((Object)MODULE$.convertAsLeaf(right, MODULE$.convertAsLeaf$default$2()), (List)Nil$.MODULE$)));
            }
            if (expression instanceof GreaterThan) {
                GreaterThan greaterThan = (GreaterThan)expression;
                Expression left = greaterThan.left();
                Expression right = greaterThan.right();
                return new GreaterThanOp((Seq<LeafOp>)new .colon.colon((Object)MODULE$.convertAsLeaf(left, MODULE$.convertAsLeaf$default$2()), (List)new .colon.colon((Object)MODULE$.convertAsLeaf(right, MODULE$.convertAsLeaf$default$2()), (List)Nil$.MODULE$)));
            }
            if (expression instanceof GreaterThanOrEqual) {
                GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)expression;
                Expression left = greaterThanOrEqual.left();
                Expression right = greaterThanOrEqual.right();
                return new GreaterThanOrEqualOp((Seq<LeafOp>)new .colon.colon((Object)MODULE$.convertAsLeaf(left, MODULE$.convertAsLeaf$default$2()), (List)new .colon.colon((Object)MODULE$.convertAsLeaf(right, MODULE$.convertAsLeaf$default$2()), (List)Nil$.MODULE$)));
            }
            if (expression instanceof IsNull) {
                IsNull isNull = (IsNull)expression;
                Expression child = isNull.child();
                return new IsNullOp((Seq<LeafOp>)new .colon.colon((Object)MODULE$.convertAsLeaf(child, MODULE$.convertAsLeaf$default$2()), (List)Nil$.MODULE$));
            }
            if (expression instanceof IsNotNull) {
                IsNotNull isNotNull = (IsNotNull)expression;
                Expression child = isNotNull.child();
                return new NotOp((Seq<BaseOp>)new .colon.colon((Object)new IsNullOp((Seq<LeafOp>)new .colon.colon((Object)MODULE$.convertAsLeaf(child, MODULE$.convertAsLeaf$default$2()), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
            }
            if (expression instanceof In) {
                SeqOps seqOps;
                SeqOps seqOps2;
                In in = (In)expression;
                Expression value = in.value();
                Seq list = in.list();
                if (list.size() > MODULE$.kMaxSqlInOpSizeLimit()) {
                    throw new IllegalArgumentException(new StringBuilder(38).append("The In predicate exceeds max limit of ").append(MODULE$.kMaxSqlInOpSizeLimit()).toString());
                }
                LeafOp leafOp = MODULE$.convertAsLeaf(value, MODULE$.convertAsLeaf$default$2());
                Seq seq = (Seq)list.map((Function1 & Serializable)e -> new EqualOp((Seq<LeafOp>)new .colon.colon((Object)leafOp, (List)new .colon.colon((Object)MODULE$.convertAsLeaf((Expression)e, MODULE$.convertAsLeaf$default$2()), (List)Nil$.MODULE$))));
                if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0) == 0) {
                    throw new IllegalArgumentException("The In predicate must have at least one entry");
                }
                if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
                    EqualOp child = (EqualOp)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                    return child;
                }
                return new OrOp((Seq<BaseOp>)seq);
            }
            if (expression instanceof EqualNullSafe) {
                EqualNullSafe equalNullSafe = (EqualNullSafe)expression;
                Expression left = equalNullSafe.left();
                Expression right = equalNullSafe.right();
                LeafOp leftOp = MODULE$.convertAsLeaf(left, MODULE$.convertAsLeaf$default$2());
                LeafOp rightOp = MODULE$.convertAsLeaf(right, MODULE$.convertAsLeaf$default$2());
                IsNullOp leftIsNullOp = new IsNullOp((Seq<LeafOp>)new .colon.colon((Object)leftOp, (List)Nil$.MODULE$));
                IsNullOp rightIsNullOp = new IsNullOp((Seq<LeafOp>)new .colon.colon((Object)rightOp, (List)Nil$.MODULE$));
                return new OrOp((Seq<BaseOp>)new .colon.colon((Object)new AndOp((Seq<BaseOp>)new .colon.colon((Object)leftIsNullOp, (List)new .colon.colon((Object)rightIsNullOp, (List)Nil$.MODULE$))), (List)new .colon.colon((Object)new AndOp((Seq<BaseOp>)new .colon.colon((Object)new NotOp((Seq<BaseOp>)new .colon.colon((Object)leftIsNullOp, (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new NotOp((Seq<BaseOp>)new .colon.colon((Object)rightIsNullOp, (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new EqualOp((Seq<LeafOp>)new .colon.colon((Object)leftOp, (List)new .colon.colon((Object)rightOp, (List)Nil$.MODULE$))), (List)Nil$.MODULE$)))), (List)Nil$.MODULE$)));
            }
            throw new IllegalArgumentException(new StringBuilder(41).append("Unsupported expression during conversion ").append(expr).toString());
        });
    }

    private Option<LeafOp> maybeConvertAsLeaf(Expression expr, Option<DataType> sqlTypeOpt) {
        DataType sqlType = (DataType)sqlTypeOpt.getOrElse((Function0 & Serializable)() -> expr.dataType());
        Expression expression = expr;
        if (expression instanceof AttributeReference) {
            AttributeReference attributeReference = (AttributeReference)expression;
            return new Some((Object)new ColumnOp(attributeReference.name(), this.convertDataType(sqlType)));
        }
        if (expression instanceof Literal) {
            Literal literal = (Literal)expression;
            return new Some((Object)new LiteralOp(this.convertLiteralValue(literal, sqlType), this.convertDataType(sqlType)));
        }
        if (expression instanceof Cast) {
            Cast cast = (Cast)expression;
            return new Some((Object)this.convertAsLeaf(cast.child(), (Option<DataType>)new Some((Object)cast.dataType())));
        }
        return None$.MODULE$;
    }

    private Option<DataType> maybeConvertAsLeaf$default$2() {
        return None$.MODULE$;
    }

    private LeafOp convertAsLeaf(Expression expr, Option<DataType> sqlTypeOpt) {
        return (LeafOp)this.maybeConvertAsLeaf(expr, sqlTypeOpt).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(28).append("Unsupported leaf expression ").append(expr).toString());
        });
    }

    private Option<DataType> convertAsLeaf$default$2() {
        return None$.MODULE$;
    }

    private String convertDataType(DataType sqlType) {
        DataType dataType = sqlType;
        if (BooleanType$.MODULE$.equals(dataType)) {
            return OpDataTypes$.MODULE$.BoolType();
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return OpDataTypes$.MODULE$.IntType();
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return OpDataTypes$.MODULE$.LongType();
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return OpDataTypes$.MODULE$.StringType();
        }
        if (DateType$.MODULE$.equals(dataType)) {
            return OpDataTypes$.MODULE$.DateType();
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return OpDataTypes$.MODULE$.DoubleType();
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return OpDataTypes$.MODULE$.FloatType();
        }
        if (TimestampType$.MODULE$.equals(dataType)) {
            return OpDataTypes$.MODULE$.TimestampType();
        }
        throw new IllegalArgumentException(new StringBuilder(22).append("Unsupported data type ").append(sqlType).toString());
    }

    private String convertLiteralValue(Literal lit, DataType sqlType) {
        DataType dataType = sqlType;
        if (TimestampType$.MODULE$.equals(dataType)) {
            return Instant.ofEpochMilli(BoxesRunTime.unboxToLong((Object)lit.value()) / 1000L).toString();
        }
        return lit.toString();
    }

    private OpConverter$() {
    }
}

