/*
 * Decompiled with CFR 0.152.
 */
package io.delta.sharing.spark;

import org.apache.spark.sql.types.StructType;
import scala.Predef$;
import scala.collection.StringOps$;

public final class DeltaSharingErrors$ {
    public static final DeltaSharingErrors$ MODULE$ = new DeltaSharingErrors$();

    public Throwable nonExistentDeltaSharingTable(String tableId) {
        return new IllegalStateException(new StringBuilder(94).append("Delta sharing table ").append(tableId).append(" doesn't exist. ").append("Please delete your streaming query checkpoint and restart.").toString());
    }

    public Throwable invalidSourceVersion(String version) {
        return new IllegalStateException(new StringBuilder(27).append("sourceVersion(").append(version).append(") is invalid.").toString());
    }

    public Throwable timestampInvalid(String str) {
        return new IllegalArgumentException(new StringBuilder(67).append("The provided timestamp (").append(str).append(") cannot be converted to a valid ").append("timestamp.").toString());
    }

    public Throwable cannotFindSourceVersionException(String json) {
        return new IllegalStateException(new StringBuilder(31).append("Cannot find 'sourceVersion' in ").append(json).toString());
    }

    public Throwable unsupportedTableReaderVersion(long supportedVersion, long tableVersion) {
        return new IllegalStateException(new StringBuilder(68).append("The table reader version ").append(tableVersion).append(" is not equal to ").append("supported reader version ").append(supportedVersion).append(".").toString());
    }

    public Throwable illegalDeltaSharingOptionException(String name, String input, String explain) {
        return new IllegalArgumentException(new StringBuilder(32).append("Invalid value '").append(input).append("' for option '").append(name).append("', ").append(explain).toString());
    }

    public Throwable versionAndTimestampBothSetException(String versionOptKey, String timestampOptKey) {
        return new IllegalArgumentException(new StringBuilder(31).append("Please either provide '").append(versionOptKey).append("' or '").append(timestampOptKey).append("'.").toString());
    }

    public Throwable deltaSharingSourceIgnoreDeleteError(long version) {
        return new UnsupportedOperationException(new StringBuilder(164).append("Detected deleted data from streaming source at version ").append(version).append(". This is currently not supported. If you'd like to ignore deletes, set the ").append("option 'ignoreDeletes' to 'true'.").toString());
    }

    public Throwable deltaSharingSourceIgnoreChangesError(long version) {
        return new UnsupportedOperationException(new StringBuilder(299).append("Detected a data update in the source table at version ").append(version).append(". This is currently not supported. If you'd like to ignore updates, set the ").append("option 'skipChangeCommits' to 'true'. If you would like the data update to be reflected, ").append("please restart the query from latest snapshot with a fresh checkpoint directory.").toString());
    }

    public Throwable unknownReadLimit(String limit) {
        return new UnsupportedOperationException(new StringBuilder(19).append("Unknown ReadLimit: ").append(limit).toString());
    }

    public Throwable specifySchemaAtReadTimeException() {
        return new UnsupportedOperationException("Delta sharing does not support specifying the schema at read time.");
    }

    public Throwable pathNotSpecifiedException() {
        return new IllegalArgumentException("'path' is not specified. If you use SQL to create a Delta Sharing table, LOCATION must be specified");
    }

    public Throwable timeTravelNotSupportedException() {
        return new UnsupportedOperationException("Cannot time travel streams.");
    }

    public Throwable schemaNotSetException() {
        return new IllegalStateException("Shared table schema is not set. Please contact your data provider.");
    }

    public Throwable schemaChangedException(StructType readSchema, StructType schemaToCheck) {
        String msg = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(391).append("Detected incompatible schema change:\n         |schema used to read data: ").append(readSchema.treeString()).append("\n         |\n         |schema seen in the table: ").append(schemaToCheck.treeString()).append("\n         |\n         |Please try restarting the query. If this issue repeats across query restarts without\n         |making progress, you have made an incompatible schema change and need to start your\n         |query from scratch using a new checkpoint directory.\n      ").toString()));
        return new IllegalStateException(msg);
    }

    private DeltaSharingErrors$() {
    }
}

