/*
 * Decompiled with CFR 0.152.
 */
package io.delta.sharing.spark;

import io.delta.sharing.spark.DeltaSharingErrors$;
import io.delta.sharing.spark.DeltaSharingOptionParser;
import io.delta.sharing.spark.DeltaSharingOptions$;
import io.delta.sharing.spark.DeltaStartingVersion;
import io.delta.sharing.spark.StartingVersion$;
import io.delta.sharing.spark.StartingVersionLatest$;
import java.io.Serializable;
import org.apache.spark.network.util.ByteUnit;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005=4qAF\f\u0011\u0002\u0007\u0005\u0001\u0005C\u0003,\u0001\u0011\u0005A\u0006C\u00041\u0001\t\u0007I\u0011A\u0019\t\u000fa\u0002!\u0019!C\u0001s!9a\b\u0001b\u0001\n\u0003\t\u0004bB \u0001\u0005\u0004%\t\u0001\u0011\u0005\b\t\u0002\u0011\r\u0011\"\u0001A\u0011\u001d)\u0005A1A\u0005\u0002\u0001CqA\u0012\u0001C\u0002\u0013\u0005\u0001\tC\u0004H\u0001\t\u0007I\u0011\u0001%\t\u000f5\u0003!\u0019!C\u0001\u001d\"91\f\u0001b\u0001\n\u0003a\u0006b\u00021\u0001\u0005\u0004%\t!\u000f\u0005\bC\u0002\u0011\r\u0011\"\u0001O\u0011\u001d\u0011\u0007A1A\u0005\u0002\rDq\u0001\u001a\u0001C\u0002\u0013\u0005A\fC\u0003f\u0001\u0011\u0005\u0001\tC\u0003g\u0001\u0011%q\rC\u0003k\u0001\u0011%1\u000eC\u0003m\u0001\u0011%1\u000eC\u0003n\u0001\u0011%A\u0006C\u0003o\u0001\u0011%AFA\fEK2$\u0018m\u00155be&twMU3bI>\u0003H/[8og*\u0011\u0001$G\u0001\u0006gB\f'o\u001b\u0006\u00035m\tqa\u001d5be&twM\u0003\u0002\u001d;\u0005)A-\u001a7uC*\ta$\u0001\u0002j_\u000e\u00011c\u0001\u0001\"OA\u0011!%J\u0007\u0002G)\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\t1\u0011I\\=SK\u001a\u0004\"\u0001K\u0015\u000e\u0003]I!AK\f\u00031\u0011+G\u000e^1TQ\u0006\u0014\u0018N\\4PaRLwN\u001c)beN,'/\u0001\u0004%S:LG\u000f\n\u000b\u0002[A\u0011!EL\u0005\u0003_\r\u0012A!\u00168ji\u0006\u0011R.\u0019=GS2,7\u000fU3s)JLwmZ3s+\u0005\u0011\u0004c\u0001\u00124k%\u0011Ag\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\t2\u0014BA\u001c$\u0005\rIe\u000e^\u0001\u0013[\u0006D()\u001f;fgB+'\u000f\u0016:jO\u001e,'/F\u0001;!\r\u00113g\u000f\t\u0003EqJ!!P\u0012\u0003\t1{gnZ\u0001\u0012[\u0006Dh+\u001a:tS>t7\u000fU3s%B\u001c\u0017!D5h]>\u0014Xm\u00115b]\u001e,7/F\u0001B!\t\u0011#)\u0003\u0002DG\t9!i\\8mK\u0006t\u0017!D5h]>\u0014X\rR3mKR,7/A\ttW&\u00048\t[1oO\u0016\u001cu.\\7jiN\faB]3bI\u000eC\u0017M\\4f\r\u0016,G-A\bti\u0006\u0014H/\u001b8h-\u0016\u00148/[8o+\u0005I\u0005c\u0001\u00124\u0015B\u0011\u0001fS\u0005\u0003\u0019^\u0011A\u0003R3mi\u0006\u001cF/\u0019:uS:<g+\u001a:tS>t\u0017!E:uCJ$\u0018N\\4US6,7\u000f^1naV\tq\nE\u0002#gA\u0003\"!\u0015-\u000f\u0005I3\u0006CA*$\u001b\u0005!&BA+ \u0003\u0019a$o\\8u}%\u0011qkI\u0001\u0007!J,G-\u001a4\n\u0005eS&AB*ue&twM\u0003\u0002XG\u0005Q1\r\u001a4PaRLwN\\:\u0016\u0003u\u0003B!\u00150Q!&\u0011qL\u0017\u0002\u0004\u001b\u0006\u0004\u0018a\u0003<feNLwN\\!t\u001f\u001a\fQ\u0002^5nKN$\u0018-\u001c9Bg>3\u0017A\u0004:fgB|gn]3G_Jl\u0017\r^\u000b\u0002!\u000692\u000f[1sK\u000e\u0013X\rZ3oi&\fGn](qi&|gn]\u0001\rSN$\u0016.\\3Ue\u00064X\r\\\u0001\u0016O\u0016$hi\u001c:nCR$X\r\u001a+j[\u0016\u001cH/Y7q)\t\u0001\u0006\u000eC\u0003j#\u0001\u0007\u0001+A\u0002tiJ\f\u0011\u0003\u001d:fa\u0006\u0014Xm\u00113g\u001fB$\u0018n\u001c8t)\u0005i\u0016A\b9sKB\f'/Z*iCJ,7I]3eK:$\u0018.\u00197t\u001fB$\u0018n\u001c8t\u0003e1\u0018\r\\5eCR,wJ\\3Ti\u0006\u0014H/\u001b8h\u001fB$\u0018n\u001c8\u00027Y\fG.\u001b3bi\u0016|e.\u001a+j[\u0016$&/\u0019<fY>\u0003H/[8o\u0001")
public interface DeltaSharingReadOptions
extends DeltaSharingOptionParser {
    public void io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$maxFilesPerTrigger_$eq(Option<Object> var1);

    public void io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$maxBytesPerTrigger_$eq(Option<Object> var1);

    public void io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$maxVersionsPerRpc_$eq(Option<Object> var1);

    public void io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$ignoreChanges_$eq(boolean var1);

    public void io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$ignoreDeletes_$eq(boolean var1);

    public void io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$skipChangeCommits_$eq(boolean var1);

    public void io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$readChangeFeed_$eq(boolean var1);

    public void io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$startingVersion_$eq(Option<DeltaStartingVersion> var1);

    public void io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$startingTimestamp_$eq(Option<String> var1);

    public void io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$cdfOptions_$eq(Map<String, String> var1);

    public void io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$versionAsOf_$eq(Option<Object> var1);

    public void io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$timestampAsOf_$eq(Option<String> var1);

    public void io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$responseFormat_$eq(String var1);

    public void io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$shareCredentialsOptions_$eq(Map<String, String> var1);

    public Option<Object> maxFilesPerTrigger();

    public Option<Object> maxBytesPerTrigger();

    public Option<Object> maxVersionsPerRpc();

    public boolean ignoreChanges();

    public boolean ignoreDeletes();

    public boolean skipChangeCommits();

    public boolean readChangeFeed();

    public Option<DeltaStartingVersion> startingVersion();

    public Option<String> startingTimestamp();

    public Map<String, String> cdfOptions();

    public Option<Object> versionAsOf();

    public Option<String> timestampAsOf();

    public String responseFormat();

    public Map<String, String> shareCredentialsOptions();

    public static /* synthetic */ boolean isTimeTravel$(DeltaSharingReadOptions $this) {
        return $this.isTimeTravel();
    }

    default public boolean isTimeTravel() {
        return this.versionAsOf().isDefined() || this.timestampAsOf().isDefined();
    }

    private String getFormattedTimestamp(String str) {
        String string;
        try {
            Cast qual$1 = new Cast((Expression)Literal$.MODULE$.apply((Object)str), (DataType)TimestampType$.MODULE$, Option$.MODULE$.apply((Object)SQLConf$.MODULE$.get().sessionLocalTimeZone()));
            InternalRow x$1 = qual$1.eval$default$1();
            Object castResult = qual$1.eval(x$1);
            if (castResult == null) {
                throw DeltaSharingErrors$.MODULE$.timestampInvalid(str);
            }
            string = DateTimeUtils$.MODULE$.toJavaTimestamp(Predef$.MODULE$.Long2long((Long)castResult)).toInstant().toString();
        }
        catch (Exception exception) {
            throw DeltaSharingErrors$.MODULE$.timestampInvalid(str);
        }
        return string;
    }

    private Map<String, String> prepareCdfOptions() {
        if (this.readChangeFeed()) {
            return (Map)((MapOps)DeltaSharingOptions$.MODULE$.validCdfOptions().filter((Function1 & Serializable)option -> BoxesRunTime.boxToBoolean((boolean)DeltaSharingReadOptions.$anonfun$prepareCdfOptions$1(this, option)))).map((Function1 & Serializable)option -> {
                block3: {
                    block2: {
                        Object object = option._1();
                        String string = DeltaSharingOptions$.MODULE$.CDF_START_TIMESTAMP();
                        if (!(object == null ? string != null : !object.equals(string))) break block2;
                        Object object2 = option._1();
                        String string2 = DeltaSharingOptions$.MODULE$.CDF_END_TIMESTAMP();
                        if (object2 != null ? !object2.equals(string2) : string2 != null) break block3;
                    }
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(option._1()), (Object)this.getFormattedTimestamp((String)this.options().get((String)option._1()).get()));
                }
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(option._1()), this.options().get((String)option._1()).get());
            });
        }
        return Predef$.MODULE$.Map().empty();
    }

    private Map<String, String> prepareShareCredentialsOptions() {
        return (Map)((MapOps)DeltaSharingOptions$.MODULE$.validShareCredentialsOptions().filter((Function1 & Serializable)option -> BoxesRunTime.boxToBoolean((boolean)DeltaSharingReadOptions.$anonfun$prepareShareCredentialsOptions$1(this, option)))).map((Function1 & Serializable)option -> {
            String key;
            String string = key = (String)option._1();
            String string2 = DeltaSharingOptions$.MODULE$.PROFILE_EXPIRATION_TIME();
            String string3 = string;
            String value = !(string2 != null ? !string2.equals(string3) : string3 != null) ? this.getFormattedTimestamp((String)this.options().get(key).get()) : (String)this.options().get(key).get();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
        });
    }

    private void validateOneStartingOption() {
        if (this.startingTimestamp().isDefined() && this.startingVersion().isDefined()) {
            throw DeltaSharingErrors$.MODULE$.versionAndTimestampBothSetException(DeltaSharingOptions$.MODULE$.STARTING_VERSION_OPTION(), DeltaSharingOptions$.MODULE$.STARTING_TIMESTAMP_OPTION());
        }
    }

    private void validateOneTimeTravelOption() {
        if (this.versionAsOf().isDefined() && this.timestampAsOf().isDefined()) {
            throw DeltaSharingErrors$.MODULE$.versionAndTimestampBothSetException(DeltaSharingOptions$.MODULE$.TIME_TRAVEL_VERSION(), DeltaSharingOptions$.MODULE$.TIME_TRAVEL_TIMESTAMP());
        }
    }

    public static /* synthetic */ int $anonfun$maxFilesPerTrigger$1(String str) {
        return BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(str))).toOption().filter((Function1)(JFunction1.mcZI.sp & Serializable)x$1 -> x$1 > 0).getOrElse((Function0 & Serializable)() -> {
            throw DeltaSharingErrors$.MODULE$.illegalDeltaSharingOptionException(DeltaSharingOptions$.MODULE$.MAX_FILES_PER_TRIGGER_OPTION(), str, "must be a positive integer");
        }));
    }

    public static /* synthetic */ long $anonfun$maxBytesPerTrigger$1(String str) {
        return BoxesRunTime.unboxToLong((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable)() -> JavaUtils.byteStringAs((String)str, (ByteUnit)ByteUnit.BYTE)).toOption().filter((Function1)(JFunction1.mcZJ.sp & Serializable)x$2 -> x$2 > 0L).getOrElse((Function0 & Serializable)() -> {
            throw DeltaSharingErrors$.MODULE$.illegalDeltaSharingOptionException(DeltaSharingOptions$.MODULE$.MAX_BYTES_PER_TRIGGER_OPTION(), str, "must be a size configuration such as '10g'");
        }));
    }

    public static /* synthetic */ int $anonfun$maxVersionsPerRpc$1(String str) {
        return BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(str))).toOption().filter((Function1)(JFunction1.mcZI.sp & Serializable)x$3 -> x$3 > 0).getOrElse((Function0 & Serializable)() -> {
            throw DeltaSharingErrors$.MODULE$.illegalDeltaSharingOptionException(DeltaSharingOptions$.MODULE$.MAX_VERSIONS_PER_RPC(), str, "must be a positive integer");
        }));
    }

    public static /* synthetic */ long $anonfun$versionAsOf$1(String str) {
        return BoxesRunTime.unboxToLong((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable)() -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(str))).toOption().filter((Function1)(JFunction1.mcZJ.sp & Serializable)x$11 -> x$11 >= 0L).getOrElse((Function0 & Serializable)() -> {
            throw DeltaSharingErrors$.MODULE$.illegalDeltaSharingOptionException(DeltaSharingOptions$.MODULE$.TIME_TRAVEL_VERSION(), str, "must be an integer greater than or equal to zero");
        }));
    }

    public static /* synthetic */ boolean $anonfun$prepareCdfOptions$1(DeltaSharingReadOptions $this, Tuple2 option) {
        return $this.options().contains((String)option._1());
    }

    public static /* synthetic */ boolean $anonfun$prepareShareCredentialsOptions$1(DeltaSharingReadOptions $this, Tuple2 option) {
        return $this.options().contains((String)option._1());
    }

    public static void $init$(DeltaSharingReadOptions $this) {
        $this.io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$maxFilesPerTrigger_$eq((Option<Object>)$this.options().get(DeltaSharingOptions$.MODULE$.MAX_FILES_PER_TRIGGER_OPTION()).map((Function1 & Serializable)str -> BoxesRunTime.boxToInteger((int)DeltaSharingReadOptions.$anonfun$maxFilesPerTrigger$1(str))));
        $this.io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$maxBytesPerTrigger_$eq((Option<Object>)$this.options().get(DeltaSharingOptions$.MODULE$.MAX_BYTES_PER_TRIGGER_OPTION()).map((Function1 & Serializable)str -> BoxesRunTime.boxToLong((long)DeltaSharingReadOptions.$anonfun$maxBytesPerTrigger$1(str))));
        $this.io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$maxVersionsPerRpc_$eq((Option<Object>)$this.options().get(DeltaSharingOptions$.MODULE$.MAX_VERSIONS_PER_RPC()).map((Function1 & Serializable)str -> BoxesRunTime.boxToInteger((int)DeltaSharingReadOptions.$anonfun$maxVersionsPerRpc$1(str))));
        $this.io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$ignoreChanges_$eq($this.options().get(DeltaSharingOptions$.MODULE$.IGNORE_CHANGES_OPTION()).exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)$this.toBoolean(x$4, DeltaSharingOptions$.MODULE$.IGNORE_CHANGES_OPTION()))));
        $this.io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$ignoreDeletes_$eq($this.options().get(DeltaSharingOptions$.MODULE$.IGNORE_DELETES_OPTION()).exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)$this.toBoolean(x$5, DeltaSharingOptions$.MODULE$.IGNORE_DELETES_OPTION()))));
        $this.io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$skipChangeCommits_$eq($this.options().get(DeltaSharingOptions$.MODULE$.SKIP_CHANGE_COMMITS_OPTION()).exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)$this.toBoolean(x$6, DeltaSharingOptions$.MODULE$.SKIP_CHANGE_COMMITS_OPTION()))));
        $this.io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$readChangeFeed_$eq($this.options().get(DeltaSharingOptions$.MODULE$.CDF_READ_OPTION()).exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)$this.toBoolean(x$7, DeltaSharingOptions$.MODULE$.CDF_READ_OPTION()))) || $this.options().get(DeltaSharingOptions$.MODULE$.CDF_READ_OPTION_LEGACY()).exists((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)$this.toBoolean(x$8, DeltaSharingOptions$.MODULE$.CDF_READ_OPTION_LEGACY()))));
        $this.io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$startingVersion_$eq((Option<DeltaStartingVersion>)$this.options().get(DeltaSharingOptions$.MODULE$.STARTING_VERSION_OPTION()).map((Function1 & Serializable)x0$1 -> {
            String string = x0$1;
            switch (string == null ? 0 : string.hashCode()) {
                case -1109880953: {
                    if (!"latest".equals(string)) break;
                    return StartingVersionLatest$.MODULE$;
                }
            }
            return (DeltaStartingVersion)Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable)() -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(string))).toOption().filter((Function1)(JFunction1.mcZJ.sp & Serializable)x$9 -> x$9 >= 0L).map((Function1)StartingVersion$.MODULE$).getOrElse((Function0 & Serializable)() -> {
                throw DeltaSharingErrors$.MODULE$.illegalDeltaSharingOptionException(DeltaSharingOptions$.MODULE$.STARTING_VERSION_OPTION(), string, "must be greater than or equal to zero");
            });
        }));
        $this.io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$startingTimestamp_$eq((Option<String>)$this.options().get(DeltaSharingOptions$.MODULE$.STARTING_TIMESTAMP_OPTION()).map((Function1 & Serializable)x$10 -> $this.getFormattedTimestamp((String)x$10)));
        $this.io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$cdfOptions_$eq($this.prepareCdfOptions());
        $this.io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$versionAsOf_$eq((Option<Object>)$this.options().get(DeltaSharingOptions$.MODULE$.TIME_TRAVEL_VERSION()).map((Function1 & Serializable)str -> BoxesRunTime.boxToLong((long)DeltaSharingReadOptions.$anonfun$versionAsOf$1(str))));
        $this.io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$timestampAsOf_$eq((Option<String>)$this.options().get(DeltaSharingOptions$.MODULE$.TIME_TRAVEL_TIMESTAMP()).map((Function1 & Serializable)x$12 -> $this.getFormattedTimestamp((String)x$12)));
        $this.io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$responseFormat_$eq((String)$this.options().get(DeltaSharingOptions$.MODULE$.RESPONSE_FORMAT()).map((Function1 & Serializable)str -> {
            String string = str;
            String string2 = DeltaSharingOptions$.MODULE$.RESPONSE_FORMAT_PARQUET();
            if (string == null ? string2 != null : !string.equals(string2)) {
                String string3 = str;
                String string4 = DeltaSharingOptions$.MODULE$.RESPONSE_FORMAT_DELTA();
                if (string3 == null ? string4 != null : !string3.equals(string4)) {
                    throw DeltaSharingErrors$.MODULE$.illegalDeltaSharingOptionException(DeltaSharingOptions$.MODULE$.RESPONSE_FORMAT(), (String)str, new StringBuilder(35).append("The user input must be one of:{").append(DeltaSharingOptions$.MODULE$.RESPONSE_FORMAT_PARQUET()).append(", ").append(DeltaSharingOptions$.MODULE$.RESPONSE_FORMAT_DELTA()).append("}.").toString());
                }
            }
            return str;
        }).getOrElse((Function0 & Serializable)() -> DeltaSharingOptions$.MODULE$.RESPONSE_FORMAT_PARQUET()));
        $this.io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$shareCredentialsOptions_$eq($this.prepareShareCredentialsOptions());
        $this.validateOneStartingOption();
        $this.validateOneTimeTravelOption();
    }
}

