/*
 * Decompiled with CFR 0.152.
 */
package io.delta.sharing.spark;

import io.delta.sharing.client.DeltaSharingClient;
import io.delta.sharing.client.model.AddFile;
import io.delta.sharing.client.model.DeltaTableFiles;
import io.delta.sharing.client.model.DeltaTableMetadata;
import io.delta.sharing.client.model.Metadata;
import io.delta.sharing.client.model.Protocol;
import io.delta.sharing.client.model.Table;
import io.delta.sharing.client.util.ConfUtils$;
import io.delta.sharing.spark.DeltaTableUtils$;
import io.delta.sharing.spark.RemoteDeltaLog$;
import io.delta.sharing.spark.RemoteDeltaSnapshotFileIndex;
import io.delta.sharing.spark.RemoteSnapshot$;
import io.delta.sharing.spark.util.QueryUtils$;
import io.delta.sharing.spark.util.SchemaUtils$;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.delta.sharing.CachedTableManager$;
import org.apache.spark.delta.sharing.TableRefreshResult;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.DeltaSharingScanUtils$;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.SQLImplicits;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\u0005]g\u0001\u0002\u000f\u001e\u0001\u0019B\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\"Aq\t\u0001B\u0001B\u0003%\u0001\n\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003P\u0011!)\u0006A!A!\u0002\u00131\u0006\u0002\u00032\u0001\u0005\u0003\u0005\u000b\u0011B2\t\u000b\u001d\u0004A\u0011\u00015\t\u000by\u0001A\u0011C9\t\u0011q\u0004\u0001R1A\u0005\nuD!B \u0001\u0011\u0002#\u001d\r\u0015\"\u0003\u0000\u0011)\t\u0019\u0002\u0001EC\u0002\u0013\u0005\u0011Q\u0003\u0005\u000b\u0003/\u0001\u0001R1A\u0005\u0002\u0005e\u0001BCA\u000e\u0001!\u0015\r\u0011\"\u0001\u0002\u001e!Q\u0011q\u0004\u0001\t\u0006\u0004%\t!!\t\t\u0015\u0005=\u0002\u0001#b\u0001\n\u0003\t\t\u0003C\u0004\u00022\u0001!\t!a\r\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002H!Q\u0011\u0011\n\u0001\t\u0006\u0004%\t!!\b\t\u000f\u0005-\u0003\u0001\"\u0003\u0002N!9\u0011\u0011\f\u0001\u0005\n\u0005m\u0003bBA1\u0001\u0011\u0005\u00111M\u0004\n\u0003Wk\u0012\u0011!E\u0001\u0003[3\u0001\u0002H\u000f\u0002\u0002#\u0005\u0011q\u0016\u0005\u0007O^!\t!!-\t\u0013\u0005Mv#%A\u0005\u0002\u0005U\u0006\"CAf/E\u0005I\u0011AAg\u0011%\t\tnFI\u0001\n\u0003\t\u0019N\u0001\bSK6|G/Z*oCB\u001c\bn\u001c;\u000b\u0005yy\u0012!B:qCJ\\'B\u0001\u0011\"\u0003\u001d\u0019\b.\u0019:j]\u001eT!AI\u0012\u0002\u000b\u0011,G\u000e^1\u000b\u0003\u0011\n!![8\u0004\u0001M\u0019\u0001aJ\u0017\u0011\u0005!ZS\"A\u0015\u000b\u0003)\nQa]2bY\u0006L!\u0001L\u0015\u0003\r\u0005s\u0017PU3g!\tqc'D\u00010\u0015\t\u0001\u0014'\u0001\u0005j]R,'O\\1m\u0015\tq\"G\u0003\u00024i\u00051\u0011\r]1dQ\u0016T\u0011!N\u0001\u0004_J<\u0017BA\u001c0\u0005\u001daunZ4j]\u001e\f\u0011\u0002^1cY\u0016\u0004\u0016\r\u001e5\u0011\u0005izT\"A\u001e\u000b\u0005qj\u0014A\u00014t\u0015\tq$'\u0001\u0004iC\u0012|w\u000e]\u0005\u0003\u0001n\u0012A\u0001U1uQ\u000611\r\\5f]R\u0004\"aQ#\u000e\u0003\u0011S!!Q\u0010\n\u0005\u0019#%A\u0005#fYR\f7\u000b[1sS:<7\t\\5f]R\fQ\u0001^1cY\u0016\u0004\"!\u0013'\u000e\u0003)S!a\u0013#\u0002\u000b5|G-\u001a7\n\u00055S%!\u0002+bE2,\u0017a\u0003<feNLwN\\!t\u001f\u001a\u00042\u0001\u000b)S\u0013\t\t\u0016F\u0001\u0004PaRLwN\u001c\t\u0003QMK!\u0001V\u0015\u0003\t1{gnZ\u0001\u000ei&lWm\u001d;b[B\f5o\u00144\u0011\u0007!\u0002v\u000b\u0005\u0002Y?:\u0011\u0011,\u0018\t\u00035&j\u0011a\u0017\u0006\u00039\u0016\na\u0001\u0010:p_Rt\u0014B\u00010*\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001-\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005yK\u0013AF5oSR$U\r\u001c;b)\u0006\u0014G.Z'fi\u0006$\u0017\r^1\u0011\u0007!\u0002F\r\u0005\u0002JK&\u0011aM\u0013\u0002\u0013\t\u0016dG/\u0019+bE2,W*\u001a;bI\u0006$\u0018-\u0001\u0004=S:LGO\u0010\u000b\bS.dWN\\8q!\tQ\u0007!D\u0001\u001e\u0011\u0015At\u00011\u0001:\u0011\u0015\tu\u00011\u0001C\u0011\u00159u\u00011\u0001I\u0011\u001dqu\u0001%AA\u0002=Cq!V\u0004\u0011\u0002\u0003\u0007a\u000bC\u0004c\u000fA\u0005\t\u0019A2\u0016\u0003I\u0004\"a]=\u000f\u0005Q<X\"A;\u000b\u0005Y\f\u0014aA:rY&\u0011\u00010^\u0001\r'B\f'o[*fgNLwN\\\u0005\u0003un\u0014qaU3tg&|gN\u0003\u0002yk\u0006iA/\u00192mK6+G/\u00193bi\u0006,\u0012\u0001Z\u0001\u0004q\u0012\u001aTCAA\u0001!!A\u00131AA\u0004\u0003\u001b\u0011\u0016bAA\u0003S\t1A+\u001e9mKN\u00022!SA\u0005\u0013\r\tYA\u0013\u0002\t\u001b\u0016$\u0018\rZ1uCB\u0019\u0011*a\u0004\n\u0007\u0005E!J\u0001\u0005Qe>$xnY8m\u0003!iW\r^1eCR\fWCAA\u0004\u0003!\u0001(o\u001c;pG>dWCAA\u0007\u0003\u001d1XM]:j_:,\u0012AU\u0001\u0007g\u000eDW-\\1\u0016\u0005\u0005\r\u0002\u0003BA\u0013\u0003Wi!!a\n\u000b\u0007\u0005%R/A\u0003usB,7/\u0003\u0003\u0002.\u0005\u001d\"AC*ueV\u001cG\u000fV=qK\u0006y\u0001/\u0019:uSRLwN\\*dQ\u0016l\u0017-\u0001\u0006gS2,gi\u001c:nCR,\"!!\u000e\u0011\t\u0005]\u0012\u0011I\u0007\u0003\u0003sQA!a\u000f\u0002>\u0005YA-\u0019;bg>,(oY3t\u0015\r\ty$^\u0001\nKb,7-\u001e;j_:LA!a\u0011\u0002:\tQa)\u001b7f\r>\u0014X.\u0019;\u0002\u0019\u001d,G\u000fV1cY\u0016\u0004\u0016\r\u001e5\u0016\u0003e\n1b]5{K&s')\u001f;fg\u000612\r[3dWB\u0013x\u000e^8d_2tu\u000e^\"iC:<W\r\u0006\u0003\u0002P\u0005U\u0003c\u0001\u0015\u0002R%\u0019\u00111K\u0015\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003/\u001a\u0002\u0019AA\u0007\u0003-qWm\u001e)s_R|7m\u001c7\u0002)\rDWmY6TG\",W.\u0019(pi\u000eC\u0017M\\4f)\u0011\ty%!\u0018\t\u000f\u0005}C\u00031\u0001\u0002\b\u0005Ya.Z<NKR\fG-\u0019;b\u000311\u0017\u000e\\3t\r>\u00148kY1o))\t)'a!\u0002\u001a\u0006u\u0015\u0011\u0015\t\u0007Q\u0005\u001d\u00141N,\n\u0007\u0005%\u0014F\u0001\u0004UkBdWM\r\t\u0007\u0003[\n9(! \u000f\t\u0005=\u00141\u000f\b\u00045\u0006E\u0014\"\u0001\u0016\n\u0007\u0005U\u0014&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005e\u00141\u0010\u0002\u0004'\u0016\f(bAA;SA\u0019\u0011*a \n\u0007\u0005\u0005%JA\u0004BI\u00124\u0015\u000e\\3\t\u000f\u0005\u0015U\u00031\u0001\u0002\b\u00069a-\u001b7uKJ\u001c\bCBA7\u0003o\nI\t\u0005\u0003\u0002\f\u0006UUBAAG\u0015\u0011\ty)!%\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0004\u0003'+\u0018\u0001C2bi\u0006d\u0017p\u001d;\n\t\u0005]\u0015Q\u0012\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007BBAN+\u0001\u0007q*A\u0005mS6LG\u000fS5oi\"1\u0011qT\u000bA\u0002Y\u000b!C[:p]B\u0013X\rZ5dCR,\u0007*\u001b8ug\"9\u00111U\u000bA\u0002\u0005\u0015\u0016!\u00034jY\u0016Le\u000eZ3y!\rQ\u0017qU\u0005\u0004\u0003Sk\"\u0001\b*f[>$X\rR3mi\u0006\u001cf.\u00199tQ>$h)\u001b7f\u0013:$W\r_\u0001\u000f%\u0016lw\u000e^3T]\u0006\u00048\u000f[8u!\tQwc\u0005\u0002\u0018OQ\u0011\u0011QV\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005]&fA(\u0002:.\u0012\u00111\u0018\t\u0005\u0003{\u000b9-\u0004\u0002\u0002@*!\u0011\u0011YAb\u0003%)hn\u00195fG.,GMC\u0002\u0002F&\n!\"\u00198o_R\fG/[8o\u0013\u0011\tI-a0\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u000b\u0003\u0003\u001fT3AVA]\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%mU\u0011\u0011Q\u001b\u0016\u0004G\u0006e\u0006")
public class RemoteSnapshot
implements Logging {
    private DeltaTableMetadata tableMetadata;
    private Tuple3<Metadata, Protocol, Object> x$3;
    private Metadata metadata;
    private Protocol protocol;
    private long version;
    private StructType schema;
    private StructType partitionSchema;
    private long sizeInBytes;
    private final Path tablePath;
    private final DeltaSharingClient client;
    private final Table table;
    private final Option<Object> versionAsOf;
    private final Option<String> timestampAsOf;
    private Option<DeltaTableMetadata> initDeltaTableMetadata;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static Option<DeltaTableMetadata> $lessinit$greater$default$6() {
        return RemoteSnapshot$.MODULE$.$lessinit$greater$default$6();
    }

    public static Option<String> $lessinit$greater$default$5() {
        return RemoteSnapshot$.MODULE$.$lessinit$greater$default$5();
    }

    public static Option<Object> $lessinit$greater$default$4() {
        return RemoteSnapshot$.MODULE$.$lessinit$greater$default$4();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SparkSession spark() {
        return SparkSession$.MODULE$.active();
    }

    private DeltaTableMetadata tableMetadata$lzycompute() {
        RemoteSnapshot remoteSnapshot = this;
        synchronized (remoteSnapshot) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.tableMetadata = (DeltaTableMetadata)this.initDeltaTableMetadata.getOrElse((Function0 & Serializable)() -> $this.client.getMetadata($this.table, $this.versionAsOf, $this.timestampAsOf));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        this.initDeltaTableMetadata = null;
        return this.tableMetadata;
    }

    private DeltaTableMetadata tableMetadata() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.tableMetadata$lzycompute();
        }
        return this.tableMetadata;
    }

    private Tuple3<Metadata, Protocol, Object> x$3$lzycompute() {
        RemoteSnapshot remoteSnapshot = this;
        synchronized (remoteSnapshot) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Tuple3 tuple3 = new Tuple3((Object)this.tableMetadata().metadata(), (Object)this.tableMetadata().protocol(), (Object)BoxesRunTime.boxToLong((long)this.tableMetadata().version()));
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                Metadata metadata = (Metadata)tuple3._1();
                Protocol protocol = (Protocol)tuple3._2();
                long version = BoxesRunTime.unboxToLong((Object)tuple3._3());
                this.x$3 = new Tuple3((Object)metadata, (Object)protocol, (Object)BoxesRunTime.boxToLong((long)version));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.x$3;
    }

    private /* synthetic */ Tuple3 x$3() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.x$3$lzycompute();
        }
        return this.x$3;
    }

    private Metadata metadata$lzycompute() {
        RemoteSnapshot remoteSnapshot = this;
        synchronized (remoteSnapshot) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.metadata = (Metadata)this.x$3()._1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.metadata;
    }

    public Metadata metadata() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.metadata$lzycompute();
        }
        return this.metadata;
    }

    private Protocol protocol$lzycompute() {
        RemoteSnapshot remoteSnapshot = this;
        synchronized (remoteSnapshot) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.protocol = (Protocol)this.x$3()._2();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.protocol;
    }

    public Protocol protocol() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.protocol$lzycompute();
        }
        return this.protocol;
    }

    private long version$lzycompute() {
        RemoteSnapshot remoteSnapshot = this;
        synchronized (remoteSnapshot) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.version = BoxesRunTime.unboxToLong((Object)this.x$3()._3());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.version;
    }

    public long version() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.version$lzycompute();
        }
        return this.version;
    }

    private StructType schema$lzycompute() {
        RemoteSnapshot remoteSnapshot = this;
        synchronized (remoteSnapshot) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.schema = DeltaTableUtils$.MODULE$.toSchema(this.metadata().schemaString());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.schema;
    }

    public StructType schema() {
        if ((byte)(this.bitmap$0 & 0x20) == 0) {
            return this.schema$lzycompute();
        }
        return this.schema;
    }

    private StructType partitionSchema$lzycompute() {
        RemoteSnapshot remoteSnapshot = this;
        synchronized (remoteSnapshot) {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                this.partitionSchema = new StructType((StructField[])((IterableOnceOps)this.metadata().partitionColumns().map((Function1 & Serializable)c -> this.schema().apply(c))).toArray(ClassTag$.MODULE$.apply(StructField.class)));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
            }
        }
        return this.partitionSchema;
    }

    public StructType partitionSchema() {
        if ((byte)(this.bitmap$0 & 0x40) == 0) {
            return this.partitionSchema$lzycompute();
        }
        return this.partitionSchema;
    }

    public FileFormat fileFormat() {
        return new ParquetFileFormat();
    }

    public Path getTablePath() {
        return this.tablePath;
    }

    private long sizeInBytes$lzycompute() {
        RemoteSnapshot remoteSnapshot = this;
        synchronized (remoteSnapshot) {
            if ((byte)(this.bitmap$0 & 0x80) == 0) {
                long l;
                if (this.metadata().size() != null) {
                    l = Predef$.MODULE$.Long2long(this.metadata().size());
                } else {
                    this.log().warn(new StringBuilder(52).append("Getting table size from a full file scan for table: ").append(this.table).toString());
                    DeltaTableFiles tableFiles = this.client.getFiles(this.table, (Seq<String>)Nil$.MODULE$, (Option<Object>)None$.MODULE$, this.versionAsOf, this.timestampAsOf, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
                    this.checkProtocolNotChange(tableFiles.protocol());
                    this.checkSchemaNotChange(tableFiles.metadata());
                    l = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)tableFiles.files().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.size()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                }
                this.sizeInBytes = l;
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x80);
            }
        }
        return this.sizeInBytes;
    }

    public long sizeInBytes() {
        if ((byte)(this.bitmap$0 & 0x80) == 0) {
            return this.sizeInBytes$lzycompute();
        }
        return this.sizeInBytes;
    }

    private void checkProtocolNotChange(Protocol newProtocol) {
        Protocol protocol = newProtocol;
        Protocol protocol2 = this.protocol();
        if (protocol == null ? protocol2 != null : !((Object)protocol).equals(protocol2)) {
            throw new SparkException("The table protocol has changed since your DataFrame was created. Please redefine your DataFrame");
        }
    }

    private void checkSchemaNotChange(Metadata newMetadata) {
        block6: {
            SparkException schemaChangedException;
            block5: {
                schemaChangedException = new SparkException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("The schema or partition columns of your Delta table has changed since your\n         |DataFrame was created. Please redefine your DataFrame")));
                if (ConfUtils$.MODULE$.structuralSchemaMatchingEnabled(this.spark().sessionState().conf())) {
                    StructType newSchema = (StructType)DataType$.MODULE$.fromJson(newMetadata.schemaString());
                    StructType currentSchema = (StructType)DataType$.MODULE$.fromJson(this.metadata().schemaString());
                    Seq<String> seq = this.metadata().partitionColumns();
                    Seq<String> seq2 = newMetadata.partitionColumns();
                    if ((seq != null ? !seq.equals(seq2) : seq2 != null) || !SchemaUtils$.MODULE$.isReadCompatible(currentSchema, newSchema)) {
                        throw schemaChangedException;
                    }
                    return;
                }
                String string = newMetadata.schemaString();
                String string2 = this.metadata().schemaString();
                if (string != null ? !string.equals(string2) : string2 != null) break block5;
                Seq<String> seq = newMetadata.partitionColumns();
                Seq<String> seq3 = this.metadata().partitionColumns();
                if (!(seq == null ? seq3 != null : !seq.equals(seq3))) break block6;
            }
            throw schemaChangedException;
        }
    }

    public Tuple2<Seq<AddFile>, String> filesForScan(Seq<Expression> filters, Option<Object> limitHint, Option<String> jsonPredicateHints, RemoteDeltaSnapshotFileIndex fileIndex) {
        Encoder<AddFile> enc = RemoteDeltaLog$.MODULE$.addFileEncoder();
        Seq partitionFilters = (Seq)filters.flatMap((Function1 & Serializable)filter -> (Seq)DeltaTableUtils$.MODULE$.splitMetadataAndDataPredicates((Expression)filter, this.metadata().partitionColumns(), this.spark())._1());
        Seq<Expression> rewrittenFilters = DeltaTableUtils$.MODULE$.rewritePartitionFilters(this.partitionSchema(), (Function2<String, String, Object>)this.spark().sessionState().conf().resolver(), (Seq<Expression>)partitionFilters, this.spark().sessionState().conf().sessionLocalTimeZone());
        Seq predicates = (Seq)rewrittenFilters.map((Function1 & Serializable)x$5 -> x$5.sql());
        if (predicates.nonEmpty()) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Sending predicates ").append(predicates).append(" to the server").toString());
        }
        SQLImplicits implicits = this.spark().implicits();
        DeltaTableFiles tableFiles = this.client.getFiles(this.table, (Seq<String>)predicates, limitHint, this.versionAsOf, this.timestampAsOf, jsonPredicateHints, (Option<String>)None$.MODULE$);
        String queryParamsHashId = QueryUtils$.MODULE$.getQueryParamsHashId((Seq<String>)predicates, limitHint, jsonPredicateHints, tableFiles.version());
        String tablePathWithParams = ConfUtils$.MODULE$.sparkParquetIOCacheEnabled(this.spark().sessionState().conf()) ? QueryUtils$.MODULE$.getTablePathWithIdSuffix(fileIndex.params().path().toString(), queryParamsHashId) : fileIndex.params().path().toString();
        ObjectRef minUrlExpirationTimestamp = ObjectRef.create((Object)None$.MODULE$);
        scala.collection.immutable.Map idToUrl = ((IterableOnceOps)tableFiles.files().map((Function1 & Serializable)file -> {
            block0: {
                if (file.expirationTimestamp() == null) break block0;
                minUrlExpirationTimestamp$1.elem = ((Option)minUrlExpirationTimestamp$1.elem).isDefined() && BoxesRunTime.unboxToLong((Object)((Option)minUrlExpirationTimestamp$1.elem).get()) < Predef$.MODULE$.Long2long(file.expirationTimestamp()) ? (Option)minUrlExpirationTimestamp$1.elem : new Some((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(file.expirationTimestamp())));
            }
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)file.id()), (Object)file.url());
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        CachedTableManager$.MODULE$.INSTANCE().register(tablePathWithParams, (scala.collection.immutable.Map<String, String>)idToUrl, (Seq<WeakReference<Object>>)new .colon.colon(new WeakReference<RemoteDeltaSnapshotFileIndex>(fileIndex), (List)Nil$.MODULE$), fileIndex.params().profileProvider(), (Function1<Option<String>, TableRefreshResult>)(Function1 & Serializable)refreshToken -> {
            DeltaTableFiles tableFiles = $this.client.getFiles($this.table, (Seq<String>)Nil$.MODULE$, (Option<Object>)None$.MODULE$, $this.versionAsOf, $this.timestampAsOf, jsonPredicateHints, (Option<String>)refreshToken);
            ObjectRef minUrlExpiration = ObjectRef.create((Object)None$.MODULE$);
            scala.collection.immutable.Map idToUrl = ((IterableOnceOps)tableFiles.files().map((Function1 & Serializable)add -> {
                block0: {
                    if (add.expirationTimestamp() == null) break block0;
                    minUrlExpiration$1.elem = ((Option)minUrlExpiration$1.elem).isDefined() && BoxesRunTime.unboxToLong((Object)((Option)minUrlExpiration$1.elem).get()) < Predef$.MODULE$.Long2long(add.expirationTimestamp()) ? (Option)minUrlExpiration$1.elem : new Some((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(add.expirationTimestamp())));
                }
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)add.id()), (Object)add.url());
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            return new TableRefreshResult((scala.collection.immutable.Map<String, String>)idToUrl, (Option<Object>)((Option)minUrlExpiration.elem), tableFiles.refreshToken());
        }, CachedTableManager$.MODULE$.INSTANCE().isValidUrlExpirationTime((Option<Object>)((Option)minUrlExpirationTimestamp.elem)) ? BoxesRunTime.unboxToLong((Object)((Option)minUrlExpirationTimestamp.elem).get()) : System.currentTimeMillis() + CachedTableManager$.MODULE$.INSTANCE().preSignedUrlExpirationMs(), tableFiles.refreshToken(), CachedTableManager$.MODULE$.INSTANCE().register$default$8());
        this.checkProtocolNotChange(tableFiles.protocol());
        this.checkSchemaNotChange(tableFiles.metadata());
        Tuple2 tuple2 = new Tuple2((Object)implicits.localSeqToDatasetHolder(tableFiles.files(), enc).toDS(), (Object)queryParamsHashId);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Dataset remoteFiles = (Dataset)tuple2._1();
        String queryParamsHashId2 = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)remoteFiles, (Object)queryParamsHashId2);
        Dataset remoteFiles2 = (Dataset)tuple22._1();
        String queryParamsHashId3 = (String)tuple22._2();
        Column columnFilter = DeltaSharingScanUtils$.MODULE$.toColumn((Expression)rewrittenFilters.reduceLeftOption((Function2)And$.MODULE$).getOrElse((Function0 & Serializable)() -> Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true))));
        return new Tuple2((Object)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(remoteFiles2.filter(columnFilter).as(enc).collect()), (Object)queryParamsHashId3);
    }

    public RemoteSnapshot(Path tablePath, DeltaSharingClient client, Table table, Option<Object> versionAsOf, Option<String> timestampAsOf, Option<DeltaTableMetadata> initDeltaTableMetadata) {
        this.tablePath = tablePath;
        this.client = client;
        this.table = table;
        this.versionAsOf = versionAsOf;
        this.timestampAsOf = timestampAsOf;
        this.initDeltaTableMetadata = initDeltaTableMetadata;
        Logging.$init$((Logging)this);
    }
}

