/*
 * Decompiled with CFR 0.152.
 */
package io.delta.sharing.client;

import io.delta.sharing.client.DeltaSharingFileSystem$;
import io.delta.sharing.client.DeltaSharingFileSystemHttpClient;
import io.delta.sharing.client.DeltaSharingFileSystemHttpClientBuilder;
import io.delta.sharing.client.DeltaSharingFileSystemHttpClientBuilder$;
import io.delta.sharing.client.InMemoryHttpInputStream;
import io.delta.sharing.client.RandomAccessHttpInputStream;
import io.delta.sharing.client.model.FileAction;
import io.delta.sharing.client.util.ConfUtils;
import io.delta.sharing.client.util.ConfUtils$;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.spark.SparkEnv$;
import org.apache.spark.delta.sharing.PreSignedUrlCache$;
import org.apache.spark.delta.sharing.PreSignedUrlFetcher;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.rpc.RpcEndpointRef;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.StringContext;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r\u0005a!\u0002\u001f>\u0001}*\u0005\"\u0002.\u0001\t\u0003a\u0006\u0002C0\u0001\u0011\u000b\u0007I\u0011\u00021\t\u0011\u001d\u0004\u0001R1A\u0005\n!D\u0001\u0002\u001c\u0001\t\u0006\u0004%I\u0001\u0019\u0005\t[\u0002A)\u0019!C\u0005]\"A!\u000f\u0001EC\u0002\u0013%1\u000f\u0003\u0004x\u0001\u0011\u0005q\b\u001f\u0005\ts\u0002A)\u0019!C\u0005Q\"A!\u0010\u0001EC\u0002\u0013%1\u0010C\u0004\u0002\u0006\u0001!\t%a\u0002\t\u000f\u0005}\u0001\u0001\"\u0011\u0002\"!9\u00111\u0007\u0001\u0005B\u0005U\u0002bBA&\u0001\u0011\u0005\u0013Q\n\u0005\b\u0003\u0013\u0003A\u0011IAF\u0011\u001d\t\u0019\n\u0001C!\u0003+Cq!a(\u0001\t\u0003\n\t\u000bC\u0004\u0002*\u0002!\t%a+\t\u000f\u0005m\u0006\u0001\"\u0011\u0002>\"9\u0011\u0011\u001a\u0001\u0005B\u0005-\u0007bBAg\u0001\u0011\u0005\u0013q\u001a\u0005\b\u0003+\u0004A\u0011IAl\u0011\u001d\tY\u000e\u0001C!\u0003;Dq!a8\u0001\t\u0003\nin\u0002\u0005\u0002bvB\taPAr\r\u001daT\b#\u0001@\u0003KDaAW\r\u0005\u0002\u00055\b\"CAx3\t\u0007I\u0011AAy\u0011!\ti0\u0007Q\u0001\n\u0005MhABA\u00003\u0001\u0013\t\u0001\u0003\u0006\u0003\u001cu\u0011)\u001a!C\u0001\u0005;A!Ba\b\u001e\u0005#\u0005\u000b\u0011BA\u0005\u0011)\u0011\t#\bBK\u0002\u0013\u0005!Q\u0004\u0005\u000b\u0005Gi\"\u0011#Q\u0001\n\u0005%\u0001\"\u0003B\u0013;\tU\r\u0011\"\u0001i\u0011%\u00119#\bB\tB\u0003%\u0011\u000e\u0003\u0004[;\u0011\u0005!\u0011\u0006\u0005\b\u0005kiB\u0011\u0001B\u001c\u0011%\u0011I$HA\u0001\n\u0003\u0011Y\u0004C\u0005\u0003Du\t\n\u0011\"\u0001\u0003F!I!1L\u000f\u0012\u0002\u0013\u0005!Q\t\u0005\n\u0005;j\u0012\u0013!C\u0001\u0005?B\u0011Ba\u0019\u001e\u0003\u0003%\t%!=\t\u0011\t\u0015T$!A\u0005\u0002\u0001D\u0011Ba\u001a\u001e\u0003\u0003%\tA!\u001b\t\u0013\tUT$!A\u0005B\t]\u0004\"\u0003BC;\u0005\u0005I\u0011\u0001BD\u0011%\u0011Y)HA\u0001\n\u0003\u0012i\tC\u0005\u0003\u0012v\t\t\u0011\"\u0011\u0003\u0014\"I!QS\u000f\u0002\u0002\u0013\u0005#q\u0013\u0005\n\u00053k\u0012\u0011!C!\u00057;\u0011Ba(\u001a\u0003\u0003E\tA!)\u0007\u0013\u0005}\u0018$!A\t\u0002\t\r\u0006B\u0002.5\t\u0003\u0011I\fC\u0005\u0003\u0016R\n\t\u0011\"\u0012\u0003\u0018\"I!1\u0018\u001b\u0002\u0002\u0013\u0005%Q\u0018\u0005\n\u0005\u000b$\u0014\u0011!CA\u0005\u000fD\u0011B!75\u0003\u0003%IAa7\t\u000f\t\r\u0018\u0004\"\u0001\u0003f\"9!\u0011`\r\u0005\u0002\tm(A\u0006#fYR\f7\u000b[1sS:<g)\u001b7f'f\u001cH/Z7\u000b\u0005yz\u0014AB2mS\u0016tGO\u0003\u0002A\u0003\u000691\u000f[1sS:<'B\u0001\"D\u0003\u0015!W\r\u001c;b\u0015\u0005!\u0015AA5p'\r\u0001aI\u0015\t\u0003\u000fBk\u0011\u0001\u0013\u0006\u0003\u0013*\u000b!AZ:\u000b\u0005-c\u0015A\u00025bI>|\u0007O\u0003\u0002N\u001d\u00061\u0011\r]1dQ\u0016T\u0011aT\u0001\u0004_J<\u0017BA)I\u0005)1\u0015\u000e\\3TsN$X-\u001c\t\u0003'bk\u0011\u0001\u0016\u0006\u0003+Z\u000b\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003/2\u000bQa\u001d9be.L!!\u0017+\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001^!\tq\u0006!D\u0001>\u0003)qW/\u001c*fiJLWm]\u000b\u0002CB\u0011!-Z\u0007\u0002G*\tA-A\u0003tG\u0006d\u0017-\u0003\u0002gG\n\u0019\u0011J\u001c;\u0002-5\f\u0007PU3uef$UO]1uS>tW*\u001b7mSN,\u0012!\u001b\t\u0003E*L!a[2\u0003\t1{gnZ\u0001\u0011i&lWm\\;u\u0013:\u001cVmY8oIN\fQ\u0003\\8h!J,7+[4oK\u0012,&\u000f\\!dG\u0016\u001c8/F\u0001p!\t\u0011\u0007/\u0003\u0002rG\n9!i\\8mK\u0006t\u0017A\u00035uiB\u001cE.[3oiV\tA\u000f\u0005\u0002_k&\u0011a/\u0010\u0002!\t\u0016dG/Y*iCJLgn\u001a$jY\u0016\u001c\u0016p\u001d;f[\"#H\u000f]\"mS\u0016tG/\u0001\tde\u0016\fG/\u001a%uiB\u001cE.[3oiR\tA/\u0001\nsK\u001a\u0014Xm\u001d5UQJ,7\u000f[8mI6\u001b\u0018\u0001\u00069sKNKwM\\3e+Jd7)Y2iKJ+g-F\u0001}!\ri\u0018\u0011A\u0007\u0002}*\u0011qPV\u0001\u0004eB\u001c\u0017bAA\u0002}\nq!\u000b]2F]\u0012\u0004x.\u001b8u%\u00164\u0017!C4fiN\u001b\u0007.Z7f)\t\tI\u0001\u0005\u0003\u0002\f\u0005ea\u0002BA\u0007\u0003+\u00012!a\u0004d\u001b\t\t\tBC\u0002\u0002\u0014m\u000ba\u0001\u0010:p_Rt\u0014bAA\fG\u00061\u0001K]3eK\u001aLA!a\u0007\u0002\u001e\t11\u000b\u001e:j]\u001eT1!a\u0006d\u0003\u00199W\r^+sSR\u0011\u00111\u0005\t\u0005\u0003K\ty#\u0004\u0002\u0002()!\u0011\u0011FA\u0016\u0003\rqW\r\u001e\u0006\u0003\u0003[\tAA[1wC&!\u0011\u0011GA\u0014\u0005\r)&+S\u0001\u0005_B,g\u000e\u0006\u0004\u00028\u0005u\u0012q\t\t\u0004\u000f\u0006e\u0012bAA\u001e\u0011\n\tbi\u0015#bi\u0006Le\u000e];u'R\u0014X-Y7\t\u000f\u0005}B\u00021\u0001\u0002B\u0005\ta\rE\u0002H\u0003\u0007J1!!\u0012I\u0005\u0011\u0001\u0016\r\u001e5\t\r\u0005%C\u00021\u0001b\u0003)\u0011WO\u001a4feNK'0Z\u0001\u0007GJ,\u0017\r^3\u0015!\u0005=\u0013QKA,\u0003K\nI'a\u001b\u0002v\u0005e\u0004cA$\u0002R%\u0019\u00111\u000b%\u0003%\u0019\u001bF)\u0019;b\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\b\u0003\u007fi\u0001\u0019AA!\u0011\u001d\tI&\u0004a\u0001\u00037\n!\u0002]3s[&\u001c8/[8o!\u0011\ti&!\u0019\u000e\u0005\u0005}#bAA-\u0011&!\u00111MA0\u0005115\u000fU3s[&\u001c8/[8o\u0011\u0019\t9'\u0004a\u0001_\u0006IqN^3soJLG/\u001a\u0005\u0007\u0003\u0013j\u0001\u0019A1\t\u000f\u00055T\u00021\u0001\u0002p\u0005Y!/\u001a9mS\u000e\fG/[8o!\r\u0011\u0017\u0011O\u0005\u0004\u0003g\u001a'!B*i_J$\bBBA<\u001b\u0001\u0007\u0011.A\u0005cY>\u001c7nU5{K\"9\u00111P\u0007A\u0002\u0005u\u0014\u0001\u00039s_\u001e\u0014Xm]:\u0011\t\u0005}\u0014QQ\u0007\u0003\u0003\u0003S1!a!K\u0003\u0011)H/\u001b7\n\t\u0005\u001d\u0015\u0011\u0011\u0002\r!J|wM]3tg\u0006\u0014G.Z\u0001\u0007CB\u0004XM\u001c3\u0015\u0011\u0005=\u0013QRAH\u0003#Cq!a\u0010\u000f\u0001\u0004\t\t\u0005\u0003\u0004\u0002J9\u0001\r!\u0019\u0005\b\u0003wr\u0001\u0019AA?\u0003\u0019\u0011XM\\1nKR)q.a&\u0002\u001c\"9\u0011\u0011T\bA\u0002\u0005\u0005\u0013aA:sG\"9\u0011QT\bA\u0002\u0005\u0005\u0013a\u00013ti\u00061A-\u001a7fi\u0016$Ra\\AR\u0003KCq!a\u0010\u0011\u0001\u0004\t\t\u0005\u0003\u0004\u0002(B\u0001\ra\\\u0001\ne\u0016\u001cWO]:jm\u0016\f!\u0002\\5tiN#\u0018\r^;t)\u0011\ti+!/\u0011\u000b\t\fy+a-\n\u0007\u0005E6MA\u0003BeJ\f\u0017\u0010E\u0002H\u0003kK1!a.I\u0005)1\u0015\u000e\\3Ti\u0006$Xo\u001d\u0005\b\u0003\u007f\t\u0002\u0019AA!\u0003M\u0019X\r^,pe.Lgn\u001a#je\u0016\u001cGo\u001c:z)\u0011\ty,!2\u0011\u0007\t\f\t-C\u0002\u0002D\u000e\u0014A!\u00168ji\"9\u0011q\u0019\nA\u0002\u0005\u0005\u0013a\u00028fo~#\u0017N]\u0001\u0014O\u0016$xk\u001c:lS:<G)\u001b:fGR|'/\u001f\u000b\u0003\u0003\u0003\na!\\6eSJ\u001cH#B8\u0002R\u0006M\u0007bBA )\u0001\u0007\u0011\u0011\t\u0005\b\u00033\"\u0002\u0019AA.\u000359W\r\u001e$jY\u0016\u001cF/\u0019;vgR!\u00111WAm\u0011\u001d\ty$\u0006a\u0001\u0003\u0003\n\u0001BZ5oC2L'0\u001a\u000b\u0003\u0003\u007f\u000bQa\u00197pg\u0016\fa\u0003R3mi\u0006\u001c\u0006.\u0019:j]\u001e4\u0015\u000e\\3TsN$X-\u001c\t\u0003=f\u00192!GAt!\r\u0011\u0017\u0011^\u0005\u0004\u0003W\u001c'AB!osJ+g\r\u0006\u0002\u0002d\u000611k\u0011%F\u001b\u0016+\"!a=\u0011\t\u0005U\u00181`\u0007\u0003\u0003oTA!!?\u0002,\u0005!A.\u00198h\u0013\u0011\tY\"a>\u0002\u000fM\u001b\u0005*R'FA\t\u0001B)\u001a7uCNC\u0017M]5oOB\u000bG\u000f[\n\b;\u0005\u001d(1\u0001B\u0005!\r\u0011'QA\u0005\u0004\u0005\u000f\u0019'a\u0002)s_\u0012,8\r\u001e\t\u0005\u0005\u0017\u0011)B\u0004\u0003\u0003\u000e\tEa\u0002BA\b\u0005\u001fI\u0011\u0001Z\u0005\u0004\u0005'\u0019\u0017a\u00029bG.\fw-Z\u0005\u0005\u0005/\u0011IB\u0001\u0007TKJL\u0017\r\\5{C\ndWMC\u0002\u0003\u0014\r\f\u0011\u0002^1cY\u0016\u0004\u0016\r\u001e5\u0016\u0005\u0005%\u0011A\u0003;bE2,\u0007+\u0019;iA\u00051a-\u001b7f\u0013\u0012\fqAZ5mK&#\u0007%\u0001\u0005gS2,7+\u001b>f\u0003%1\u0017\u000e\\3TSj,\u0007\u0005\u0006\u0005\u0003,\t=\"\u0011\u0007B\u001a!\r\u0011i#H\u0007\u00023!9!1\u0004\u0013A\u0002\u0005%\u0001b\u0002B\u0011I\u0001\u0007\u0011\u0011\u0002\u0005\u0007\u0005K!\u0003\u0019A5\u0002\rQ|\u0007+\u0019;i+\t\t\t%\u0001\u0003d_BLH\u0003\u0003B\u0016\u0005{\u0011yD!\u0011\t\u0013\tma\u0005%AA\u0002\u0005%\u0001\"\u0003B\u0011MA\u0005\t\u0019AA\u0005\u0011!\u0011)C\nI\u0001\u0002\u0004I\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005\u000fRC!!\u0003\u0003J-\u0012!1\n\t\u0005\u0005\u001b\u00129&\u0004\u0002\u0003P)!!\u0011\u000bB*\u0003%)hn\u00195fG.,GMC\u0002\u0003V\r\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0011IFa\u0014\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!\u0011\r\u0016\u0004S\n%\u0013!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\t-$\u0011\u000f\t\u0004E\n5\u0014b\u0001B8G\n\u0019\u0011I\\=\t\u0011\tMD&!AA\u0002\u0005\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B=!\u0019\u0011YH!!\u0003l5\u0011!Q\u0010\u0006\u0004\u0005\u007f\u001a\u0017AC2pY2,7\r^5p]&!!1\u0011B?\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007=\u0014I\tC\u0005\u0003t9\n\t\u00111\u0001\u0003l\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t\u0019Pa$\t\u0011\tMt&!AA\u0002\u0005\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002C\u0006AAo\\*ue&tw\r\u0006\u0002\u0002t\u00061Q-];bYN$2a\u001cBO\u0011%\u0011\u0019HMA\u0001\u0002\u0004\u0011Y'\u0001\tEK2$\u0018m\u00155be&tw\rU1uQB\u0019!Q\u0006\u001b\u0014\u000bQ\u0012)K!-\u0011\u0017\t\u001d&QVA\u0005\u0003\u0013I'1F\u0007\u0003\u0005SS1Aa+d\u0003\u001d\u0011XO\u001c;j[\u0016LAAa,\u0003*\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0011\t\tM&qW\u0007\u0003\u0005kS1\u0001RA\u0016\u0013\u0011\u00119B!.\u0015\u0005\t\u0005\u0016!B1qa2LH\u0003\u0003B\u0016\u0005\u007f\u0013\tMa1\t\u000f\tmq\u00071\u0001\u0002\n!9!\u0011E\u001cA\u0002\u0005%\u0001B\u0002B\u0013o\u0001\u0007\u0011.A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t%'Q\u001b\t\u0006E\n-'qZ\u0005\u0004\u0005\u001b\u001c'AB(qi&|g\u000e\u0005\u0005c\u0005#\fI!!\u0003j\u0013\r\u0011\u0019n\u0019\u0002\u0007)V\u0004H.Z\u001a\t\u0013\t]\u0007(!AA\u0002\t-\u0012a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!Q\u001c\t\u0005\u0003k\u0014y.\u0003\u0003\u0003b\u0006](AB(cU\u0016\u001cG/\u0001\u0004f]\u000e|G-\u001a\u000b\u0007\u0003\u0003\u00129O!;\t\u000f\tm!\b1\u0001\u0002\n!9!1\u001e\u001eA\u0002\t5\u0018AB1di&|g\u000e\u0005\u0003\u0003p\nUXB\u0001By\u0015\r\u0011\u00190P\u0001\u0006[>$W\r\\\u0005\u0005\u0005o\u0014\tP\u0001\u0006GS2,\u0017i\u0019;j_:\fa\u0001Z3d_\u0012,G\u0003\u0002B\u0016\u0005{DqAa@<\u0001\u0004\t\t%\u0001\u0003qCRD\u0007")
public class DeltaSharingFileSystem
extends FileSystem
implements Logging {
    private int numRetries;
    private long maxRetryDurationMillis;
    private int timeoutInSeconds;
    private boolean logPreSignedUrlAccess;
    private DeltaSharingFileSystemHttpClient httpClient;
    private long refreshThresholdMs;
    private RpcEndpointRef preSignedUrlCacheRef;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static DeltaSharingPath decode(Path path) {
        return DeltaSharingFileSystem$.MODULE$.decode(path);
    }

    public static Path encode(String tablePath, FileAction action) {
        return DeltaSharingFileSystem$.MODULE$.encode(tablePath, action);
    }

    public static String SCHEME() {
        return DeltaSharingFileSystem$.MODULE$.SCHEME();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int numRetries$lzycompute() {
        DeltaSharingFileSystem deltaSharingFileSystem = this;
        synchronized (deltaSharingFileSystem) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.numRetries = ConfUtils$.MODULE$.numRetries(this.getConf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.numRetries;
    }

    private int numRetries() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.numRetries$lzycompute();
        }
        return this.numRetries;
    }

    private long maxRetryDurationMillis$lzycompute() {
        DeltaSharingFileSystem deltaSharingFileSystem = this;
        synchronized (deltaSharingFileSystem) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.maxRetryDurationMillis = ConfUtils$.MODULE$.maxRetryDurationMillis(this.getConf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.maxRetryDurationMillis;
    }

    private long maxRetryDurationMillis() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.maxRetryDurationMillis$lzycompute();
        }
        return this.maxRetryDurationMillis;
    }

    private int timeoutInSeconds$lzycompute() {
        DeltaSharingFileSystem deltaSharingFileSystem = this;
        synchronized (deltaSharingFileSystem) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.timeoutInSeconds = ConfUtils$.MODULE$.timeoutInSeconds(this.getConf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.timeoutInSeconds;
    }

    private int timeoutInSeconds() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.timeoutInSeconds$lzycompute();
        }
        return this.timeoutInSeconds;
    }

    private boolean logPreSignedUrlAccess$lzycompute() {
        DeltaSharingFileSystem deltaSharingFileSystem = this;
        synchronized (deltaSharingFileSystem) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.logPreSignedUrlAccess = ConfUtils$.MODULE$.logPreSignedUrlAccessEnabled(this.getConf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.logPreSignedUrlAccess;
    }

    private boolean logPreSignedUrlAccess() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.logPreSignedUrlAccess$lzycompute();
        }
        return this.logPreSignedUrlAccess;
    }

    private DeltaSharingFileSystemHttpClient httpClient$lzycompute() {
        DeltaSharingFileSystem deltaSharingFileSystem = this;
        synchronized (deltaSharingFileSystem) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.httpClient = this.createHttpClient();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.httpClient;
    }

    private DeltaSharingFileSystemHttpClient httpClient() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.httpClient$lzycompute();
        }
        return this.httpClient;
    }

    public DeltaSharingFileSystemHttpClient createHttpClient() {
        Option<ConfUtils.ProxyConfig> proxyConfigOpt = ConfUtils$.MODULE$.getProxyConfig(this.getConf());
        int maxConnections = ConfUtils$.MODULE$.maxConnections(this.getConf());
        boolean neverUseHttps = ConfUtils$.MODULE$.getNeverUseHttps(this.getConf());
        RequestConfig config = RequestConfig.custom().setConnectTimeout(this.timeoutInSeconds() * 1000).setConnectionRequestTimeout(this.timeoutInSeconds() * 1000).setSocketTimeout(this.timeoutInSeconds() * 1000).build();
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(58).append("Creating delta sharing httpClient with timeoutInSeconds: ").append(this.timeoutInSeconds()).append(".").toString());
        DeltaSharingFileSystemHttpClientBuilder clientBuilder = DeltaSharingFileSystemHttpClientBuilder$.MODULE$.create().setMaxConnTotal(maxConnections).setMaxConnPerRoute(maxConnections).setDefaultRequestConfig(config).disableAutomaticRetries();
        Object object = neverUseHttps ? clientBuilder.setDisableHttps() : BoxedUnit.UNIT;
        proxyConfigOpt.foreach((Function1 & Serializable)proxyConfig -> {
            HttpHost proxy = new HttpHost(proxyConfig.host(), proxyConfig.port());
            clientBuilder.setProxy(proxy);
            return clientBuilder.setNoProxyHosts(proxyConfig.noProxyHosts());
        });
        return clientBuilder.build();
    }

    private long refreshThresholdMs$lzycompute() {
        DeltaSharingFileSystem deltaSharingFileSystem = this;
        synchronized (deltaSharingFileSystem) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.refreshThresholdMs = this.getConf().getLong("spark.delta.sharing.executor.refreshThresholdMs", TimeUnit.MINUTES.toMillis(10L));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.refreshThresholdMs;
    }

    private long refreshThresholdMs() {
        if ((byte)(this.bitmap$0 & 0x20) == 0) {
            return this.refreshThresholdMs$lzycompute();
        }
        return this.refreshThresholdMs;
    }

    private RpcEndpointRef preSignedUrlCacheRef$lzycompute() {
        DeltaSharingFileSystem deltaSharingFileSystem = this;
        synchronized (deltaSharingFileSystem) {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                this.preSignedUrlCacheRef = PreSignedUrlCache$.MODULE$.getEndpointRefInExecutor(SparkEnv$.MODULE$.get());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
            }
        }
        return this.preSignedUrlCacheRef;
    }

    private RpcEndpointRef preSignedUrlCacheRef() {
        if ((byte)(this.bitmap$0 & 0x40) == 0) {
            return this.preSignedUrlCacheRef$lzycompute();
        }
        return this.preSignedUrlCacheRef;
    }

    public String getScheme() {
        return DeltaSharingFileSystem$.MODULE$.SCHEME();
    }

    public URI getUri() {
        return URI.create(new StringBuilder(4).append(DeltaSharingFileSystem$.MODULE$.SCHEME()).append(":///").toString());
    }

    public FSDataInputStream open(Path f, int bufferSize) {
        DeltaSharingPath path = DeltaSharingFileSystem$.MODULE$.decode(f);
        PreSignedUrlFetcher fetcher = new PreSignedUrlFetcher(this.preSignedUrlCacheRef(), path.tablePath(), path.fileId(), this.refreshThresholdMs());
        if (this.getConf().getBoolean("spark.delta.sharing.loadDataFilesInMemory", false)) {
            long start = System.currentTimeMillis();
            FSDataInputStream stream = new FSDataInputStream((InputStream)new InMemoryHttpInputStream(new URI(fetcher.getUrl())));
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(64).append("Took ").append((System.currentTimeMillis() - start) / 1000L).append("s to build ").append("InMemoryHttpInputStream for delta sharing path ").append(path).append(".").toString());
            return stream;
        }
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(83).append("opening delta sharing path [").append(path).append("] with RandomAccessHttpInputStream, ").append("with bufferSize:[").append(bufferSize).append("].").toString());
        return new FSDataInputStream((InputStream)((Object)new RandomAccessHttpInputStream((HttpClient)this.httpClient(), fetcher, path.fileSize(), this.statistics, this.numRetries(), this.maxRetryDurationMillis(), this.logPreSignedUrlAccess())));
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) {
        throw new UnsupportedOperationException("create");
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) {
        throw new UnsupportedOperationException("append");
    }

    public boolean rename(Path src, Path dst) {
        throw new UnsupportedOperationException("rename");
    }

    public boolean delete(Path f, boolean recursive) {
        throw new UnsupportedOperationException("delete");
    }

    public FileStatus[] listStatus(Path f) {
        throw new UnsupportedOperationException("listStatus");
    }

    public void setWorkingDirectory(Path new_dir) {
        throw new UnsupportedOperationException("setWorkingDirectory");
    }

    public Path getWorkingDirectory() {
        return new Path(this.getUri());
    }

    public boolean mkdirs(Path f, FsPermission permission) {
        throw new UnsupportedOperationException("mkdirs");
    }

    public FileStatus getFileStatus(Path f) {
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append("Checking delta sharing file status for path: ").append(f).append(".").toString());
        Path resolved = this.makeQualified(f);
        return new FileStatus(DeltaSharingFileSystem$.MODULE$.decode(resolved).fileSize(), false, 0, 1L, 0L, f);
    }

    public void finalize() {
        try {
            super.finalize();
        }
        finally {
            this.close();
        }
    }

    public void close() {
        try {
            super.close();
        }
        finally {
            this.httpClient().close();
        }
    }

    public DeltaSharingFileSystem() {
        Logging.$init$((Logging)this);
    }

    public static class DeltaSharingPath
    implements Product,
    Serializable {
        private final String tablePath;
        private final String fileId;
        private final long fileSize;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String tablePath() {
            return this.tablePath;
        }

        public String fileId() {
            return this.fileId;
        }

        public long fileSize() {
            return this.fileSize;
        }

        public Path toPath() {
            String encodedTablePath = URLEncoder.encode(this.tablePath(), "UTF-8");
            String encodedFileId = URLEncoder.encode(this.fileId(), "UTF-8");
            return new Path(new StringBuilder(6).append(DeltaSharingFileSystem$.MODULE$.SCHEME()).append(":///").append(encodedTablePath).append("/").append(encodedFileId).append("/").append(this.fileSize()).toString());
        }

        public DeltaSharingPath copy(String tablePath, String fileId, long fileSize) {
            return new DeltaSharingPath(tablePath, fileId, fileSize);
        }

        public String copy$default$1() {
            return this.tablePath();
        }

        public String copy$default$2() {
            return this.fileId();
        }

        public long copy$default$3() {
            return this.fileSize();
        }

        public String productPrefix() {
            return "DeltaSharingPath";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.tablePath();
                }
                case 1: {
                    return this.fileId();
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this.fileSize());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof DeltaSharingPath;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "tablePath";
                }
                case 1: {
                    return "fileId";
                }
                case 2: {
                    return "fileSize";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.tablePath()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.fileId()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.fileSize()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof DeltaSharingPath)) return false;
            boolean bl = true;
            if (!bl) return false;
            DeltaSharingPath deltaSharingPath = (DeltaSharingPath)x$1;
            if (this.fileSize() != deltaSharingPath.fileSize()) return false;
            String string = this.tablePath();
            String string2 = deltaSharingPath.tablePath();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.fileId();
            String string4 = deltaSharingPath.fileId();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (!deltaSharingPath.canEqual(this)) return false;
            return true;
        }

        public DeltaSharingPath(String tablePath, String fileId, long fileSize) {
            this.tablePath = tablePath;
            this.fileId = fileId;
            this.fileSize = fileSize;
            Product.$init$((Product)this);
        }
    }
}

