/*
 * Decompiled with CFR 0.152.
 */
package io.delta.sharing.client;

import io.delta.sharing.client.DeltaSharingClient;
import io.delta.sharing.client.DeltaSharingOptionsProfileProvider;
import io.delta.sharing.client.DeltaSharingProfileProvider;
import io.delta.sharing.client.ParsedDeltaSharingTablePath;
import io.delta.sharing.client.model.EndStreamAction;
import io.delta.sharing.client.model.SingleAction;
import io.delta.sharing.client.util.ConfUtils$;
import io.delta.sharing.client.util.JsonUtils$;
import io.delta.sharing.spark.DeltaSharingServerException;
import io.delta.sharing.spark.MissingEndStreamActionException;
import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.VersionInfo;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.package$;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.internal.SQLConf;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Properties$;
import scala.util.control.NonFatal$;

public final class DeltaSharingRestClient$
implements Logging {
    public static final DeltaSharingRestClient$ MODULE$ = new DeltaSharingRestClient$();
    private static String USER_AGENT;
    private static final String SPARK_STRUCTURED_STREAMING;
    private static final String DELTA_SHARING_CAPABILITIES_HEADER;
    private static final String RESPONSE_TABLE_VERSION_HEADER_KEY;
    private static final String RESPONSE_FORMAT;
    private static final String READER_FEATURES;
    private static final String DELTA_SHARING_CAPABILITIES_ASYNC_READ;
    private static final String DELTA_SHARING_INCLUDE_END_STREAM_ACTION;
    private static final String RESPONSE_FORMAT_DELTA;
    private static final String RESPONSE_FORMAT_PARQUET;
    private static final String DELTA_SHARING_CAPABILITIES_DELIMITER;
    private static transient Logger org$apache$spark$internal$Logging$$log_;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$((Logging)MODULE$);
        SPARK_STRUCTURED_STREAMING = "Delta-Sharing-SparkStructuredStreaming";
        DELTA_SHARING_CAPABILITIES_HEADER = "delta-sharing-capabilities";
        RESPONSE_TABLE_VERSION_HEADER_KEY = "Delta-Table-Version";
        RESPONSE_FORMAT = "responseformat";
        READER_FEATURES = "readerfeatures";
        DELTA_SHARING_CAPABILITIES_ASYNC_READ = "asyncquery";
        DELTA_SHARING_INCLUDE_END_STREAM_ACTION = "includeendstreamaction";
        RESPONSE_FORMAT_DELTA = "delta";
        RESPONSE_FORMAT_PARQUET = "parquet";
        DELTA_SHARING_CAPABILITIES_DELIMITER = ";";
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int $lessinit$greater$default$2() {
        return 120;
    }

    public int $lessinit$greater$default$3() {
        return 3;
    }

    public long $lessinit$greater$default$4() {
        return Long.MAX_VALUE;
    }

    public long $lessinit$greater$default$5() {
        return 1000L;
    }

    public boolean $lessinit$greater$default$6() {
        return false;
    }

    public boolean $lessinit$greater$default$7() {
        return false;
    }

    public String $lessinit$greater$default$8() {
        return this.RESPONSE_FORMAT_PARQUET();
    }

    public String $lessinit$greater$default$9() {
        return "";
    }

    public boolean $lessinit$greater$default$10() {
        return false;
    }

    public int $lessinit$greater$default$11() {
        return 100000;
    }

    public boolean $lessinit$greater$default$12() {
        return false;
    }

    public boolean $lessinit$greater$default$13() {
        return false;
    }

    public long $lessinit$greater$default$14() {
        return 10000L;
    }

    public long $lessinit$greater$default$15() {
        return 600000L;
    }

    public int $lessinit$greater$default$16() {
        return 5;
    }

    public int $lessinit$greater$default$17() {
        return 60;
    }

    public int $lessinit$greater$default$18() {
        return 600;
    }

    public String SPARK_STRUCTURED_STREAMING() {
        return SPARK_STRUCTURED_STREAMING;
    }

    public String DELTA_SHARING_CAPABILITIES_HEADER() {
        return DELTA_SHARING_CAPABILITIES_HEADER;
    }

    public String RESPONSE_TABLE_VERSION_HEADER_KEY() {
        return RESPONSE_TABLE_VERSION_HEADER_KEY;
    }

    public String RESPONSE_FORMAT() {
        return RESPONSE_FORMAT;
    }

    public String READER_FEATURES() {
        return READER_FEATURES;
    }

    public String DELTA_SHARING_CAPABILITIES_ASYNC_READ() {
        return DELTA_SHARING_CAPABILITIES_ASYNC_READ;
    }

    public String DELTA_SHARING_INCLUDE_END_STREAM_ACTION() {
        return DELTA_SHARING_INCLUDE_END_STREAM_ACTION;
    }

    public String RESPONSE_FORMAT_DELTA() {
        return RESPONSE_FORMAT_DELTA;
    }

    public String RESPONSE_FORMAT_PARQUET() {
        return RESPONSE_FORMAT_PARQUET;
    }

    public String DELTA_SHARING_CAPABILITIES_DELIMITER() {
        return DELTA_SHARING_CAPABILITIES_DELIMITER;
    }

    private String USER_AGENT$lzycompute() {
        DeltaSharingRestClient$ deltaSharingRestClient$ = this;
        synchronized (deltaSharingRestClient$) {
            if (!bitmap$0) {
                USER_AGENT = this.liftedTree1$1();
                bitmap$0 = true;
            }
        }
        return USER_AGENT;
    }

    public String USER_AGENT() {
        if (!bitmap$0) {
            return this.USER_AGENT$lzycompute();
        }
        return USER_AGENT;
    }

    public String sparkVersionString() {
        return (String)Option$.MODULE$.apply((Object)SparkEnv$.MODULE$.get()).flatMap((Function1 & Serializable)env -> env.conf().getOption("spark.databricks.clusterUsageTags.sparkVersion")).map((Function1 & Serializable)dbrVersion -> new StringBuilder(19).append("Databricks-Runtime/").append((String)dbrVersion).toString()).getOrElse((Function0 & Serializable)() -> new StringBuilder(6).append("Spark/").append(package$.MODULE$.SPARK_VERSION()).toString());
    }

    public String spaceFreeProperty(String key) {
        String value = System.getProperty(key);
        if (value == null) {
            return "<unknown>";
        }
        return value.replace(' ', '_');
    }

    public ParsedDeltaSharingTablePath parsePath(String path, scala.collection.immutable.Map<String, String> shareCredentialsOptions) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        int shapeIndex = path.lastIndexOf(35);
        SQLConf sqlConf = SparkSession$.MODULE$.active().sessionState().conf();
        if (!ConfUtils$.MODULE$.optionsProfileProviderEnabled(sqlConf)) {
            if (shareCredentialsOptions.nonEmpty()) {
                throw new IllegalArgumentException(new StringBuilder(145).append("DeltaSharingOptionsProfileProvider is disabled. ").append("Please set ").append(ConfUtils$.MODULE$.OPTIONS_PROFILE_PROVIDER_ENABLED_CONF()).append("=true to enable it, ").append("or use a profile file path format: profile_file#share.schema.table").toString());
            }
            if (shapeIndex < 0) {
                throw new IllegalArgumentException(new StringBuilder(103).append("Path ").append(path).append(" is not valid. ").append("you must provide a profile file path in the format: profile_file#share.schema.table").toString());
            }
        }
        if (shareCredentialsOptions.nonEmpty() && shapeIndex < 0) {
            tuple22 = new Tuple2((Object)"", (Object)path);
        } else {
            if (shareCredentialsOptions.nonEmpty() && shapeIndex >= 0) {
                throw new IllegalArgumentException("cannot specify both share credentials options and a profile file path");
            }
            if (shareCredentialsOptions.isEmpty() && shapeIndex < 0) {
                throw new IllegalArgumentException(new StringBuilder(18).append("path ").append(path).append(" is not valid").toString());
            }
            tuple22 = tuple2 = new Tuple2((Object)path.substring(0, shapeIndex), (Object)path.substring(shapeIndex + 1));
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String profileFile = (String)tuple2._1();
        String tablePath = (String)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)profileFile, (Object)tablePath);
        String profileFile2 = (String)tuple23._1();
        String tablePath2 = (String)tuple23._2();
        String[] tableSplits = tablePath2.split("\\.", -1);
        if (tableSplits.length != 3) {
            throw new IllegalArgumentException(new StringBuilder(18).append("path ").append(path).append(" is not valid").toString());
        }
        if (profileFile2.isEmpty() && shareCredentialsOptions.isEmpty() || tableSplits[0].isEmpty() || tableSplits[1].isEmpty() || tableSplits[2].isEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(18).append("path ").append(path).append(" is not valid").toString());
        }
        return new ParsedDeltaSharingTablePath(profileFile2, tableSplits[0], tableSplits[1], tableSplits[2]);
    }

    private EndStreamAction tryParseEndStreamAction(String line) {
        EndStreamAction endStreamAction;
        try {
            endStreamAction = ((SingleAction)JsonUtils$.MODULE$.fromJson(line, ManifestFactory$.MODULE$.classType(SingleAction.class))).endStreamAction();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Failed to parse last line in response as EndStreamAction:").append(line).toString());
                endStreamAction = null;
            }
            throw throwable;
        }
        return endStreamAction;
    }

    private Option<Object> getRespondedIncludeEndStreamActionHeader(scala.collection.immutable.Map<String, String> capabilitiesMap) {
        return capabilitiesMap.get((Object)this.DELTA_SHARING_INCLUDE_END_STREAM_ACTION()).map((Function1 & Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$23))));
    }

    public void checkEndStreamAction(Option<String> capabilities, scala.collection.immutable.Map<String, String> capabilitiesMap, Seq<String> lines, String queryIdForLogging) {
        boolean bl;
        Option<Object> includeEndStreamActionHeader = this.getRespondedIncludeEndStreamActionHeader(capabilitiesMap);
        boolean bl2 = false;
        Some some = null;
        Option<Object> option = includeEndStreamActionHeader;
        if (option instanceof Some) {
            bl2 = true;
            some = (Some)option;
            boolean bl3 = BoxesRunTime.unboxToBoolean((Object)some.value());
            if (bl3) {
                String lastLine = (String)lines.lastOption().getOrElse((Function0 & Serializable)() -> "Empty_Seq_in_checkEndStreamAction");
                EndStreamAction lastEndStreamAction = this.tryParseEndStreamAction(lastLine);
                if (lastEndStreamAction == null) {
                    throw new MissingEndStreamActionException(new StringBuilder(99).append("Client sets ").append(this.DELTA_SHARING_INCLUDE_END_STREAM_ACTION()).append("=true ").append(queryIdForLogging).append(", server responded with the header set to true(").append(capabilities).append(") ").append("and ").append(lines.size()).append(" lines, and last line as [").append(lastLine).append("].").toString());
                }
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append("Successfully verified endStreamAction in the response").append(queryIdForLogging).toString());
                if (lastEndStreamAction.errorMessage() != null) {
                    Option errorCodeOpt = Option$.MODULE$.apply((Object)lastEndStreamAction.httpStatusErrorCode()).map((Function1 & Serializable)x$24 -> BoxesRunTime.boxToInteger((int)x$24));
                    throw new DeltaSharingServerException(new StringBuilder(20).append("Server Exception[").append(errorCodeOpt.getOrElse((Function0 & Serializable)() -> "")).append("]: ").append(lastEndStreamAction.errorMessage()).toString(), (Option<Object>)errorCodeOpt);
                }
                return;
            }
        }
        if (bl2 && !(bl = BoxesRunTime.unboxToBoolean((Object)some.value()))) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(89).append("Client sets ").append(MODULE$.DELTA_SHARING_INCLUDE_END_STREAM_ACTION()).append("=true in the ").append("header, but the server responded with the header set to false(").append(capabilities).append("),").append(queryIdForLogging).toString());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(78).append("Client sets ").append(MODULE$.DELTA_SHARING_INCLUDE_END_STREAM_ACTION()).append("=true in the").append(" header, but server didn't respond with the header(").append(capabilities).append("), ").append(queryIdForLogging).toString());
            return;
        }
        throw new MatchError(option);
    }

    public DeltaSharingClient apply(String profileFile, scala.collection.immutable.Map<String, String> shareCredentialsOptions, boolean forStreaming, String responseFormat, String readerFeatures) {
        DeltaSharingProfileProvider deltaSharingProfileProvider;
        SQLConf sqlConf = SparkSession$.MODULE$.active().sessionState().conf();
        if (!ConfUtils$.MODULE$.optionsProfileProviderEnabled(sqlConf) && shareCredentialsOptions.nonEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(145).append("DeltaSharingOptionsProfileProvider is disabled. ").append("Please set ").append(ConfUtils$.MODULE$.OPTIONS_PROFILE_PROVIDER_ENABLED_CONF()).append("=true to enable it, ").append("or use a profile file path format: profile_file#share.schema.table").toString());
        }
        if (shareCredentialsOptions.nonEmpty()) {
            deltaSharingProfileProvider = new DeltaSharingOptionsProfileProvider(shareCredentialsOptions);
        } else {
            String profileProviderClass = ConfUtils$.MODULE$.profileProviderClass(sqlConf);
            deltaSharingProfileProvider = (DeltaSharingProfileProvider)Class.forName(profileProviderClass).getConstructor(Configuration.class, String.class).newInstance(SparkSession$.MODULE$.active().sessionState().newHadoopConf(), profileFile);
        }
        DeltaSharingOptionsProfileProvider profileProvider = deltaSharingProfileProvider;
        boolean sslTrustAll = ConfUtils$.MODULE$.sslTrustAll(sqlConf);
        int numRetries = ConfUtils$.MODULE$.numRetries(sqlConf);
        long maxRetryDurationMillis = ConfUtils$.MODULE$.maxRetryDurationMillis(sqlConf);
        long retrySleepIntervalMillis = ConfUtils$.MODULE$.retrySleepIntervalMillis(sqlConf);
        int timeoutInSeconds = ConfUtils$.MODULE$.timeoutInSeconds(sqlConf);
        boolean queryTablePaginationEnabled = ConfUtils$.MODULE$.queryTablePaginationEnabled(sqlConf);
        int maxFilesPerReq = ConfUtils$.MODULE$.maxFilesPerQueryRequest(sqlConf);
        boolean useAsyncQuery = ConfUtils$.MODULE$.useAsyncQuery(sqlConf);
        boolean endStreamActionEnabled = ConfUtils$.MODULE$.includeEndStreamAction(sqlConf);
        long asyncQueryMaxDurationMillis = ConfUtils$.MODULE$.asyncQueryTimeout(sqlConf);
        long asyncQueryPollDurationMillis = ConfUtils$.MODULE$.asyncQueryPollIntervalMillis(sqlConf);
        int tokenExchangeMaxRetries = ConfUtils$.MODULE$.tokenExchangeMaxRetries(sqlConf);
        int tokenExchangeMaxRetryDurationInSeconds = ConfUtils$.MODULE$.tokenExchangeMaxRetryDurationInSeconds(sqlConf);
        int tokenRenewalThresholdInSeconds = ConfUtils$.MODULE$.tokenRenewalThresholdInSeconds(sqlConf);
        String clientClass = ConfUtils$.MODULE$.clientClass(sqlConf);
        return (DeltaSharingClient)Class.forName(clientClass).getConstructor(DeltaSharingProfileProvider.class, Integer.TYPE, Integer.TYPE, Long.TYPE, Long.TYPE, Boolean.TYPE, Boolean.TYPE, String.class, String.class, Boolean.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(profileProvider, timeoutInSeconds, numRetries, maxRetryDurationMillis, retrySleepIntervalMillis, sslTrustAll, forStreaming, responseFormat, readerFeatures, queryTablePaginationEnabled, maxFilesPerReq, endStreamActionEnabled, useAsyncQuery, asyncQueryPollDurationMillis, asyncQueryMaxDurationMillis, tokenExchangeMaxRetries, tokenExchangeMaxRetryDurationInSeconds, tokenRenewalThresholdInSeconds);
    }

    public boolean apply$default$3() {
        return false;
    }

    public String apply$default$4() {
        return this.RESPONSE_FORMAT_PARQUET();
    }

    public String apply$default$5() {
        return "";
    }

    private final /* synthetic */ String liftedTree1$1() {
        String string;
        try {
            string = new StringBuilder(38).append(" Hadoop/").append(VersionInfo.getVersion()).append(" ").append(this.spaceFreeProperty("os.name")).append("/").append(this.spaceFreeProperty("os.version")).append(" ").append(this.spaceFreeProperty("java.vm.name")).append("/").append(this.spaceFreeProperty("java.vm.version")).append(" java/").append(this.spaceFreeProperty("java.version")).append(" scala/").append(Properties$.MODULE$.versionNumberString()).append(" java_vendor/").append(this.spaceFreeProperty("java.vendor")).toString();
        }
        catch (Throwable e) {
            this.log().warn("Unable to load version information for Delta Sharing", e);
            string = "Delta-Sharing-Spark/<unknown>";
        }
        return string;
    }

    private DeltaSharingRestClient$() {
    }
}

