/*
 * Decompiled with CFR 0.152.
 */
package io.delta.sharing.client.auth;

import com.fasterxml.jackson.databind.JsonNode;
import io.delta.sharing.client.auth.AuthConfig;
import io.delta.sharing.client.auth.OAuthClient$;
import io.delta.sharing.client.auth.OAuthClientCredentials;
import io.delta.sharing.client.util.JsonUtils$;
import io.delta.sharing.client.util.RetryUtils$;
import io.delta.sharing.client.util.UnexpectedHttpStatus;
import java.io.Serializable;
import java.util.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005E4Qa\u0004\t\u0001%iA\u0001\"\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\ta\u0001\u0011\t\u0011)A\u0005c!AQ\u0007\u0001B\u0001B\u0003%a\u0007\u0003\u0005B\u0001\t\u0005\t\u0015!\u00037\u0011!\u0011\u0005A!A!\u0002\u00131\u0004\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011\u0002#\t\u000b\u001d\u0003A\u0011\u0001%\t\u000bA\u0003A\u0011A)\t\u000bU\u0003A\u0011\u0002,\t\u000be\u0003A\u0011\u0002.\b\u0011\u0005\u0004\u0012\u0011!E\u0001%\t4\u0001b\u0004\t\u0002\u0002#\u0005!c\u0019\u0005\u0006\u000f2!\t\u0001\u001a\u0005\bK2\t\n\u0011\"\u0001g\u0005-y\u0015)\u001e;i\u00072LWM\u001c;\u000b\u0005E\u0011\u0012\u0001B1vi\"T!a\u0005\u000b\u0002\r\rd\u0017.\u001a8u\u0015\t)b#A\u0004tQ\u0006\u0014\u0018N\\4\u000b\u0005]A\u0012!\u00023fYR\f'\"A\r\u0002\u0005%|7C\u0001\u0001\u001c!\tar$D\u0001\u001e\u0015\u0005q\u0012!B:dC2\f\u0017B\u0001\u0011\u001e\u0005\u0019\te.\u001f*fM\u0006Q\u0001\u000e\u001e;q\u00072LWM\u001c;\u0004\u0001A\u0011AEL\u0007\u0002K)\u00111C\n\u0006\u0003O!\nA![7qY*\u0011\u0011FK\u0001\u0005QR$\bO\u0003\u0002,Y\u00051\u0011\r]1dQ\u0016T\u0011!L\u0001\u0004_J<\u0017BA\u0018&\u0005M\u0019En\\:fC\ndW\r\u0013;ua\u000ec\u0017.\u001a8u\u0003)\tW\u000f\u001e5D_:4\u0017n\u001a\t\u0003eMj\u0011\u0001E\u0005\u0003iA\u0011!\"Q;uQ\u000e{gNZ5h\u00035!xn[3o\u000b:$\u0007o\\5oiB\u0011qG\u0010\b\u0003qq\u0002\"!O\u000f\u000e\u0003iR!a\u000f\u0012\u0002\rq\u0012xn\u001c;?\u0013\tiT$\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u007f\u0001\u0013aa\u0015;sS:<'BA\u001f\u001e\u0003!\u0019G.[3oi&#\u0017\u0001D2mS\u0016tGoU3de\u0016$\u0018!B:d_B,\u0007c\u0001\u000fFm%\u0011a)\b\u0002\u0007\u001fB$\u0018n\u001c8\u0002\rqJg.\u001b;?)\u001dI%j\u0013'N\u001d>\u0003\"A\r\u0001\t\u000b\u0005:\u0001\u0019A\u0012\t\u000bA:\u0001\u0019A\u0019\t\u000bU:\u0001\u0019\u0001\u001c\t\u000b\u0005;\u0001\u0019\u0001\u001c\t\u000b\t;\u0001\u0019\u0001\u001c\t\u000f\r;\u0001\u0013!a\u0001\t\u0006\t2\r\\5f]R\u001c%/\u001a3f]RL\u0017\r\\:\u0015\u0003I\u0003\"AM*\n\u0005Q\u0003\"AF(BkRD7\t\\5f]R\u001c%/\u001a3f]RL\u0017\r\\:\u0002/A\f'o]3P\u0003V$\b\u000eV8lK:\u0014Vm\u001d9p]N,GC\u0001*X\u0011\u0015A\u0016\u00021\u00017\u0003!\u0011Xm\u001d9p]N,\u0017aE4fiJ+7\u000f]8og\u0016\f5o\u0015;sS:<GC\u0001\u001c\\\u0011\u0015a&\u00021\u0001^\u0003)AG\u000f\u001e9F]RLG/\u001f\t\u0003=~k\u0011\u0001K\u0005\u0003A\"\u0012!\u0002\u0013;ua\u0016sG/\u001b;z\u0003-y\u0015)\u001e;i\u00072LWM\u001c;\u0011\u0005Ib1C\u0001\u0007\u001c)\u0005\u0011\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$c'F\u0001hU\t!\u0005nK\u0001j!\tQw.D\u0001l\u0015\taW.A\u0005v]\u000eDWmY6fI*\u0011a.H\u0001\u000bC:tw\u000e^1uS>t\u0017B\u00019l\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class OAuthClient {
    private final CloseableHttpClient httpClient;
    private final AuthConfig authConfig;
    private final String tokenEndpoint;
    private final String clientId;
    private final String clientSecret;
    private final Option<String> scope;

    public static Option<String> $lessinit$greater$default$6() {
        return OAuthClient$.MODULE$.$lessinit$greater$default$6();
    }

    public OAuthClientCredentials clientCredentials() {
        String credentials = Base64.getEncoder().encodeToString(new StringBuilder(1).append(this.clientId).append(":").append(this.clientSecret).toString().getBytes("UTF-8"));
        HttpPost post = new HttpPost(this.tokenEndpoint);
        post.setHeader("accept", "application/json");
        post.setHeader("authorization", new StringBuilder(6).append("Basic ").append(credentials).toString());
        post.setHeader("content-type", "application/x-www-form-urlencoded");
        String scopeParam = (String)this.scope.map((Function1 & Serializable)s -> new StringBuilder(7).append("&scope=").append((String)s).toString()).getOrElse((Function0 & Serializable)() -> "");
        String body = new StringBuilder(29).append("grant_type=client_credentials").append(scopeParam).toString();
        post.setEntity((HttpEntity)new StringEntity(body));
        return (OAuthClientCredentials)RetryUtils$.MODULE$.runWithExponentialBackoff(this.authConfig.tokenExchangeMaxRetries(), this.authConfig.tokenExchangeMaxRetryDurationInSeconds() * 1000L, RetryUtils$.MODULE$.runWithExponentialBackoff$default$3(), RetryUtils$.MODULE$.runWithExponentialBackoff$default$4(), (Function0 & Serializable)() -> {
            OAuthClientCredentials oAuthClientCredentials;
            try (CloseableHttpResponse response = null;){
                response = $this.httpClient.execute((HttpUriRequest)post);
                String responseString = this.getResponseAsString(response.getEntity());
                if (response.getStatusLine().getStatusCode() != 200) {
                    throw new UnexpectedHttpStatus(new StringBuilder(89).append("Failed to get OAuth token from token endpoint: ").append("Token Endpoint responded: ").append(response.getStatusLine()).append(" with response: ").append(responseString).toString(), response.getStatusLine().getStatusCode());
                }
                oAuthClientCredentials = this.parseOAuthTokenResponse(responseString);
            }
            return oAuthClientCredentials;
        });
    }

    private OAuthClientCredentials parseOAuthTokenResponse(String response) {
        long l;
        if (response == null || response.isEmpty()) {
            throw new RuntimeException("Empty response from OAuth token endpoint");
        }
        JsonNode jsonNode = JsonUtils$.MODULE$.readTree(response);
        if (!jsonNode.has("access_token") || !jsonNode.get("access_token").isTextual()) {
            throw new RuntimeException("Missing 'access_token' field in OAuth token response");
        }
        if (!jsonNode.has("expires_in")) {
            throw new RuntimeException("Missing 'expires_in' field in OAuth token response");
        }
        JsonNode jsonNode2 = jsonNode.get("expires_in");
        if (jsonNode2.isNumber()) {
            l = jsonNode2.asLong();
        } else if (jsonNode2.isTextual()) {
            try {
                l = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(jsonNode2.asText()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuntimeException("Invalid 'expires_in' field in OAuth token response");
            }
        } else {
            throw new RuntimeException("Invalid 'expires_in' field in OAuth token response");
        }
        long expiresIn = l;
        return new OAuthClientCredentials(jsonNode.get("access_token").asText(), expiresIn, System.currentTimeMillis());
    }

    private String getResponseAsString(HttpEntity httpEntity) {
        if (httpEntity != null) {
            return EntityUtils.toString((HttpEntity)httpEntity);
        }
        return null;
    }

    public OAuthClient(CloseableHttpClient httpClient, AuthConfig authConfig, String tokenEndpoint, String clientId, String clientSecret, Option<String> scope) {
        this.httpClient = httpClient;
        this.authConfig = authConfig;
        this.tokenEndpoint = tokenEndpoint;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.scope = scope;
    }
}

