/*
 * Decompiled with CFR 0.152.
 */
package io.delta.sharing.client.util;

import io.delta.sharing.spark.DeltaSharingExceptionWithErrorCode;
import io.delta.sharing.spark.DeltaSharingExceptionWithErrorCode$;
import io.delta.sharing.spark.MissingEndStreamActionException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Locale;
import java.util.Map;
import org.apache.http.ConnectionClosedException;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.StringContext;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction1;

public final class RetryUtils$
implements Logging {
    public static final RetryUtils$ MODULE$ = new RetryUtils$();
    private static volatile Function1<Object, BoxedUnit> sleeper;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        sleeper = (JFunction1.mcVJ.sp & Serializable)sleepMs -> Thread.sleep(sleepMs);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Function1<Object, BoxedUnit> sleeper() {
        return sleeper;
    }

    public void sleeper_$eq(Function1<Object, BoxedUnit> x$1) {
        sleeper = x$1;
    }

    public <T> T runWithExponentialBackoff(int numRetries, long maxDurationMillis, long retrySleepInterval, Option<Function1<Exception, BoxedUnit>> onError, Function0<T> func) {
        IntRef times = IntRef.create((int)0);
        LongRef sleepMs = LongRef.create((long)retrySleepInterval);
        long startTime = System.currentTimeMillis();
        while (true) {
            ++times.elem;
            long retryStartTime = System.currentTimeMillis();
            try {
                return (T)func.apply();
            }
            catch (Exception e) {
                long totalDuration = System.currentTimeMillis() - startTime;
                long retryDuration = System.currentTimeMillis() - retryStartTime;
                this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Error during retry attempt ").append(times$1.elem).append(", retryDuration=").append(retryDuration).append(", totalDuration=").append(totalDuration).append(" : ").append(e.getMessage()).toString(), (Throwable)e);
                onError.foreach((Function1 & Serializable)x$1 -> {
                    x$1.apply((Object)e);
                    return BoxedUnit.UNIT;
                });
                if (this.shouldRetry(e) && times.elem <= numRetries && totalDuration <= maxDurationMillis) {
                    this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Sleeping ").append(sleepMs$1.elem).append(" ms to retry on error: ").append(e.getMessage()).append(".").toString());
                    this.sleeper().apply$mcVJ$sp(sleepMs.elem);
                    sleepMs.elem *= 2L;
                    continue;
                }
                this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Not retrying delta sharing rpc on error: ").append(e.getMessage()).append(".").toString());
                throw e;
            }
            break;
        }
    }

    public <T> long runWithExponentialBackoff$default$2() {
        return Long.MAX_VALUE;
    }

    public <T> long runWithExponentialBackoff$default$3() {
        return 1000L;
    }

    public <T> Option<Function1<Exception, BoxedUnit>> runWithExponentialBackoff$default$4() {
        return None$.MODULE$;
    }

    public boolean shouldRetry(Throwable t) {
        Option option;
        DeltaSharingExceptionWithErrorCode deltaSharingExceptionWithErrorCode;
        Option<Option<Object>> option2;
        Throwable throwable = t;
        if (throwable instanceof DeltaSharingExceptionWithErrorCode && !(option2 = DeltaSharingExceptionWithErrorCode$.MODULE$.unapply(deltaSharingExceptionWithErrorCode = (DeltaSharingExceptionWithErrorCode)throwable)).isEmpty() && (option = (Option)option2.get()) instanceof Some) {
            Some some = (Some)option;
            int statusCode = BoxesRunTime.unboxToInt((Object)some.value());
            if (statusCode == 429) {
                return true;
            }
            return statusCode >= 500 && statusCode < 600;
        }
        if (throwable instanceof MissingEndStreamActionException) {
            return true;
        }
        if (throwable instanceof SocketTimeoutException) {
            return true;
        }
        if (throwable instanceof SocketException) {
            SocketException socketException = (SocketException)throwable;
            return socketException.getMessage() != null && socketException.getMessage().toLowerCase(Locale.ROOT).contains("connection reset");
        }
        if (throwable instanceof ConnectionClosedException) {
            return false;
        }
        if (throwable instanceof InterruptedException) {
            return false;
        }
        if (throwable instanceof InterruptedIOException) {
            return false;
        }
        return throwable instanceof IOException;
    }

    private RetryUtils$() {
    }
}

