/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.delta.sharing;

import io.delta.sharing.client.DeltaSharingProfileProvider;
import io.delta.sharing.client.util.ConfUtils$;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.spark.delta.sharing.BaseCachedTable;
import org.apache.spark.delta.sharing.CachedTable;
import org.apache.spark.delta.sharing.CachedTableManager$;
import org.apache.spark.delta.sharing.QuerySpecificCachedTable;
import org.apache.spark.delta.sharing.TableRefreshResult;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\t5a\u0001\u0002\u0013&\u0001AB\u0001\"\u0010\u0001\u0003\u0006\u0004%\tA\u0010\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u007f!A1\t\u0001B\u0001B\u0003%q\b\u0003\u0005E\u0001\t\u0015\r\u0011\"\u0001?\u0011!)\u0005A!A!\u0002\u0013y\u0004\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011B \t\u000b\u001d\u0003A\u0011\u0001%\t\u000f=\u0003!\u0019!C\u0005!\"1\u0011\u000e\u0001Q\u0001\nECqA\u001b\u0001C\u0002\u0013%1\u000e\u0003\u0004p\u0001\u0001\u0006I\u0001\u001c\u0005\u0006a\u0002!\t!\u001d\u0005\u0006k\u0002!\tA\u001e\u0005\u0006s\u0002!\tA\u001f\u0005\b\u0003\u000f\u0001A\u0011AA\u0005\u0011\u001d\t\t\u0002\u0001C\u0005\u0003'Aq!a\t\u0001\t\u0013\t)\u0003C\u0004\u00024\u0001!I!!\u000e\t\u000f\u0005e\u0002\u0001\"\u0001\u0002<!9\u0011\u0011\f\u0001\u0005\u0002\u0005m\u0003bBAO\u0001\u0011%\u0011q\u0014\u0005\n\u0003\u0013\u0004\u0011\u0013!C\u0005\u0003\u0017Dq!!9\u0001\t\u0003\t\u0019\u000fC\u0005\u0002v\u0002\t\n\u0011\"\u0001\u0002x\"I\u00111 \u0001\u0012\u0002\u0013\u0005\u00111\u001a\u0005\b\u0003{\u0004A\u0011AA\u0005\u0011\u001d\ty\u0010\u0001C\u0001\u0003\u00139qA!\u0001&\u0011\u0003\u0011\u0019A\u0002\u0004%K!\u0005!Q\u0001\u0005\u0007\u000fv!\tAa\u0002\t\u0011uj\u0002R1A\u0005\nyB\u0001bQ\u000f\t\u0006\u0004%IA\u0010\u0005\t\tvA)\u0019!C\u0005}!Aa)\bEC\u0002\u0013%a\b\u0003\u0006\u0003\nuA)\u0019!C\u0001\u0005\u0017\u0011!cQ1dQ\u0016$G+\u00192mK6\u000bg.Y4fe*\u0011aeJ\u0001\bg\"\f'/\u001b8h\u0015\tA\u0013&A\u0003eK2$\u0018M\u0003\u0002+W\u0005)1\u000f]1sW*\u0011A&L\u0001\u0007CB\f7\r[3\u000b\u00039\n1a\u001c:h\u0007\u0001\u00192\u0001A\u00198!\t\u0011T'D\u00014\u0015\u0005!\u0014!B:dC2\f\u0017B\u0001\u001c4\u0005\u0019\te.\u001f*fMB\u0011\u0001hO\u0007\u0002s)\u0011!(K\u0001\tS:$XM\u001d8bY&\u0011A(\u000f\u0002\b\u0019><w-\u001b8h\u0003a\u0001(/Z*jO:,G-\u0016:m\u000bb\u0004\u0018N]1uS>tWj]\u000b\u0002\u007fA\u0011!\u0007Q\u0005\u0003\u0003N\u0012A\u0001T8oO\u0006I\u0002O]3TS\u001etW\rZ+sY\u0016C\b/\u001b:bi&|g.T:!\u0003Y\u0011XM\u001a:fg\"\u001c\u0005.Z2l\u0013:$XM\u001d<bY6\u001b\u0018A\u0005:fMJ,7\u000f\u001b+ie\u0016\u001c\bn\u001c7e\u001bN\f1C]3ge\u0016\u001c\b\u000e\u00165sKNDw\u000e\u001c3Ng\u0002\n1#\u001a=qSJ,\u0017I\u001a;fe\u0006\u001b7-Z:t\u001bN\fa\u0001P5oSRtD#B%L\u00196s\u0005C\u0001&\u0001\u001b\u0005)\u0003\"B\u001f\b\u0001\u0004y\u0004\"B\"\b\u0001\u0004y\u0004\"\u0002#\b\u0001\u0004y\u0004\"\u0002$\b\u0001\u0004y\u0014!B2bG\",W#A)\u0011\tIK6LZ\u0007\u0002'*\u0011A+V\u0001\u000bG>t7-\u001e:sK:$(B\u0001,X\u0003\u0011)H/\u001b7\u000b\u0003a\u000bAA[1wC&\u0011!l\u0015\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bC\u0001/d\u001d\ti\u0016\r\u0005\u0002_g5\tqL\u0003\u0002a_\u00051AH]8pizJ!AY\u001a\u0002\rA\u0013X\rZ3g\u0013\t!WM\u0001\u0004TiJLgn\u001a\u0006\u0003EN\u0002\"AS4\n\u0005!,#a\u0004\"bg\u0016\u001c\u0015m\u00195fIR\u000b'\r\\3\u0002\r\r\f7\r[3!\u00035\u0011XM\u001a:fg\"$\u0006N]3bIV\tA\u000e\u0005\u0002S[&\u0011an\u0015\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017A\u0004:fMJ,7\u000f\u001b+ie\u0016\fG\rI\u0001\u0005g&TX\rF\u0001s!\t\u00114/\u0003\u0002ug\t\u0019\u0011J\u001c;\u0002#\u001d,G/U;fef\u001cF/\u0019;f'&TX\r\u0006\u0002so\")\u00010\u0004a\u00017\u0006IA/\u00192mKB\u000bG\u000f[\u0001\u0019SN4\u0016\r\\5e+JdW\t\u001f9je\u0006$\u0018n\u001c8US6,GCA>\u007f!\t\u0011D0\u0003\u0002~g\t9!i\\8mK\u0006t\u0007BB@\u000f\u0001\u0004\t\t!\u0001\u0006fqBL'/\u0019;j_:\u0004BAMA\u0002\u007f%\u0019\u0011QA\u001a\u0003\r=\u0003H/[8o\u0003\u001d\u0011XM\u001a:fg\"$\"!a\u0003\u0011\u0007I\ni!C\u0002\u0002\u0010M\u0012A!\u00168ji\u0006IBn\\4ES\u001a4WM]3oG\u0016\u001c()\u001a;xK\u0016tWK\u001d7t)\u0019\tY!!\u0006\u0002 !9\u0011q\u0003\tA\u0002\u0005e\u0011!\u0004:fMJ,7\u000f[3e+Jd7\u000fE\u0003]\u00037Y6,C\u0002\u0002\u001e\u0015\u00141!T1q\u0011\u001d\t\t\u0003\u0005a\u0001\u00033\t!bY1dQ\u0016$WK\u001d7t\u0003aA\u0017M\u001c3mK\u000e\u000b7\r[3e)\u0006\u0014G.\u001a*fMJ,7\u000f\u001b\u000b\u0007\u0003\u0017\t9#!\u000b\t\u000ba\f\u0002\u0019A.\t\u000f\u0005-\u0012\u00031\u0001\u0002.\u0005Y1-Y2iK\u0012$\u0016M\u00197f!\rQ\u0015qF\u0005\u0004\u0003c)#aC\"bG\",G\rV1cY\u0016\fQ\u0005[1oI2,\u0017+^3ssN\u0003XmY5gS\u000e\u001c\u0015m\u00195fIR\u000b'\r\\3SK\u001a\u0014Xm\u001d5\u0015\t\u0005-\u0011q\u0007\u0005\u0006qJ\u0001\raW\u0001\u0010O\u0016$\bK]3TS\u001etW\rZ+sYR1\u0011QHA*\u0003+\u0002B!a\u0010\u0002N9!\u0011\u0011IA$\u001d\rQ\u00151I\u0005\u0004\u0003\u000b*\u0013!\u0005)sKNKwM\\3e+Jd7)Y2iK&!\u0011\u0011JA&\u0003\r\u0011\u0006o\u0019\u0006\u0004\u0003\u000b*\u0013\u0002BA(\u0003#\u0012qcR3u!J,7+[4oK\u0012,&\u000f\u001c*fgB|gn]3\u000b\t\u0005%\u00131\n\u0005\u0006qN\u0001\ra\u0017\u0005\u0007\u0003/\u001a\u0002\u0019A.\u0002\r\u0019LG.Z%e\u00035\u0012XmZ5ti\u0016\u0014\u0018+^3ssN#\u0018\r^3t\u0013:\fV/\u001a:z'B,7-\u001b4jG\u000e\u000b7\r[3e)\u0006\u0014G.\u001a\u000b\t\u0003\u0017\ti&a\u0018\u0002\u0006\")\u0001\u0010\u0006a\u00017\"9\u0011\u0011\r\u000bA\u0002\u0005\r\u0014\u0001\u0002:fMN\u0004b!!\u001a\u0002p\u0005Ud\u0002BA4\u0003Wr1AXA5\u0013\u0005!\u0014bAA7g\u00059\u0001/Y2lC\u001e,\u0017\u0002BA9\u0003g\u00121aU3r\u0015\r\tig\r\t\u0006\u0003o\n\t)M\u0007\u0003\u0003sRA!a\u001f\u0002~\u0005\u0019!/\u001a4\u000b\u0007\u0005}t+\u0001\u0003mC:<\u0017\u0002BAB\u0003s\u0012QbV3bWJ+g-\u001a:f]\u000e,\u0007bBAD)\u0001\u0007\u0011\u0011R\u0001\u0010aJ|g-\u001b7f!J|g/\u001b3feB!\u00111RAM\u001b\t\tiI\u0003\u0003\u0002\u0010\u0006E\u0015AB2mS\u0016tGOC\u0002'\u0003'S1\u0001KAK\u0015\t\t9*\u0001\u0002j_&!\u00111TAG\u0005m!U\r\u001c;b'\"\f'/\u001b8h!J|g-\u001b7f!J|g/\u001b3fe\u0006\u0001#/Z4jgR,'/U;fef\u001c\u0006/Z2jM&\u001c7)Y2iK\u0012$\u0016M\u00197f)I\tY!!)\u0002$\u0006\u001d\u0016\u0011VA^\u0003\u007f\u000b\u0019-!2\t\u000ba,\u0002\u0019A.\t\u000f\u0005\u0015V\u00031\u0001\u0002\u001a\u00059\u0011\u000e\u001a+p+Jd\u0007bBA1+\u0001\u0007\u00111\r\u0005\b\u0003W+\u0002\u0019AAW\u0003%\u0011XM\u001a:fg\",'\u000fE\u00043\u0003_\u000b\u0019,!.\n\u0007\u0005E6GA\u0005Gk:\u001cG/[8ocA!!'a\u0001\\!\rQ\u0015qW\u0005\u0004\u0003s+#A\u0005+bE2,'+\u001a4sKND'+Z:vYRDa!!0\u0016\u0001\u0004y\u0014aE3ya&\u0014\u0018\r^5p]RKW.Z:uC6\u0004\bbBAa+\u0001\u0007\u00111W\u0001\re\u00164'/Z:i)>\\WM\u001c\u0005\b\u0003\u000f+\u0002\u0019AAE\u0011!\t9-\u0006I\u0001\u0002\u0004Y\u0018!F6fKB,&\u000f\\:BMR,'OU3gg\u001e{g.Z\u0001+e\u0016<\u0017n\u001d;feF+XM]=Ta\u0016\u001c\u0017NZ5d\u0007\u0006\u001c\u0007.\u001a3UC\ndW\r\n3fM\u0006,H\u000e\u001e\u00139+\t\tiMK\u0002|\u0003\u001f\\#!!5\u0011\t\u0005M\u0017Q\\\u0007\u0003\u0003+TA!a6\u0002Z\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00037\u001c\u0014AC1o]>$\u0018\r^5p]&!\u0011q\\Ak\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\te\u0016<\u0017n\u001d;feR\u0011\u00121BAs\u0003O\fI/a;\u0002n\u0006=\u0018\u0011_Az\u0011\u0015Ax\u00031\u0001\\\u0011\u001d\t)k\u0006a\u0001\u00033Aq!!\u0019\u0018\u0001\u0004\t\u0019\u0007C\u0004\u0002\b^\u0001\r!!#\t\u000f\u0005-v\u00031\u0001\u0002.\"A\u0011QX\f\u0011\u0002\u0003\u0007q\bC\u0004\u0002B^\u0001\r!a-\t\u0011\u0005\u001dw\u0003%AA\u0002m\f!C]3hSN$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%mU\u0011\u0011\u0011 \u0016\u0004\u007f\u0005=\u0017A\u0005:fO&\u001cH/\u001a:%I\u00164\u0017-\u001e7uIa\nAa\u001d;pa\u0006)1\r\\3be\u0006\u00112)Y2iK\u0012$\u0016M\u00197f\u001b\u0006t\u0017mZ3s!\tQUd\u0005\u0002\u001ecQ\u0011!1A\u0001\t\u0013:\u001bF+\u0011(D\u000bV\t\u0011\n")
public class CachedTableManager
implements Logging {
    private final long preSignedUrlExpirationMs;
    private final long refreshThresholdMs;
    private final long expireAfterAccessMs;
    private final ConcurrentHashMap<String, BaseCachedTable> cache;
    private final ScheduledExecutorService refreshThread;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static CachedTableManager INSTANCE() {
        return CachedTableManager$.MODULE$.INSTANCE();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public long preSignedUrlExpirationMs() {
        return this.preSignedUrlExpirationMs;
    }

    public long refreshThresholdMs() {
        return this.refreshThresholdMs;
    }

    private ConcurrentHashMap<String, BaseCachedTable> cache() {
        return this.cache;
    }

    private ScheduledExecutorService refreshThread() {
        return this.refreshThread;
    }

    public int size() {
        return this.cache().size();
    }

    public int getQueryStateSize(String tablePath) {
        BaseCachedTable cachedTable = this.cache().get(tablePath);
        if (cachedTable == null) {
            throw new IllegalStateException(new StringBuilder(18).append("table ").append(tablePath).append(" was removed").toString());
        }
        BaseCachedTable baseCachedTable = cachedTable;
        if (baseCachedTable instanceof QuerySpecificCachedTable) {
            QuerySpecificCachedTable querySpecificCachedTable = (QuerySpecificCachedTable)baseCachedTable;
            return querySpecificCachedTable.queryStates().size();
        }
        return 0;
    }

    public boolean isValidUrlExpirationTime(Option<Object> expiration) {
        boolean isValid;
        block0: {
            boolean bl = isValid = expiration.isDefined() && BoxesRunTime.unboxToLong((Object)expiration.get()) > System.currentTimeMillis() + this.refreshThresholdMs();
            if (isValid || !expiration.isDefined()) break block0;
            long currentTs = System.currentTimeMillis();
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(81).append("Invalid url expiration timestamp(").append(expiration).append(", ").append(new Date(BoxesRunTime.unboxToLong((Object)expiration.get()))).append("), refreshThresholdMs:").append(this.refreshThresholdMs()).append(", ").append("current timestamp(").append(currentTs).append(", ").append(new Date(currentTs)).append(").").toString());
        }
        return isValid;
    }

    public void refresh() {
        Map.Entry[] snapshot = (Map.Entry[])((IterableOnceOps)JavaConverters$.MODULE$.asScalaSetConverter(this.cache().entrySet()).asScala()).toArray(ClassTag$.MODULE$.apply(Map.Entry.class));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])snapshot), (Function1 & Serializable)entry -> {
            String tablePath = (String)entry.getKey();
            BaseCachedTable cachedTable = (BaseCachedTable)entry.getValue();
            if (cachedTable.lastAccess() + $this.expireAfterAccessMs < System.currentTimeMillis()) {
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(78).append("Removing table ").append(tablePath).append(" from the pre signed url cache as it was not accessed ").append("after ").append($this.expireAfterAccessMs).append(" ms").toString());
                return BoxesRunTime.boxToBoolean((boolean)this.cache().remove(tablePath, cachedTable));
            }
            BaseCachedTable baseCachedTable = cachedTable;
            if (baseCachedTable instanceof CachedTable) {
                CachedTable cachedTable2 = (CachedTable)baseCachedTable;
                this.handleCachedTableRefresh(tablePath, cachedTable2);
            } else if (baseCachedTable instanceof QuerySpecificCachedTable) {
                this.handleQuerySpecificCachedTableRefresh(tablePath);
            } else {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Unknown table type for ").append(tablePath).append(", type ").append(cachedTable.getClass()).append(".").toString());
            }
            return BoxedUnit.UNIT;
        });
    }

    private void logDifferencesBetweenUrls(scala.collection.immutable.Map<String, String> refreshedUrls, scala.collection.immutable.Map<String, String> cachedUrls) {
        if (refreshedUrls.size() != cachedUrls.size()) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("freshen urls size ").append(refreshedUrls.size()).append(" is not equal to ").append("cached urls size ").append(cachedUrls.size()).toString());
        }
        scala.collection.immutable.Set onlyInRefresh = (scala.collection.immutable.Set)refreshedUrls.keySet().diff((Set)cachedUrls.keySet());
        scala.collection.immutable.Set onlyInCached = (scala.collection.immutable.Set)cachedUrls.keySet().diff((Set)refreshedUrls.keySet());
        if (onlyInRefresh.nonEmpty() || onlyInCached.nonEmpty()) {
            if (onlyInRefresh.nonEmpty()) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Keys only in refreshRes.idToUrl: ").append(onlyInRefresh.mkString(", ")).toString());
            }
            if (onlyInCached.nonEmpty()) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("Keys only in cachedTable.idToUrl: ").append(onlyInCached.mkString(", ")).toString());
                return;
            }
            return;
        }
    }

    private void handleCachedTableRefresh(String tablePath, CachedTable cachedTable) {
        if (cachedTable.refs().forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CachedTableManager.$anonfun$handleCachedTableRefresh$1(x$1)))) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(86).append("Removing table ").append(tablePath).append(" from the pre signed url cache as there are").append(" no references pointed to it").toString());
            this.cache().remove(tablePath, cachedTable);
            return;
        }
        if (cachedTable.expiration() - System.currentTimeMillis() < this.refreshThresholdMs()) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Updating pre signed urls for ").append(tablePath).append(" (expiration time: ").append(new Date(cachedTable.expiration())).append("), token:").append(cachedTable.refreshToken()).toString());
            try {
                TableRefreshResult refreshRes = (TableRefreshResult)cachedTable.refresher().apply(cachedTable.refreshToken());
                this.logDifferencesBetweenUrls(refreshRes.idToUrl(), cachedTable.idToUrl());
                long x$12 = this.isValidUrlExpirationTime(refreshRes.expirationTimestamp()) ? BoxesRunTime.unboxToLong((Object)refreshRes.expirationTimestamp().get()) : this.preSignedUrlExpirationMs() + System.currentTimeMillis();
                scala.collection.immutable.Map<String, String> x$2 = refreshRes.idToUrl();
                Seq<WeakReference<Object>> x$3 = cachedTable.refs();
                long x$4 = cachedTable.lastAccess();
                Function1<Option<String>, TableRefreshResult> x$5 = cachedTable.refresher();
                Option<String> x$6 = refreshRes.refreshToken();
                CachedTable newTable = new CachedTable(x$12, x$2, x$4, x$6, x$5, x$3);
                this.cache().replace(tablePath, cachedTable, newTable);
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(39).append("Updated pre signed urls for ").append(tablePath).append(" with size ").append(refreshRes.idToUrl().size()).toString());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (NonFatal$.MODULE$.apply(throwable2)) {
                    this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Failed to refresh pre signed urls for table ").append(tablePath).toString(), throwable2);
                    if (cachedTable.expiration() < System.currentTimeMillis()) {
                        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(61).append("Removing table ").append(tablePath).append(" form cache as the pre signed url have expired").toString());
                        this.cache().remove(tablePath, cachedTable);
                    }
                }
                throw throwable;
            }
            return;
        }
    }

    private void handleQuerySpecificCachedTableRefresh(String tablePath) {
        this.cache().computeIfPresent(tablePath, (x$2, cachedTable) -> {
            BaseCachedTable baseCachedTable = cachedTable;
            if (baseCachedTable instanceof QuerySpecificCachedTable) {
                QuerySpecificCachedTable querySpecificCachedTable = (QuerySpecificCachedTable)baseCachedTable;
                scala.collection.immutable.Map validStates = (scala.collection.immutable.Map)querySpecificCachedTable.queryStates().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CachedTableManager.$anonfun$handleQuerySpecificCachedTableRefresh$2(x0$1)));
                if (validStates.isEmpty()) {
                    if (!querySpecificCachedTable.keepUrlsAfterRefsGone()) {
                        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Removing table ").append(tablePath).append(" as no valid query mappings remain.").toString());
                        return null;
                    }
                    if (querySpecificCachedTable.expiration() - System.currentTimeMillis() < this.refreshThresholdMs()) {
                        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(95).append("Removing table ").append(tablePath).append(" as URLs are about to expire and no valid query ").append("mappings remain to refresh them.").toString());
                        return null;
                    }
                    this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(70).append("Keeping URLs for ").append(tablePath).append(" after all references are gone, URLs are still ").append("valid.").toString());
                    return new QuerySpecificCachedTable(querySpecificCachedTable.expiration(), querySpecificCachedTable.idToUrl(), querySpecificCachedTable.lastAccess(), querySpecificCachedTable.refreshToken(), querySpecificCachedTable.refresher(), (scala.collection.immutable.Map<String, Tuple2<Seq<WeakReference<Object>>, Function2<Option<String>, Function1<Option<String>, TableRefreshResult>, TableRefreshResult>>>)validStates, querySpecificCachedTable.keepUrlsAfterRefsGone());
                }
                if (querySpecificCachedTable.expiration() - System.currentTimeMillis() < this.refreshThresholdMs()) {
                    QuerySpecificCachedTable querySpecificCachedTable2;
                    try {
                        Tuple2 tuple2;
                        Tuple2 tuple22 = (Tuple2)validStates.head();
                        if (tuple22 == null || (tuple2 = (Tuple2)tuple22._2()) == null) {
                            throw new MatchError((Object)tuple22);
                        }
                        Function2 refresherWrapper = (Function2)tuple2._2();
                        Function2 refresherWrapper2 = refresherWrapper;
                        TableRefreshResult refreshRes = (TableRefreshResult)refresherWrapper2.apply(querySpecificCachedTable.refreshToken(), querySpecificCachedTable.refresher());
                        this.logDifferencesBetweenUrls(refreshRes.idToUrl(), querySpecificCachedTable.idToUrl());
                        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append("Updated pre-signed URLs for ").append(tablePath).append(" with size ").append(refreshRes.idToUrl().size()).append(", ").append("validStates: ").append(validStates.size()).append(".").toString());
                        querySpecificCachedTable2 = new QuerySpecificCachedTable(this.isValidUrlExpirationTime(refreshRes.expirationTimestamp()) ? BoxesRunTime.unboxToLong((Object)refreshRes.expirationTimestamp().get()) : this.preSignedUrlExpirationMs() + System.currentTimeMillis(), refreshRes.idToUrl(), querySpecificCachedTable.lastAccess(), refreshRes.refreshToken(), querySpecificCachedTable.refresher(), (scala.collection.immutable.Map<String, Tuple2<Seq<WeakReference<Object>>, Function2<Option<String>, Function1<Option<String>, TableRefreshResult>, TableRefreshResult>>>)validStates, querySpecificCachedTable.keepUrlsAfterRefsGone());
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (NonFatal$.MODULE$.apply(throwable2)) {
                            this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Failed to refresh pre-signed URLs for table ").append(tablePath).toString(), throwable2);
                            if (querySpecificCachedTable.expiration() < System.currentTimeMillis()) {
                                this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Removing table ").append(tablePath).append(" as the pre-signed URL has expired.").toString());
                                querySpecificCachedTable2 = null;
                            } else {
                                querySpecificCachedTable2 = new QuerySpecificCachedTable(querySpecificCachedTable.expiration(), querySpecificCachedTable.idToUrl(), querySpecificCachedTable.lastAccess(), querySpecificCachedTable.refreshToken(), querySpecificCachedTable.refresher(), (scala.collection.immutable.Map<String, Tuple2<Seq<WeakReference<Object>>, Function2<Option<String>, Function1<Option<String>, TableRefreshResult>, TableRefreshResult>>>)validStates, querySpecificCachedTable.keepUrlsAfterRefsGone());
                            }
                        }
                        throw throwable;
                    }
                    return querySpecificCachedTable2;
                }
                return new QuerySpecificCachedTable(querySpecificCachedTable.expiration(), querySpecificCachedTable.idToUrl(), querySpecificCachedTable.lastAccess(), querySpecificCachedTable.refreshToken(), querySpecificCachedTable.refresher(), (scala.collection.immutable.Map<String, Tuple2<Seq<WeakReference<Object>>, Function2<Option<String>, Function1<Option<String>, TableRefreshResult>, TableRefreshResult>>>)validStates, querySpecificCachedTable.keepUrlsAfterRefsGone());
            }
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Unexpected table type for ").append(tablePath).append(". Expected QuerySpecificCachedTable.").toString());
            return cachedTable;
        });
    }

    public Tuple2<String, Object> getPreSignedUrl(String tablePath, String fileId) {
        BaseCachedTable cachedTable = this.cache().get(tablePath);
        if (cachedTable == null) {
            throw new IllegalStateException(new StringBuilder(18).append("table ").append(tablePath).append(" was removed").toString());
        }
        cachedTable.lastAccess_$eq(System.currentTimeMillis());
        String url = (String)cachedTable.idToUrl().getOrElse((Object)fileId, (Function0 & Serializable)() -> {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append(cachedTable.idToUrl().size()).append(" urls in cache ").append("with expiration ").append(new Date(cachedTable.expiration())).toString());
            throw new IllegalStateException(new StringBuilder(33).append("cannot find url for id ").append(fileId).append(" in table ").append(tablePath).toString());
        });
        return new Tuple2((Object)url, (Object)BoxesRunTime.boxToLong((long)cachedTable.expiration()));
    }

    public void registerQueryStatesInQuerySpecificCachedTable(String tablePath, Seq<WeakReference<Object>> refs, DeltaSharingProfileProvider profileProvider) {
        String queryId = (String)profileProvider.getCustomQueryId().getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException("Query ID is not defined.");
        });
        Function2 refresherWrapper = (Function2)profileProvider.getCustomRefresherWrapper().getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException("refresherWrapper is not defined.");
        });
        String customTablePath = profileProvider.getCustomTablePath(tablePath);
        this.cache().computeIfPresent(customTablePath, (x$4, existingTable) -> {
            BaseCachedTable baseCachedTable = existingTable;
            if (baseCachedTable instanceof QuerySpecificCachedTable) {
                QuerySpecificCachedTable querySpecificCachedTable = (QuerySpecificCachedTable)baseCachedTable;
                scala.collection.immutable.Map newQueryStates = (scala.collection.immutable.Map)querySpecificCachedTable.queryStates().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)queryId), (Object)new Tuple2((Object)refs, (Object)refresherWrapper)));
                return new QuerySpecificCachedTable(querySpecificCachedTable.expiration(), querySpecificCachedTable.idToUrl(), querySpecificCachedTable.lastAccess(), querySpecificCachedTable.refreshToken(), querySpecificCachedTable.refresher(), (scala.collection.immutable.Map<String, Tuple2<Seq<WeakReference<Object>>, Function2<Option<String>, Function1<Option<String>, TableRefreshResult>, TableRefreshResult>>>)newQueryStates, true);
            }
            return existingTable;
        });
    }

    private void registerQuerySpecificCachedTable(String tablePath, scala.collection.immutable.Map<String, String> idToUrl, Seq<WeakReference<Object>> refs, Function1<Option<String>, TableRefreshResult> refresher, long expirationTimestamp, Option<String> refreshToken, DeltaSharingProfileProvider profileProvider, boolean keepUrlsAfterRefsGone) {
        Tuple3 tuple3;
        TableRefreshResult refreshRes;
        String queryId = (String)profileProvider.getCustomQueryId().getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException("Query ID is not defined.");
        });
        Function2 refresherWrapper = (Function2)profileProvider.getCustomRefresherWrapper().getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException("refresherWrapper is not defined.");
        });
        if (refs.size() != 1) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(63).append("Multiple references sharing the same QuerySpecificCachedTable: ").append(refs.size()).toString());
        }
        Tuple3 tuple32 = expirationTimestamp - System.currentTimeMillis() < this.refreshThresholdMs() ? (this.isValidUrlExpirationTime((refreshRes = (TableRefreshResult)refresherWrapper.apply(refreshToken, refresher)).expirationTimestamp()) ? new Tuple3(refreshRes.idToUrl(), refreshRes.expirationTimestamp().get(), refreshRes.refreshToken()) : new Tuple3(refreshRes.idToUrl(), (Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() + this.preSignedUrlExpirationMs())), refreshRes.refreshToken())) : (tuple3 = new Tuple3(idToUrl, (Object)BoxesRunTime.boxToLong((long)expirationTimestamp), refreshToken));
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        scala.collection.immutable.Map resolvedIdToUrl = (scala.collection.immutable.Map)tuple3._1();
        long resolvedExpiration = BoxesRunTime.unboxToLong((Object)tuple3._2());
        Option resolvedRefreshToken = (Option)tuple3._3();
        Tuple3 tuple33 = new Tuple3((Object)resolvedIdToUrl, (Object)BoxesRunTime.boxToLong((long)resolvedExpiration), (Object)resolvedRefreshToken);
        scala.collection.immutable.Map resolvedIdToUrl2 = (scala.collection.immutable.Map)tuple33._1();
        long resolvedExpiration2 = BoxesRunTime.unboxToLong((Object)tuple33._2());
        Option resolvedRefreshToken2 = (Option)tuple33._3();
        this.cache().compute(tablePath, (x$6, existingTable) -> {
            scala.collection.immutable.Map map;
            Some some;
            Tuple2 tuple2;
            Option existingQueryState;
            Option option;
            if (existingTable == null) {
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(72).append("Registered a new QuerySpecificCachedTable in cache for table ").append(tablePath).append(", ").append("queryId ").append(queryId).append(".").toString());
                return new QuerySpecificCachedTable(resolvedExpiration2, (scala.collection.immutable.Map<String, String>)resolvedIdToUrl2, System.currentTimeMillis(), (Option<String>)resolvedRefreshToken2, refresher, (scala.collection.immutable.Map<String, Tuple2<Seq<WeakReference<Object>>, Function2<Option<String>, Function1<Option<String>, TableRefreshResult>, TableRefreshResult>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)queryId), (Object)new Tuple2((Object)refs, (Object)refresherWrapper))}))), keepUrlsAfterRefsGone);
            }
            BaseCachedTable baseCachedTable = existingTable;
            if (!(baseCachedTable instanceof QuerySpecificCachedTable)) {
                throw new IllegalStateException(new StringBuilder(88).append("Cache entry type mismatch: existing type is ").append(existingTable.getClass()).append(", ").append("expected type is QuerySpecificCachedTable.").toString());
            }
            QuerySpecificCachedTable querySpecificCachedTable = (QuerySpecificCachedTable)baseCachedTable;
            QuerySpecificCachedTable querySpecificCachedTable2 = querySpecificCachedTable;
            scala.collection.immutable.Map mergedIdToUrl = (scala.collection.immutable.Map)querySpecificCachedTable2.idToUrl().$plus$plus((IterableOnce)resolvedIdToUrl2);
            scala.collection.immutable.Set existingIds = querySpecificCachedTable2.idToUrl().keySet();
            scala.collection.immutable.Set newIds = resolvedIdToUrl2.keySet();
            scala.collection.immutable.Set addedIds = (scala.collection.immutable.Set)newIds.$minus$minus((IterableOnce)existingIds);
            scala.collection.immutable.Set updatedIds = (scala.collection.immutable.Set)newIds.intersect((Set)existingIds);
            scala.collection.immutable.Set preservedIds = (scala.collection.immutable.Set)existingIds.$minus$minus((IterableOnce)newIds);
            if (addedIds.nonEmpty() || updatedIds.nonEmpty() || preservedIds.nonEmpty()) {
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(103).append("Merging URLs for table ").append(tablePath).append(". ").append("Total URLs: ").append(mergedIdToUrl.size()).append(" (existing: ").append(existingIds.size()).append(", ").append("new: ").append(newIds.size()).append(", added: ").append(addedIds.size()).append(", updated: ").append(updatedIds.size()).append(", ").append("preserved: ").append(preservedIds.size()).append("). Query ID: ").append(queryId).append(".").toString());
            }
            if ((option = (existingQueryState = querySpecificCachedTable2.queryStates().get((Object)queryId))) instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                Seq existingRefs = (Seq)tuple2._1();
                Seq mergedRefs = (Seq)((IterableOps)refs.filterNot((Function1 & Serializable)ref -> BoxesRunTime.boxToBoolean((boolean)existingRefs.exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)CachedTableManager.$anonfun$registerQuerySpecificCachedTable$8(ref, x$7)))))).$plus$plus((IterableOnce)existingRefs);
                map = (scala.collection.immutable.Map)querySpecificCachedTable2.queryStates().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)queryId), (Object)new Tuple2((Object)mergedRefs, (Object)refresherWrapper)));
            } else if (None$.MODULE$.equals(option)) {
                map = (scala.collection.immutable.Map)querySpecificCachedTable2.queryStates().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)queryId), (Object)new Tuple2((Object)refs, (Object)refresherWrapper)));
            } else {
                throw new MatchError((Object)option);
            }
            scala.collection.immutable.Map mergedQueryStates = map;
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(127).append("Registered to an existing QuerySpecificCachedTable in cache for table ").append(tablePath).append(", ").append("queryId ").append(queryId).append(", total queryStates: ").append(mergedQueryStates.size()).append(", ").append("refs size after merge: ").append(((SeqOps)((Tuple2)mergedQueryStates.apply((Object)queryId))._1()).size()).append(".").toString());
            return new QuerySpecificCachedTable(preservedIds.nonEmpty() ? RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(resolvedExpiration2), querySpecificCachedTable2.expiration()) : resolvedExpiration2, (scala.collection.immutable.Map<String, String>)mergedIdToUrl, System.currentTimeMillis(), (Option<String>)resolvedRefreshToken2, refresher, (scala.collection.immutable.Map<String, Tuple2<Seq<WeakReference<Object>>, Function2<Option<String>, Function1<Option<String>, TableRefreshResult>, TableRefreshResult>>>)mergedQueryStates, keepUrlsAfterRefsGone);
        });
    }

    public void register(String tablePath, scala.collection.immutable.Map<String, String> idToUrl, Seq<WeakReference<Object>> refs, DeltaSharingProfileProvider profileProvider, Function1<Option<String>, TableRefreshResult> refresher, long expirationTimestamp, Option<String> refreshToken, boolean keepUrlsAfterRefsGone) {
        Tuple3 tuple3;
        Tuple3 tuple32;
        boolean parquetIOCacheEnabled;
        boolean bl;
        String customTablePath = profileProvider.getCustomTablePath(tablePath);
        try {
            bl = ConfUtils$.MODULE$.sparkParquetIOCacheEnabled(SparkSession$.MODULE$.active().sessionState().conf());
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Failed to get sparkParquetIOCacheEnabled, using default value.");
            bl = parquetIOCacheEnabled = false;
        }
        if (parquetIOCacheEnabled && profileProvider.getCustomQueryId().isDefined()) {
            this.registerQuerySpecificCachedTable(customTablePath, idToUrl, refs, refresher, expirationTimestamp, refreshToken, profileProvider, keepUrlsAfterRefsGone);
            return;
        }
        Function1<Option<String>, TableRefreshResult> customRefresher = profileProvider.getCustomRefresher(refresher);
        if (expirationTimestamp - System.currentTimeMillis() < this.refreshThresholdMs()) {
            TableRefreshResult refreshRes = (TableRefreshResult)customRefresher.apply(refreshToken);
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(82).append("Refreshed urls during cache register with old expiration ").append(new Date(expirationTimestamp)).append(", new expiration ").append(refreshRes.expirationTimestamp().map((Function1 & Serializable)x$8 -> CachedTableManager.$anonfun$register$3(BoxesRunTime.unboxToLong((Object)x$8))).getOrElse((Function0 & Serializable)() -> "None")).append(", ").append("lines ").append(refreshRes.idToUrl().size()).toString());
            tuple32 = this.isValidUrlExpirationTime(refreshRes.expirationTimestamp()) ? new Tuple3(refreshRes.idToUrl(), refreshRes.expirationTimestamp().get(), refreshRes.refreshToken()) : new Tuple3(refreshRes.idToUrl(), (Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() + this.preSignedUrlExpirationMs())), refreshRes.refreshToken());
        } else {
            tuple32 = tuple3 = new Tuple3(idToUrl, (Object)BoxesRunTime.boxToLong((long)expirationTimestamp), refreshToken);
        }
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        scala.collection.immutable.Map resolvedIdToUrl = (scala.collection.immutable.Map)tuple3._1();
        long resolvedExpiration = BoxesRunTime.unboxToLong((Object)tuple3._2());
        Option resolvedRefreshToken = (Option)tuple3._3();
        Tuple3 tuple33 = new Tuple3((Object)resolvedIdToUrl, (Object)BoxesRunTime.boxToLong((long)resolvedExpiration), (Object)resolvedRefreshToken);
        scala.collection.immutable.Map resolvedIdToUrl2 = (scala.collection.immutable.Map)tuple33._1();
        long resolvedExpiration2 = BoxesRunTime.unboxToLong((Object)tuple33._2());
        Option resolvedRefreshToken2 = (Option)tuple33._3();
        long x$1 = resolvedExpiration2;
        scala.collection.immutable.Map x$2 = resolvedIdToUrl2;
        Seq<WeakReference<Object>> x$3 = refs;
        long x$4 = System.currentTimeMillis();
        Function1<Option<String>, TableRefreshResult> x$5 = customRefresher;
        Option x$6 = resolvedRefreshToken2;
        CachedTable cachedTable = new CachedTable(x$1, (scala.collection.immutable.Map<String, String>)x$2, x$4, (Option<String>)x$6, x$5, x$3);
        BaseCachedTable oldTable = this.cache().putIfAbsent(customTablePath, cachedTable);
        if (oldTable == null) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(43).append("Registered a new entry in cache for table ").append(customTablePath).append(".").toString());
            return;
        }
        BaseCachedTable baseCachedTable = oldTable;
        if (!(baseCachedTable instanceof CachedTable)) {
            throw new IllegalStateException(new StringBuilder(75).append("Cache entry type mismatch: existing type is ").append(oldTable.getClass()).append(", ").append("expected type is CachedTable.").toString());
        }
        CachedTable cachedTable2 = (CachedTable)baseCachedTable;
        CachedTable oldCachedTable = cachedTable2;
        do {
            long x$7 = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(cachedTable.expiration()), oldTable.expiration());
            scala.collection.immutable.Map x$8 = (scala.collection.immutable.Map)oldTable.idToUrl().$plus$plus(cachedTable.idToUrl());
            Seq x$9 = (Seq)((IterableOps)refs.filterNot((Function1 & Serializable)ref -> BoxesRunTime.boxToBoolean((boolean)CachedTableManager.$anonfun$register$6(oldCachedTable, ref)))).$plus$plus(oldCachedTable.refs());
            long x$10 = System.currentTimeMillis();
            Function1<Option<String>, TableRefreshResult> x$11 = customRefresher;
            Option<String> x$12 = cachedTable.refreshToken();
            CachedTable mergedTable = new CachedTable(x$7, (scala.collection.immutable.Map<String, String>)x$8, x$10, x$12, x$11, (Seq<WeakReference<Object>>)x$9);
            if (!this.cache().replace(customTablePath, oldTable, mergedTable)) continue;
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Registered to an existing entry in cache for table ").append(customTablePath).append(".").toString());
            return;
        } while ((oldTable = this.cache().get(customTablePath)) != null || (oldTable = this.cache().putIfAbsent(customTablePath, cachedTable)) != null);
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(54).append("Registered a new entry in cache for table ").append(customTablePath).append(" on 2nd try.").toString());
    }

    private boolean registerQuerySpecificCachedTable$default$8() {
        return false;
    }

    public long register$default$6() {
        return System.currentTimeMillis() + this.preSignedUrlExpirationMs();
    }

    public boolean register$default$8() {
        return false;
    }

    public void stop() {
        this.refreshThread().shutdownNow();
    }

    public void clear() {
        this.cache().clear();
    }

    public static final /* synthetic */ boolean $anonfun$handleCachedTableRefresh$1(WeakReference x$1) {
        return x$1.get() == null;
    }

    public static final /* synthetic */ boolean $anonfun$handleQuerySpecificCachedTableRefresh$3(WeakReference x$3) {
        return x$3.get() != null;
    }

    public static final /* synthetic */ boolean $anonfun$handleQuerySpecificCachedTableRefresh$2(Tuple2 x0$1) {
        Tuple2 tuple2;
        Tuple2 tuple22 = x0$1;
        if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
            Seq refs = (Seq)tuple2._1();
            return refs.exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CachedTableManager.$anonfun$handleQuerySpecificCachedTableRefresh$3(x$3)));
        }
        throw new MatchError((Object)tuple22);
    }

    public static final /* synthetic */ boolean $anonfun$registerQuerySpecificCachedTable$8(WeakReference ref$1, WeakReference x$7) {
        return x$7.get() == ref$1.get();
    }

    public static final /* synthetic */ Date $anonfun$register$3(long x$8) {
        return new Date(x$8);
    }

    public static final /* synthetic */ boolean $anonfun$register$7(WeakReference ref$2, WeakReference x$10) {
        return x$10.get() == ref$2.get();
    }

    public static final /* synthetic */ boolean $anonfun$register$6(CachedTable oldCachedTable$1, WeakReference ref) {
        return oldCachedTable$1.refs().exists((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)CachedTableManager.$anonfun$register$7(ref, x$10)));
    }

    public CachedTableManager(long preSignedUrlExpirationMs, long refreshCheckIntervalMs, long refreshThresholdMs, long expireAfterAccessMs) {
        this.preSignedUrlExpirationMs = preSignedUrlExpirationMs;
        this.refreshThresholdMs = refreshThresholdMs;
        this.expireAfterAccessMs = expireAfterAccessMs;
        Logging.$init$((Logging)this);
        this.cache = new ConcurrentHashMap();
        ScheduledExecutorService thread = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("delta-sharing-pre-signed-url-refresh-thread");
        thread.scheduleWithFixedDelay(() -> this.refresh(), refreshCheckIntervalMs, refreshCheckIntervalMs, TimeUnit.MILLISECONDS);
        this.refreshThread = thread;
    }
}

