/*
 * Decompiled with CFR 0.152.
 */
package io.delta.sharing.spark;

import io.delta.sharing.spark.RemoteDeltaCDCFileIndex;
import io.delta.sharing.spark.RemoteDeltaCDFAddFileIndex;
import io.delta.sharing.spark.RemoteDeltaCDFFileIndexBase;
import io.delta.sharing.spark.RemoteDeltaCDFRemoveFileIndex;
import io.delta.sharing.spark.RemoteDeltaFileIndexParams;
import io.delta.sharing.spark.model.AddCDCFile;
import io.delta.sharing.spark.model.AddFileForCDF;
import io.delta.sharing.spark.model.RemoveFile;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import org.apache.spark.delta.sharing.CachedTableManager$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.DeltaSharingScanUtils$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag$;

public final class DeltaSharingCDFReader$ {
    public static DeltaSharingCDFReader$ MODULE$;

    static {
        new DeltaSharingCDFReader$();
    }

    public Dataset<Row> changesToDF(RemoteDeltaFileIndexParams params, String[] requiredColumns, Seq<AddFileForCDF> addFiles, Seq<AddCDCFile> cdfFiles, Seq<RemoveFile> removeFiles, StructType schema, boolean isStreaming, Function0<Map<String, String>> refresher) {
        ListBuffer dfs = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ListBuffer refs = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RemoteDeltaCDFAddFileIndex fileIndex1 = new RemoteDeltaCDFAddFileIndex(params, addFiles);
        refs.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new WeakReference[]{new WeakReference<RemoteDeltaCDFAddFileIndex>(fileIndex1)}));
        dfs.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Dataset[]{this.scanIndex(fileIndex1, schema, isStreaming)}));
        RemoteDeltaCDCFileIndex fileIndex2 = new RemoteDeltaCDCFileIndex(params, cdfFiles);
        refs.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new WeakReference[]{new WeakReference<RemoteDeltaCDCFileIndex>(fileIndex2)}));
        dfs.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Dataset[]{this.scanIndex(fileIndex2, schema, isStreaming)}));
        RemoteDeltaCDFRemoveFileIndex fileIndex3 = new RemoteDeltaCDFRemoveFileIndex(params, removeFiles);
        refs.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new WeakReference[]{new WeakReference<RemoteDeltaCDFRemoveFileIndex>(fileIndex3)}));
        dfs.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Dataset[]{this.scanIndex(fileIndex3, schema, isStreaming)}));
        CachedTableManager$.MODULE$.INSTANCE().register(params.path().toString(), this.getIdToUrl(addFiles, cdfFiles, removeFiles), (Seq<WeakReference<Object>>)refs, params.profileProvider(), refresher);
        return ((Dataset)dfs.reduce((Function2 & Serializable & scala.Serializable)(df1, df2) -> df1.unionAll(df2))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredColumns)).map((Function1 & Serializable & scala.Serializable)c -> functions$.MODULE$.col(MODULE$.quoteIdentifier((String)c)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)))));
    }

    public Map<String, String> getIdToUrl(Seq<AddFileForCDF> addFiles, Seq<AddCDCFile> cdfFiles, Seq<RemoveFile> removeFiles) {
        return ((TraversableOnce)addFiles.map((Function1 & Serializable & scala.Serializable)a -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)a.id()), (Object)a.url()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)((TraversableOnce)cdfFiles.map((Function1 & Serializable & scala.Serializable)c -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)c.id()), (Object)c.url()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).$plus$plus((GenTraversableOnce)((TraversableOnce)removeFiles.map((Function1 & Serializable & scala.Serializable)r -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)r.id()), (Object)r.url()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }

    private String quoteIdentifier(String part) {
        return new StringBuilder(2).append("`").append(part.replace("`", "``")).append("`").toString();
    }

    private Dataset<Row> scanIndex(RemoteDeltaCDFFileIndexBase fileIndex, StructType schema, boolean isStreaming) {
        HadoopFsRelation relation = new HadoopFsRelation((FileIndex)fileIndex, fileIndex.partitionSchema(), schema, (Option)None$.MODULE$, fileIndex.params().snapshotAtAnalysis().fileFormat(), Predef$.MODULE$.Map().empty(), fileIndex.params().spark());
        LogicalRelation plan = LogicalRelation$.MODULE$.apply((BaseRelation)relation, isStreaming);
        return DeltaSharingScanUtils$.MODULE$.ofRows(fileIndex.params().spark(), plan);
    }

    private DeltaSharingCDFReader$() {
        MODULE$ = this;
    }
}

