/*
 * Decompiled with CFR 0.152.
 */
package io.delta.sharing.spark;

import io.delta.sharing.spark.DeltaSharingFileSystem$;
import io.delta.sharing.spark.InMemoryHttpInputStream;
import io.delta.sharing.spark.RandomAccessHttpInputStream;
import io.delta.sharing.spark.model.FileAction;
import java.io.InputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.spark.SparkEnv$;
import org.apache.spark.delta.sharing.PreSignedUrlCache$;
import org.apache.spark.delta.sharing.PreSignedUrlFetcher;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.rpc.RpcEndpointRef;
import scala.Product;
import scala.Serializable;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\tUg!\u0002\u001d:\u0001m\n\u0005\"\u0002(\u0001\t\u0003\u0001\u0006\u0002C*\u0001\u0011\u000b\u0007I\u0011\u0002+\t\u0011m\u0003\u0001R1A\u0005\nQC\u0001\u0002\u0018\u0001\t\u0006\u0004%I!\u0018\u0005\tQ\u0002A)\u0019!C\u0005S\"AQ\u000e\u0001EC\u0002\u0013%a\u000eC\u0003w\u0001\u0011\u0005s\u000fC\u0004\u0002\b\u0001!\t%!\u0003\t\u000f\u0005m\u0001\u0001\"\u0011\u0002\u001e!9\u00111\u0007\u0001\u0005B\u0005U\u0002bBA<\u0001\u0011\u0005\u0013\u0011\u0010\u0005\b\u0003\u0003\u0003A\u0011IAB\u0011\u001d\ti\t\u0001C!\u0003\u001fCq!a&\u0001\t\u0003\nI\nC\u0004\u0002*\u0002!\t%a+\t\u000f\u0005]\u0006\u0001\"\u0011\u0002:\"9\u00111\u0018\u0001\u0005B\u0005u\u0006bBAb\u0001\u0011\u0005\u0013Q\u0019\u0005\b\u0003\u0013\u0004A\u0011IAf\u0011\u001d\ti\r\u0001C!\u0003\u0017<\u0001\"a4:\u0011\u0003Y\u0014\u0011\u001b\u0004\bqeB\taOAj\u0011\u0019qe\u0003\"\u0001\u0002\\\"I\u0011Q\u001c\fC\u0002\u0013\u0005\u0011q\u001c\u0005\t\u0003W4\u0002\u0015!\u0003\u0002b\u001a1\u0011Q\u001e\fA\u0003_D!\"!@\u001b\u0005+\u0007I\u0011AA\u0000\u0011%\u0011\tA\u0007B\tB\u0003%\u0001\u0010\u0003\u0006\u0003\u0004i\u0011)\u001a!C\u0001\u0003\u007fD\u0011B!\u0002\u001b\u0005#\u0005\u000b\u0011\u0002=\t\u0013\t\u001d!D!f\u0001\n\u0003I\u0007\"\u0003B\u00055\tE\t\u0015!\u0003k\u0011\u0019q%\u0004\"\u0001\u0003\f!9!q\u0003\u000e\u0005\u0002\te\u0001\"\u0003B\u000e5\u0005\u0005I\u0011\u0001B\u000f\u0011%\u0011)CGI\u0001\n\u0003\u00119\u0003C\u0005\u0003>i\t\n\u0011\"\u0001\u0003(!I!q\b\u000e\u0012\u0002\u0013\u0005!\u0011\t\u0005\n\u0005\u000bR\u0012\u0011!C!\u0003?D\u0001Ba\u0012\u001b\u0003\u0003%\t\u0001\u0016\u0005\n\u0005\u0013R\u0012\u0011!C\u0001\u0005\u0017B\u0011Ba\u0016\u001b\u0003\u0003%\tE!\u0017\t\u0013\t\u001d$$!A\u0005\u0002\t%\u0004\"\u0003B75\u0005\u0005I\u0011\tB8\u0011%\u0011\tHGA\u0001\n\u0003\u0012\u0019\bC\u0005\u0003vi\t\t\u0011\"\u0011\u0003x\u001dI!1\u0010\f\u0002\u0002#\u0005!Q\u0010\u0004\n\u0003[4\u0012\u0011!E\u0001\u0005\u007fBaA\u0014\u0019\u0005\u0002\t5\u0005\"\u0003B9a\u0005\u0005IQ\tB:\u0011%\u0011y\tMA\u0001\n\u0003\u0013\t\nC\u0005\u0003\u001aB\n\t\u0011\"!\u0003\u001c\"I!Q\u0016\u0019\u0002\u0002\u0013%!q\u0016\u0005\b\u0005o3B\u0011\u0001B]\u0011\u001d\u0011iM\u0006C\u0001\u0005\u001f\u0014a\u0003R3mi\u0006\u001c\u0006.\u0019:j]\u001e4\u0015\u000e\\3TsN$X-\u001c\u0006\u0003um\nQa\u001d9be.T!\u0001P\u001f\u0002\u000fMD\u0017M]5oO*\u0011ahP\u0001\u0006I\u0016dG/\u0019\u0006\u0002\u0001\u0006\u0011\u0011n\\\n\u0003\u0001\t\u0003\"a\u0011'\u000e\u0003\u0011S!!\u0012$\u0002\u0005\u0019\u001c(BA$I\u0003\u0019A\u0017\rZ8pa*\u0011\u0011JS\u0001\u0007CB\f7\r[3\u000b\u0003-\u000b1a\u001c:h\u0013\tiEI\u0001\u0006GS2,7+_:uK6\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002#B\u0011!\u000bA\u0007\u0002s\u0005Qa.^7SKR\u0014\u0018.Z:\u0016\u0003U\u0003\"AV-\u000e\u0003]S\u0011\u0001W\u0001\u0006g\u000e\fG.Y\u0005\u00035^\u00131!\u00138u\u0003A!\u0018.\\3pkRLenU3d_:$7/\u0001\u0006iiR\u00048\t\\5f]R,\u0012A\u0018\t\u0003?\u001al\u0011\u0001\u0019\u0006\u0003C\n\faa\u00197jK:$(BA2e\u0003\u0011IW\u000e\u001d7\u000b\u0005\u0015D\u0015\u0001\u00025uiBL!a\u001a1\u0003'\rcwn]3bE2,\u0007\n\u001e;q\u00072LWM\u001c;\u0002%I,gM]3tQRC'/Z:i_2$Wj]\u000b\u0002UB\u0011ak[\u0005\u0003Y^\u0013A\u0001T8oO\u0006!\u0002O]3TS\u001etW\rZ+sY\u000e\u000b7\r[3SK\u001a,\u0012a\u001c\t\u0003aRl\u0011!\u001d\u0006\u0003eN\f1A\u001d9d\u0015\tQ\u0004*\u0003\u0002vc\nq!\u000b]2F]\u0012\u0004x.\u001b8u%\u00164\u0017!C4fiN\u001b\u0007.Z7f)\u0005A\bcA=\u0002\u00029\u0011!P \t\u0003w^k\u0011\u0001 \u0006\u0003{>\u000ba\u0001\u0010:p_Rt\u0014BA@X\u0003\u0019\u0001&/\u001a3fM&!\u00111AA\u0003\u0005\u0019\u0019FO]5oO*\u0011qpV\u0001\u0007O\u0016$XK]5\u0015\u0005\u0005-\u0001\u0003BA\u0007\u0003/i!!a\u0004\u000b\t\u0005E\u00111C\u0001\u0004]\u0016$(BAA\u000b\u0003\u0011Q\u0017M^1\n\t\u0005e\u0011q\u0002\u0002\u0004+JK\u0015\u0001B8qK:$b!a\b\u0002&\u0005=\u0002cA\"\u0002\"%\u0019\u00111\u0005#\u0003#\u0019\u001bF)\u0019;b\u0013:\u0004X\u000f^*ue\u0016\fW\u000eC\u0004\u0002(%\u0001\r!!\u000b\u0002\u0003\u0019\u00042aQA\u0016\u0013\r\ti\u0003\u0012\u0002\u0005!\u0006$\b\u000e\u0003\u0004\u00022%\u0001\r!V\u0001\u000bEV4g-\u001a:TSj,\u0017AB2sK\u0006$X\r\u0006\t\u00028\u0005u\u0012qHA'\u0003/\nI&a\u0019\u0002hA\u00191)!\u000f\n\u0007\u0005mBI\u0001\nG'\u0012\u000bG/Y(viB,Ho\u0015;sK\u0006l\u0007bBA\u0014\u0015\u0001\u0007\u0011\u0011\u0006\u0005\b\u0003\u0003R\u0001\u0019AA\"\u0003)\u0001XM]7jgNLwN\u001c\t\u0005\u0003\u000b\nI%\u0004\u0002\u0002H)\u0019\u0011\u0011\t#\n\t\u0005-\u0013q\t\u0002\r\rN\u0004VM]7jgNLwN\u001c\u0005\b\u0003\u001fR\u0001\u0019AA)\u0003%yg/\u001a:xe&$X\rE\u0002W\u0003'J1!!\u0016X\u0005\u001d\u0011un\u001c7fC:Da!!\r\u000b\u0001\u0004)\u0006bBA.\u0015\u0001\u0007\u0011QL\u0001\fe\u0016\u0004H.[2bi&|g\u000eE\u0002W\u0003?J1!!\u0019X\u0005\u0015\u0019\u0006n\u001c:u\u0011\u0019\t)G\u0003a\u0001U\u0006I!\r\\8dWNK'0\u001a\u0005\b\u0003SR\u0001\u0019AA6\u0003!\u0001(o\\4sKN\u001c\b\u0003BA7\u0003gj!!a\u001c\u000b\u0007\u0005Ed)\u0001\u0003vi&d\u0017\u0002BA;\u0003_\u0012A\u0002\u0015:pOJ,7o]1cY\u0016\fa!\u00199qK:$G\u0003CA\u001c\u0003w\ni(a \t\u000f\u0005\u001d2\u00021\u0001\u0002*!1\u0011\u0011G\u0006A\u0002UCq!!\u001b\f\u0001\u0004\tY'\u0001\u0004sK:\fW.\u001a\u000b\u0007\u0003#\n))!#\t\u000f\u0005\u001dE\u00021\u0001\u0002*\u0005\u00191O]2\t\u000f\u0005-E\u00021\u0001\u0002*\u0005\u0019Am\u001d;\u0002\r\u0011,G.\u001a;f)\u0019\t\t&!%\u0002\u0014\"9\u0011qE\u0007A\u0002\u0005%\u0002bBAK\u001b\u0001\u0007\u0011\u0011K\u0001\ne\u0016\u001cWO]:jm\u0016\f!\u0002\\5tiN#\u0018\r^;t)\u0011\tY*a*\u0011\u000bY\u000bi*!)\n\u0007\u0005}uKA\u0003BeJ\f\u0017\u0010E\u0002D\u0003GK1!!*E\u0005)1\u0015\u000e\\3Ti\u0006$Xo\u001d\u0005\b\u0003Oq\u0001\u0019AA\u0015\u0003M\u0019X\r^,pe.Lgn\u001a#je\u0016\u001cGo\u001c:z)\u0011\ti+a-\u0011\u0007Y\u000by+C\u0002\u00022^\u0013A!\u00168ji\"9\u0011QW\bA\u0002\u0005%\u0012a\u00028fo~#\u0017N]\u0001\u0014O\u0016$xk\u001c:lS:<G)\u001b:fGR|'/\u001f\u000b\u0003\u0003S\ta!\\6eSJ\u001cHCBA)\u0003\u007f\u000b\t\rC\u0004\u0002(E\u0001\r!!\u000b\t\u000f\u0005\u0005\u0013\u00031\u0001\u0002D\u0005iq-\u001a;GS2,7\u000b^1ukN$B!!)\u0002H\"9\u0011q\u0005\nA\u0002\u0005%\u0012\u0001\u00034j]\u0006d\u0017N_3\u0015\u0005\u00055\u0016!B2m_N,\u0017A\u0006#fYR\f7\u000b[1sS:<g)\u001b7f'f\u001cH/Z7\u0011\u0005I32c\u0001\f\u0002VB\u0019a+a6\n\u0007\u0005ewK\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003#\faaU\"I\u000b6+UCAAq!\u0011\t\u0019/!;\u000e\u0005\u0005\u0015(\u0002BAt\u0003'\tA\u0001\\1oO&!\u00111AAs\u0003\u001d\u00196\tS#N\u000b\u0002\u0012\u0001\u0003R3mi\u0006\u001c\u0006.\u0019:j]\u001e\u0004\u0016\r\u001e5\u0014\u000fi\t).!=\u0002xB\u0019a+a=\n\u0007\u0005UxKA\u0004Qe>$Wo\u0019;\u0011\u0007Y\u000bI0C\u0002\u0002|^\u0013AbU3sS\u0006d\u0017N_1cY\u0016\f\u0011\u0002^1cY\u0016\u0004\u0016\r\u001e5\u0016\u0003a\f!\u0002^1cY\u0016\u0004\u0016\r\u001e5!\u0003\u00191\u0017\u000e\\3JI\u00069a-\u001b7f\u0013\u0012\u0004\u0013\u0001\u00034jY\u0016\u001c\u0016N_3\u0002\u0013\u0019LG.Z*ju\u0016\u0004C\u0003\u0003B\u0007\u0005#\u0011\u0019B!\u0006\u0011\u0007\t=!$D\u0001\u0017\u0011\u0019\ti0\ta\u0001q\"1!1A\u0011A\u0002aDaAa\u0002\"\u0001\u0004Q\u0017A\u0002;p!\u0006$\b.\u0006\u0002\u0002*\u0005!1m\u001c9z)!\u0011iAa\b\u0003\"\t\r\u0002\u0002CA\u007fGA\u0005\t\u0019\u0001=\t\u0011\t\r1\u0005%AA\u0002aD\u0001Ba\u0002$!\u0003\u0005\rA[\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011ICK\u0002y\u0005WY#A!\f\u0011\t\t=\"\u0011H\u0007\u0003\u0005cQAAa\r\u00036\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005o9\u0016AC1o]>$\u0018\r^5p]&!!1\bB\u0019\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"Aa\u0011+\u0007)\u0014Y#A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011iEa\u0015\u0011\u0007Y\u0013y%C\u0002\u0003R]\u00131!\u00118z\u0011!\u0011)&KA\u0001\u0002\u0004)\u0016a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003\\A1!Q\fB2\u0005\u001bj!Aa\u0018\u000b\u0007\t\u0005t+\u0001\u0006d_2dWm\u0019;j_:LAA!\u001a\u0003`\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\tFa\u001b\t\u0013\tU3&!AA\u0002\t5\u0013\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003U\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003C\fa!Z9vC2\u001cH\u0003BA)\u0005sB\u0011B!\u0016/\u0003\u0003\u0005\rA!\u0014\u0002!\u0011+G\u000e^1TQ\u0006\u0014\u0018N\\4QCRD\u0007c\u0001B\baM)\u0001G!!\u0002xBI!1\u0011BEqbT'QB\u0007\u0003\u0005\u000bS1Aa\"X\u0003\u001d\u0011XO\u001c;j[\u0016LAAa#\u0003\u0006\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0015\u0005\tu\u0014!B1qa2LH\u0003\u0003B\u0007\u0005'\u0013)Ja&\t\r\u0005u8\u00071\u0001y\u0011\u0019\u0011\u0019a\ra\u0001q\"1!qA\u001aA\u0002)\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\u001e\n%\u0006#\u0002,\u0003 \n\r\u0016b\u0001BQ/\n1q\n\u001d;j_:\u0004bA\u0016BSqbT\u0017b\u0001BT/\n1A+\u001e9mKNB\u0011Ba+5\u0003\u0003\u0005\rA!\u0004\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001BY!\u0011\t\u0019Oa-\n\t\tU\u0016Q\u001d\u0002\u0007\u001f\nTWm\u0019;\u0002\r\u0015t7m\u001c3f)\u0019\tICa/\u0003>\"1\u0011Q \u001cA\u0002aDqAa07\u0001\u0004\u0011\t-\u0001\u0004bGRLwN\u001c\t\u0005\u0005\u0007\u0014I-\u0004\u0002\u0003F*\u0019!qY\u001d\u0002\u000b5|G-\u001a7\n\t\t-'Q\u0019\u0002\u000b\r&dW-Q2uS>t\u0017A\u00023fG>$W\r\u0006\u0003\u0003\u000e\tE\u0007b\u0002Bjo\u0001\u0007\u0011\u0011F\u0001\u0005a\u0006$\b\u000e")
public class DeltaSharingFileSystem
extends FileSystem {
    private int numRetries;
    private int timeoutInSeconds;
    private CloseableHttpClient httpClient;
    private long refreshThresholdMs;
    private RpcEndpointRef preSignedUrlCacheRef;
    private volatile byte bitmap$0;

    public static DeltaSharingPath decode(Path path) {
        return DeltaSharingFileSystem$.MODULE$.decode(path);
    }

    public static Path encode(String string, FileAction fileAction) {
        return DeltaSharingFileSystem$.MODULE$.encode(string, fileAction);
    }

    public static String SCHEME() {
        return DeltaSharingFileSystem$.MODULE$.SCHEME();
    }

    /*
     * WARNING - void declaration
     */
    private int numRetries$lzycompute() {
        DeltaSharingFileSystem deltaSharingFileSystem = this;
        synchronized (deltaSharingFileSystem) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var2_2;
                int numRetries = this.getConf().getInt("spark.delta.sharing.network.numRetries", 10);
                if (numRetries < 0) {
                    throw new IllegalArgumentException("spark.delta.sharing.network.numRetries must not be negative");
                }
                this.numRetries = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.numRetries;
    }

    private int numRetries() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.numRetries$lzycompute() : this.numRetries;
    }

    private int timeoutInSeconds$lzycompute() {
        DeltaSharingFileSystem deltaSharingFileSystem = this;
        synchronized (deltaSharingFileSystem) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                String timeoutStr = this.getConf().get("spark.delta.sharing.network.timeout", "120s");
                long timeoutInSeconds = JavaUtils.timeStringAs((String)timeoutStr, (TimeUnit)TimeUnit.SECONDS);
                if (timeoutInSeconds < 0L) {
                    throw new IllegalArgumentException("spark.delta.sharing.network.timeout must not be negative");
                }
                if (timeoutInSeconds > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException(new StringBuilder(48).append("spark.delta.sharing.network.timeout is too big: ").append(timeoutStr).toString());
                }
                this.timeoutInSeconds = (int)timeoutInSeconds;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.timeoutInSeconds;
    }

    private int timeoutInSeconds() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.timeoutInSeconds$lzycompute() : this.timeoutInSeconds;
    }

    private CloseableHttpClient httpClient$lzycompute() {
        DeltaSharingFileSystem deltaSharingFileSystem = this;
        synchronized (deltaSharingFileSystem) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                int maxConnections = this.getConf().getInt("spark.delta.sharing.network.maxConnections", 64);
                if (maxConnections < 0) {
                    throw new IllegalArgumentException("spark.delta.sharing.network.maxConnections must not be negative");
                }
                RequestConfig config = RequestConfig.custom().setConnectTimeout(this.timeoutInSeconds() * 1000).setConnectionRequestTimeout(this.timeoutInSeconds() * 1000).setSocketTimeout(this.timeoutInSeconds() * 1000).build();
                this.httpClient = HttpClientBuilder.create().setMaxConnTotal(maxConnections).setMaxConnPerRoute(maxConnections).setDefaultRequestConfig(config).disableAutomaticRetries().build();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.httpClient;
    }

    private CloseableHttpClient httpClient() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.httpClient$lzycompute() : this.httpClient;
    }

    private long refreshThresholdMs$lzycompute() {
        DeltaSharingFileSystem deltaSharingFileSystem = this;
        synchronized (deltaSharingFileSystem) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.refreshThresholdMs = this.getConf().getLong("spark.delta.sharing.executor.refreshThresholdMs", TimeUnit.MINUTES.toMillis(10L));
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.refreshThresholdMs;
    }

    private long refreshThresholdMs() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.refreshThresholdMs$lzycompute() : this.refreshThresholdMs;
    }

    private RpcEndpointRef preSignedUrlCacheRef$lzycompute() {
        DeltaSharingFileSystem deltaSharingFileSystem = this;
        synchronized (deltaSharingFileSystem) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.preSignedUrlCacheRef = PreSignedUrlCache$.MODULE$.getEndpointRefInExecutor(SparkEnv$.MODULE$.get());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.preSignedUrlCacheRef;
    }

    private RpcEndpointRef preSignedUrlCacheRef() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.preSignedUrlCacheRef$lzycompute() : this.preSignedUrlCacheRef;
    }

    public String getScheme() {
        return DeltaSharingFileSystem$.MODULE$.SCHEME();
    }

    public URI getUri() {
        return URI.create(new StringBuilder(4).append(DeltaSharingFileSystem$.MODULE$.SCHEME()).append(":///").toString());
    }

    public FSDataInputStream open(Path f, int bufferSize) {
        DeltaSharingPath path = DeltaSharingFileSystem$.MODULE$.decode(f);
        PreSignedUrlFetcher fetcher = new PreSignedUrlFetcher(this.preSignedUrlCacheRef(), path.tablePath(), path.fileId(), this.refreshThresholdMs());
        return this.getConf().getBoolean("spark.delta.sharing.loadDataFilesInMemory", false) ? new FSDataInputStream((InputStream)new InMemoryHttpInputStream(new URI(fetcher.getUrl()))) : new FSDataInputStream((InputStream)((Object)new RandomAccessHttpInputStream((HttpClient)this.httpClient(), fetcher, path.fileSize(), this.statistics, this.numRetries())));
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) {
        throw new UnsupportedOperationException("create");
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) {
        throw new UnsupportedOperationException("append");
    }

    public boolean rename(Path src, Path dst) {
        throw new UnsupportedOperationException("rename");
    }

    public boolean delete(Path f, boolean recursive) {
        throw new UnsupportedOperationException("delete");
    }

    public FileStatus[] listStatus(Path f) {
        throw new UnsupportedOperationException("listStatus");
    }

    public void setWorkingDirectory(Path new_dir) {
        throw new UnsupportedOperationException("setWorkingDirectory");
    }

    public Path getWorkingDirectory() {
        return new Path(this.getUri());
    }

    public boolean mkdirs(Path f, FsPermission permission) {
        throw new UnsupportedOperationException("mkdirs");
    }

    public FileStatus getFileStatus(Path f) {
        Path resolved = this.makeQualified(f);
        return new FileStatus(DeltaSharingFileSystem$.MODULE$.decode(resolved).fileSize(), false, 0, 1L, 0L, f);
    }

    public void finalize() {
        try {
            super.finalize();
        }
        finally {
            this.close();
        }
    }

    public void close() {
        try {
            super.close();
        }
        finally {
            this.httpClient().close();
        }
    }

    public static class DeltaSharingPath
    implements Product,
    Serializable {
        private final String tablePath;
        private final String fileId;
        private final long fileSize;

        public String tablePath() {
            return this.tablePath;
        }

        public String fileId() {
            return this.fileId;
        }

        public long fileSize() {
            return this.fileSize;
        }

        public Path toPath() {
            String encodedTablePath = URLEncoder.encode(this.tablePath(), "UTF-8");
            String encodedFileId = URLEncoder.encode(this.fileId(), "UTF-8");
            return new Path(new StringBuilder(6).append(DeltaSharingFileSystem$.MODULE$.SCHEME()).append(":///").append(encodedTablePath).append("/").append(encodedFileId).append("/").append(this.fileSize()).toString());
        }

        public DeltaSharingPath copy(String tablePath, String fileId, long fileSize) {
            return new DeltaSharingPath(tablePath, fileId, fileSize);
        }

        public String copy$default$1() {
            return this.tablePath();
        }

        public String copy$default$2() {
            return this.fileId();
        }

        public long copy$default$3() {
            return this.fileSize();
        }

        public String productPrefix() {
            return "DeltaSharingPath";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.tablePath();
                    break;
                }
                case 1: {
                    object = this.fileId();
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToLong((long)this.fileSize());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof DeltaSharingPath;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.tablePath()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.fileId()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.fileSize()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof DeltaSharingPath)) return false;
            boolean bl = true;
            if (!bl) return false;
            DeltaSharingPath deltaSharingPath = (DeltaSharingPath)x$1;
            String string = this.tablePath();
            String string2 = deltaSharingPath.tablePath();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.fileId();
            String string4 = deltaSharingPath.fileId();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (this.fileSize() != deltaSharingPath.fileSize()) return false;
            if (!deltaSharingPath.canEqual(this)) return false;
            return true;
        }

        public DeltaSharingPath(String tablePath, String fileId, long fileSize) {
            this.tablePath = tablePath;
            this.fileId = fileId;
            this.fileSize = fileSize;
            Product.$init$((Product)this);
        }
    }
}

