/*
 * Decompiled with CFR 0.152.
 */
package io.delta.sharing.spark;

import io.delta.sharing.spark.DeltaSharingErrors$;
import io.delta.sharing.spark.DeltaSharingOptionParser;
import io.delta.sharing.spark.DeltaSharingOptions$;
import io.delta.sharing.spark.DeltaStartingVersion;
import io.delta.sharing.spark.StartingVersion$;
import io.delta.sharing.spark.StartingVersionLatest$;
import java.io.Serializable;
import org.apache.spark.network.util.ByteUnit;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u00114q!\u0005\n\u0011\u0002\u0007\u00051\u0004C\u0003'\u0001\u0011\u0005q\u0005C\u0004,\u0001\t\u0007I\u0011\u0001\u0017\t\u000fM\u0002!\u0019!C\u0001i!9\u0011\b\u0001b\u0001\n\u0003Q\u0004b\u0002 \u0001\u0005\u0004%\tA\u000f\u0005\b\u007f\u0001\u0011\r\u0011\"\u0001;\u0011\u001d\u0001\u0005A1A\u0005\u0002\u0005CqA\u0012\u0001C\u0002\u0013\u0005q\tC\u0004U\u0001\t\u0007I\u0011A+\t\u000fe\u0003!\u0019!C\u0001i!9!\f\u0001b\u0001\n\u00039\u0005\"B.\u0001\t\u0003Q\u0004\"\u0002/\u0001\t\u0013i\u0006\"\u00021\u0001\t\u0013\t\u0007\"\u00022\u0001\t\u00139\u0003\"B2\u0001\t\u00139#a\u0006#fYR\f7\u000b[1sS:<'+Z1e\u001fB$\u0018n\u001c8t\u0015\t\u0019B#A\u0003ta\u0006\u00148N\u0003\u0002\u0016-\u000591\u000f[1sS:<'BA\f\u0019\u0003\u0015!W\r\u001c;b\u0015\u0005I\u0012AA5p\u0007\u0001\u00192\u0001\u0001\u000f#!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\u0019\te.\u001f*fMB\u00111\u0005J\u0007\u0002%%\u0011QE\u0005\u0002\u0019\t\u0016dG/Y*iCJLgnZ(qi&|g\u000eU1sg\u0016\u0014\u0018A\u0002\u0013j]&$H\u0005F\u0001)!\ti\u0012&\u0003\u0002+=\t!QK\\5u\u0003Ii\u0017\r\u001f$jY\u0016\u001c\b+\u001a:Ue&<w-\u001a:\u0016\u00035\u00022!\b\u00181\u0013\tycD\u0001\u0004PaRLwN\u001c\t\u0003;EJ!A\r\u0010\u0003\u0007%sG/\u0001\nnCb\u0014\u0015\u0010^3t!\u0016\u0014HK]5hO\u0016\u0014X#A\u001b\u0011\u0007uqc\u0007\u0005\u0002\u001eo%\u0011\u0001H\b\u0002\u0005\u0019>tw-A\u0007jO:|'/Z\"iC:<Wm]\u000b\u0002wA\u0011Q\u0004P\u0005\u0003{y\u0011qAQ8pY\u0016\fg.A\u0007jO:|'/\u001a#fY\u0016$Xm]\u0001\u000fe\u0016\fGm\u00115b]\u001e,g)Z3e\u0003=\u0019H/\u0019:uS:<g+\u001a:tS>tW#\u0001\"\u0011\u0007uq3\t\u0005\u0002$\t&\u0011QI\u0005\u0002\u0015\t\u0016dG/Y*uCJ$\u0018N\\4WKJ\u001c\u0018n\u001c8\u0002#M$\u0018M\u001d;j]\u001e$\u0016.\\3ti\u0006l\u0007/F\u0001I!\rib&\u0013\t\u0003\u0015Fs!aS(\u0011\u00051sR\"A'\u000b\u00059S\u0012A\u0002\u001fs_>$h(\u0003\u0002Q=\u00051\u0001K]3eK\u001aL!AU*\u0003\rM#(/\u001b8h\u0015\t\u0001f$\u0001\u0006dI\u001a|\u0005\u000f^5p]N,\u0012A\u0016\t\u0005\u0015^K\u0015*\u0003\u0002Y'\n\u0019Q*\u00199\u0002\u0017Y,'o]5p]\u0006\u001bxJZ\u0001\u000ei&lWm\u001d;b[B\f5o\u00144\u0002\u0019%\u001cH+[7f)J\fg/\u001a7\u0002+\u001d,GOR8s[\u0006$H/\u001a3US6,7\u000f^1naR\u0011\u0011J\u0018\u0005\u0006?6\u0001\r!S\u0001\u0004gR\u0014\u0018!\u00059sKB\f'/Z\"eM>\u0003H/[8ogR\ta+A\rwC2LG-\u0019;f\u001f:,7\u000b^1si&twm\u00149uS>t\u0017a\u0007<bY&$\u0017\r^3P]\u0016$\u0016.\\3Ue\u00064X\r\\(qi&|g\u000e")
public interface DeltaSharingReadOptions
extends DeltaSharingOptionParser {
    public void io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$maxFilesPerTrigger_$eq(Option<Object> var1);

    public void io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$maxBytesPerTrigger_$eq(Option<Object> var1);

    public void io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$ignoreChanges_$eq(boolean var1);

    public void io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$ignoreDeletes_$eq(boolean var1);

    public void io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$readChangeFeed_$eq(boolean var1);

    public void io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$startingVersion_$eq(Option<DeltaStartingVersion> var1);

    public void io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$startingTimestamp_$eq(Option<String> var1);

    public void io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$cdfOptions_$eq(Map<String, String> var1);

    public void io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$versionAsOf_$eq(Option<Object> var1);

    public void io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$timestampAsOf_$eq(Option<String> var1);

    public Option<Object> maxFilesPerTrigger();

    public Option<Object> maxBytesPerTrigger();

    public boolean ignoreChanges();

    public boolean ignoreDeletes();

    public boolean readChangeFeed();

    public Option<DeltaStartingVersion> startingVersion();

    public Option<String> startingTimestamp();

    public Map<String, String> cdfOptions();

    public Option<Object> versionAsOf();

    public Option<String> timestampAsOf();

    public static /* synthetic */ boolean isTimeTravel$(DeltaSharingReadOptions $this) {
        return $this.isTimeTravel();
    }

    default public boolean isTimeTravel() {
        return this.versionAsOf().isDefined() || this.timestampAsOf().isDefined();
    }

    private String getFormattedTimestamp(String str) {
        InternalRow x$1;
        Cast qual$1 = new Cast((Expression)Literal$.MODULE$.apply((Object)str), (DataType)TimestampType$.MODULE$, Option$.MODULE$.apply((Object)SQLConf$.MODULE$.get().sessionLocalTimeZone()));
        Object castResult = qual$1.eval(x$1 = qual$1.eval$default$1());
        if (castResult == null) {
            throw DeltaSharingErrors$.MODULE$.timestampInvalid(str);
        }
        return DateTimeUtils$.MODULE$.toJavaTimestamp(Predef$.MODULE$.Long2long((Long)castResult)).toInstant().toString();
    }

    private Map<String, String> prepareCdfOptions() {
        return this.readChangeFeed() ? (Map)((TraversableLike)DeltaSharingOptions$.MODULE$.validCdfOptions().filter((Function1 & Serializable & scala.Serializable)option -> BoxesRunTime.boxToBoolean((boolean)DeltaSharingReadOptions.$anonfun$prepareCdfOptions$1(this, option)))).map((Function1 & Serializable & scala.Serializable)option -> {
            Tuple2 tuple2;
            block3: {
                block2: {
                    Object object = option._1();
                    String string = DeltaSharingOptions$.MODULE$.CDF_START_TIMESTAMP();
                    if (!(object == null ? string != null : !object.equals(string))) break block2;
                    Object object2 = option._1();
                    String string2 = DeltaSharingOptions$.MODULE$.CDF_END_TIMESTAMP();
                    if (object2 != null ? !object2.equals(string2) : string2 != null) break block3;
                }
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(option._1()), (Object)this.getFormattedTimestamp((String)this.options().get((String)option._1()).get()));
                return tuple2;
            }
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(option._1()), this.options().get((String)option._1()).get());
            return tuple2;
        }, Map$.MODULE$.canBuildFrom()) : Predef$.MODULE$.Map().empty();
    }

    private void validateOneStartingOption() {
        if (this.startingTimestamp().isDefined() && this.startingVersion().isDefined()) {
            throw DeltaSharingErrors$.MODULE$.versionAndTimestampBothSetException(DeltaSharingOptions$.MODULE$.STARTING_VERSION_OPTION(), DeltaSharingOptions$.MODULE$.STARTING_TIMESTAMP_OPTION());
        }
    }

    private void validateOneTimeTravelOption() {
        if (this.versionAsOf().isDefined() && this.timestampAsOf().isDefined()) {
            throw DeltaSharingErrors$.MODULE$.versionAndTimestampBothSetException(DeltaSharingOptions$.MODULE$.TIME_TRAVEL_VERSION(), DeltaSharingOptions$.MODULE$.TIME_TRAVEL_TIMESTAMP());
        }
    }

    public static /* synthetic */ int $anonfun$maxFilesPerTrigger$1(String str) {
        return BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(str)).toInt()).toOption().filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> x$1 > 0).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw DeltaSharingErrors$.MODULE$.illegalDeltaSharingOptionException(DeltaSharingOptions$.MODULE$.MAX_FILES_PER_TRIGGER_OPTION(), str, "must be a positive integer");
        }));
    }

    public static /* synthetic */ long $anonfun$maxBytesPerTrigger$1(String str) {
        return BoxesRunTime.unboxToLong((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> JavaUtils.byteStringAs((String)str, (ByteUnit)ByteUnit.BYTE)).toOption().filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$2 -> x$2 > 0L).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw DeltaSharingErrors$.MODULE$.illegalDeltaSharingOptionException(DeltaSharingOptions$.MODULE$.MAX_BYTES_PER_TRIGGER_OPTION(), str, "must be a size configuration such as '10g'");
        }));
    }

    public static /* synthetic */ long $anonfun$versionAsOf$1(String str) {
        return BoxesRunTime.unboxToLong((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(str)).toLong()).toOption().filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$9 -> x$9 >= 0L).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw DeltaSharingErrors$.MODULE$.illegalDeltaSharingOptionException(DeltaSharingOptions$.MODULE$.TIME_TRAVEL_VERSION(), str, "must be an integer greater than or equal to zero");
        }));
    }

    public static /* synthetic */ boolean $anonfun$prepareCdfOptions$1(DeltaSharingReadOptions $this, Tuple2 option) {
        return $this.options().contains((String)option._1());
    }

    public static void $init$(DeltaSharingReadOptions $this) {
        $this.io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$maxFilesPerTrigger_$eq((Option<Object>)$this.options().get(DeltaSharingOptions$.MODULE$.MAX_FILES_PER_TRIGGER_OPTION()).map((Function1 & Serializable & scala.Serializable)str -> BoxesRunTime.boxToInteger((int)DeltaSharingReadOptions.$anonfun$maxFilesPerTrigger$1(str))));
        $this.io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$maxBytesPerTrigger_$eq((Option<Object>)$this.options().get(DeltaSharingOptions$.MODULE$.MAX_BYTES_PER_TRIGGER_OPTION()).map((Function1 & Serializable & scala.Serializable)str -> BoxesRunTime.boxToLong((long)DeltaSharingReadOptions.$anonfun$maxBytesPerTrigger$1(str))));
        $this.io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$ignoreChanges_$eq($this.options().get(DeltaSharingOptions$.MODULE$.IGNORE_CHANGES_OPTION()).exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)$this.toBoolean(x$3, DeltaSharingOptions$.MODULE$.IGNORE_CHANGES_OPTION()))));
        $this.io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$ignoreDeletes_$eq($this.options().get(DeltaSharingOptions$.MODULE$.IGNORE_DELETES_OPTION()).exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)$this.toBoolean(x$4, DeltaSharingOptions$.MODULE$.IGNORE_DELETES_OPTION()))));
        $this.io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$readChangeFeed_$eq($this.options().get(DeltaSharingOptions$.MODULE$.CDF_READ_OPTION()).exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)$this.toBoolean(x$5, DeltaSharingOptions$.MODULE$.CDF_READ_OPTION()))) || $this.options().get(DeltaSharingOptions$.MODULE$.CDF_READ_OPTION_LEGACY()).exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)$this.toBoolean(x$6, DeltaSharingOptions$.MODULE$.CDF_READ_OPTION_LEGACY()))));
        $this.io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$startingVersion_$eq((Option<DeltaStartingVersion>)$this.options().get(DeltaSharingOptions$.MODULE$.STARTING_VERSION_OPTION()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string = x0$1;
            DeltaStartingVersion deltaStartingVersion = "latest".equals(string) ? StartingVersionLatest$.MODULE$ : (DeltaStartingVersion)Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(string)).toLong()).toOption().filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$7 -> x$7 >= 0L).map((Function1)StartingVersion$.MODULE$).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw DeltaSharingErrors$.MODULE$.illegalDeltaSharingOptionException(DeltaSharingOptions$.MODULE$.STARTING_VERSION_OPTION(), string, "must be greater than or equal to zero");
            });
            return deltaStartingVersion;
        }));
        $this.io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$startingTimestamp_$eq((Option<String>)$this.options().get(DeltaSharingOptions$.MODULE$.STARTING_TIMESTAMP_OPTION()).map((Function1 & Serializable & scala.Serializable)x$8 -> $this.getFormattedTimestamp((String)x$8)));
        $this.io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$cdfOptions_$eq($this.prepareCdfOptions());
        $this.io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$versionAsOf_$eq((Option<Object>)$this.options().get(DeltaSharingOptions$.MODULE$.TIME_TRAVEL_VERSION()).map((Function1 & Serializable & scala.Serializable)str -> BoxesRunTime.boxToLong((long)DeltaSharingReadOptions.$anonfun$versionAsOf$1(str))));
        $this.io$delta$sharing$spark$DeltaSharingReadOptions$_setter_$timestampAsOf_$eq((Option<String>)$this.options().get(DeltaSharingOptions$.MODULE$.TIME_TRAVEL_TIMESTAMP()).map((Function1 & Serializable & scala.Serializable)x$10 -> $this.getFormattedTimestamp((String)x$10)));
        $this.validateOneStartingOption();
        $this.validateOneTimeTravelOption();
    }
}

