/*
 * Decompiled with CFR 0.152.
 */
package io.delta.sharing.spark;

import io.delta.sharing.spark.util.RetryUtils$;
import io.delta.sharing.spark.util.UnexpectedHttpStatus;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.EofSensorInputStream;
import org.apache.spark.delta.sharing.PreSignedUrlFetcher;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e!\u0002\u0010 \u0001\u0005:\u0003\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u0011\u0011\u0003!\u0011!Q\u0001\n\u0015C\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\t%\u0002\u0011\t\u0011)A\u0005'\"A!\f\u0001B\u0001B\u0003%1\fC\u0003_\u0001\u0011\u0005q\fC\u0004h\u0001\u0001\u0007I\u0011\u00025\t\u000f1\u0004\u0001\u0019!C\u0005[\"11\u000f\u0001Q!\n%Dq\u0001\u001e\u0001A\u0002\u0013%Q\u000fC\u0004w\u0001\u0001\u0007I\u0011B<\t\re\u0004\u0001\u0015)\u0003M\u0011\u001dQ\b\u00011A\u0005\nmD\u0011\"a\u0002\u0001\u0001\u0004%I!!\u0003\t\u000f\u00055\u0001\u0001)Q\u0005y\"I\u0011q\u0002\u0001A\u0002\u0013%\u0011\u0011\u0003\u0005\n\u0003S\u0001\u0001\u0019!C\u0005\u0003WA\u0001\"a\f\u0001A\u0003&\u00111\u0003\u0005\b\u0003c\u0001A\u0011BA\u001a\u0011\u001d\t)\u0004\u0001C!\u0003oAq!a\u000f\u0001\t\u0003\ni\u0004C\u0004\u0002@\u0001!\t%!\u0011\t\u000f\u0005\u001d\u0003\u0001\"\u0011\u0002J!9\u00111\n\u0001\u0005\n\u00055\u0003bBA$\u0001\u0011\u0005\u0013q\f\u0005\b\u0003s\u0002A\u0011BA>\u0011\u001d\ty\b\u0001C!\u0003\u0013Bq!!!\u0001\t\u0013\t\u0019\u0004C\u0004\u0002\u0004\u0002!\t%a\r\u00037I\u000bg\u000eZ8n\u0003\u000e\u001cWm]:IiR\u0004\u0018J\u001c9viN#(/Z1n\u0015\t\u0001\u0013%A\u0003ta\u0006\u00148N\u0003\u0002#G\u000591\u000f[1sS:<'B\u0001\u0013&\u0003\u0015!W\r\u001c;b\u0015\u00051\u0013AA5p'\r\u0001\u0001\u0006\u000e\t\u0003SIj\u0011A\u000b\u0006\u0003W1\n!AZ:\u000b\u00055r\u0013A\u00025bI>|\u0007O\u0003\u00020a\u00051\u0011\r]1dQ\u0016T\u0011!M\u0001\u0004_J<\u0017BA\u001a+\u0005515+\u00138qkR\u001cFO]3b[B\u0011Q'O\u0007\u0002m)\u0011q\u0007O\u0001\tS:$XM\u001d8bY*\u0011\u0001EL\u0005\u0003uY\u0012q\u0001T8hO&tw-\u0001\u0004dY&,g\u000e^\u0002\u0001!\tq$)D\u0001@\u0015\tY\u0004I\u0003\u0002B]\u0005!\u0001\u000e\u001e;q\u0013\t\u0019uH\u0001\u0006IiR\u00048\t\\5f]R\fqAZ3uG\",'\u000f\u0005\u0002G\u00136\tqI\u0003\u0002#\u0011*\u0011A\u0005O\u0005\u0003\u0015\u001e\u00131\u0003\u0015:f'&<g.\u001a3Ve24U\r^2iKJ\fQbY8oi\u0016tG\u000fT3oORD\u0007CA'Q\u001b\u0005q%\"A(\u0002\u000bM\u001c\u0017\r\\1\n\u0005Es%\u0001\u0002'p]\u001e\fQa\u001d;biN\u0004\"\u0001V,\u000f\u0005%*\u0016B\u0001,+\u0003)1\u0015\u000e\\3TsN$X-\\\u0005\u00031f\u0013!b\u0015;bi&\u001cH/[2t\u0015\t1&&\u0001\u0006ok6\u0014V\r\u001e:jKN\u0004\"!\u0014/\n\u0005us%aA%oi\u00061A(\u001b8jiz\"b\u0001\u00192dI\u00164\u0007CA1\u0001\u001b\u0005y\u0002\"B\u001e\u0007\u0001\u0004i\u0004\"\u0002#\u0007\u0001\u0004)\u0005\"B&\u0007\u0001\u0004a\u0005\"\u0002*\u0007\u0001\u0004\u0019\u0006\"\u0002.\u0007\u0001\u0004Y\u0016AB2m_N,G-F\u0001j!\ti%.\u0003\u0002l\u001d\n9!i\\8mK\u0006t\u0017AC2m_N,Gm\u0018\u0013fcR\u0011a.\u001d\t\u0003\u001b>L!\u0001\u001d(\u0003\tUs\u0017\u000e\u001e\u0005\be\"\t\t\u00111\u0001j\u0003\rAH%M\u0001\bG2|7/\u001a3!\u0003\r\u0001xn]\u000b\u0002\u0019\u00069\u0001o\\:`I\u0015\fHC\u00018y\u0011\u001d\u00118\"!AA\u00021\u000bA\u0001]8tA\u0005i1-\u001e:sK:$8\u000b\u001e:fC6,\u0012\u0001 \t\u0004{\u0006\rQ\"\u0001@\u000b\u0005\u0019z(BAA\u0001\u0003\u0011Q\u0017M^1\n\u0007\u0005\u0015aPA\u0006J]B,Ho\u0015;sK\u0006l\u0017!E2veJ,g\u000e^*ue\u0016\fWn\u0018\u0013fcR\u0019a.a\u0003\t\u000fIt\u0011\u0011!a\u0001y\u0006q1-\u001e:sK:$8\u000b\u001e:fC6\u0004\u0013aA;sSV\u0011\u00111\u0003\t\u0005\u0003+\t\u0019C\u0004\u0003\u0002\u0018\u0005}\u0001cAA\r\u001d6\u0011\u00111\u0004\u0006\u0004\u0003;a\u0014A\u0002\u001fs_>$h(C\u0002\u0002\"9\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0013\u0003O\u0011aa\u0015;sS:<'bAA\u0011\u001d\u00069QO]5`I\u0015\fHc\u00018\u0002.!A!/EA\u0001\u0002\u0004\t\u0019\"\u0001\u0003ve&\u0004\u0013aD1tg\u0016\u0014HOT8u\u00072|7/\u001a3\u0015\u00039\fAa]3fWR\u0019a.!\u000f\t\u000bQ$\u0002\u0019\u0001'\u0002\r\u001d,G\u000fU8t)\u0005a\u0015aD:fK.$vNT3x'>,(oY3\u0015\u0007%\f\u0019\u0005\u0003\u0004\u0002FY\u0001\r\u0001T\u0001\ni\u0006\u0014x-\u001a;Q_N\fAA]3bIR\t1,A\tde\u0016\fG/\u001a%uiB\u0014V-];fgR$B!a\u0014\u0002\\A!\u0011\u0011KA,\u001b\t\t\u0019FC\u0002\u0002V}\nq!\\3uQ>$7/\u0003\u0003\u0002Z\u0005M#a\u0004%uiB\u0014V-];fgR\u0014\u0015m]3\t\r\u0005u\u0003\u00041\u0001M\u0003\u0015\u0019H/\u0019:u)\u001dY\u0016\u0011MA9\u0003kBq!a\u0019\u001a\u0001\u0004\t)'A\u0002ck\u001a\u0004R!TA4\u0003WJ1!!\u001bO\u0005\u0015\t%O]1z!\ri\u0015QN\u0005\u0004\u0003_r%\u0001\u0002\"zi\u0016Da!a\u001d\u001a\u0001\u0004Y\u0016aA8gM\"1\u0011qO\rA\u0002m\u000b1\u0001\\3o\u0003\u0019\u0011Xm\u001c9f]R\u0019a.! \t\u000bQT\u0002\u0019\u0001'\u0002\u0013\u00054\u0018-\u001b7bE2,\u0017AE1c_J$8)\u001e:sK:$8\u000b\u001e:fC6\fQa\u00197pg\u0016\u0004")
public class RandomAccessHttpInputStream
extends FSInputStream
implements Logging {
    private final HttpClient client;
    private final PreSignedUrlFetcher fetcher;
    private final long contentLength;
    private final FileSystem.Statistics stats;
    private final int numRetries;
    private boolean closed;
    private long pos;
    private InputStream currentStream;
    private String uri;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private boolean closed() {
        return this.closed;
    }

    private void closed_$eq(boolean x$1) {
        this.closed = x$1;
    }

    private long pos() {
        return this.pos;
    }

    private void pos_$eq(long x$1) {
        this.pos = x$1;
    }

    private InputStream currentStream() {
        return this.currentStream;
    }

    private void currentStream_$eq(InputStream x$1) {
        this.currentStream = x$1;
    }

    private String uri() {
        return this.uri;
    }

    private void uri_$eq(String x$1) {
        this.uri = x$1;
    }

    private void assertNotClosed() {
        block1: {
            if (this.closed()) {
                throw new IOException("Stream is closed!");
            }
            String newUrl = this.fetcher.getUrl();
            String string = this.uri();
            String string2 = newUrl;
            if (!(string == null ? string2 != null : !string.equals(string2))) break block1;
            this.uri_$eq(newUrl);
            this.abortCurrentStream();
        }
    }

    public synchronized void seek(long pos) {
        block0: {
            if (this.pos() == pos) break block0;
            this.assertNotClosed();
            this.reopen(pos);
        }
    }

    public synchronized long getPos() {
        return this.pos();
    }

    public boolean seekToNewSource(long targetPos) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized int read() {
        void var1_1;
        block2: {
            int n;
            this.assertNotClosed();
            if (this.currentStream() == null) {
                this.reopen(this.pos());
            }
            if ((n = this.currentStream().read()) >= 0) {
                this.pos_$eq(this.pos() + 1L);
            }
            if (this.stats == null || n < 0) break block2;
            this.stats.incrementBytesRead(1L);
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private HttpRequestBase createHttpRequest(long start) {
        void var3_2;
        HttpGet request = new HttpGet(this.uri());
        String rangeValue = new StringBuilder(7).append("bytes=").append(start).append("-").append(this.contentLength - 1L).toString();
        request.addHeader("Range", rangeValue);
        return var3_2;
    }

    public synchronized int read(byte[] buf, int off, int len) {
        int byteRead;
        block2: {
            this.assertNotClosed();
            if (this.currentStream() == null) {
                this.reopen(this.pos());
            }
            if ((byteRead = this.currentStream().read(buf, off, len)) > 0) {
                this.pos_$eq(this.pos() + (long)byteRead);
            }
            if (this.stats == null || byteRead <= 0) break block2;
            this.stats.incrementBytesRead((long)byteRead);
        }
        return byteRead;
    }

    private void reopen(long pos) {
        if (this.currentStream() != null) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Aborting old stream to open at pos ").append(pos).toString());
            this.abortCurrentStream();
        }
        if (pos < 0L) {
            throw new EOFException(new StringBuilder(33).append("Cannot seek to a negative offset ").append(pos).toString());
        }
        if (this.contentLength > 0L && pos > this.contentLength - 1L) {
            throw new EOFException(new StringBuilder(51).append("Attempted to seek or read past the end of the file ").append(pos).toString());
        }
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Opening file ").append(this.uri()).append(" at pos ").append(pos).toString());
        HttpEntity entity = (HttpEntity)RetryUtils$.MODULE$.runWithExponentialBackoff(this.numRetries, (Function0 & Serializable & scala.Serializable)() -> {
            HttpRequestBase httpRequest = this.createHttpRequest(pos);
            HttpResponse response = $this.client.execute((HttpUriRequest)httpRequest);
            StatusLine status = response.getStatusLine();
            HttpEntity entity = response.getEntity();
            int statusCode = status.getStatusCode();
            if (statusCode != 206) {
                String string;
                if (entity == null) {
                    string = "";
                } else {
                    try (InputStream input = entity.getContent();){
                        string = IOUtils.toString((InputStream)input, (Charset)StandardCharsets.UTF_8);
                    }
                }
                String errorBody = string;
                throw new UnexpectedHttpStatus(new StringBuilder(34).append("HTTP request failed with status: ").append(status).append(" ").append(errorBody).toString(), statusCode);
            }
            return entity;
        });
        this.currentStream_$eq(entity.getContent());
        this.pos_$eq(pos);
    }

    public synchronized int available() {
        this.assertNotClosed();
        return this.currentStream().available();
    }

    private void abortCurrentStream() {
        block2: {
            if (this.currentStream() == null) break block2;
            InputStream inputStream = this.currentStream();
            if (inputStream instanceof EofSensorInputStream) {
                EofSensorInputStream eofSensorInputStream = (EofSensorInputStream)inputStream;
                eofSensorInputStream.abortConnection();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.currentStream().close();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            this.currentStream_$eq(null);
        }
    }

    public synchronized void close() {
        block3: {
            if (this.closed()) break block3;
            super.close();
            this.closed_$eq(true);
            if (this.currentStream() != null) {
                if (this.contentLength - this.pos() <= 4096L) {
                    this.currentStream().close();
                    this.currentStream_$eq(null);
                } else {
                    this.abortCurrentStream();
                }
            }
        }
    }

    public RandomAccessHttpInputStream(HttpClient client, PreSignedUrlFetcher fetcher, long contentLength, FileSystem.Statistics stats, int numRetries) {
        this.client = client;
        this.fetcher = fetcher;
        this.contentLength = contentLength;
        this.stats = stats;
        this.numRetries = numRetries;
        Logging.$init$((Logging)this);
        this.closed = false;
        this.pos = 0L;
        this.currentStream = null;
        this.uri = null;
    }
}

