/*
 * Decompiled with CFR 0.152.
 */
package io.delta.sharing.spark;

import io.delta.sharing.spark.DeltaSharingClient;
import io.delta.sharing.spark.DeltaTableUtils$;
import io.delta.sharing.spark.RemoteDeltaLog$;
import io.delta.sharing.spark.RemoteDeltaSnapshotFileIndex;
import io.delta.sharing.spark.RemoteSnapshot$;
import io.delta.sharing.spark.model.AddFile;
import io.delta.sharing.spark.model.DeltaTableFiles;
import io.delta.sharing.spark.model.DeltaTableMetadata;
import io.delta.sharing.spark.model.Metadata;
import io.delta.sharing.spark.model.Protocol;
import io.delta.sharing.spark.model.Table;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.delta.sharing.CachedTableManager$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001\u0002\u000e\u001c\u0001\u0011B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\"AA\t\u0001B\u0001B\u0003%Q\t\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003M\u0011!\u0011\u0006A!A!\u0002\u0013\u0019\u0006\"B0\u0001\t\u0003\u0001\u0007\"\u0002\u000f\u0001\t#9\u0007B\u00038\u0001!\u0003E9\u0019)C\u0005_\"A\u0011\u0010\u0001EC\u0002\u0013\u0005!\u0010\u0003\u0005|\u0001!\u0015\r\u0011\"\u0001}\u0011!i\b\u0001#b\u0001\n\u0003q\b\"C@\u0001\u0011\u000b\u0007I\u0011AA\u0001\u0011)\ty\u0001\u0001EC\u0002\u0013\u0005\u0011\u0011\u0001\u0005\b\u0003#\u0001A\u0011AA\n\u0011\u001d\t)\u0003\u0001C\u0001\u0003OA\u0011\"!\u000b\u0001\u0011\u000b\u0007I\u0011\u0001@\t\r\u0005-\u0002\u0001\"\u0003p\u0011\u001d\ti\u0003\u0001C\u0005\u0003_Aq!a\u000f\u0001\t\u0013\ti\u0004C\u0004\u0002D\u0001!\t!!\u0012\b\u0013\u0005\u001d5$!A\t\u0002\u0005%e\u0001\u0003\u000e\u001c\u0003\u0003E\t!a#\t\r}3B\u0011AAG\u0011%\tyIFI\u0001\n\u0003\t\t\nC\u0005\u0002(Z\t\n\u0011\"\u0001\u0002*\nq!+Z7pi\u0016\u001cf.\u00199tQ>$(B\u0001\u000f\u001e\u0003\u0015\u0019\b/\u0019:l\u0015\tqr$A\u0004tQ\u0006\u0014\u0018N\\4\u000b\u0005\u0001\n\u0013!\u00023fYR\f'\"\u0001\u0012\u0002\u0005%|7\u0001A\n\u0004\u0001\u0015Z\u0003C\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#AB!osJ+g\r\u0005\u0002-i5\tQF\u0003\u0002/_\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u001da)\u0011\u0011GM\u0001\u0007CB\f7\r[3\u000b\u0003M\n1a\u001c:h\u0013\t)TFA\u0004M_\u001e<\u0017N\\4\u0002\u0013Q\f'\r\\3QCRD\u0007C\u0001\u001d>\u001b\u0005I$B\u0001\u001e<\u0003\t17O\u0003\u0002=a\u00051\u0001.\u00193p_BL!AP\u001d\u0003\tA\u000bG\u000f[\u0001\u0007G2LWM\u001c;\u0011\u0005\u0005\u0013U\"A\u000e\n\u0005\r[\"A\u0005#fYR\f7\u000b[1sS:<7\t\\5f]R\fQ\u0001^1cY\u0016\u0004\"AR%\u000e\u0003\u001dS!\u0001S\u000e\u0002\u000b5|G-\u001a7\n\u0005);%!\u0002+bE2,\u0017a\u0003<feNLwN\\!t\u001f\u001a\u00042AJ'P\u0013\tquE\u0001\u0004PaRLwN\u001c\t\u0003MAK!!U\u0014\u0003\t1{gnZ\u0001\u000ei&lWm\u001d;b[B\f5o\u00144\u0011\u0007\u0019jE\u000b\u0005\u0002V9:\u0011aK\u0017\t\u0003/\u001ej\u0011\u0001\u0017\u0006\u00033\u000e\na\u0001\u0010:p_Rt\u0014BA.(\u0003\u0019\u0001&/\u001a3fM&\u0011QL\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005m;\u0013A\u0002\u001fj]&$h\b\u0006\u0004bE\u000e$WM\u001a\t\u0003\u0003\u0002AQA\u000e\u0004A\u0002]BQa\u0010\u0004A\u0002\u0001CQ\u0001\u0012\u0004A\u0002\u0015Cqa\u0013\u0004\u0011\u0002\u0003\u0007A\nC\u0004S\rA\u0005\t\u0019A*\u0016\u0003!\u0004\"!\u001b7\u000e\u0003)T!a[\u0018\u0002\u0007M\fH.\u0003\u0002nU\na1\u000b]1sWN+7o]5p]\u0006\u0019\u0001\u0010\n\u001a\u0016\u0003A\u0004RAJ9tm>K!A]\u0014\u0003\rQ+\b\u000f\\34!\t1E/\u0003\u0002v\u000f\nAQ*\u001a;bI\u0006$\u0018\r\u0005\u0002Go&\u0011\u0001p\u0012\u0002\t!J|Go\\2pY\u0006AQ.\u001a;bI\u0006$\u0018-F\u0001t\u0003!\u0001(o\u001c;pG>dW#\u0001<\u0002\u000fY,'o]5p]V\tq*\u0001\u0004tG\",W.Y\u000b\u0003\u0003\u0007\u0001B!!\u0002\u0002\f5\u0011\u0011q\u0001\u0006\u0004\u0003\u0013Q\u0017!\u0002;za\u0016\u001c\u0018\u0002BA\u0007\u0003\u000f\u0011!b\u0015;sk\u000e$H+\u001f9f\u0003=\u0001\u0018M\u001d;ji&|gnU2iK6\f\u0017A\u00034jY\u00164uN]7biV\u0011\u0011Q\u0003\t\u0005\u0003/\t\t#\u0004\u0002\u0002\u001a)!\u00111DA\u000f\u0003-!\u0017\r^1t_V\u00148-Z:\u000b\u0007\u0005}!.A\u0005fq\u0016\u001cW\u000f^5p]&!\u00111EA\r\u0005)1\u0015\u000e\\3G_Jl\u0017\r^\u0001\rO\u0016$H+\u00192mKB\u000bG\u000f[\u000b\u0002o\u0005Y1/\u001b>f\u0013:\u0014\u0015\u0010^3t\u0003A9W\r\u001e+bE2,W*\u001a;bI\u0006$\u0018-\u0001\fdQ\u0016\u001c7\u000e\u0015:pi>\u001cw\u000e\u001c(pi\u000eC\u0017M\\4f)\u0011\t\t$a\u000e\u0011\u0007\u0019\n\u0019$C\u0002\u00026\u001d\u0012A!\u00168ji\"1\u0011\u0011\b\nA\u0002Y\f1B\\3x!J|Go\\2pY\u0006!2\r[3dWN\u001b\u0007.Z7b\u001d>$8\t[1oO\u0016$B!!\r\u0002@!1\u0011\u0011I\nA\u0002M\f1B\\3x\u001b\u0016$\u0018\rZ1uC\u0006aa-\u001b7fg\u001a{'oU2b]RQ\u0011qIA0\u0003k\nI(! \u0011\r\u0005%\u00131KA-\u001d\u0011\tY%a\u0014\u000f\u0007]\u000bi%C\u0001)\u0013\r\t\tfJ\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)&a\u0016\u0003\u0007M+\u0017OC\u0002\u0002R\u001d\u00022ARA.\u0013\r\tif\u0012\u0002\b\u0003\u0012$g)\u001b7f\u0011\u001d\t\t\u0007\u0006a\u0001\u0003G\nqAZ5mi\u0016\u00148\u000f\u0005\u0004\u0002J\u0005M\u0013Q\r\t\u0005\u0003O\n\t(\u0004\u0002\u0002j)!\u00111NA7\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0007\u0005=$.\u0001\u0005dCR\fG._:u\u0013\u0011\t\u0019(!\u001b\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0003\u0004\u0002xQ\u0001\r\u0001T\u0001\nY&l\u0017\u000e\u001e%j]RDa!a\u001f\u0015\u0001\u0004\u0019\u0016A\u00056t_:\u0004&/\u001a3jG\u0006$X\rS5oiNDq!a \u0015\u0001\u0004\t\t)A\u0005gS2,\u0017J\u001c3fqB\u0019\u0011)a!\n\u0007\u0005\u00155D\u0001\u000fSK6|G/\u001a#fYR\f7K\\1qg\"|GOR5mK&sG-\u001a=\u0002\u001dI+Wn\u001c;f':\f\u0007o\u001d5piB\u0011\u0011IF\n\u0003-\u0015\"\"!!#\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\t\u0019JK\u0002M\u0003+[#!a&\u0011\t\u0005e\u00151U\u0007\u0003\u00037SA!!(\u0002 \u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003C;\u0013AC1o]>$\u0018\r^5p]&!\u0011QUAN\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005-&fA*\u0002\u0016\u0002")
public class RemoteSnapshot
implements Logging {
    private Tuple3<Metadata, Protocol, Object> x$2;
    private Metadata metadata;
    private Protocol protocol;
    private long version;
    private StructType schema;
    private StructType partitionSchema;
    private long sizeInBytes;
    private final Path tablePath;
    private final DeltaSharingClient client;
    private final Table table;
    private final Option<Object> versionAsOf;
    private final Option<String> timestampAsOf;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static Option<String> $lessinit$greater$default$5() {
        return RemoteSnapshot$.MODULE$.$lessinit$greater$default$5();
    }

    public static Option<Object> $lessinit$greater$default$4() {
        return RemoteSnapshot$.MODULE$.$lessinit$greater$default$4();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SparkSession spark() {
        return SparkSession$.MODULE$.active();
    }

    private Tuple3<Metadata, Protocol, Object> x$2$lzycompute() {
        RemoteSnapshot remoteSnapshot = this;
        synchronized (remoteSnapshot) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Tuple3<Metadata, Protocol, Object> tuple3 = this.getTableMetadata();
                if (tuple3 == null) {
                    throw new MatchError(tuple3);
                }
                Metadata metadata = (Metadata)tuple3._1();
                Protocol protocol = (Protocol)tuple3._2();
                long version = BoxesRunTime.unboxToLong((Object)tuple3._3());
                Tuple3 tuple32 = new Tuple3((Object)metadata, (Object)protocol, (Object)BoxesRunTime.boxToLong((long)version));
                this.x$2 = tuple32;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.x$2;
    }

    private /* synthetic */ Tuple3 x$2() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.x$2$lzycompute() : this.x$2;
    }

    private Metadata metadata$lzycompute() {
        RemoteSnapshot remoteSnapshot = this;
        synchronized (remoteSnapshot) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.metadata = (Metadata)this.x$2()._1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.metadata;
    }

    public Metadata metadata() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.metadata$lzycompute() : this.metadata;
    }

    private Protocol protocol$lzycompute() {
        RemoteSnapshot remoteSnapshot = this;
        synchronized (remoteSnapshot) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.protocol = (Protocol)this.x$2()._2();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.protocol;
    }

    public Protocol protocol() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.protocol$lzycompute() : this.protocol;
    }

    private long version$lzycompute() {
        RemoteSnapshot remoteSnapshot = this;
        synchronized (remoteSnapshot) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.version = BoxesRunTime.unboxToLong((Object)this.x$2()._3());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.version;
    }

    public long version() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.version$lzycompute() : this.version;
    }

    private StructType schema$lzycompute() {
        RemoteSnapshot remoteSnapshot = this;
        synchronized (remoteSnapshot) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.schema = DeltaTableUtils$.MODULE$.toSchema(this.metadata().schemaString());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.schema;
    }

    public StructType schema() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.schema$lzycompute() : this.schema;
    }

    private StructType partitionSchema$lzycompute() {
        RemoteSnapshot remoteSnapshot = this;
        synchronized (remoteSnapshot) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.partitionSchema = new StructType((StructField[])((TraversableOnce)this.metadata().partitionColumns().map((Function1 & Serializable & scala.Serializable)c -> this.schema().apply(c), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(StructField.class)));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.partitionSchema;
    }

    public StructType partitionSchema() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.partitionSchema$lzycompute() : this.partitionSchema;
    }

    public FileFormat fileFormat() {
        return new ParquetFileFormat();
    }

    public Path getTablePath() {
        return this.tablePath;
    }

    private long sizeInBytes$lzycompute() {
        RemoteSnapshot remoteSnapshot = this;
        synchronized (remoteSnapshot) {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                long l;
                SparkSession.implicits$ implicits = this.spark().implicits();
                if (this.metadata().size() != null) {
                    l = Predef$.MODULE$.Long2long(this.metadata().size());
                } else {
                    this.log().warn(new StringBuilder(52).append("Getting table size from a full file scan for table: ").append(this.table).toString());
                    DeltaTableFiles tableFiles = this.client.getFiles(this.table, (Seq<String>)Nil$.MODULE$, (Option<Object>)None$.MODULE$, this.versionAsOf, this.timestampAsOf, (Option<String>)None$.MODULE$);
                    this.checkProtocolNotChange(tableFiles.protocol());
                    this.checkSchemaNotChange(tableFiles.metadata());
                    l = BoxesRunTime.unboxToLong((Object)((TraversableOnce)tableFiles.files().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.size()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                }
                this.sizeInBytes = l;
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
            }
        }
        return this.sizeInBytes;
    }

    public long sizeInBytes() {
        return (byte)(this.bitmap$0 & 0x40) == 0 ? this.sizeInBytes$lzycompute() : this.sizeInBytes;
    }

    private Tuple3<Metadata, Protocol, Object> getTableMetadata() {
        Tuple3 tuple3;
        if (this.versionAsOf.isEmpty()) {
            DeltaTableMetadata tableMetadata = this.client.getMetadata(this.table);
            tuple3 = new Tuple3((Object)tableMetadata.metadata(), (Object)tableMetadata.protocol(), (Object)BoxesRunTime.boxToLong((long)tableMetadata.version()));
        } else {
            DeltaTableFiles tableFiles = this.client.getFiles(this.table, (Seq<String>)Nil$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), this.versionAsOf, this.timestampAsOf, (Option<String>)None$.MODULE$);
            tuple3 = new Tuple3((Object)tableFiles.metadata(), (Object)tableFiles.protocol(), (Object)BoxesRunTime.boxToLong((long)tableFiles.version()));
        }
        return tuple3;
    }

    private void checkProtocolNotChange(Protocol newProtocol) {
        Protocol protocol = newProtocol;
        Protocol protocol2 = this.protocol();
        if (protocol == null ? protocol2 != null : !((Object)protocol).equals(protocol2)) {
            throw new SparkException("The table protocol has changed since your DataFrame was created. Please redefine your DataFrame");
        }
    }

    private void checkSchemaNotChange(Metadata newMetadata) {
        block3: {
            block2: {
                String string = newMetadata.schemaString();
                String string2 = this.metadata().schemaString();
                if (string != null ? !string.equals(string2) : string2 != null) break block2;
                Seq<String> seq = newMetadata.partitionColumns();
                Seq<String> seq2 = this.metadata().partitionColumns();
                if (!(seq == null ? seq2 != null : !seq.equals(seq2))) break block3;
            }
            throw new SparkException("The schema or partition columns of your Delta table has changed since your\n           |DataFrame was created. Please redefine your DataFrame");
        }
    }

    public Seq<AddFile> filesForScan(Seq<Expression> filters, Option<Object> limitHint, Option<String> jsonPredicateHints, RemoteDeltaSnapshotFileIndex fileIndex) {
        Encoder<AddFile> enc = RemoteDeltaLog$.MODULE$.addFileEncoder();
        Seq partitionFilters = (Seq)filters.flatMap((Function1 & Serializable & scala.Serializable)filter -> (Seq)DeltaTableUtils$.MODULE$.splitMetadataAndDataPredicates((Expression)filter, this.metadata().partitionColumns(), this.spark())._1(), Seq$.MODULE$.canBuildFrom());
        Seq<Expression> rewrittenFilters = DeltaTableUtils$.MODULE$.rewritePartitionFilters(this.partitionSchema(), (Function2<String, String, Object>)this.spark().sessionState().conf().resolver(), (Seq<Expression>)partitionFilters);
        Seq predicates = (Seq)rewrittenFilters.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.sql(), Seq$.MODULE$.canBuildFrom());
        if (predicates.nonEmpty()) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Sending predicates ").append(predicates).append(" to the server").toString());
        }
        SparkSession.implicits$ implicits = this.spark().implicits();
        DeltaTableFiles tableFiles = this.client.getFiles(this.table, (Seq<String>)predicates, limitHint, this.versionAsOf, this.timestampAsOf, jsonPredicateHints);
        Map idToUrl = ((TraversableOnce)tableFiles.files().map((Function1 & Serializable & scala.Serializable)file -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)file.id()), (Object)file.url()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        CachedTableManager$.MODULE$.INSTANCE().register(fileIndex.params().path().toString(), (Map<String, String>)idToUrl, (Seq<WeakReference<Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new WeakReference[]{new WeakReference<RemoteDeltaSnapshotFileIndex>(fileIndex)}))), fileIndex.params().profileProvider(), (Function0<Map<String, String>>)(Function0 & Serializable & scala.Serializable)() -> ((TraversableOnce)$this.client.getFiles($this.table, (Seq<String>)Nil$.MODULE$, (Option<Object>)None$.MODULE$, $this.versionAsOf, $this.timestampAsOf, jsonPredicateHints).files().map((Function1 & Serializable & scala.Serializable)add -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)add.id()), (Object)add.url()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        this.checkProtocolNotChange(tableFiles.protocol());
        this.checkSchemaNotChange(tableFiles.metadata());
        Dataset remoteFiles = implicits.localSeqToDatasetHolder(tableFiles.files(), enc).toDS();
        Column columnFilter = new Column((Expression)rewrittenFilters.reduceLeftOption((Function2)And$.MODULE$).getOrElse((Function0 & Serializable & scala.Serializable)() -> Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true))));
        return Predef$.MODULE$.wrapRefArray((Object[])remoteFiles.filter(columnFilter).as(enc).collect());
    }

    public RemoteSnapshot(Path tablePath, DeltaSharingClient client, Table table, Option<Object> versionAsOf, Option<String> timestampAsOf) {
        this.tablePath = tablePath;
        this.client = client;
        this.table = table;
        this.versionAsOf = versionAsOf;
        this.timestampAsOf = timestampAsOf;
        Logging.$init$((Logging)this);
    }
}

