/*
 * Decompiled with CFR 0.152.
 */
package io.delta.sharing.spark.filters;

import io.delta.sharing.spark.filters.AndOp;
import io.delta.sharing.spark.filters.BaseOp;
import io.delta.sharing.spark.filters.ColumnOp;
import io.delta.sharing.spark.filters.EqualOp;
import io.delta.sharing.spark.filters.GreaterThanOp;
import io.delta.sharing.spark.filters.GreaterThanOrEqualOp;
import io.delta.sharing.spark.filters.IsNullOp;
import io.delta.sharing.spark.filters.LeafOp;
import io.delta.sharing.spark.filters.LessThanOp;
import io.delta.sharing.spark.filters.LessThanOrEqualOp;
import io.delta.sharing.spark.filters.LiteralOp;
import io.delta.sharing.spark.filters.NonLeafOp;
import io.delta.sharing.spark.filters.NotOp;
import io.delta.sharing.spark.filters.OpDataTypes$;
import io.delta.sharing.spark.filters.OrOp;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;

public final class OpConverter$ {
    public static OpConverter$ MODULE$;
    private final int kMaxSqlInOpSizeLimit;

    static {
        new OpConverter$();
    }

    public int kMaxSqlInOpSizeLimit() {
        return this.kMaxSqlInOpSizeLimit;
    }

    public Option<BaseOp> convert(Seq<Expression> expressions) throws IllegalArgumentException {
        None$ none$;
        Seq seq = (Seq)expressions.map((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.convertOne((Expression)x$1), Seq$.MODULE$.canBuildFrom());
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(0) == 0) {
            none$ = None$.MODULE$;
        } else {
            Some some2 = Seq$.MODULE$.unapplySeq(seq);
            if (!some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(1) == 0) {
                BaseOp child = (BaseOp)((SeqLike)some2.get()).apply(0);
                none$ = new Some((Object)child);
            } else {
                none$ = new Some((Object)new AndOp((Seq<BaseOp>)seq.toList()));
            }
        }
        return none$;
    }

    private BaseOp convertOne(Expression expr) {
        return (BaseOp)this.maybeConvertAsLeaf(expr, this.maybeConvertAsLeaf$default$2()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            scala.Serializable serializable;
            Expression expression = expr;
            if (expression instanceof And) {
                And and = (And)expression;
                Expression left = and.left();
                Expression right = and.right();
                serializable = new AndOp((Seq<BaseOp>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BaseOp[]{MODULE$.convertOne(left), MODULE$.convertOne(right)}))));
            } else if (expression instanceof Or) {
                Or or = (Or)expression;
                Expression left = or.left();
                Expression right = or.right();
                serializable = new OrOp((Seq<BaseOp>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BaseOp[]{MODULE$.convertOne(left), MODULE$.convertOne(right)}))));
            } else if (expression instanceof Not) {
                Not not = (Not)expression;
                Expression child = not.child();
                serializable = new NotOp((Seq<BaseOp>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BaseOp[]{MODULE$.convertOne(child)}))));
            } else if (expression instanceof EqualTo) {
                EqualTo equalTo = (EqualTo)expression;
                Expression left = equalTo.left();
                Expression right = equalTo.right();
                serializable = new EqualOp((Seq<LeafOp>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeafOp[]{MODULE$.convertAsLeaf(left, MODULE$.convertAsLeaf$default$2()), MODULE$.convertAsLeaf(right, MODULE$.convertAsLeaf$default$2())}))));
            } else if (expression instanceof LessThan) {
                LessThan lessThan = (LessThan)expression;
                Expression left = lessThan.left();
                Expression right = lessThan.right();
                serializable = new LessThanOp((Seq<LeafOp>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeafOp[]{MODULE$.convertAsLeaf(left, MODULE$.convertAsLeaf$default$2()), MODULE$.convertAsLeaf(right, MODULE$.convertAsLeaf$default$2())}))));
            } else if (expression instanceof LessThanOrEqual) {
                LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)expression;
                Expression left = lessThanOrEqual.left();
                Expression right = lessThanOrEqual.right();
                serializable = new LessThanOrEqualOp((Seq<LeafOp>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeafOp[]{MODULE$.convertAsLeaf(left, MODULE$.convertAsLeaf$default$2()), MODULE$.convertAsLeaf(right, MODULE$.convertAsLeaf$default$2())}))));
            } else if (expression instanceof GreaterThan) {
                GreaterThan greaterThan = (GreaterThan)expression;
                Expression left = greaterThan.left();
                Expression right = greaterThan.right();
                serializable = new GreaterThanOp((Seq<LeafOp>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeafOp[]{MODULE$.convertAsLeaf(left, MODULE$.convertAsLeaf$default$2()), MODULE$.convertAsLeaf(right, MODULE$.convertAsLeaf$default$2())}))));
            } else if (expression instanceof GreaterThanOrEqual) {
                GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)expression;
                Expression left = greaterThanOrEqual.left();
                Expression right = greaterThanOrEqual.right();
                serializable = new GreaterThanOrEqualOp((Seq<LeafOp>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeafOp[]{MODULE$.convertAsLeaf(left, MODULE$.convertAsLeaf$default$2()), MODULE$.convertAsLeaf(right, MODULE$.convertAsLeaf$default$2())}))));
            } else if (expression instanceof IsNull) {
                IsNull isNull = (IsNull)expression;
                Expression child = isNull.child();
                serializable = new IsNullOp((Seq<LeafOp>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeafOp[]{MODULE$.convertAsLeaf(child, MODULE$.convertAsLeaf$default$2())}))));
            } else if (expression instanceof IsNotNull) {
                IsNotNull isNotNull = (IsNotNull)expression;
                Expression child = isNotNull.child();
                serializable = new NotOp((Seq<BaseOp>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IsNullOp[]{new IsNullOp((Seq<LeafOp>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeafOp[]{MODULE$.convertAsLeaf(child, MODULE$.convertAsLeaf$default$2())}))))}))));
            } else if (expression instanceof In) {
                scala.Serializable serializable2;
                In in = (In)expression;
                Expression value = in.value();
                Seq list = in.list();
                if (list.size() > MODULE$.kMaxSqlInOpSizeLimit()) {
                    throw new IllegalArgumentException(new StringBuilder(38).append("The In predicate exceeds max limit of ").append(MODULE$.kMaxSqlInOpSizeLimit()).toString());
                }
                LeafOp leafOp = MODULE$.convertAsLeaf(value, MODULE$.convertAsLeaf$default$2());
                Seq seq = (Seq)list.map((Function1 & Serializable & scala.Serializable)e -> new EqualOp((Seq<LeafOp>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeafOp[]{leafOp, MODULE$.convertAsLeaf((Expression)e, MODULE$.convertAsLeaf$default$2())})))), Seq$.MODULE$.canBuildFrom());
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(0) == 0) {
                    throw new IllegalArgumentException("The In predicate must have at least one entry");
                }
                Some some2 = Seq$.MODULE$.unapplySeq(seq);
                if (!some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(1) == 0) {
                    EqualOp child = (EqualOp)((SeqLike)some2.get()).apply(0);
                    serializable2 = child;
                } else {
                    serializable2 = new OrOp((Seq<BaseOp>)seq);
                }
                serializable = serializable2;
            } else if (expression instanceof EqualNullSafe) {
                EqualNullSafe equalNullSafe = (EqualNullSafe)expression;
                Expression left = equalNullSafe.left();
                Expression right = equalNullSafe.right();
                LeafOp leftOp = MODULE$.convertAsLeaf(left, MODULE$.convertAsLeaf$default$2());
                LeafOp rightOp = MODULE$.convertAsLeaf(right, MODULE$.convertAsLeaf$default$2());
                IsNullOp leftIsNullOp = new IsNullOp((Seq<LeafOp>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeafOp[]{leftOp}))));
                IsNullOp rightIsNullOp = new IsNullOp((Seq<LeafOp>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeafOp[]{rightOp}))));
                serializable = new OrOp((Seq<BaseOp>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AndOp[]{new AndOp((Seq<BaseOp>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IsNullOp[]{leftIsNullOp, rightIsNullOp})))), new AndOp((Seq<BaseOp>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NonLeafOp[]{new NotOp((Seq<BaseOp>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IsNullOp[]{leftIsNullOp})))), new NotOp((Seq<BaseOp>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IsNullOp[]{rightIsNullOp})))), new EqualOp((Seq<LeafOp>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeafOp[]{leftOp, rightOp}))))}))))}))));
            } else {
                throw new IllegalArgumentException(new StringBuilder(41).append("Unsupported expression during conversion ").append(expr).toString());
            }
            return serializable;
        });
    }

    private Option<LeafOp> maybeConvertAsLeaf(Expression expr, Option<DataType> sqlTypeOpt) {
        None$ none$;
        DataType sqlType = (DataType)sqlTypeOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> expr.dataType());
        Expression expression = expr;
        if (expression instanceof AttributeReference) {
            AttributeReference attributeReference = (AttributeReference)expression;
            none$ = new Some((Object)new ColumnOp(attributeReference.name(), this.convertDataType(sqlType)));
        } else if (expression instanceof Literal) {
            Literal literal = (Literal)expression;
            none$ = new Some((Object)new LiteralOp(literal.toString(), this.convertDataType(sqlType)));
        } else if (expression instanceof Cast) {
            Cast cast = (Cast)expression;
            none$ = new Some((Object)this.convertAsLeaf(cast.child(), (Option<DataType>)new Some((Object)cast.dataType())));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Option<DataType> maybeConvertAsLeaf$default$2() {
        return None$.MODULE$;
    }

    private LeafOp convertAsLeaf(Expression expr, Option<DataType> sqlTypeOpt) {
        return (LeafOp)this.maybeConvertAsLeaf(expr, sqlTypeOpt).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(28).append("Unsupported leaf expression ").append(expr).toString());
        });
    }

    private Option<DataType> convertAsLeaf$default$2() {
        return None$.MODULE$;
    }

    private String convertDataType(DataType sqlType) {
        String string;
        DataType dataType = sqlType;
        if (BooleanType$.MODULE$.equals(dataType)) {
            string = OpDataTypes$.MODULE$.BoolType();
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            string = OpDataTypes$.MODULE$.IntType();
        } else if (LongType$.MODULE$.equals(dataType)) {
            string = OpDataTypes$.MODULE$.LongType();
        } else if (StringType$.MODULE$.equals(dataType)) {
            string = OpDataTypes$.MODULE$.StringType();
        } else if (DateType$.MODULE$.equals(dataType)) {
            string = OpDataTypes$.MODULE$.DateType();
        } else {
            throw new IllegalArgumentException(new StringBuilder(22).append("Unsupported data type ").append(sqlType).toString());
        }
        return string;
    }

    private OpConverter$() {
        MODULE$ = this;
        this.kMaxSqlInOpSizeLimit = 20;
    }
}

