/*
 * Decompiled with CFR 0.152.
 */
package io.delta.sharing.spark.util;

import io.delta.sharing.spark.util.UnexpectedHttpStatus;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Serializable;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

public final class RetryUtils$
implements Logging {
    public static RetryUtils$ MODULE$;
    private volatile Function1<Object, BoxedUnit> sleeper;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new RetryUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Function1<Object, BoxedUnit> sleeper() {
        return this.sleeper;
    }

    public void sleeper_$eq(Function1<Object, BoxedUnit> x$1) {
        this.sleeper = x$1;
    }

    public <T> T runWithExponentialBackoff(int numRetries, Function0<T> func) {
        int times = 0;
        IntRef sleepMs = IntRef.create((int)100);
        while (true) {
            ++times;
            try {
                return (T)func.apply();
            }
            catch (Throwable throwable) {
                Throwable e;
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty() && this.shouldRetry(e = (Throwable)option.get()) && times <= numRetries) {
                    this.logWarning((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(40).append("Sleeping ").append(sleepMs$1.elem).append(" ms to retry because of error: ").append(e.getMessage()).toString(), e);
                    this.sleeper().apply$mcVJ$sp((long)sleepMs.elem);
                    sleepMs.elem *= 2;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw throwable;
            }
            break;
        }
    }

    public boolean shouldRetry(Throwable t) {
        UnexpectedHttpStatus unexpectedHttpStatus;
        Throwable throwable = t;
        boolean bl = throwable instanceof UnexpectedHttpStatus ? ((unexpectedHttpStatus = (UnexpectedHttpStatus)throwable).statusCode() == 429 ? true : unexpectedHttpStatus.statusCode() >= 500 && unexpectedHttpStatus.statusCode() < 600) : (throwable instanceof InterruptedException ? false : (throwable instanceof InterruptedIOException ? false : throwable instanceof IOException));
        return bl;
    }

    private RetryUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.sleeper = (JFunction1.mcVJ.sp & java.io.Serializable & Serializable)sleepMs -> Thread.sleep(sleepMs);
    }
}

