/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.delta.sharing;

import io.delta.sharing.spark.DeltaSharingProfileProvider;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.spark.delta.sharing.CachedTable;
import org.apache.spark.delta.sharing.CachedTableManager$;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005Uc\u0001B\f\u0019\u0001\rB\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\ti\u0001\u0011\t\u0011)A\u0005c!AQ\u0007\u0001B\u0001B\u0003%\u0011\u0007\u0003\u00057\u0001\t\u0005\t\u0015!\u00032\u0011\u00159\u0004\u0001\"\u00019\u0011\u001dy\u0004A1A\u0005\n\u0001Ca!\u0017\u0001!\u0002\u0013\t\u0005b\u0002.\u0001\u0005\u0004%Ia\u0017\u0005\u0007?\u0002\u0001\u000b\u0011\u0002/\t\u000b\u0001\u0004A\u0011A1\t\u000b\u0015\u0004A\u0011\u00014\t\u000bY\u0004A\u0011A<\t\r\u0005\r\u0003\u0001\"\u0001b\u0011\u0019\t)\u0005\u0001C\u0001C\u001e9\u0011q\t\r\t\u0002\u0005%cAB\f\u0019\u0011\u0003\tY\u0005\u0003\u00048!\u0011\u0005\u0011Q\n\u0005\naAA)\u0019!C\u0005\u0003\u001fB\u0011\u0002\u000e\t\t\u0006\u0004%I!a\u0014\t\u0013U\u0002\u0002R1A\u0005\n\u0005=\u0003\"\u0003\u001c\u0011\u0011\u000b\u0007I\u0011BA(\u0011)\t\t\u0006\u0005EC\u0002\u0013\u0005\u00111\u000b\u0002\u0013\u0007\u0006\u001c\u0007.\u001a3UC\ndW-T1oC\u001e,'O\u0003\u0002\u001a5\u000591\u000f[1sS:<'BA\u000e\u001d\u0003\u0015!W\r\u001c;b\u0015\tib$A\u0003ta\u0006\u00148N\u0003\u0002 A\u00051\u0011\r]1dQ\u0016T\u0011!I\u0001\u0004_J<7\u0001A\n\u0004\u0001\u0011R\u0003CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#AB!osJ+g\r\u0005\u0002,]5\tAF\u0003\u0002.9\u0005A\u0011N\u001c;fe:\fG.\u0003\u00020Y\t9Aj\\4hS:<\u0017\u0001\u00079sKNKwM\\3e+JdW\t\u001f9je\u0006$\u0018n\u001c8NgB\u0011QEM\u0005\u0003g\u0019\u0012A\u0001T8oO\u00061\"/\u001a4sKND7\t[3dW&sG/\u001a:wC2l5/\u0001\nsK\u001a\u0014Xm\u001d5UQJ,7\u000f[8mI6\u001b\u0018aE3ya&\u0014X-\u00114uKJ\f5mY3tg6\u001b\u0018A\u0002\u001fj]&$h\bF\u0003:wqjd\b\u0005\u0002;\u00015\t\u0001\u0004C\u00031\u000b\u0001\u0007\u0011\u0007C\u00035\u000b\u0001\u0007\u0011\u0007C\u00036\u000b\u0001\u0007\u0011\u0007C\u00037\u000b\u0001\u0007\u0011'A\u0003dC\u000eDW-F\u0001B!\u0011\u0011\u0015j\u0013,\u000e\u0003\rS!\u0001R#\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002G\u000f\u0006!Q\u000f^5m\u0015\u0005A\u0015\u0001\u00026bm\u0006L!AS\"\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0002M':\u0011Q*\u0015\t\u0003\u001d\u001aj\u0011a\u0014\u0006\u0003!\n\na\u0001\u0010:p_Rt\u0014B\u0001*'\u0003\u0019\u0001&/\u001a3fM&\u0011A+\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005I3\u0003C\u0001\u001eX\u0013\tA\u0006DA\u0006DC\u000eDW\r\u001a+bE2,\u0017AB2bG\",\u0007%A\u0007sK\u001a\u0014Xm\u001d5UQJ,\u0017\rZ\u000b\u00029B\u0011!)X\u0005\u0003=\u000e\u0013\u0001dU2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u00039\u0011XM\u001a:fg\"$\u0006N]3bI\u0002\nqA]3ge\u0016\u001c\b\u000eF\u0001c!\t)3-\u0003\u0002eM\t!QK\\5u\u0003=9W\r\u001e)sKNKwM\\3e+JdGcA4siB\u0011\u0001n\u001c\b\u0003S2t!A\u000f6\n\u0005-D\u0012!\u0005)sKNKwM\\3e+Jd7)Y2iK&\u0011QN\\\u0001\u0004%B\u001c'BA6\u0019\u0013\t\u0001\u0018OA\fHKR\u0004&/Z*jO:,G-\u0016:m%\u0016\u001c\bo\u001c8tK*\u0011QN\u001c\u0005\u0006g.\u0001\raS\u0001\ni\u0006\u0014G.\u001a)bi\"DQ!^\u0006A\u0002-\u000baAZ5mK&#\u0017\u0001\u0003:fO&\u001cH/\u001a:\u0015\u0011\tD\u0018P`A\u0012\u0003sAQa\u001d\u0007A\u0002-CQA\u001f\u0007A\u0002m\fq!\u001b3U_V\u0013H\u000e\u0005\u0003My.[\u0015BA?V\u0005\ri\u0015\r\u001d\u0005\u0007\u007f2\u0001\r!!\u0001\u0002\tI,gm\u001d\t\u0007\u0003\u0007\ti!a\u0005\u000f\t\u0005\u0015\u0011\u0011\u0002\b\u0004\u001d\u0006\u001d\u0011\"A\u0014\n\u0007\u0005-a%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005=\u0011\u0011\u0003\u0002\u0004'\u0016\f(bAA\u0006MA)\u0011QCA\u0010I5\u0011\u0011q\u0003\u0006\u0005\u00033\tY\"A\u0002sK\u001aT1!!\bH\u0003\u0011a\u0017M\\4\n\t\u0005\u0005\u0012q\u0003\u0002\u000e/\u0016\f7NU3gKJ,gnY3\t\u000f\u0005\u0015B\u00021\u0001\u0002(\u0005y\u0001O]8gS2,\u0007K]8wS\u0012,'\u000f\u0005\u0003\u0002*\u0005URBAA\u0016\u0015\ri\u0012Q\u0006\u0006\u00043\u0005=\"bA\u000e\u00022)\u0011\u00111G\u0001\u0003S>LA!a\u000e\u0002,\tYB)\u001a7uCNC\u0017M]5oOB\u0013xNZ5mKB\u0013xN^5eKJDq!a\u000f\r\u0001\u0004\ti$A\u0005sK\u001a\u0014Xm\u001d5feB!Q%a\u0010|\u0013\r\t\tE\n\u0002\n\rVt7\r^5p]B\nAa\u001d;pa\u0006)1\r\\3be\u0006\u00112)Y2iK\u0012$\u0016M\u00197f\u001b\u0006t\u0017mZ3s!\tQ\u0004c\u0005\u0002\u0011IQ\u0011\u0011\u0011J\u000b\u0002c\u0005A\u0011JT*U\u0003:\u001bU)F\u0001:\u0001")
public class CachedTableManager
implements Logging {
    private final long preSignedUrlExpirationMs;
    private final long refreshThresholdMs;
    private final long expireAfterAccessMs;
    private final ConcurrentHashMap<String, CachedTable> cache;
    private final ScheduledExecutorService refreshThread;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static CachedTableManager INSTANCE() {
        return CachedTableManager$.MODULE$.INSTANCE();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ConcurrentHashMap<String, CachedTable> cache() {
        return this.cache;
    }

    private ScheduledExecutorService refreshThread() {
        return this.refreshThread;
    }

    public void refresh() {
        Map.Entry[] snapshot = (Map.Entry[])((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(this.cache().entrySet()).asScala()).toArray(ClassTag$.MODULE$.apply(Map.Entry.class));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])snapshot)).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            Boolean bl;
            String tablePath = (String)entry.getKey();
            CachedTable cachedTable = (CachedTable)entry.getValue();
            if (cachedTable.refs().forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CachedTableManager.$anonfun$refresh$2(x$1)))) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(86).append("Removing table ").append(tablePath).append(" from the pre signed url cache as there are").append(" no references pointed to it").toString());
                bl = BoxesRunTime.boxToBoolean((boolean)this.cache().remove(tablePath, cachedTable));
            } else if (cachedTable.lastAccess() + $this.expireAfterAccessMs < System.currentTimeMillis()) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Removing table ").append(tablePath).append(" from the pre signed url cache as it was not accessed ").append("after ").append($this.expireAfterAccessMs).append(" ms").toString());
                bl = BoxesRunTime.boxToBoolean((boolean)this.cache().remove(tablePath, cachedTable));
            } else if (cachedTable.expiration() - System.currentTimeMillis() < $this.refreshThresholdMs) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Updating pre signed urls for ").append(tablePath).append(" (expiration time: ").append(new Date(cachedTable.expiration())).append(")").toString());
                try {
                    CachedTable newTable = new CachedTable($this.preSignedUrlExpirationMs + System.currentTimeMillis(), (Map<String, String>)((Map)cachedTable.refresher().apply()), cachedTable.refs(), cachedTable.lastAccess(), cachedTable.refresher());
                    bl = BoxesRunTime.boxToBoolean((boolean)this.cache().replace(tablePath, cachedTable, newTable));
                }
                catch (Throwable throwable) {
                    Object object;
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Failed to refresh pre signed urls for table ").append(tablePath).toString(), e);
                        if (cachedTable.expiration() < System.currentTimeMillis()) {
                            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Removing table ").append(tablePath).append(" form cache as the pre signed url have expired").toString());
                            object = BoxesRunTime.boxToBoolean((boolean)this.cache().remove(tablePath, cachedTable));
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                    } else {
                        throw throwable;
                    }
                    BoxedUnit boxedUnit = object;
                    bl = boxedUnit;
                }
            } else {
                bl = BoxedUnit.UNIT;
            }
            return bl;
        });
    }

    public Tuple2<String, Object> getPreSignedUrl(String tablePath, String fileId) {
        CachedTable cachedTable = this.cache().get(tablePath);
        if (cachedTable == null) {
            throw new IllegalStateException(new StringBuilder(18).append("table ").append(tablePath).append(" was removed").toString());
        }
        cachedTable.lastAccess_$eq(System.currentTimeMillis());
        String url = (String)cachedTable.idToUrl().getOrElse((Object)fileId, (Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(33).append("cannot find url for id ").append(fileId).append(" in table ").append(tablePath).toString());
        });
        return new Tuple2((Object)url, (Object)BoxesRunTime.boxToLong((long)cachedTable.expiration()));
    }

    /*
     * Unable to fully structure code
     */
    public void register(String tablePath, Map<String, String> idToUrl, Seq<WeakReference<Object>> refs, DeltaSharingProfileProvider profileProvider, Function0<Map<String, String>> refresher) {
        customTablePath = profileProvider.getCustomTablePath(tablePath);
        customRefresher = profileProvider.getCustomRefresher(refresher);
        cachedTable = new CachedTable(this.preSignedUrlExpirationMs + System.currentTimeMillis(), idToUrl, refs, System.currentTimeMillis(), customRefresher);
        oldTable = ObjectRef.create((Object)this.cache().putIfAbsent(customTablePath, cachedTable));
        if ((CachedTable)oldTable.elem == null) {
            return;
        }
        do lbl-1000:
        // 3 sources

        {
            mergedTable = new CachedTable(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(cachedTable.expiration()), ((CachedTable)oldTable.elem).expiration()), (Map<String, String>)((CachedTable)oldTable.elem).idToUrl().$plus$plus(cachedTable.idToUrl()), (Seq<WeakReference<Object>>)((Seq)((TraversableLike)refs.filterNot((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$register$1$adapted(scala.runtime.ObjectRef java.lang.ref.WeakReference ), (Ljava/lang/ref/WeakReference;)Ljava/lang/Object;)((ObjectRef)oldTable))).$plus$plus(((CachedTable)oldTable.elem).refs(), Seq$.MODULE$.canBuildFrom())), System.currentTimeMillis(), customRefresher);
            if (this.cache().replace(customTablePath, (CachedTable)oldTable.elem, mergedTable)) {
                return;
            }
            oldTable.elem = this.cache().get(customTablePath);
            if ((CachedTable)oldTable.elem != null) ** GOTO lbl-1000
            oldTable.elem = this.cache().putIfAbsent(customTablePath, cachedTable);
        } while ((CachedTable)oldTable.elem != null);
    }

    public void stop() {
        this.refreshThread().shutdownNow();
    }

    public void clear() {
        this.cache().clear();
    }

    public static final /* synthetic */ boolean $anonfun$refresh$2(WeakReference x$1) {
        return x$1.get() == null;
    }

    public static final /* synthetic */ boolean $anonfun$register$2(WeakReference ref$1, WeakReference x$2) {
        return x$2.get() == ref$1.get();
    }

    public static final /* synthetic */ boolean $anonfun$register$1(ObjectRef oldTable$1, WeakReference ref) {
        return ((CachedTable)oldTable$1.elem).refs().exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CachedTableManager.$anonfun$register$2(ref, x$2)));
    }

    public CachedTableManager(long preSignedUrlExpirationMs, long refreshCheckIntervalMs, long refreshThresholdMs, long expireAfterAccessMs) {
        this.preSignedUrlExpirationMs = preSignedUrlExpirationMs;
        this.refreshThresholdMs = refreshThresholdMs;
        this.expireAfterAccessMs = expireAfterAccessMs;
        Logging.$init$((Logging)this);
        this.cache = new ConcurrentHashMap();
        ScheduledExecutorService thread = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("delta-sharing-pre-signed-url-refresh-thread");
        thread.scheduleWithFixedDelay(() -> this.refresh(), refreshCheckIntervalMs, refreshCheckIntervalMs, TimeUnit.MILLISECONDS);
        this.refreshThread = thread;
    }

    public static final /* synthetic */ Object $anonfun$register$1$adapted(ObjectRef oldTable$1, WeakReference ref) {
        return BoxesRunTime.boxToBoolean((boolean)CachedTableManager.$anonfun$register$1(oldTable$1, ref));
    }
}

